/*! Ubiattendance.ubihrm.js
 * ================
 *
 * @Author  sohan patel
 * @Email   <sohna@gmail.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBICRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('adminapp', ['datatables']);


app.controller('attroasterCtrl', function($scope, $http, $timeout,DTOptionsBuilder) {
	  
	  $scope.dtOptions = DTOptionsBuilder.newOptions();
    
 $scope.hastrue=false;
 $scope.name='sohan patel';
 $scope.records = [];
 $scope.arrdate = [];
 $scope.dates=[];
 
	
 
 
 $scope.fetchtabledata = function()
 {
	        $scope.hastrue=true;
	        var shift=$('#shift').val();
			var deprt=$('#deprt').val();
			var empl=$('#empl').val();
			var desg=$('#desg').val();
			var date=$('#revenuedate').val();
			
	  var xsrf = $.param({shift:shift, deprt: deprt,empl:empl,desg:desg});
		$http({
			url: 'getattRoaster',
			method: "POST",
			data:xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			
			 $scope.dates = data.date;
			var obj = data.data;
			var n = data.count;
			
			  $scope.arrdate = obj;
			 $scope.records = obj;
			$scope.hastrue=false;
			
		}).error(function (data, status, headers, config) {
			
			$scope.hastrue=false;
			
		});
 }
 
 
 
    $scope.GetEmpList = function($shiftid)
 	  {
		 
		$scope.emparray=[];
		$scope.shiftid=$shiftid;
		$scope.hastrue=true;
		var xsrf = $.param({shiftid: $scope.shiftid});
		$http({
			url: 'getemployeebyshift',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config){
			
				
				$scope.emparray=data.data;
				console.log(data.data);
				setTimeout(function(){
					$timeout(function(){	$scope.getrow();}, 500); 
				}, 1000);
			
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
 ////////////List group item function ///////////////
 $scope.getrow= function ($index) {
     $('.list-group.checked-list-box .list-group-item').each(function () {
        
        // Settings
        var $widget = $(this),
            $checkbox = $('<input type="checkbox" class="hidden" value="'+$index+'" id="'+$index+'checked"/>'),
            color = ($widget.data('color') ? $widget.data('color') : "primary"),
            style = ($widget.data('style') == "button" ? "btn-" : "list-group-item-"),
            settings = {
                on: {
                    icon: 'fa fa-check-square-o'
                },
                off: {
                    icon: 'fa fa-square-o'
                }
            };
            
        $widget.css('cursor', 'pointer')
        $widget.append($checkbox);

        // Event Handlers
        $widget.on('click', function () {
            $checkbox.prop('checked', !$checkbox.is(':checked'));
            $checkbox.triggerHandler('change');
            updateDisplay();
        });
        $checkbox.on('change', function () {
            updateDisplay();
        });
        // Actions
        function updateDisplay() {
            var isChecked = $checkbox.is(':checked');
//console.log(isChecked);
            // Set the button's state
            $widget.data('state', (isChecked) ? "on" : "off");
				
            // Set the button's icon
            $widget.find('.state-icon')
                .removeClass()
                .addClass('state-icon ' + settings[$widget.data('state')].icon);

            // Update the button's color
            if (isChecked) {
                $widget.addClass(style + color + ' active');
            } else {
                $widget.removeClass(style + color + ' active');
            }
        }
		// Initialization
        function init() {
            
            if ($widget.data('checked') == true) {
                $checkbox.prop('checked', !$checkbox.is(':checked'));
            }
            
            updateDisplay();

            // Inject the icon if applicable
            if ($widget.find('.state-icon').length == 0) {
                $widget.prepend('<span class="state-icon ' + settings[$widget.data('state')].icon + '"></span>');
            }
        }
        init();
    });
};
 
 
 $scope.getchecklistid=function($id){
	//alert($id);
		var customInput =  $(".list-group-item.list-group-item-success.active").length;
		//alert(customInput);
			for(var i=0; i< $scope.emparray.length;i++){
				
				if($scope.emparray[i]['id']==$id){
					if(customInput==i){
						$scope.emparray[i]['sts']=0;
						console.log($scope.emparray[i]['sts']);
					}else{
						$scope.emparray[i]['sts']=1;
						console.log($scope.emparray[i]['sts']);
							//console.log($scope.checklistarray[i]['sts1']);
					}
			}
		}
	}
 
 
 $scope.SaveEmpList=function($id){
		var total= $("#check-list-box li").length;
		var selectcheck= $(".list-group-item.list-group-item-success.active").length;
	
		if(selectcheck!=0){
			var json=angular.toJson($scope.emparray);			
			//console.log(json);
			var xsrf = $.param({ shiftid:$scope.shiftid,emplist:json});
			$http({
				url: 'SaveEmpShiftList',
				method: "POST",
				
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			}).success(function(data, status, headers, config){
				$scope.hastrue = false;
				$('#updateShift').modal('hide');
				
		doNotify('top','center',2,'Employee shift Updated Successfully.');
				
			}).error(function(data, status, headers, config){
			
				$scope.hastrue=false;
			});
		} else {
			//alert("Select atleast one employee ");
			doNotify('top','center',4,'Please select atleast one employee.');
			return false;
	}
	}
 
 
 
 
 
 
 
 
 
 
 
 
 
 $scope.filter = function()
 {
	         $scope.hastrue=true;
	         $scope.arrdate = [];
			 $scope.records = [];
			 $scope.dates=[];
	        var shift=$('#shift').val();
			var deprt=$('#deprt').val();
			var empl=$('#empl').val();
			var desg=$('#desg').val();
			var date=$('#revenuedate').val();
		    var todayTime = new Date(date);
            var month = (todayTime . getMonth() + 1);
			 if(month<9)
				  month = 0+""+month;
            var year = (todayTime . getFullYear());
			  date = month+"-"+year;
			//alert(date);
			
			var xsrf = $.param({shift:shift,empl:empl,desg:desg,date:date});
			//	alert(xsrf);
		$http({
			url: 'getattRoaster',
			method: "POST",
			data:xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			//alert(data);
			$scope.dates = data.date;
			var n = data.count;
			var obj = data.data;
		   $scope.arrdate = obj;
		   $scope.records = obj;
			
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			$scope.hastrue=false;
		});
			
 }
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
	
});
