<?php
include("library.php");

?>
<html>
<head>
<title>Journal Web Builder</title>
<?php addCSSFiles()?>
<style>
.chart-legend,.bar-legend,.line-legend,.pie-legend,.radar-legend,.polararea-legend,.doughnut-legend{list-style-type:none;margin-top:5px;text-align:left}.chart-legend li,.line-legend li,.pie-legend li,.bar-legend li,.radar-legend li,.polararea-legend li,.doughnut-legend li{display:inline-block;white-space:nowrap;position:relative;margin-bottom:4px;border-radius:5px;padding:2px 8px 2px 28px;font-size:smaller;cursor:default}.chart-legend li span,.bar-legend li span,.line-legend li span,.pie-legend li span,.radar-legend li span,.polararea-legend li span,.doughnut-legend li span{display:block;position:absolute;left:0;top:0;width:20px;height:20px;border-radius:5px}
.pie-legend li{display:list-item}
.dialog-window {
  height: 200px;
}

.scrollable-content {
  height: 195px;
  overflow: auto;
}
</style>
</head>
<body>
<?php navigationbar()?>

        <!-- Sidebar -->
       
	<div class="container-fluid">
		  <div class="row">
			<div class="col-sm-3 col-md-2 sidebar">
			  <?php sidebar(0)?>
			</div>
			<div class="col-sm-9 col-sm-offset-3 col-md-10 col-md-offset-2 main">
				<div class="row">
					<h1 class="page-header pull-left">Dashboard</h1>
					
				</div>
				<div class="row">
					
							<div class="row">
								<div class="col-lg-6 col-sm-12" >
									<div class="panel panel-primary">
										<div class="panel-heading">Total Journals by month</div>
										<div class="panel-body">
											<div id="line_legend"></div>
											
											<canvas id="line" class="chart chart-line chart-xl" height="100" style="width:100%"></canvas>
											
										</div>
									</div>
								</div>
								<div class="col-lg-6 col-sm-12" >
									<div class="panel panel-primary">
										<div class="panel-heading">Total Journals by year</div>
										<div class="panel-body">
											<div id="bar_legend"></div>
											<canvas id="bar" class="chart chart-bar" height="100" style="width:100%"></canvas>
											
										</div>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-lg-6 col-sm-12">
									<div class="panel panel-primary">
										<div class="panel-heading">Total Journals by package</div>
										<div class="panel-body">
											<div class="row">
												<div class="col-md-7">
													<canvas id="pie" class="chart chart-pie chart-xs" height="200" ></canvas>
												</div>
												<div class="col-md-5" >
													<div id="pie_legend"></div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-lg-6 col-sm-12"  >
									<div class="panel panel-primary">
										<div class="panel-heading">Total Journals by country</div>
										<div class="panel-body">
											<div class="row">
												<div class="col-md-7">
													<canvas id="pie1" class="chart chart-pie chart-xs" height="200"></canvas>
												</div>
												<div class="col-md-5">
													<div class="dialog-window">
															<div id="pie_legend1" class="scrollable-content"></div>
														
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							
					
				</div>
			</div>
		</div>
	</div>
<?php addJSFiles()?>
<script src="js/Chart.min.js"></script>
<script src="js/echarts.min.js"></script>
<script>
$(document).ready(function(){
//loadPiedata();
function loadPiedata(){
$.ajax({ url: "dashboard_data.php",
        data:'action=OrgData',
		type: "POST",
        success: function(data){
           //alert(data);
		   pieData =  JSON.parse(data);;
		    var context = document.getElementById('pie').getContext('2d');
			var pieChart = new Chart(context).Pie(pieData);
			var legend = pieChart.generateLegend();
			 
			 $('#pie_legend').append(legend);
			 $("#pie").click(function(e) {
			   var activeBars = pieChart.getSegmentsAtEvent(e); 
			   //$('#pie_legend').empty().remove();
			  //loadPiedata();
			});	
        }});
	
$.ajax({ url: "dashboard_data.php",
        data:'action=CountryWiseOrgData',
		type: "POST",
        success: function(data){
           //alert(data);
		   pieData =  JSON.parse(data);;
		    var context1 = document.getElementById('pie1').getContext('2d');
			var pieChart1 = new Chart(context1).Pie(pieData);
			var legend1 = pieChart1.generateLegend();
			 $('#pie_legend1').append(legend1);
        }});
$.ajax({ url: "dashboard_data.php",
        data:'action=DateWiseOrgData',
		type: "POST",
        success: function(data){
           
		   pieData =  JSON.parse(data);
		   //alert(pieData['color']);
		   var data = {
				labels: pieData['label'],
				datasets: [
					{
						label: "Total Journal",
						fillColor: pieData['color'],
						strokeColor: pieData['color'],
						data: pieData['data']
					} ]
			};
		    var linectx = document.getElementById("line").getContext("2d");
			var myLineChart = new Chart(linectx).Line(data);
			var linelegend = myLineChart.generateLegend();
			 $('#line_legend').append(linelegend);
        }});
$.ajax({ url: "dashboard_data.php",
        data:'action=YearWiseOrgData',
		type: "POST",
        success: function(data){
           
		   pieData =  JSON.parse(data);
		   //alert(pieData['color']);
		   var data = {
				labels: pieData['label'],
				datasets: [
					{
						label: "Total Journal",
						fillColor: pieData['color'],
						strokeColor: pieData['color'],
						data: pieData['data']
					} ]
			};
		    var barctx = document.getElementById("bar").getContext("2d");
			var myBarChart = new Chart(barctx).Bar(data);
			var barlegend = myBarChart.generateLegend();
			 $('#bar_legend').append(barlegend);
			
        }});

	
}

	
});
/*
var theme = {
          color: [
              '#26B99A', '#34495E', '#BDC3C7', '#3498DB',
              '#9B59B6', '#8abb6f', '#759c6a', '#bfd3b7'
          ],

          title: {
              itemGap: 8,
              textStyle: {
                  fontWeight: 'normal',
                  color: '#408829'
              }
          },

          dataRange: {
              color: ['#1f610a', '#97b58d']
          },

          toolbox: {
              color: ['#408829', '#408829', '#408829', '#408829']
          },

          tooltip: {
              backgroundColor: 'rgba(0,0,0,0.5)',
              axisPointer: {
                  type: 'line',
                  lineStyle: {
                      color: '#408829',
                      type: 'dashed'
                  },
                  crossStyle: {
                      color: '#408829'
                  },
                  shadowStyle: {
                      color: 'rgba(200,200,200,0.3)'
                  }
              }
          },

          dataZoom: {
              dataBackgroundColor: '#eee',
              fillerColor: 'rgba(64,136,41,0.2)',
              handleColor: '#408829'
          },
          grid: {
              borderWidth: 0
          },

          categoryAxis: {
              axisLine: {
                  lineStyle: {
                      color: '#408829'
                  }
              },
              splitLine: {
                  lineStyle: {
                      color: ['#eee']
                  }
              }
          },

          valueAxis: {
              axisLine: {
                  lineStyle: {
                      color: '#408829'
                  }
              },
              splitArea: {
                  show: true,
                  areaStyle: {
                      color: ['rgba(250,250,250,0.1)', 'rgba(200,200,200,0.1)']
                  }
              },
              splitLine: {
                  lineStyle: {
                      color: ['#eee']
                  }
              }
          },
          timeline: {
              lineStyle: {
                  color: '#408829'
              },
              controlStyle: {
                  normal: {color: '#408829'},
                  emphasis: {color: '#408829'}
              }
          },

          k: {
              itemStyle: {
                  normal: {
                      color: '#68a54a',
                      color0: '#a9cba2',
                      lineStyle: {
                          width: 1,
                          color: '#408829',
                          color0: '#86b379'
                      }
                  }
              }
          },
          map: {
              itemStyle: {
                  normal: {
                      areaStyle: {
                          color: '#ddd'
                      },
                      label: {
                          textStyle: {
                              color: '#c12e34'
                          }
                      }
                  },
                  emphasis: {
                      areaStyle: {
                          color: '#99d2dd'
                      },
                      label: {
                          textStyle: {
                              color: '#c12e34'
                          }
                      }
                  }
              }
          },
          force: {
              itemStyle: {
                  normal: {
                      linkStyle: {
                          strokeColor: '#408829'
                      }
                  }
              }
          },
          chord: {
              padding: 4,
              itemStyle: {
                  normal: {
                      lineStyle: {
                          width: 1,
                          color: 'rgba(128, 128, 128, 0.5)'
                      },
                      chordStyle: {
                          lineStyle: {
                              width: 1,
                              color: 'rgba(128, 128, 128, 0.5)'
                          }
                      }
                  },
                  emphasis: {
                      lineStyle: {
                          width: 1,
                          color: 'rgba(128, 128, 128, 0.5)'
                      },
                      chordStyle: {
                          lineStyle: {
                              width: 1,
                              color: 'rgba(128, 128, 128, 0.5)'
                          }
                      }
                  }
              }
          },
          gauge: {
              startAngle: 225,
              endAngle: -45,
              axisLine: {
                  show: true,
                  lineStyle: {
                      color: [[0.2, '#86b379'], [0.8, '#68a54a'], [1, '#408829']],
                      width: 8
                  }
              },
              axisTick: {
                  splitNumber: 10,
                  length: 12,
                  lineStyle: {
                      color: 'auto'
                  }
              },
              axisLabel: {
                  textStyle: {
                      color: 'auto'
                  }
              },
              splitLine: {
                  length: 18,
                  lineStyle: {
                      color: 'auto'
                  }
              },
              pointer: {
                  length: '90%',
                  color: 'auto'
              },
              title: {
                  textStyle: {
                      color: '#333'
                  }
              },
              detail: {
                  textStyle: {
                      color: 'auto'
                  }
              }
          },
          textStyle: {
              fontFamily: 'Arial, Verdana, sans-serif'
          }
      };
	  

	  
	  var echartGauge = echarts.init(document.getElementById('echart_guage'), theme);

      echartGauge.setOption({
        tooltip: {
          formatter: "{a} <br/>{b} : {c}%"
        },
        toolbox: {
          show: true,
          feature: {
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        series: [{
          name: 'Performance',
          type: 'gauge',
          center: ['50%', '50%'],
          startAngle: 140,
          endAngle: -140,
          min: 0,
          max: 100,
          precision: 0,
          splitNumber: 10,
          axisLine: {
            show: true,
            lineStyle: {
              color: [
                [0.2, 'lightgreen'],
                [0.4, 'orange'],
                [0.8, 'skyblue'],
                [1, '#ff4500']
              ],
              width: 30
            }
          },
          axisTick: {
            show: true,
            splitNumber: 5,
            length: 8,
            lineStyle: {
              color: '#eee',
              width: 1,
              type: 'solid'
            }
          },
          axisLabel: {
            show: true,
            formatter: function(v) {
              switch (v + '') {
                case '10':
                  return 'a';
                case '30':
                  return 'b';
                case '60':
                  return 'c';
                case '90':
                  return 'd';
                default:
                  return '';
              }
            },
            textStyle: {
              color: '#333'
            }
          },
          splitLine: {
            show: true,
            length: 30,
            lineStyle: {
              color: '#eee',
              width: 2,
              type: 'solid'
            }
          },
          pointer: {
            length: '80%',
            width: 8,
            color: 'auto'
          },
          title: {
            show: true,
            offsetCenter: ['-65%', -10],
            textStyle: {
              color: '#333',
              fontSize: 15
            }
          },
          detail: {
            show: true,
            backgroundColor: 'rgba(0,0,0,0)',
            borderWidth: 0,
            borderColor: '#ccc',
            width: 100,
            height: 40,
            offsetCenter: ['-60%', 10],
            formatter: '{value}%',
            textStyle: {
              color: 'auto',
              fontSize: 30
            }
          },
          data: [{
            value: 5,
            name: 'Performance'
          }]
        }]
      });
	  var echartLine = echarts.init(document.getElementById('echart_line'), theme);

      echartLine.setOption({
        title: {
          text: 'Line Graph',
          subtext: 'Subtitle'
        },
        tooltip: {
          trigger: 'axis'
        },
        legend: {
          x: 220,
          y: 40,
          data: ['Intent', 'Pre-order', 'Deal']
        },
        toolbox: {
          show: true,
          feature: {
            magicType: {
              show: true,
              title: {
                line: 'Line',
                bar: 'Bar',
                stack: 'Stack',
                tiled: 'Tiled'
              },
              type: ['line', 'bar', 'stack', 'tiled']
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: true,
        xAxis: [{
          type: 'category',
          boundaryGap: false,
          data: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
        }],
        yAxis: [{
          type: 'value'
        }],
        series: [{
          name: 'Deal',
          type: 'line',
          smooth: true,
          itemStyle: {
            normal: {
              areaStyle: {
                type: 'default'
              }
            }
          },
          data: [10, 12, 21, 54, 260, 830, 710]
        }, {
          name: 'Pre-order',
          type: 'line',
          smooth: true,
          itemStyle: {
            normal: {
              areaStyle: {
                type: 'default'
              }
            }
          },
          data: [30, 182, 434, 791, 390, 30, 10]
        }, {
          name: 'Intent',
          type: 'line',
          smooth: true,
          itemStyle: {
            normal: {
              areaStyle: {
                type: 'default'
              }
            }
          },
          data: [1320, 1132, 601, 234, 120, 90, 20]
        }]
      });*/
</script>
</body>
</html>