<?php   
class searchArticles
{
	public function strip_word_html($text, $allowed_tags = '<b><i><sup><sub><em><strong><u><br><a>') 
    {
    	mb_regex_encoding('UTF-8'); 
        //replace MS special characters first 
        $search = array('/&lsquo;/u', '/&rsquo;/u', '/&ldquo;/u', '/&rdquo;/u', '/&mdash;/u', '/&quot;/u', '/&acute;/u', '/&ndash;/u', '/&acirc;/u', '/&frasl;/u', '/&reg;/u', '/&uacute;/u', '/&eacute;/u', '/&acute;/u', '/&acirc;/u', '/&oacute;/u', '/&beta;/u', '/&alpha;/u', '/&atilde;/u', '/&mu;/u', '/&pi;/u', '/&Omega;/u', '/&deg;/u', '/&infin;/u', '/&trade;/u', '/&plusmn;/u', '/&auml;/u', '/&euml;/u', '/&uuml;/u', '/&yuml;/u'); 
        $replace = array('\'', '\'', '\"', '\"', '\-', '\"', "\'", '\�', '\ ', '\/', '\�', '\�', '\�', '\�', '\�', '\�', '\�', '\a', '\�', '\�', '\p', '\?', '\�', '\8', '\�', '\�', '\�', '\�', '\�', '\�'); 
        $text = preg_replace($search, $replace, $text); 
        //make sure _all_ html entities are converted to the plain ascii equivalents - it appears 
        //in some MS headers, some html entities are encoded and some aren't 
        $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8'); 
        //try to strip out any C style comments first, since these, embedded in html comments, seem to 
        //prevent strip_tags from removing html comments (MS Word introduced combination) 
        //if(mb_stripos($text, '/*') !== FALSE){ 
         //   $text = mb_eregi_replace('#/\*.*?\*/#s', '', $text, 'm'); 
        //} 
        //introduce a space into any arithmetic expressions that could be caught by strip_tags so that they won't be 
        //'<1' becomes '< 1'(note: somewhat application specific) 
        $text = preg_replace(array('/<([0-9]+)/'), array('< $1'), $text); 
        $text = strip_tags($text, $allowed_tags); 
        //eliminate extraneous whitespace from start and end of line, or anywhere there are two or more spaces, convert it to one 
        $text = preg_replace(array('/^\s\s+/', '/\s\s+$/', '/\s\s+/u'), array('', '', ' '), $text); 
        //strip out inline css and simplify style tags 
        $search = array('#<(strong|b)[^>]*>(.*?)</(strong|b)>#isu', '#<(em|i)[^>]*>(.*?)</(em|i)>#isu', '#<u[^>]*>(.*?)</u>#isu'); 
        $replace = array('<b>$2</b>', '<i>$2</i>', '<u>$1</u>'); 
        $text = preg_replace($search, $replace, $text); 
        //on some of the ?newer MS Word exports, where you get conditionals of the form 'if gte mso 9', etc., it appears 
        //that whatever is in one of the html comments prevents strip_tags from eradicating the html comment that contains 
        //some MS Style Definitions - this last bit gets rid of any leftover comments */ 
        $num_matches = preg_match_all("/\<!--/u", $text, $matches); 
        if($num_matches)
		{
			$text = preg_replace('/\<!--(.)*--\>/isu', '', $text); 
        } 
        return $text; 
    }
	
	public function showArchives()
	{
		$sql = "SELECT * FROM issue_master where issue_status='Visible' order by issue_id desc";
		$dbq = query ($sql);
		assert ($dbq);
		echo '<table width="100%" border="0" cellspacing="0" cellpadding="0">';
		$i=1;$bgcolour="";
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
			if ($bgcolour == "row_line2")
				$bgcolour = "row_line1";
			else
				$bgcolour = "row_line2";
				echo "<tr><td width=\"100%\" class=$bgcolour onmouseout=\"className='$bgcolour';\" style='font-size: 12px;    line-height: 18px;'>J.App.Pharm.Sci. ".$records['issue_no'].", <a href=\"past-articles.php?issueid=".$records['issue_id']."\">".$records['issue_period']."</a></td></tr>";
			}
		}
     	echo "</table>";
	}
	
	public function getCurrentIssueTitle()
	{
		$sql = "select * from issue_master where issue_status='Current'";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				echo trim($records['issue_no']) . ", " . trim($records['issue_period']);
				break;
			}
		}
	}
	public function getEditorContents($id)
	{
		$sql = "select contents from editor_master where editor_id=$id";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				echo $records['contents'];
				break;
			}
		}
	}
	
	public function getAboutJournal()
	{
		$sql = "select contents from about_journal";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				echo $records['contents'];
				break;
			}
		}
	}
	
	public function getIndexingname()
	{
		$sql = "select * from indexing_master where index_sts='Visible' order by index_sort";
		$dbq = query ($sql);
		assert ($dbq);
		if(getRowCount($dbq) >=1)
		{
			$storearray = array();
			$count=0;
			while($records = mysql_fetch_array($dbq, MYSQL_ASSOC))
			{ 
				$storearray[$count] = $records['index_name'];
				//$index = explode(',',$storearray);
				$count++;
			}
			$index_val = implode(", ", $storearray);
			print_r($index_val);
		}
	}
	
	public function getCurrentIssuePeriod()
	{
		$sql = "select * from issue_master where issue_status='Current'";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;	
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				echo "<span style=\"text-transfrom:uppercase;\">".trim($records['issue_period'])."</span>";
				break;
			}
		}
	}

	public function updateCounter($id)
	{
		$sql = "select view from articles where article_id=".$id;
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;	
		if( getRowCount($dbq) >=1)
		{
			/*$records = fetch($dbq);
				$count=$records[0]+1;
				$sqlarti="update articles set view=".$count." where article_id=".$id;
				query ($sqlarti);
			*/
			$records = fetch($dbq);
			$text="Event Time [".date('d-m-Y h:i:s')."] Update article [id=".$id." from view count =".$records[0]." to view count =".($records[0]+1)."]\n";
			$filenameSuccess='log/log'.date('d-m-Y');
			$fp = fopen($filenameSuccess, "a+");
			$fw = fwrite($fp,$text);
			fclose($fp);
			$count=$records[0]+1;
			$sql1="update articles set view=".$count." where article_id=".$id;
			query ($sql1);
		}
	}
	public function updateDownloadCounter($id)
	{
		$sql = "select download from articles where article_id=".$id;
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;	
		if( getRowCount($dbq) >=1)
		{
			$records = fetch($dbq);
			$text="Event Time [".date('d-m-Y h:i:s')."] Download article [id=".$id." from download count =".$records[0]." to download count =".($records[0]+1)."]\n";
			$filenameSuccess='log/log'.date('d-m-Y');
			$fp = fopen($filenameSuccess, "a+");
			$fw = fwrite($fp,$text);
			fclose($fp);
			$count=$records[0]+1;
			$sql1="update articles set download=".$count." where article_id=".$id;
			query ($sql1);
		}
	}

	
	public function getArchiveIssueTitle()
	{
		$issueid	= isset ($_REQUEST['issueid']) ? $_REQUEST['issueid'] : '';
		$sql = "select * from issue_master where issue_id=$issueid";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				echo trim($records['issue_no']) . ", " . trim($records['issue_period']);
				break;
			}
		}
	}

	private function getIssueUrl($issueid)
	{
		$issue_url = "";
		$sql = "select issue_url from issue_master where issue_id=$issueid";
		$dbq = query ($sql);
		assert ($dbq);
		if( getRowCount($dbq) >=1)
		{
			$records = fetch($dbq);
			$issue_url = trim($records['issue_url']);
		}
		return $issue_url;
	}
		
	public function archiveIssueArticle()
	{
		$issueid	= isset ($_REQUEST['issueid']) ? $_REQUEST['issueid'] : '';
		//$issue_url	= $this->getIssueUrl($issueid);
		$cat1_total = 0;
		$cat2_total = 0;
		
		$sql = "select *, file_url as filelink from articles where articles.issue_id=$issueid ";//and article_category='" . $this->tabname[0] . "'";
		$cat1_data = $this->makeDataGrid($sql,"search",$cat1_total,0);
		
		?>
                    <div id="Pha" style="background-color:#F5F7F0;"><?php  echo $cat1_data; ?></div>
	<?php 
	    	
	}
	
	
	
	public function arcIssueArticle()
	{
		$cat1_total = 0;
		$issueid	= isset ($_REQUEST['issueid']) ? $_REQUEST['issueid'] : '';		
		$sql = "select *,file_url as filelink from articles where issue_id = $issueid order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		
		$cat1_data = $this->makeDataGrid($sql,"normal",$cat1_total,0);
		?>
		<div id="tabs" style="background-color:#F5F7F0;border:0;">
	    <?php
		
					echo '<div id="Pha" style="background-color:#F5F7F0;">';                 	
        				echo $cat1_data;						
					echo '</div>';
	    		?>
                
				</div>
                
<?php                 
	} 
	public function abstractdetails()
	{     
     	$cat1_total = 0;
     	
     		     	
		$article_id	= isset ($_REQUEST['article_id']) ? $_REQUEST['article_id'] : '';		
				
		$sql = "SELECT * FROM articles a join issue_master i where a.issue_id=i.issue_id and article_id = $article_id order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		
		$cat1_data = $this->viewAbstract($sql,"normal",$cat1_total);
				
		?>
		<div>
	    	<ul>
	    		<li></li>		
	    	</ul>
		<?php
		
						echo $cat1_data;						
				?>
                
				</div>
                <?php
				}
	
	public function getMostViewArticle()
	{
		$cat1_total = 0;
		$view	= isset ($_REQUEST['view']) ? $_REQUEST['view'] : '';		
		$sql = "select *,file_url as filelink from articles order by view desc limit 5";
		
		$cat1_data = $this->fillMostView($sql,"normal",$cat1_total);
		
		?>
		<div id="tabs" style="background-color:#F5F7F0;border:0;">
	    <?php
			echo '<div id="Pha" style="background-color:#F5F7F0;">';              	
        		echo $cat1_data;						
			echo '</div>';
	    ?>
        </div>
        <?php
	}
	
	public function getNews()
	{
		$cat1_total = 0;
		$news_sts	= isset ($_REQUEST['news_sts']) ? $_REQUEST['news_sts'] : '';		
		$sql = "select news_desc from news_master where news_sts='Visible' order by news_sort asc";
		
		$cat1_data = $this->fillNewsGrid($sql,"normal",$cat1_total);
		
			//echo '<div id="Pha" style="background-color:#F5F7F0;">';
			echo '<div id="Pha">';                 	
        		echo $cat1_data;						
			echo '</div>';
	   
	}
	
	public function currentIssueArticle()
	{
		$cat1_total = 0;
		$sql = "select a.*,a.file_url as filelink,b.issue_no from articles a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$cat1_data = $this->makeDataGrid($sql,"normal",$cat1_total,0);
		?>
		<div id="tabs" style="background-color:#F5F7F0;border:0;">
	   <?php
		echo '<div id="Pha" style="background-color:#F5F7F0;">';
        	echo $cat1_data;
		echo '</div>';
	    		?>
                
				</div>             
                
				<?php
				if($cat1_total<=0 && $cat2_total<=0)
				{
				?>		<div class="head" style="height:150px" align="center"><br /><br /><br />Current issues would be published very soon. Keep looking this space. </div>
<?php 
				}
	}
	
	
	public function MostviewedArticle()
	{
		$cat1_total = 0;
		$sql = "select *, a.file_url as filelink from articles a order by a.view desc limit 15";
		$cat1_data = $this->makeDataGrid($sql,"normal",$cat1_total,1);
		?>
		<div id="tabs" style="background-color:#F5F7F0;border:0;">
	   <?php
		echo '<div id="Pha" style="background-color:#F5F7F0;">';
        	echo $cat1_data;
		echo '</div>';
	    		?>
                
				</div>
				<?php
				if($cat1_total<=0 && $cat2_total<=0)
				{
				?>		<div class="head" style="height:150px" align="center"><br /><br /><br />Current issues would be published very soon. Keep looking this space. </div>
<?php 
				}
	}

  	public function searchIssueArticle()
  	{
		$cat1_total = 0;
		$cat2_total = 0;
		$cat3_total = 0;
		$cat4_total = 0;
  		$record = array();
 		$record['au']	= isset ($_REQUEST['au']) ? $_REQUEST['au'] : '';
		$record['tit']	= isset ($_REQUEST['tit']) ? $_REQUEST['tit'] : '';
		$record['ky']	= isset ($_REQUEST['ky']) ? $_REQUEST['ky'] : '';		
		$record['isu']	= isset ($_REQUEST['isu']) ? $_REQUEST['isu'] : '';
		$record['cat']	= isset ($_REQUEST['cat']) ? $_REQUEST['cat'] : '';
		
		if($record['au']!="" || $record['tit']!="" || $record['ky']!=""|| $record['isu']!="" || $record['cat']!="")
		{
			$sql = "select a.*,sm.issue_no,a.file_url as filelink from articles a, issue_master sm where a.issue_id=sm.issue_id";
			
			if($record['au']!="")
			{
				$sql .= " and authors like '%".$record['au']."%'";
			}
			if($record['tit']!="")
			{
				$sql .= " and title like '%".$record['tit']."%'";
			}
			if($record['ky']!="")
			{
				$sql .= " and keywords like '%".$record['ky']."%'";
			}
			if($record['isu']!="" && $record['isu']!="0")
			{
				$sql .= " and sm.issue_id like '%".$record['isu']."%'";
			}
			if($record['cat']!="" && $record['cat']!="0")
			{
				$sql .= " and a.article_category like '%".$record['cat']."%'";
			}
			//echo $this->makeDataGrid($sql,"search");
		}		
		//$cat1_data = $this->makeDataGrid($sql,"search",$cat1_total);
		
		$sql1=$sql;
		$sql4=$sql;
		$sql3=$sql;
		
		
		//echo $sql = "select a.*,replace(a.file_url,'[URL]',b.issue_url) as filelink from articles a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' and article_category='" . $this->tabname[0] . "'";
		$sql .= " and a.article_category='" . $this->tabname[0] . "'  and a.article_subcategory='" . $this->subtabname[0] . "' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$cat1_data = $this->makeDataGrid($sql,"search",$cat1_total,0);
		
		$sql1 .= " and a.article_category='" . $this->tabname[0] . "'   and a.article_subcategory='" . $this->subtabname[1] . "' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$cat2_data = $this->makeDataGrid($sql1,"search",$cat2_total,0);
		
		
		$sql3 .= " and a.article_category='" . $this->tabname[1] . "'   and a.article_subcategory='" . $this->subtabname[0] . "' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$cat3_data = $this->makeDataGrid($sql3,"search",$cat3_total,0);
		
		
		$sql4 .= " and a.article_category='" . $this->tabname[1] . "'   and a.article_subcategory='" . $this->subtabname[1] . "' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$cat4_data = $this->makeDataGrid($sql4,"search",$cat4_total,0);
		
		?>
		<div id="tabs" style="background-color:#F5F7F0;border:0;">
	    	<ul>
	    		<?php
	    			if ($cat1_total >=1 || $cat2_total >=1)
	    			{
	    				?>
	    					<li><a href="#Pha"><span><?php  echo $this->tabname[0]; ?></span></a></li>		
	    				<?php 
	    			}
	    			
					if ($cat3_total >=1 || $cat4_total >=1)
	    			{
	    				?>
	    					<li><a href="#Bio"><span><?php  echo $this->tabname[1]; ?></span></a></li>		
	    				<?php 
	    			}
	    		?>
	    	</ul>
		<?php
		
				if ($cat1_total >=1 || $cat2_total >=1)
	    		{
	    				    
					echo '<div id="Pha" style="background-color:#F5F7F0;">';
                 	if($cat1_total>=1)  
					{
        				echo '<span class="toplink"><h3>'. $this->subtabname[0].'</h3></span>'.$cat1_data;
					}
					if($cat2_total>=1)  
					{ 
        				echo '<span class="toplink"><h3>'. $this->subtabname[1].'</h3></span>'.$cat2_data;
					}
					echo '</div>';
	    		}
	    		
				
				if ($cat3_total >=1 || $cat4_total >=1)
	    		{
	    				    
					echo '<div id="Bio" style="background-color:#F5F7F0;">';
                 	if($cat3_total>=1)  
					{ 
        				echo '<span class="toplink"><h3>'. $this->subtabname[0].'</h3></span>'.$cat3_data;
					}
					if($cat4_total>=1)  
					{ 
        				echo '<span class="toplink"><h3>'. $this->subtabname[1].'</h3></span>'.$cat4_data;
					}
					echo '</div>';
	    		}
	}

	private function makeDataGrid($sql,$action="normal",&$total_record=0, $mv=0)	//$action = normal/search
	{
		$dbq = query ($sql);
		assert ($dbq);
		
		$i		= 0;
		$data 	= "";
		$colnum = 3;
		
		$data.= "<table border =\"0\" width=\"50%\" cellspacing=\"0\" cellpadding=\"10\">";
		if( getRowCount($dbq) >=1)
		{
			$data .= "<tr style=\"background: #fff;border-top: 1px solid #ccc;font-size: 12px;    line-height: 18px;\"><td colspan=\"2\"  ></td></tr>";
			while($records = fetch($dbq))
			{  
				$authors = stripslashes(str_replace(",",", ",$records['authors']));
	
				$i++;
				
				$data .= "<tr>";
				$DbContent = self::strip_word_html(html_entity_decode($records['title'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br>');
				//$DbContent=$records['title'];
				/*$DbContent=htmlentities($DbContent,ENT_COMPAT,'utf-8'); 
	      		$DbContent = html_entity_decode($DbContent,ENT_COMPAT,'ISO-8859-1'); 
	      		$DbContent = self::unhtmlspecialchars($DbContent);*/
	      		
	      		$DbContent1 = self::strip_word_html(html_entity_decode($authors,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br>');
				//$DbContent=$records['title'];
				//$DbContent1=htmlentities($DbContent1,ENT_COMPAT,'utf-8'); 
	      		//$DbContent1 = html_entity_decode($DbContent1,ENT_COMPAT,'ISO-8859-1'); 
	      		//$DbContent1 = self::unhtmlspecialchars($DbContent1);
	      		
				$data .= "<td colspan=\"2\"><span style='font-size: 12px;    line-height: 18px;' class=\"title\"><strong>".$records['article_category'].": </strong>" .$DbContent/*htmlspecialchars_decode($DbContent, ENT_NOQUOTES)*//*self::strip_word_html(, $allowed_tags = '<b><i><sup><sub><em><strong><u><br>')*/. "</span><p class=\"author\" style=\"margin:0; padding:4px 0;font-size: 12px;    line-height: 18px;\"> ".$DbContent1." </p>";
        if($records['doi']!='')
	  	{
	  		$data .= "<p style=\"margin:0; padding:3px 0;font-size: 12px;    line-height: 18px;\"><strong>DOI:</strong> ".$records['doi']." &nbsp;&nbsp;&nbsp;&nbsp;Pages: ".$records['pages']."</p>";
		} 
	  	else 
	  	{
	  		$data .= "<p style=\"margin:0; padding:3px 0;font-size: 12px;    line-height: 18px;\">Pages: ".$records['pages']."</p>";
	  	}
			$data .="</td></tr><tr>";
		if($mv)
		{
			$data .= "<td style='font-size:12px'><p >[<a href=\"#\" onclick=\"window.open('counter.php?aid=".$records['article_id']."','_self')\" >Abstract</a>]&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  [<a href=\"admin/php/uploads/".$records['filelink']."\" onclick=\"window.open('counter.php?did=".$records['article_id']."','_parent')\" target=\"_blank\">Download PDF</a>]</td>";
			$data .= "<td style=\"text-align:right;\"><i>Viewed:&nbsp;&nbsp;".$records['view']."</i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Downloaded:&nbsp;&nbsp;".$records['download']."</i></p></td>";
		}
		else {
			$data .= "<td  colspan=\"2\" style='font-size:12px'><p style=\"margin:0; padding:2px 0;font-size:12px\">[<a href=\"#\" onclick=\"window.open('counter.php?aid=".$records['article_id']."','_self')\" >Abstract</a>]&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  [<a href=\"admin/php/uploads/".$records['filelink']."\" onclick=\"window.open('counter.php?did=".$records['article_id']."','_parent')\" target=\"_blank\">Download PDF</a>]</p></td>";
		
		}
      			$data .="</tr>";
				$data .= "<tr style=\"background: #fff;border-top: 1px solid #ccc;\"><td colspan=\"2\"  ></td></tr>";
				
			}	
		}
		else
		{
			$data .= "<tr><td colspan=2 align=center>Article not found</td></tr>";
		}
		
     	$data .= "</table>";
     	
     	$total_record = $i;
     	return $data;
	}
	
	
	private function fillMostView($sql,$action="normal",&$total_record=0)	//$action = normal/search
	{
		$dbq = query ($sql);
		assert ($dbq);
		
		$i		= 0;
		$data 	= "";
		$colnum = 3;
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				$str = self::strip_word_html($records['title'], $allowed_tags = '<b><i><sup><sub><em><strong><u><br>');
				/*if(strlen($str)>90)
				{
					$str=substr($str,0,90);					
				}
				$str=$str." <span style=\"color:#0b75b2\">read more</span>";*/
				$data .= "<li><p><a href=\"abstract.php?article_id=".$records['article_id']."\">" .$str. "</a></p></li><br />";
			}
		}
     	$total_record = $i;
     	return $data;
	}
	
	private function fillNewsGrid($sql,$action="normal",&$total_record=0)	//$action = normal/search
	{
		$dbq = query ($sql);
		assert ($dbq);
		
		$i		= 1;
		$data 	= "";
		$colnum = 3;
		if( getRowCount($dbq) >=1)
		{
			$data.="<ul>";
			while($records = fetch($dbq))
			{ $i++;
				$data .= "<li>";
				$data .= stripslashes(self::strip_word_html($records['news_desc'], $allowed_tags = '<b><i><sup><sub><em><strong><u><br><a>')). "</li>";
			}
						$data.="</ul>";
			
		}
     	$total_record = $i;
     	return $data;
	}


	private function viewAbstract($sql,$action="normal",&$total_record=0)	//$action = normal/search
	{
		$dbq = query ($sql);
		assert ($dbq);
		
		$i		= 0;
		$data 	= "";
		$colnum = 3;
		
		$data.= "<table border =0 width=50% cellspacing=0 cellpadding=10>";
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				$authors = str_replace(",",", ",$records['authors']);
				$keywords = str_replace(",",", ",$records['keywords']);
	
				$DbContent = self::strip_word_html(html_entity_decode($records['title'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><a>');
				//$DbContent=$records['title'];
				/*$DbContent=htmlentities($DbContent,ENT_COMPAT,'utf-8'); 
	      		$DbContent = html_entity_decode($DbContent,ENT_COMPAT,'ISO-8859-1'); 
	      		$DbContent = self::unhtmlspecialchars($DbContent);*/
	      		
	      		$DbContent1 = self::strip_word_html(html_entity_decode($records['long_desc'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><a>');
				//$DbContent=$records['title'];
				/*$DbContent1=htmlentities($DbContent1,ENT_COMPAT,'utf-8'); 
	      		$DbContent1 = html_entity_decode($DbContent1,ENT_COMPAT,'ISO-8859-1'); 
	      		$DbContent1 = self::unhtmlspecialchars($DbContent1);*/
				$i++;
				$data .= "<tr>";
				$data .= "<div id=\"txt\"><p>Home >";
				if ($records['issue_status']=='Current')
				{
					$data .= " <a href=\"current-issue.php\">Current Issue</a></p>";
				}
				else
				{
					$data .= " <a href=\"past-issue.php\">Past Issue</a></p>";
				}
				 if($records['cross_mark'] == 1){
				 $data.='<!-- Start CrossMark Snippet v1.5 --> 
					<div style="float:right;">
					<div style="float:right"><script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.4.4/jquery.min.js" ></script> 
					<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.7/jquery-ui.min.js" ></script> 
					<script src="https://crossmark-cdn.crossref.org/widget/v2.0/widget.js"></script>
					<a data-target="crossmark" ><img style="border: 0px; margin-top: 50px;" id="crossmark-icon" src="https://crossmark.crossref.org/images/crossmark_button.png" title="" alt=""></a>
					</div> 
					<div id="crossmark-dialog" style="display: none;" title=""> 
						<!-- the external CrossMark data is loaded inside this iframe --> 
						<iframe id="crossmark-dialog-frame" frameborder="0"></iframe> 
					</div> 
					
		 <!-- End CrossMark Snippet -->';
				 }
				 $data .= "<p>Journal of Applied Pharmaceutical Science ".$records['issue_no'].", ".$records['issue_period']."<br />";
				  if ($records['doi']!='')
				{
				$data .= "DOI: ".$records['doi']." <br />";
				}
				$data .= "ISSN 2231-3354</p><br>
				  <h3>".$records['article_category']."</h3><br />
				  <h2>".$DbContent."</h2>
				  <p><strong>".self::strip_word_html(html_entity_decode($authors,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br>')."</strong></p>
				  <p>[<a href=\"admin/php/uploads/".$records['file_url']."\" onclick=\"window.open('counter.php?did=".$records['article_id']."','_parent')\" target=\"_blank\">Download PDF</a>]</p>";

				  if (strlen($DbContent1) >1)
				  {
					  $data .= "<h4>Abstract</h4>
					  <p class=\"abstract\">".$DbContent1."</p>
					  <p><strong>Keywords:</strong> ".self::strip_word_html(html_entity_decode($keywords,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br>')."</p>";
				  }
			      $data .= "</div>";
				$data .="</tr>";
				
			}	
		}
		else
		{
			$data .= "<tr><td colspan=5 align=center>Article not found</td></tr>";
		}
     	$data .= "</table>";
     	
     	$total_record = $i;
     	return $data;
	}

	public function fillArticleCategory()
	{
		echo "<option value=\"\">Select Subject</option>";
		foreach($this->tabname as $key=>$value)
		{
			echo "<option value=\"$value\">$value</option>";
		}
	}
	public function fillArticlesIssue()
	{
			$sql="select issue_no,issue_id from issue_master";
		$dbq = query ($sql);
		assert ($dbq);
		echo "<option value=\"\">Select Issue</option>";
		echo "<option value=\"0\">All Issue</option>";
		while($records = fetch($dbq))
		{
			echo "<option value=".$records['issue_id'].">".$records['issue_no']."</option>";		
		}
	}
	
		public function searchArticleForm1()
	{
	
		?>	<form name="frm">
                        <table width="100%">
                            <tr><td class="head" colspan="2">Search Article</td>
                            </tr>
                                    <tr>
								     <td>Title:</td>							     
								 	 <td>Author:</td>								  
								  </tr>
                                  <tr>
								  <td><input name="tit" type="text" size="20" height="15px" /></td>  						    
								  <td><input name="au" type="text" size="20" height="15px" /></td>
								  </tr>
								  
								   <tr>
								     <td>Keywords:</td>
                                     <td>Issue:</td>
                                    </tr>
								   <tr>
								  <td><input name="ky" type="text" size="20" height="15px" /></td>
                                  <td><select name="isu" style="width:150px;"><?php $this->fillArticlesIssue(); ?>
                                  </select></td>								    
								     </tr>
								   
                                   <tr>
								     
                                     <td align="left"><input type="Submit" name="smt" value="Search"  onclick="return submitform()" height="15px" /></td>
                                     <td></td>
 								   								  </table>
								  </form>
                                  
                                  
		<?php 
	}
public function unhtmlspecialcharsReverse( $string )
	{
		$string = str_replace ( chr(157),  '&#65533;', $string ); //129
		$string = str_replace ( chr(128),  '&euro;', $string ); //129
	    $string = str_replace ( '�',  '&sbquo;', $string ); //130
	    $string = str_replace ( '�',   '&fnof;', $string ); //131
	    $string = str_replace ( '�',  '&bdquo;', $string ); //132
	    $string = str_replace ( '�',   '&hellip;', $string ); //133
	    $string = str_replace ( '�',   '&dagger;', $string ); //134
	    $string = str_replace ( '�',   '&Dagger;', $string ); //135
	    $string = str_replace ( '�',   '&circ;', $string ); //136 
	    $string = str_replace ( '�',   '&permil;', $string ); //137
	    $string = str_replace ( '�',   '&Scaron;', $string ); //138 
	    $string = str_replace ( '�',   '&lsaquo;', $string ); //139 
	    $string = str_replace ( '�',   '&OElig;', $string ); //140 
	    $string = str_replace ( '�',   '&#381;', $string ); //142  
	    $string = str_replace ( '�',   '&lsquo;', $string ); //145
	    $string = str_replace ( '�',   '&rsquo;', $string ); //146
	    $string = str_replace ( '�',   '&ldquo;', $string ); //147
	    $string = str_replace ( '�',   '&rdquo;', $string ); //148
	    $string = str_replace ( '�',   '&bull;', $string ); //149
	    $string = str_replace ( '�',   '&ndash;', $string ); //150
	    $string = str_replace ( '�',   '&mdash;', $string ); //151
	    $string = str_replace ( '� ',   '&tilde;', $string ); //152
	    $string = str_replace ( '�',   '&trade;', $string ); //153 
	    $string = str_replace ( '�',   '&scaron;', $string ); //154 
	    $string = str_replace ( '�',   '&rsaquo;', $string ); //155  
	    $string = str_replace ( '�',   '&oelig;', $string ); //156 
	    $string = str_replace ( '�',   '&#382;', $string ); //158 
	    $string = str_replace ( '�',   '&Yuml;', $string ); //159   
	    return $string;
	  }
	  
	  public function unhtmlspecialchars( $string )
	  {
	    //$string = str_replace ( '�',   '', $string );
	     $string = str_replace ( '�',chr(157) , $string ); //129
	    $string = str_replace ( '&euro;',  '�', $string ); //129
	    $string = str_replace ( '&sbquo;', '�', $string ); //130
	    $string = str_replace ( '&fnof;',  '�', $string ); //131
	    $string = str_replace ( '&bdquo;', '�', $string ); //132
	    $string = str_replace ( '&hellip;',  '�', $string ); //133
	    $string = str_replace ( '&dagger;',  '�', $string ); //134
	    $string = str_replace ( '&Dagger;',  '�', $string ); //135
	    $string = str_replace ( '&circ;',  '�', $string ); //136 
	    $string = str_replace ( '&permil;',  '�', $string ); //137
	    $string = str_replace ( '&Scaron;',  '�', $string ); //138 
	    $string = str_replace ( '&lsaquo;',  '�', $string ); //139 
	    $string = str_replace ( '&OElig;',  '�', $string ); //140 
	    $string = str_replace ( 'Ž',   '�', $string ); //142  
	    $string = str_replace ( '&lsquo;',  '�', $string ); //145
	    $string = str_replace ( '&rsquo;',  '�', $string ); //146
	    $string = str_replace ( '&ldquo;',  '�', $string ); //147
	    $string = str_replace ( '&rdquo;',  '�', $string ); //148
	    $string = str_replace ( '&bull;',  '�', $string ); //149
	    $string = str_replace ( '&ndash;',  '�', $string ); //150
	    $string = str_replace ( '&mdash;',  '�', $string ); //151
	    $string = str_replace ( '&tilde;',  '� ', $string ); //152
	    $string = str_replace ( '&trade;',  '�', $string ); //153 
	    $string = str_replace ( '&scaron;',  '�', $string ); //154 
	    $string = str_replace ( '&rsaquo;',  '�', $string ); //155  
	    $string = str_replace ( '&oelig;',  '�', $string ); //156 
	    $string = str_replace ( 'ž',   '�', $string ); //158 
	    $string = str_replace ( '&Yuml;',  '�', $string ); //159   
	    return $string;
	  }
	public function searchArticleForm()
	{
	
		?>	<form name="frm">
			<table width="100%">
				<tr><td colspan="3" class="head">Search Article</td>
				</tr>
								  <tr>
								     <td width="32%">Title:</td>
								     
								  <td colspan="2"><input name="tit" type="text" class="text"/></td>
								  </tr>
                                  <tr>
								    <td>Author:</td>
								    
								  <td colspan="2"><input name="au" type="text"  class="text"/></td>
								  </tr>
								  
								   <tr>
								     <td>Keywords:</td>
								     
								  <td colspan="2"><input name="ky" type="text" class="text"/></td>
								  </tr>
								   <tr>
								     <td>Issue:</td>
								     
								  <td valign="bottom" colspan="2"><select name="isu"  style="width:125px" class="text"><?php $this->fillArticlesIssue(); ?></select></td>
								  
							      </tr>	
                                  <tr>
								     <td>Subject:</td>
								     
								  <td width="4%" valign="bottom"><select name="cat" class="text"><?php $this->fillArticleCategory(); ?></select></td>
								  <td width="64%"><img src="images/ijlpr_24.jpg" alt="search" width="15" height="15" onclick="return submitform()"/></td>
							      </tr>							                                                                        
								  </table>
								  </form>
                                  
                                  
		<?php 
	}
	public function getUsersOnline() { 
	$count = 0; 
		$sessionpath=session_save_path();
		$handle = opendir($sessionpath); 
		if ($handle == false) return -1; 
		/*while (false !== ($file = readdir($handle))) {
			if (filectime($file)< (time()-60)) {  // 600 = 10*60
			 $count++; 
			}
		}*/
		while (($file = readdir($handle)) != false) { 
			//if (preg_match("/^sess", $file)){ 
			if (substr($file, 0,4) == "sess"){
			
			//echo time()- filemtime( $sessionpath.'/'.$file)."<br>";
			
				if(time()- filemtime( $sessionpath.'/'.$file) <  1900) { 
						$count++; 
					}else{
						unlink($sessionpath.'/'.$file);
					}	
			}
		} 
		closedir($handle); 
		//echo $count; 
		return $count; 
} 

	
	
} 
//////////////////////////////////////////////////

/*	public function currentIssueArticle()
	{
		$cat1_total = 0;
		$cat2_total = 0;
		
		//echo $sql = "select a.*,replace(a.file_url,'[URL]',b.issue_url) as filelink from articles a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' and article_category='" . $this->tabname[0] . "'";
		$sql = "select a.*,a.file_url as filelink from articles a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' and a.article_category='" . $this->tabname[0] . "'";
		$cat1_data = $this->makeDataGrid($sql,"current",$cat1_total);
		
		$sql = "select a.*,a.file_url as filelink from articles a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' and article_category='" . $this->tabname[1] . "'";
		$cat2_data = $this->makeDataGrid($sql,"current",$cat2_total);	 		
		
		?>
		<!-- background-color:#F5F7F0; -->
		<div id="tabs" style="background-color:#F5F7F0;border:0;">
	    	<ul>
	    		<?php
	    			if ($cat1_total >=1)
	    			{
	    				?>
	    					<li><a href="#Pha"><span><?php  echo $this->tabname[0]; ?></span></a></li>		
	    				<?php 
	    			}
	    			
					if ($cat2_total >=1)
	    			{
	    				?>
	    					<li><a href="#Bio"><span><?php  echo $this->tabname[1]; ?></span></a></li>		
	    				<?php 
	    			}
	    		?>
	    	</ul>
	    	<?php 
	    		if ($cat1_total >=1)
	    		{
	    			?><div id="Pha" style="background-color:#F5F7F0;"><?php  echo $cat1_data; ?></div><?php 
	    		}
	    		
				if ($cat2_total >=1)
	    		{
	    			?><div id="Bio" style="background-color:#F5F7F0;"><?php  echo $cat2_data; ?></div><?php 
	    		}
	    	?>
		</div>
		<?php 
	}
*/   
?>
                                                                                                                 