<?php
	//error_reporting(E_ALL);
	//ini_set('display_errors', '1');
	
	function _initConnection() 
	{
    	$isInitialized = false;
		if (!$isInitialized) 
		{
        	connect();
        	$isInitialized = true;
		}
	}
		
	function connect() 
	{
		global $UBI_CONFIG;
		
		$link = mysql_pconnect($UBI_CONFIG['conn_host'], $UBI_CONFIG['user_name'], $UBI_CONFIG['password']);
		if (!$link)
			die("Could't connect to mysql");

		$dbc = mysql_select_db($UBI_CONFIG['conn_instance'], $link) or die (mysql_error());
		@assert ($dbc);
	    return $dbc;
    }
		
    function generateXML($root,$element,$data)
	{
		$resultXML = "<$root>";
		foreach($data as $rowid=>$row_value)
		{
			$resultXML .= "<$element>";
			foreach($row_value as $col_key=>$col_value)
			{
				$resultXML .= "<$col_key>$col_value</$col_key>";
			}	
			$resultXML .= "</$element>";
		}
		$resultXML .= "</$root>";
		return $resultXML;
	}
	
	function escapeSQL ($str) 
	{
    	if (is_null ($str))
        	return null;
      	
        if (is_array ($str)) 
		{
			$result = array();
        	foreach ($str as $name => $value) 
			{
          		$result[$name] =  escapeSQL ($value);
        	}
        	return $result;
      	}
	    return mysql_escape_string (strval ($str));
    }

    function escapeSQLSearchPattern ($str) 
	{
    	if (is_null ($str))
        	return null;
      	
        if (is_array ($str)) 
		{
        	$result = array();
        	foreach ($str as $name => $value) 
			{
          		$result[$name] =  escapeSQLSearchPattern ($value);
        	}
        	return $result;
      	}
	    @assert (is_scalar ($str));
    	$rv =  escapeSQL ($str);
      	$rv = preg_replace ('/([\\\\_%])/', '\\\\\\\\\\\\\\1', $rv);
      	return $rv;
    }

   	function escapeSQLString ($str) 
	{
    	if (is_null ($str))
      		return 'NULL';
    	return "'" .  escapeSQL ($str) . "'";
    }

    function escapeSQLTimestamp ($ts) 
	{
    	if (is_null ($ts))
      		return 'NULL';
    	$escapedTimeString = gmstrftime ($GLOBALS['DATABASE__PHP_TIME_FORMAT'], $ts);
    	return "TO_TIMESTAMP ('$escapedTimeString', '${GLOBALS['DATABASE__DB_TIME_FORMAT']}')";
    }

    function createSQLParameter ($arg, $as_string = true) 
    {
    	if (is_null ($arg))
        	return 'NULL';
      	if ($as_string)
        	return  escapeSQL (strval ($arg));
      	return strval ($arg);
    }

    function createInsertCommand ($table, $content) 
	{
    	@assert (is_string ($table));
      	@assert (strlen ($table) > 0);
      	@assert (is_array ($content));
      	@assert (count ($content) > 0);
      	$keys = '';
      	$values = '';
      	$comma = '';
      	foreach ($content as $key => $value) 
		{
        	$value =  escapeSQL ($value);
        	$keys .= "$comma$key";
        	$values .= "$comma'$value'";
        	$comma = ", ";
      	}
      	$sql = "INSERT INTO $table ($keys) VALUES ($values)";
      	return $sql;
    }

    function createUpdateCommand ($table, $content, $match = null) 
	{
    	@assert (is_string ($table));
    	@assert (strlen ($table) > 0);
    	@assert (is_array ($content));
    	@assert (count ($content) > 0);
    	$sql = "UPDATE $table SET ";
    	$where = '';
    	$exclude_keys = array();
    	if (!is_null ($match)) 
    	{
        	if (is_array ($match)) 
        	{
          		if (count ($match) > 0) 
          		{
            		$where = " WHERE ";
            		$and = '';
            		foreach ($match as $key => $value) 
            		{
		            	@assert (is_string ($key));
		              	@assert (is_scalar ($value));
		              	$exclude_keys[$key] = true;
		              	$value =  escapeSQL ($value);
		              	$where .= "$and$key = '$value'";
		              	$and = " AND ";
            		}
          		}
        	} 
        	else 
        	{
          		@assert (is_string ($match));
          		if (strlen ($match) > 0)
            		$where = " WHERE $match";
        	}
      	}
      
      	$field_count = 0;
      	$comma = '';
      	foreach ($content as $key => $value) 
      	{
        	@assert (is_string ($key));
        	if (array_key_exists ($key, $exclude_keys))
          		continue;
        	if (is_null ($value))
          		$sql .= "$comma$key = NULL";
        	else 
        	{
          		@assert (is_scalar ($value));        
          		$notam_list = array();
          		$value =  escapeSQL ($value);
          		$sql .= "$comma$key = '$value'";
        	}
        	$comma = ', ';
        	++$field_count;
      	}
      	@assert ($field_count > 0);
      	$sql .= $where;
      	return $sql;
	}

    function createDeleteCommand ($table, $match = null) 
    {
    	@assert (is_string ($table));
      	@assert (strlen ($table) > 0);
      	$sql = "DELETE FROM $table";
      	if (is_array ($match)) 
      	{
       		$search_cond = '';
        	$and = '';
        	$cond_count = 0;
        	foreach ($match as $key => $value) 
        	{
          		@assert (is_string ($key));
          		@assert (strlen ($key) > 0);
          		@assert (is_scalar ($value));
          		$value =  escapeSQL ($value);
          		$search_cond .= "$and$key = '$value'";
          		$and = " AND ";
          		++$cond_count;
        	}
        	if ($cond_count > 0)
          		$sql .= " WHERE $search_cond";
      	} 
      	else if (strlen (trim ($match)) > 0) 
      	{
        	$sql .= " WHERE $match";
      	}
      	return $sql;
    }


    function query ($sql) 
    {
    	_initConnection();
		$dbq = mysql_query ($sql);
      	@assert ($dbq);
     	return $dbq;
    }

    function getRowCount ($dbq, $dbc = null) 
    {
    	$count = mysql_num_rows ($dbq);
      	return $count;
    }

    function getAffectedRowCount ($dbq) 
    {
    	$count = mysql_affected_rows ($dbq);
      	return $count;
    }
    
    function command ($sql) 
    {
    	_initConnection();
		$dbq = mysql_query ($sql);
      	@assert ($dbq);
		return $dbq;
    }


    function fetch ($dbq, $row_id = null) 
    {
    	if (is_null ($row_id))
       		$row = mysql_fetch_array ($dbq);
      	else
        	$row = mysql_fetch_array ($dbq, $row_id);
      	if ($row) 
      	{
        	$buf = '';
        	$comma = '';
        	foreach ($row as $key => $value) 
        	{
          		if (is_int ($key))
            		continue;
          		$buf .= "$comma$key=$value";
          		$comma = ', ';
        	}
		}
      	return $row;
    }

    function fetchAll ($dbq, $start = 0, $count = null) 
    {
    	$result = array();
      	$row_id = $start;
      	if (is_null ($count))
        	$end = mysql_num_rows ($dbq);
      	else
        	$end = min ($start + $count, mysql_num_rows ($dbq));
		
      	while (true) 
      	{
			if ($row_id >= $end)
          		break;
        	if (!($row = mysql_fetch_array ($dbq, $row_id)))
          		break;
        	array_push ($result, $row);
        	++$row_id;
      	}
      	return $result;
    }

    function lastErrorMessage () 
    {
    	_initConnection();
      	return mysql_last_error();
    }
    
    function getConfigParameter ($name, $default_value = null) 
    {
    	$dbq =  query ("SELECT Value from UBI_Config WHERE ID = '" .  escapeSQL ($name) . "'");
      	@assert ($dbq);
      	if (($row =  fetch ($dbq)))
        	return $row[0];
      	return $default_value;
    }

    function getNextSequenceValue ($sequence_name) 
    {
		$sql = "SELECT max($fld) from $tbl";
	  	$dbq = query ($sql);
		@assert ($dbq);
		if (!($row = fetch ($dbq)))
			return 1;
		else
			return ($row[0]+1);
    }

    function insert ($table, $content) 
    {
    	$sql =  createInsertCommand ($table, $content);
	  	$status =  command ($sql);
      	@assert ($status);
	  	return $status;
    }
	
   
    function update ($table, $content, $match) 
    {
    	$sql =  createUpdateCommand ($table, $content, $match);
	  
	  	$status =  command ($sql);
      	@assert ($status);
	  	return $status;
    }

    function delete ($table, $match) 
    {
    	$sql =  createDeleteCommand ($table, $match);
      	$status =  command ($sql);
      	@assert ($status);
	  	return $status;
    }

    /*function beginTransaction () 
    {
    	$status =  command ("BEGIN TRANSACTION");
      	@assert ($status);
      	return $status;
    }

	function commitTransaction () 
	{
    	$status =  command ("COMMIT");
      	@assert ($status);
      	return $status;
    }

    function rollbackTransaction () 
    {
    	$status =  command ("ROLLBACK");
      	@assert ($status);
      	return $status;
    }*/
?>