<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Administrator | Quiz</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <!-- bootstrap 3.0.2 -->
		<link rel="shortcut icon" type="image/png" href="<?php echo URL; ?>favicon.ico"/>
        <link href="<?php echo URL;?>public/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <!-- font Awesome -->
        <link href="<?php echo URL;?>public/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <!-- Ionicons -->
        <link href="<?php echo URL;?>public/css/ionicons.min.css" rel="stylesheet" type="text/css" />
        <!-- DATA TABLES -->
        <link href="<?php echo URL;?>public/css/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
        <!-- Theme style -->
        <link href="<?php echo URL;?>public/css/AdminLTE.css" rel="stylesheet" type="text/css" />
<script src="<?php echo URL; ?>public/js/jquery.min.js"></script>
      
    </head>
    <body class="skin-blue fixed">
        <!-- header logo: style can be found in header.less -->
        <?php require VIEWS_PATH . '_templates/sidebar.php'; 
				topbar();
				?>
        <div class="wrapper row-offcanvas row-offcanvas-left">
            <!-- Left side column. contains the logo and sidebar -->
            <aside class="left-side sidebar-offcanvas">                
                <!-- sidebar: style can be found in sidebar.less -->
                <?php  
				sidemenu(2);
				?>
                <!-- /.sidebar -->
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <aside class="right-side">                
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Quiz Attempts
                        <small></small>
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Quiz Attempts</li>
                    </ol>
                </section>

                <!-- Main content -->
                <section class="content">
					<div class="row">
							<div class="col-xs-12">
                            <!-- /.box -->
                            
                            <div class="box">
                                <div class="box-header">
                                    <h3 class="box-title">Questions List</h3>
									<!-- tools box -->
                                    <div class="pull-right box-tools">									
                                        <button class="btn btn-info btn-sm"  data-toggle="tooltip" title="Refresh"><i class="fa fa-refresh"></i></button>                                        
                                    </div><!-- /. tools -->                                    
                                </div><!-- /.box-header -->
                                <div class="box-body table-responsive">
									<?php $this->renderFeedbackMessages(); ?>
                                    <table id="example1" class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>Quiz Name</th>
                                                <th>Total Question</th>
                                                <th>Total Time</th>
                                                <th>Total Marks</th>
                                                <th>Passing Marks</th>
                                                <th>Attempt Score</th>
                                                <th>Negative Marks</th>  
                                                <th>Result</th>                       
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
										<?php
											if ($this->attempts) {
												foreach($this->attempts as $key => $value) {
													echo '<tr>';
													echo '<td>' . $value['quiz_name'] . '</td>';
													echo '<td>' . $value['total_ques']. '</td>';
													echo '<td>' . $value['total_time']. '</td>';
													echo '<td>' . $value['total_marks']. '</td>';
													echo '<td>' . $value['passing_score']. '</td>';
													echo '<td>' . $value['total_marks1']. '</td>';
													echo '<td>' . ($value['total_wrong']*$value['negative_marking_point']). '</td>';
												if($value['quiz_sts']=="FINISH"){
													
													if($value['result']){
														echo '<td><small class="badge bg-green">Passed</small></td>';
													}else{
														echo '<td><small class="badge bg-red">Failed</small></td>';			
													}
												}else{
													echo '<td>Incomplete</td>';
												}
													echo '<td><a href="'.URL.'quiz/result/'.$value['attempt_id'].'/'.$value['quiz_id'].'"><i class="fa fa-eye"></i></a></td>';
													
													echo '</tr>';
												}
											} 
										?>
                                        </tbody>
                                        <tfoot>
                                           <tr>
                                                <th>Quiz Name</th>
                                                <th>Total Question</th>
                                                <th>Total Time</th>
                                                <th>Total Marks</th>
                                                <th>Passing Marks</th>
                                                <th>Attempt Score</th>
                                                <th>Negative Marks</th>                       
                                                <th>Result</th>
                                                <th>Action</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                </section><!-- /.content -->
            </aside><!-- /.right-side -->
        </div><!-- ./wrapper -->

<div class="modal fade" id="confirm-quiz" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">            
            <div class="modal-body">
                <h4>Do you want to start this quiz?</h4>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a href="#" class="btn btn-danger danger">Start</a>
            </div>
        </div>
    </div>
</div>


       
        <!-- Bootstrap -->
        <script src="<?php echo URL;?>public/js/bootstrap.min.js" type="text/javascript"></script>
        <!-- DATA TABES SCRIPT -->
        <script src="<?php echo URL;?>public/js/plugins/datatables/jquery.dataTables.js" type="text/javascript"></script>
        <script src="<?php echo URL;?>public/js/plugins/datatables/dataTables.bootstrap.js" type="text/javascript"></script>
        <!-- AdminLTE App -->
        <script src="<?php echo URL;?>public/js/AdminLTE/app.js" type="text/javascript"></script>
       
        <!-- page script -->
        <script type="text/javascript">
			$('#confirm-quiz').on('show.bs.modal', function(e) {
				$(this).find('.danger').attr('href', $(e.relatedTarget).data('href'));
			});
			
            
        </script>

    </body>
</html>
