<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Student | Lessons</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <!-- bootstrap 3.0.2 -->
        <link href="<?php echo URL;?>public/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <!-- font Awesome -->
        <link href="<?php echo URL;?>public/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <!-- Ionicons -->
        <link href="<?php echo URL;?>public/css/ionicons.min.css" rel="stylesheet" type="text/css" />
        <!-- DATA TABLES -->
        <link href="<?php echo URL;?>public/css/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
        <!-- Theme style -->
        <link href="<?php echo URL;?>public/css/AdminLTE.css" rel="stylesheet" type="text/css" />

      <script src="<?php echo URL; ?>public/js/jquery.min.js"></script>
    </head>
    <body class="skin-blue fixed">
        <!-- header logo: style can be found in header.less -->
         <?php require VIEWS_PATH . '_templates/sidebar.php'; 
				topbar();
				?>
        <div class="wrapper row-offcanvas row-offcanvas-left">
            <!-- Left side column. contains the logo and sidebar -->
            <aside class="left-side sidebar-offcanvas">                
                <!-- sidebar: style can be found in sidebar.less -->
                <?php sidemenu(2);
				?>
                <!-- /.sidebar -->
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <aside class="right-side">                
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        <?php
									if ($this->course) {
										echo ($this->course->course_name);
									}
									?>
                        <small>Course</small>
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Lessons</li>
                    </ol>
                </section>

                <!-- Main content -->
                <section class="content">
					 <div class="row">
						 <div class="col-md-12">
							 <div class="box box-solid">
									<div class="box-body">
										
									<?php
									if ($this->course) {
										?>
										<blockquote>
                                        <p>
										<?= html_entity_decode(substr($this->course->long_desc, 0, 200))."...";?>
										</p>
                                        <small><?= $this->course->course_name;?></small>
                                    </blockquote>
										<?php
									}
									?>
									</div>
								</div>
							</div>
						
					 </div>
					 
                    <div class="row">
										<?php
										
											if ($this->lesions) {
												$index=0; $rowcount=0;
												foreach($this->lesions as $key => $value) {
													++$index;
										++$rowcount;
										if($rowcount==4){
											echo '</div><div class="row">'; 
											$rowcount=0;
										}
										?>
										<div class="col-md-4">
											<!-- Primary box -->
											<div class="box box-solid box-success">
												<div class="box-header">
													<h3 class="box-title">Lesson <?=$index?></h3>					
												</div>
												<div class="box-body">
													<h4><?=$value["lession_name"]?></h4>
													<p><?php
													echo html_entity_decode($value['short_desc'])."<br>";
													
													echo "<b>Duration:</b> ".$value['duration']."<br>";
													echo "<b>Total Reading Time:</b> ";
													if($value['readtime']=="00:00:00")
														echo "Not Started";
													else
														echo $value['readtime'];
													
													$flg=false;
													echo "<h4>Prerequisite Lesson: </h4><ul>";
													if(count($value['prerequis'])<1)
													{
														echo "<li>&nbsp;&nbsp; No Lesson</li>";
													}
													foreach($value['prerequis'] as $key1=>$value1)
													{
														if($value1['lesion_sts']){
														echo "<li><i class='fa fa-check text-success'></i>&nbsp;&nbsp;".$value1['lesion_name']."</li>";
														}else{
														echo "<li><i class='fa fa-times text-danger'></i> &nbsp;&nbsp;".$value1['lesion_name']."</li>";
														$flg=true;
														}
													}
													echo "</ul>";
													?>
													</p>	
																				<?php
													if($value['readtime']=="00:00:00")
													{?>
														<a <?php if($flg){echo "disabled";}?> href="<?=URL."lesion/details/".$value['course_id'].'/'.$value['lession_id']?>" class="btn btn-success">Start Reading</a>
													<?php }else{?>
														<a <?php if($flg){echo "disabled";}?> href="<?=URL."lesion/details/".$value['course_id'].'/'.$value['lession_id']?>" class="btn btn-warning">Continue Reading</a>
													<?php }?>	
													
												</div><!-- /.box-body -->
											</div><!-- /.box -->
										</div><!-- /.col -->
										<?php }}else{
								echo '<div class="col-md-12"><h3>No lesion found</h3></div>';}?>										
									</div>
									
									<div class="row">
										<?php
											if ($this->quizs) {
												$index=0;
												foreach($this->quizs as $key => $value) {
													++$index;
										?>
										<div class="col-md-4">
											<!-- Primary box -->
											<div class="box box-solid box-danger">
												<div class="box-header">
													<h3 class="box-title">Quiz <?=$index?></h3>					
												</div>
												<div class="box-body">
													<h4><?=$value["quiz_name"]?></h4>
													<ul><li><b>Syllabus:</b> <?php echo $value['course_name']."</li>";
													echo "<li><b>Total Ques.:</b> ".$value["total_ques"]."</li>";
													echo "<li><b>Total Time:</b> ".date("H:i", strtotime(date($value["total_time"])))." hrs </li>";
													echo "<li><b>Passing Score:</b> ".$value["passing_score"]."%</li>";
													echo "<li><b>Negative Marking:</b> ".(($value["negative_marking"])?"Yes":"No")."</li>";
													if($value["negative_marking"]){
													echo "<li><b>Negative Score:</b> ".$value["negative_markingscore"]."</li>";
													}
													?>
													
													</ul>	<br>												
													<a data-href="<?= URL;?>quiz/view_quiz_instruction/<?=$value['quiz_id']?>" data-toggle="modal" data-target="#confirm-quiz" href="#" class="btn btn-danger danger">Take Test</a>
												</div><!-- /.box-body -->
											</div><!-- /.box -->
										</div><!-- /.col -->
										<?php }}else{
								echo '<div class="col-md-12"><h3>No quiz found</h3></div>';}?>										
									</div>
									
                </section><!-- /.content -->
            </aside><!-- /.right-side -->
        </div><!-- ./wrapper -->
<div class="modal fade" id="confirm-quiz" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">            
            <div class="modal-body">
                <h4>Do you want to start this quiz?</h4>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a href="#" class="btn btn-danger danger">Start</a>
            </div>
        </div>
    </div>
</div>

       
        <!-- Bootstrap -->
        <script src="<?php echo URL;?>public/js/bootstrap.min.js" type="text/javascript"></script>
       
        <script src="<?php echo URL;?>public/js/AdminLTE/app.js" type="text/javascript"></script>
       <!-- page script -->
        <script type="text/javascript">
			$('#confirm-quiz').on('show.bs.modal', function(e) {
				$(this).find('.danger').attr('href', $(e.relatedTarget).data('href'));
			});
			
            
        </script>

    </body>
</html>
