<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Administrator | Courses</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <!-- bootstrap 3.0.2 -->
        <link href="<?php echo URL;?>public/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <!-- font Awesome -->
        <link href="<?php echo URL;?>public/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <!-- Ionicons -->
        <link href="<?php echo URL;?>public/css/ionicons.min.css" rel="stylesheet" type="text/css" />
        <!-- DATA TABLES -->
        <link href="<?php echo URL;?>public/css/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
        <!-- Theme style -->
        <link href="<?php echo URL;?>public/css/AdminLTE.css" rel="stylesheet" type="text/css" />

       <script src="<?php echo URL; ?>public/js/jquery.min.js"></script>
    </head>
    <body class="skin-blue fixed">
        <!-- header logo: style can be found in header.less -->
        <?php require VIEWS_PATH . '_templates/sidebar.php'; 
				topbar();
				?>
        <div class="wrapper row-offcanvas row-offcanvas-left">
            <!-- Left side column. contains the logo and sidebar -->
            <aside class="left-side sidebar-offcanvas">                
                <!-- sidebar: style can be found in sidebar.less -->
                <?php  
				sidemenu(2);
				?>
                <!-- /.sidebar -->
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <aside class="right-side">                
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Courses
                        <small></small>
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Courses</li>
                    </ol>
                </section>

                <!-- Main content -->
                <section class="content">
                    
									<?php $this->renderFeedbackMessages(); ?>
									<div class="row">
										<?php
											if ($this->courses) {
												$index=0; $rowcount=0;
												foreach($this->courses as $key => $value) {
													if($value['student_course']){
														continue;
													}
										++$rowcount;										
										if($rowcount==4){
											echo '</div><div class="row">'; 
											$rowcount=1;
										}
										?>
										<div class="col-md-4">
											<!-- Primary box -->
											<div class="box box-solid box-success">
												<div class="box-header">
													<h3 class="box-title"><?=$value["course_name"]?></h3>
													
												</div>
												<div class="box-body">
													<img src="<?= URL."admin/public/uploads/".$value["course_image"]?>" alt="User Image" />
													<p><?= strip_tags(html_entity_decode($value['short_desc']), "<p><b><i><u><a><ul><ol><li>")?>
													</p>
													<?php if($value['student_sts']){?>
													<a href="<?=URL.'lesion/readLesion/'.$value['course_id'];?>" class="btn btn-success">Read Course</a>
												<?php }else{?>
													<a href="#" data-href="<?= URL.'course/addCourse/'.$value['course_id'];?>" data-toggle="modal" data-target="#confirm-add" class="btn btn-danger">Add</a>
													<?php }?>
													<a href="<?=URL."course/details/".$value['course_id']?>" class="btn btn-default">Details</a>
												</div><!-- /.box-body -->
											</div><!-- /.box -->
										</div><!-- /.col -->
										
											<?php }}else{
								echo '<div class="col-md-12"><h3>No lesion found</h3></div>';}?>										
									</div>
                                

                </section><!-- /.content -->
            </aside><!-- /.right-side -->
        </div><!-- ./wrapper -->


<div class="modal fade" id="confirm-add" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">            
            <div class="modal-body">
                <h4>Do you want to add course to you account?</h4>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a href="#" class="btn btn-danger danger">Add Course</a>
            </div>
        </div>
    </div>
</div>

       
        <!-- Bootstrap -->
        <script src="<?php echo URL;?>public/js/bootstrap.min.js" type="text/javascript"></script>
        <!-- DATA TABES SCRIPT -->
        <script src="<?php echo URL;?>public/js/plugins/datatables/jquery.dataTables.js" type="text/javascript"></script>
        <script src="<?php echo URL;?>public/js/plugins/datatables/dataTables.bootstrap.js" type="text/javascript"></script>
        <!-- AdminLTE App -->
        <script src="<?php echo URL;?>public/js/AdminLTE/app.js" type="text/javascript"></script>
        <!-- page script -->
        <script type="text/javascript">
			
			$('#confirm-add').on('show.bs.modal', function(e) {
				$(this).find('.danger').attr('href', $(e.relatedTarget).data('href'));
			});
            
        </script>

    </body>
</html>
