<?php

/**
 * UserModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class UserModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    
    public function getAllUsers()
    {
        $sql = "SELECT user_id, user_active, user_name, user_email, user_fullname, user_group_id, user_email FROM users";
        $query = $this->db->prepare($sql);
        $query->execute();
        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['user_id'] = $row->user_id;
			$res['user_active'] = $row->user_active;
			$res['user_name'] = $row->user_name;
			$res['user_email'] = $row->user_email;
			$res['user_fullname'] = ucwords(strtolower($row->user_fullname));
			$res['user_group_id'] = $row->user_group_id;
			$res['user_group_name'] = "";
			
			$sql1 = "SELECT group_name FROM user_group where user_group_id =:groupid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('groupid'=>$row->user_group_id));
			while($row1= $query1->fetch())
			{
				$res['user_group_name'] = ucwords(strtolower($row1->group_name));
			}
			$result[] =$res;
		}
      
        return $result;
    }

    
    public function getUser($user_id)
    {
        $sql = "SELECT user_id, user_active, user_name, user_fullname, user_group_id, user_email from users WHERE user_id = :user_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_id' => $user_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }

    
    public function create()
    {
        // clean the input to prevent for example javascript within the groups.
		$user_name = strip_tags($_POST['user_name']);
		$user_fullname = strip_tags($_POST['fullname']);
		$user_group_id = strip_tags($_POST['group_id']);
		$user_email = strip_tags($_POST['email']);
		
		$hash_cost_factor = (defined('HASH_COST_FACTOR') ? HASH_COST_FACTOR : null);
        $user_password_hash = password_hash($_POST['user_password_new'], PASSWORD_DEFAULT, array('cost' => $hash_cost_factor));
        $user_creation_timestamp = time();
        
        $sql = "INSERT INTO users (user_name, user_fullname, user_group_id, user_email, user_active, user_provider_type, user_password_hash,user_creation_timestamp) VALUES (:user_name, :user_fullname, :user_group_id, :user_email, :user_active, :user_provider_type, :user_password_hash, :user_creation_timestamp)";
        $query = $this->db->prepare($sql);
        $query->execute(array( ':user_name'=>$user_name, ':user_fullname' =>$user_fullname, ':user_group_id' =>$user_group_id, ':user_email' => $user_email, ':user_active'=>1, ':user_provider_type'=>'DEFAULT', ':user_password_hash'=>$user_password_hash, ':user_creation_timestamp'=> $user_creation_timestamp));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_USER_ADDITION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_USER_ADDITION_FAILED;
        }
        // default return
        return false;
    }


    public function editSave($user_id)
    {
        // clean the input to prevent for example javascript within the groups.
       
       $user_name = strip_tags($_POST['user_name']);
		$user_fullname = strip_tags($_POST['fullname']);
		$user_group_id = strip_tags($_POST['group_id']);
		$user_email = strip_tags($_POST['email']);
		
        $sql = "UPDATE users SET user_name=:user_name, user_fullname=:user_fullname, user_group_id=:user_group_id, user_email=:user_email WHERE user_id = :user_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_name' => $user_name, ':user_fullname' => $user_fullname, ':user_group_id' => $user_group_id, ':user_email' => $user_email, ':user_id' => $user_id));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_USER_EDITING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_USER_EDITING_FAILED;
        }
        // default return
        return false;
    }

    /**
     * Deletes a specific group
     * @param int $group_id id of the group
     * @return bool feedback (was the group deleted properly ?)
     */
    public function delete($user_id)
    {
        $sql = "DELETE FROM users WHERE user_id = :user_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_id' => $user_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_USER_DELETION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_USER_DELETION_FAILED;
        }
        // default return
        return false;
    }
    
    public function changestatus($user_id, $status)
    {
		$status = ($status==1)?0:1;
        $sql = "update users set user_active=:sts WHERE user_id = :user_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':user_id' => $user_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_USER_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_USER_CHANGE_STATUS_FAILED;
        }
        // default return
        return false;
    }
}
