<?php

/**
 * TemplateModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class TemplateModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Getter for all notes (notes are an implementation of example data, in a real world application this
     * would be data that the user has created)
     * @return array an array with several objects (the results)
     */
    public function getAllTemplates($type)
    {
        $sql = "SELECT temp_id, temp_name, temp_type, temp_text, temp_status, created_date, modified_date FROM template_table where temp_type='$type'";
        $query = $this->db->prepare($sql);
        $query->execute();
        // fetchAll() is the PDO method that gets all result rows
        return $query->fetchAll();
    }


    public function getTemplate($temp_id)
    {
        $sql = "SELECT temp_id, temp_name, temp_type, temp_text, temp_status, created_date, modified_date FROM template_table WHERE temp_id =:temp_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':temp_id' => $temp_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }

    public function create($temp_type)
    {
        // clean the input to prevent for example javascript within the notes.
        $temp_name = strip_tags($_POST['temp_name']);
		$temp_text = htmlspecialchars($_POST['temp_text']);
		
		$mdate = date("Y-m-d H:i:s");
		
        $sql = "INSERT INTO template_table (temp_name, temp_type, temp_text, temp_status, created_date, modified_date) VALUES (:temp_name, :temp_type, :temp_text, :temp_sts, :cdate, :mdate)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':temp_name' => $temp_name, ':temp_type' => $temp_type,':temp_text' => $temp_text,':temp_sts' => 1,':cdate' => $mdate,':mdate' => $mdate));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][]=FEEDBACK_TEMPLATE_ADDITION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_TEMPLATE_ADDITION_FAILED;
        }
        // default return
        return false;
    }

    public function editSave($temp_id,$temp_type)
    {
        // clean the input to prevent for example javascript within the notes.
        $temp_name = strip_tags($_POST['temp_name']);
		$temp_text = htmlspecialchars($_POST['temp_text']);
		
		$mdate = date("Y-m-d H:i:s");

        $sql = "UPDATE template_table SET temp_name=:temp_name, temp_type=:temp_type, temp_text=:temp_text, modified_date=:mdate WHERE temp_id = :temp_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':temp_name' => $temp_name, ':temp_type' => $temp_type, ':temp_text' => $temp_text, ':mdate' => $mdate,':temp_id' => $temp_id));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][]= FEEDBACK_TEMPLATE_EDITING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_TEMPLATE_EDITING_FAILED;
        }
        // default return
        return false;
    }

  
    public function delete($temp_id)
    {
        $sql = "DELETE FROM template_table WHERE temp_id = :temp_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':temp_id' => $temp_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][]=FEEDBACK_TEMPLATE_DELETION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_TEMPLATE_DELETION_FAILED;
        }
        // default return
        return false;
    }
}
