<?php

/**
 * SettingModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SettingModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    
    public function getProfile($stud_id)
    {
        $sql = "SELECT stud_id, stud_zip, enroll_no, stud_fname, stud_lname, stud_address, stud_city, stud_pass, stud_email, stud_contact from student_table WHERE stud_id = :stud_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':stud_id' => $stud_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }

    public function editSaveProfile($stud_id)
    {
        // clean the input to prevent for example javascript within the groups.
       
        $stud_fname = strip_tags($_POST['fname']);
		$stud_lname = strip_tags($_POST['lname']);
		$stud_email = strip_tags($_POST['user_email']);
		$stud_contact = strip_tags($_POST['contact']);
		$stud_address = strip_tags($_POST['address']);
		$stud_city = strip_tags($_POST['city']);
		$stud_zip = strip_tags($_POST['zip']);
		
		$mdate = date("Y-m-d");
		 
        $sql = "UPDATE student_table SET stud_fname=:stud_fname, stud_lname=:stud_lname, stud_email=:stud_email, stud_contact=:stud_contact, stud_address=:stud_address, stud_city=:stud_city, stud_zip=:stud_zip, modified_date=:mdate WHERE stud_id = :stud_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':stud_fname' => $stud_fname, ':stud_lname' => $stud_lname, ':stud_email' => $stud_email, ':stud_contact' => $stud_contact, ':stud_address' => $stud_address, ':stud_city' => $stud_city, ':stud_zip' => $stud_zip, ':mdate'=>$mdate, ':stud_id' => $stud_id));

        $count =  $query->rowCount();
        if ($count == 1) {
			Session::set('stud_fname', $stud_fname);
            Session::set('stud_lname', $stud_lname);
			$_SESSION["feedback_positive"][] = FEEDBACK_PROFILE_EDITING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_PROFILE_EDITING_FAILED;
        }
        // default return
        return false;
    }
    
    public function editChangePassword($stud_id)
    {
        // clean the input to prevent for example javascript within the groups.
       
       
		if (empty($_POST['new_pass']) OR empty($_POST['renew_pass'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_FIELD_EMPTY;
            return false;
        } elseif ($_POST['new_pass'] !== $_POST['renew_pass']) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_REPEAT_WRONG;
            return false;
        } elseif (strlen($_POST['new_pass']) < 6) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_TOO_SHORT;
            return false;
        }
        
        $query = $this->db->prepare("SELECT stud_pass FROM student_table WHERE stud_id = :stud_id");
            $query->execute(array(':stud_id' => $stud_id));
            $result = $query->fetch();
            if (password_verify($_POST['old_pass'], $result->stud_pass)) {
                $hash_cost_factor = (defined('HASH_COST_FACTOR') ? HASH_COST_FACTOR : null);
				$user_password_hash = password_hash($_POST['new_pass'], PASSWORD_DEFAULT, array('cost' => $hash_cost_factor));
                $mdate = date("Y-m-d");
		 
				$sql = "UPDATE student_table SET stud_pass=:stud_pass, modified_date=:mdate WHERE stud_id = :stud_id";
				$query = $this->db->prepare($sql);
				$query->execute(array(':stud_pass' => $user_password_hash, ':mdate'=>$mdate, ':stud_id' => $stud_id));

				$count =  $query->rowCount();
				if ($count == 1) {
					$_SESSION["feedback_positive"][] = FEEDBACK_PASSWORD_CHANGE_SUCCESSFUL;
					return true;
				} else {
					$_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_CHANGE_FAILED;
				}                
            }else{
				$_SESSION["feedback_negative"][] = FEEDBACK_OLDPASSWORD_MATCHED_FAILED;
			}
            
		
        // default return
        return false;
    }
    
    
	public function changeAvatar($stud_id)
    {
        // clean the input to prevent for example javascript within the groups.
        $mdate = date("Y-m-d H:i:s");
		$count=0;
		$target_dir = AVATAR_PATH;
		$filename =  "";
		
		if (!empty($_FILES['fileToUpload']['tmp_name']) ) {
			
		 if (!is_dir($target_dir) OR !is_writable($target_dir)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_FOLDER_DOES_NOT_EXIST_OR_NOT_WRITABLE;
            return false;
        }

        if (!isset($_FILES['fileToUpload']) OR empty ($_FILES['fileToUpload']['tmp_name'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_FAILED;
            return false;
        }

        // get the image width, height and mime type
        $image_proportions = getimagesize($_FILES['fileToUpload']['tmp_name']);

        // if input file too big (>5MB)
        if ($_FILES['fileToUpload']['size'] > 5000000 ) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_TOO_BIG;
            return false;
        }
        // if input file too small
        if ($image_proportions[0] < AVATAR_SIZE OR $image_proportions[1] < AVATAR_SIZE) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_TOO_SMALL;
            return false;
        }

        if ($image_proportions['mime'] == 'image/jpeg' || $image_proportions['mime'] == 'image/png') {
            // create a jpg file in the avatar folder
            $filename = mt_rand(1000, 9999).round(microtime(true) * 1000) . ".jpg";
            $target_file_path = $target_dir .  $filename;
            $this->resizeAvatarImage($_FILES['fileToUpload']['tmp_name'], $target_file_path, AVATAR_SIZE, AVATAR_SIZE, IMAGE_JPEG_QUALITY, true);
            
            Session::set('user_avatar_file', $this->getUserAvatarFilePath());
            $_SESSION["feedback_positive"][] = FEEDBACK_IMAGE_UPLOAD_SUCCESSFUL;
            //return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_WRONG_TYPE;
            return false;
        }
        $sql = "UPDATE student_table SET stud_img = :stud_image, modified_date=:mdate WHERE stud_id = :stud_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':stud_image' => $filename, ':mdate'=>$mdate, ':stud_id' => $stud_id ));
        $count =  $query->rowCount();
	}
        
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_PROFILE_EDITING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_PROFILE_EDITING_FAILED;
        }
        // default return
        return false;
    }
    
    public function resizeAvatarImage(
        $source_image, $destination_filename, $width = 150, $height = 150, $quality = 85, $crop = true)
    {
        $image_data = getimagesize($source_image);
        if (!$image_data) {
            return false;
        }

        // set to-be-used function according to filetype
        switch ($image_data['mime']) {
            case 'image/gif':
                $get_func = 'imagecreatefromgif';
                $suffix = ".gif";
            break;
            case 'image/jpeg';
                $get_func = 'imagecreatefromjpeg';
                $suffix = ".jpg";
            break;
            case 'image/png':
                $get_func = 'imagecreatefrompng';
                $suffix = ".png";
            break;
        }

        $img_original = call_user_func($get_func, $source_image );
        $old_width = $image_data[0];
        $old_height = $image_data[1];
        $new_width = $width;
        $new_height = $height;
        $src_x = 0;
        $src_y = 0;
        $current_ratio = round($old_width / $old_height, 2);
        $desired_ratio_after = round($width / $height, 2);
        $desired_ratio_before = round($height / $width, 2);

        if ($old_width < $width OR $old_height < $height) {
             // the desired image size is bigger than the original image. Best not to do anything at all really.
            return false;
        }

        // if crop is on: it will take an image and best fit it so it will always come out the exact specified size.
        if ($crop) {
            // create empty image of the specified size
            $new_image = imagecreatetruecolor($width, $height);

            // landscape image
            if ($current_ratio > $desired_ratio_after) {
                $new_width = $old_width * $height / $old_height;
            }

            // nearly square ratio image
            if ($current_ratio > $desired_ratio_before AND $current_ratio < $desired_ratio_after) {

                if ($old_width > $old_height) {
                    $new_height = max($width, $height);
                    $new_width = $old_width * $new_height / $old_height;
                } else {
                    $new_height = $old_height * $width / $old_width;
                }
            }

            // portrait sized image
            if ($current_ratio < $desired_ratio_before) {
                $new_height = $old_height * $width / $old_width;
            }

            // find ratio of original image to find where to crop
            $width_ratio = $old_width / $new_width;
            $height_ratio = $old_height / $new_height;

            // calculate where to crop based on the center of the image
            $src_x = floor((($new_width - $width) / 2) * $width_ratio);
            $src_y = round((($new_height - $height) / 2) * $height_ratio);
        }
        // don't crop the image, just resize it proportionally
        else {
            if ($old_width > $old_height) {
                $ratio = max($old_width, $old_height) / max($width, $height);
            } else {
                $ratio = max($old_width, $old_height) / min($width, $height);
            }

            $new_width = $old_width / $ratio;
            $new_height = $old_height / $ratio;
            $new_image = imagecreatetruecolor($new_width, $new_height);
        }

        // create avatar thumbnail
        imagecopyresampled($new_image, $img_original, 0, 0, $src_x, $src_y, $new_width, $new_height, $old_width, $old_height);

        // save it as a .jpg file with our $destination_filename parameter
        imagejpeg($new_image, $destination_filename, $quality);

        // delete "working copy" and original file, keep the thumbnail
        imagedestroy($new_image);
        imagedestroy($img_original);

        if (file_exists($destination_filename)) {
            return true;
        }
        // default return
        return false;
    }
    public function getUserAvatarFilePath()
    {
        $query = $this->db->prepare("SELECT stud_img FROM student_table WHERE stud_id = :stud_id");
        $query->execute(array(':stud_id' => $_SESSION['stud_id']));
        $img = $query->fetch()->stud_img;
        if (isset($img)) {
            return URL . AVATAR_PATH . $img;
        } else {
            return URL . AVATAR_PATH . AVATAR_DEFAULT_IMAGE;
        }
    }
}
