<?php

/**
 * QuestionModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class QuestionModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getAllQuestions()
    {
        $sql = "SELECT ques_id, ques_type, ques_file, ques_text, ques_status, quiz_id, created_date, modified_date, ques_title FROM question_table";
        $query = $this->db->prepare($sql);
        $query->execute();
		$result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['ques_id'] = $row->ques_id;
			$res['ques_type'] = $row->ques_type;
			$res['ques_file'] = $row->ques_file;
			$res['ques_text'] = $row->ques_text;
			$res['ques_status'] = $row->ques_status;
			$res['quiz_id'] = $row->quiz_id;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			$res['ques_title'] = $row->ques_title;
			$res['quiz_name'] ="";
			$res['ques_type_name'] = "";
			if($row->ques_type==1)
				$res['ques_type_name'] = "Single Choice";
			else if($row->ques_type==2)
				$res['ques_type_name'] = "Multiple Choice";
			else if($row->ques_type==3)
				$res['ques_type_name'] = "True/False";
			else if($row->ques_type==4)
				$res['ques_type_name'] = "Mix Match";
			
			$sql1 = "SELECT quiz_name FROM quiz_table where quiz_id =:quizid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('quizid'=>$row->quiz_id));
			while($row1 = $query1->fetch()){
				$res['quiz_name'] = $row1->quiz_name;
			}
			$result[] =$res;
		}
		return $result;
    }
    public function getQuestion($ques_id)
    {
        $sql = "SELECT ques_id, ques_type, ques_file, ques_text, ques_status, quiz_id, createded_date, modified_date, ques_title FROM question_table WHERE ques_id = :ques_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':ques_id' => $ques_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }
    public function getQuizQuestion($quiz_id)
    {
        $sql = "SELECT quiz_id FROM question_table WHERE quiz_id = :quiz_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':quiz_id' => $quiz_id));
		// fetch() is the PDO method that gets a single result
        return $query->fetchAll();
    }


    public function create($quiz_id)
    {
        // clean the input to prevent for example javascript within the groups.
        //$quiz_id = strip_tags($_POST['quiz_name']);
		$ques_type = strip_tags($_POST['qtype']);
		$ques_title = strip_tags($_POST['questitle']);
		$ques_text = strip_tags($_POST['temp_text']);
		
		
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		
		$target_dir = "public/uploads/quiz_files/";
		$filename =  "";
		
		if (!empty($_FILES['fileToUpload']['tmp_name']) ) {
			
		 if (!is_dir($target_dir) OR !is_writable($target_dir)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_FOLDER_DOES_NOT_EXIST_OR_NOT_WRITABLE;
            return false;
        }

        if (!isset($_FILES['fileToUpload']) OR empty ($_FILES['fileToUpload']['tmp_name'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_FAILED;
            return false;
        }

        // get the image width, height and mime type
        $image_proportions = getimagesize($_FILES['fileToUpload']['tmp_name']);

        // if input file too big (>5MB)
        if ($_FILES['fileToUpload']['size'] > 5000000 ) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_TOO_BIG;
            return false;
        }
        

			$path = $_FILES['fileToUpload']['name'];
            $ext = pathinfo($path, PATHINFO_EXTENSION);
            $filename = mt_rand(1000, 9999).round(microtime(true) * 1000) . ".".$ext;
            $target_file_path = $target_dir .  $filename;
            
            if (move_uploaded_file($_FILES["fileToUpload"]["tmp_name"], $target_file_path)) {
				$_SESSION["feedback_positive"][] = "The file ". $target_file_path. " has been uploaded.";
			} else {
				$_SESSION["feedback_negative"][] = "Sorry, there was an error uploading your file.";
				return false;
			}
           
            $_SESSION["feedback_positive"][] = FEEDBACK_IMAGE_UPLOAD_SUCCESSFUL;       
	}
		$sql2 = "select coalesce(max(ques_id), 0) as maxid from question_table";
        $query2 = $this->db->prepare($sql2);
        $query2->execute();
        $row1 = $query2->fetch();
        $quesid =$row1->maxid+1;
        
        $sql = "INSERT INTO question_table (ques_id, ques_type, ques_file, ques_text, quiz_id, created_date, modified_date, ques_title) VALUES (:ques_id, :ques_type, :ques_file, :ques_text, :quiz_id, :cdate, :mdate, :ques_title)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':ques_id' => $quesid,':ques_type' => $ques_type, ':ques_file' => $filename, ':ques_text' => $ques_text, ':quiz_id'=>$quiz_id,':cdate'=>$mdate, ':mdate'=>$mdate,':ques_title' => $ques_title));

        $count =  $query->rowCount();
        
        if(isset($_POST['anstext'])){
			$ans = $_POST['ans'];
			$ind=0;
			foreach($_POST['anstext'] as $value){
				
			  $sql1 = "INSERT INTO answer_table (ques_id, answer_text, answer_status) VALUES (:ques_id, :answer_text, :answer_status)";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':ques_id' => $quesid, ':answer_text' => $value, ':answer_status' => $ans[$ind]));
				++$ind;
			  
			}
		}
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_QUESTION_ADDITION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_QUESTION_ADDITION_FAILED;
        }
        // default return
        return false;
    }

    public function editSave($course_id)
    {
        // clean the input to prevent for example javascript within the groups.
        $course_name = strip_tags($_POST['course_name']);
		$short_desc = htmlspecialchars($_POST['short_desc']);
		$long_desc = htmlspecialchars($_POST['long_desc']);
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		
		$target_dir = UPLOAD_PATH;
		//$ext = pathinfo($_FILES["fileToUpload"]["tmp_name"],PATHINFO_EXTENSION);
		$filename =  "";//mt_rand(1000, 9999).round(microtime(true) * 1000).".".$ext;
		//$target_file = $target_dir .$filename;
		
		if (!empty($_FILES['fileToUpload']['tmp_name']) ) {
			
		 if (!is_dir($target_dir) OR !is_writable($target_dir)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_FOLDER_DOES_NOT_EXIST_OR_NOT_WRITABLE;
            return false;
        }

        if (!isset($_FILES['fileToUpload']) OR empty ($_FILES['fileToUpload']['tmp_name'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_FAILED;
            return false;
        }

        // get the image width, height and mime type
        $image_proportions = getimagesize($_FILES['fileToUpload']['tmp_name']);

        // if input file too big (>5MB)
        if ($_FILES['fileToUpload']['size'] > 5000000 ) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_TOO_BIG;
            return false;
        }
        // if input file too small
        if ($image_proportions[0] < IMAGE_SIZE OR $image_proportions[1] < IMAGE_SIZE) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_TOO_SMALL;
            return false;
        }

        if ($image_proportions['mime'] == 'image/jpeg' || $image_proportions['mime'] == 'image/png') {
            // create a jpg file in the avatar folder
            $filename = mt_rand(1000, 9999).round(microtime(true) * 1000) . ".jpg";
            $target_file_path = $target_dir .  $filename;
            $this->resizeAvatarImage($_FILES['fileToUpload']['tmp_name'], $target_file_path, IMAGE_SIZE, IMAGE_SIZE, IMAGE_JPEG_QUALITY, true);
            
            //Session::set('user_avatar_file', $this->getUserAvatarFilePath());
            $_SESSION["feedback_positive"][] = FEEDBACK_IMAGE_UPLOAD_SUCCESSFUL;
            //return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_WRONG_TYPE;
            return false;
        }
        $sql = "UPDATE course_table SET course_name = :course_name, short_desc = :short_desc, long_desc = :long_desc, course_image=:file, modified_date=:mdate WHERE course_id = :course_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_name' => $course_name, ':long_desc' => $long_desc, ':short_desc' => $short_desc, ':file' => $filename, ':mdate'=>$mdate, ':course_id' => $course_id ));
        $count =  $query->rowCount();
	}else{
		$sql = "UPDATE course_table SET course_name = :course_name, short_desc = :short_desc, long_desc = :long_desc, modified_date=:mdate WHERE course_id = :course_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_name' => $course_name, ':long_desc' => $long_desc, ':short_desc' => $short_desc, ':mdate'=>$mdate, ':course_id' => $course_id ));
        $count =  $query->rowCount();
	}
        

        
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_QUESTION_EDITING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_QUESTION_EDITING_FAILED;
        }
        // default return
        return false;
    }
    
    
	
    /**
     * Deletes a specific group
     * @param int $group_id id of the group
     * @return bool feedback (was the group deleted properly ?)
     */
    public function delete($ques_id)
    {
        $sql = "DELETE FROM question_table WHERE ques_id = :ques_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':ques_id' => $ques_id));
        
        $sql1 = "DELETE FROM answer_table WHERE ques_id = :ques_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array(':ques_id' => $ques_id));
        
        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_QUESTION_DELETION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_QUESTION_DELETION_FAILED;
        }
        // default return
        return false;
    }
    
    public function changestatus($ques_id, $status)
    {
		$status = ($status==1)?0:1;
        $sql = "update question_table set ques_status=:sts WHERE ques_id = :ques_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':ques_id' => $ques_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_QUESTION_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_QUESTION_CHANGE_STATUS_FAILED;
        }
        // default return
        return false;
    }
}
