<?php

/**
 * LesionModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class LesionModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getAllLesions($course_id,$stud_id)
    {
        $sql = "SELECT course_id,short_desc, lession_id, lession_name, lession_status, create_date, modified_date, duration, prerequisite FROM lession_table where course_id =:courseid and lession_status=1";
        $query = $this->db->prepare($sql);
        $query->execute(array('courseid'=>$course_id));
		$result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['course_id'] = $row->course_id;
			$res['lession_id'] = $row->lession_id;
			$res['lession_name'] = $row->lession_name;
			$res['duration'] = $row->duration;
			$res['prerequisite'] = $row->prerequisite;
			$res['short_desc'] = substr($row->short_desc, 0, 100)."...";
			$res['lession_status'] = $row->lession_status;
			$res['create_date'] = $row->create_date;
			$res['modified_date'] = $row->modified_date;
			$res['course_name']="";
			
			$sql1 = "SELECT course_name FROM course_table where course_id =:courseid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('courseid'=>$row->course_id));
			while($name =  $query1->fetch())
			{
				$res['course_name'] = $name->course_name;
			}
			
			$sql2 = "SELECT read_time FROM student_lesion_detail where stud_id=:stud_id and lesion_id=:lession_id and course_id =:courseid";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array('stud_id'=>$stud_id,'lession_id'=>$row->lession_id,'courseid'=>$row->course_id));
			$time="00:00:00";
			while($row2 =  $query2->fetch())
			{
				
				$secs = strtotime($row2->read_time)-strtotime("00:00:00");
				$time = date("H:i:s",strtotime($time)+$secs);
			}
			$res['readtime'] =$time;
			$pre= array();
			if($row->prerequisite!="")
				$pre = explode(",", $row->prerequisite);
			
			
			$prearr= array();
			$index=0;
			for($i=0; $i<count($pre); $i++)
			{
				$prearr1= array();
				$sql3 = "select * from lesion_finish where stud_id=:stud_id and lesion_id=:lesion_id";
				$query3 = $this->db->prepare($sql3);
				$query3->execute(array(':stud_id'=>$stud_id,':lesion_id'=>$pre[$i]));
				$prearr1["lesion_sts"]=$query3->rowCount();
				$prearr1["lesion_name"]=self::lesionName($pre[$i]);
				$prearr[] = $prearr1;
			}
			$res['prerequis']=$prearr;
			
			//$count = $query3->rowCount();
			
			$result[] =$res;
		}
      
        return $result;
    }

    public function lesionName($lesion_id)
    {
		$name ="";		
		$sql1 = "SELECT lession_name FROM lession_table where lession_id=:lesion_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':lesion_id'=>$lesion_id));
			$count1 = $query1->rowCount();
			if($count1==1)
			{	
				$row1 = $query1->fetch();					
				$name = ucwords(strtolower($row1->lession_name));						
			}      
        return $name;
	}
    public function getLesion($lession_id,$id,$stud_id)
    {
        $sql = "SELECT course_id, lession_id, lession_name, attach_type, attach, lession_status, create_date, modified_date, short_desc, long_desc FROM lession_table WHERE lession_id = :lession_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':lession_id' => $lession_id));
        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['course_id'] = $row->course_id;
			$res['lession_id'] = $row->lession_id;
			$res['lession_name'] = $row->lession_name;
			$res['attach_type'] = $row->attach_type;
			$res['attach'] = $row->attach;
			$res['short_desc'] = $row->short_desc;
			$res['long_desc'] = $row->long_desc;
			$res['lession_status'] = $row->lession_status;
			$res['create_date'] = $row->create_date;
			$res['modified_date'] = $row->modified_date;
			$res['timerid']=$id;
			$res['course_name']="";
			
			$sql1 = "SELECT course_name FROM course_table where course_id =:courseid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('courseid'=>$row->course_id));
			while($name =  $query1->fetch())
			{
				$res['course_name'] = $name->course_name;
			}
			$res['feedback']="";
			$res['feedback_date'] =date("Y-m-d H:i:s");
			$sql1 = "SELECT feedback, created_date FROM feed_back where stud_id=:stud_id and id=:lession_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('stud_id'=>$stud_id,'lession_id'=>$lession_id));
			while($name =  $query1->fetch())
			{
				$res['feedback'] = $name->feedback;
				$res['feedback_date'] = $name->created_date;
			}
			
			$sql2 = "SELECT read_time FROM student_lesion_detail where created_date=current_date and stud_id=:stud_id and lesion_id=:lession_id and course_id =:courseid";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array('stud_id'=>$stud_id,'lession_id'=>$lession_id,'courseid'=>$row->course_id));
			$time1="00:00:00";
			while($row2 =  $query2->fetch())
			{
				$time1 = $row2->read_time;
			}
			$res['time_spent_today'] = $time1;
			
			$sql2 = "SELECT read_time FROM student_lesion_detail where stud_id=:stud_id and lesion_id=:lession_id and course_id =:courseid";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array('stud_id'=>$stud_id,'lession_id'=>$lession_id,'courseid'=>$row->course_id));
			$time="00:00:00";
			while($row2 =  $query2->fetch())
			{
				
				$secs = strtotime($row2->read_time)-strtotime("00:00:00");
				$time = date("H:i:s",strtotime($time)+$secs);
			}
			$res['time_spent'] =$time;
			
			$sql3 = "select * from lesion_finish where stud_id=:stud_id and lesion_id=:lesion_id";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array(':stud_id'=>$stud_id,':lesion_id'=>$lession_id));
			$res['finished'] = $query3->rowCount();
			
			$result[] =$res;
		}
		return $result;
    }
    
    public function setLesionDetails($stud_id, $course_id, $lesion_id)
    {
		$mdate = date("Y-m-d");
		$query = $this->db->prepare("select stud_les_id from student_lesion_detail where DATE(created_date)= CURRENT_DATE and stud_id=:stud_id and course_id=:course_id and lesion_id=:lesion_id");
        $query->execute(array(':stud_id' => $stud_id, ':course_id' => $course_id, ':lesion_id' => $lesion_id));
        $count =  $query->rowCount();
        if($count==1)
        {
			return $query->fetch()->stud_les_id;
		}
        
		$query = $this->db->prepare("select coalesce(max(stud_les_id),0) as maxid from student_lesion_detail");
        $query->execute();
        $maxr= $query->fetch();
        $id= ($maxr->maxid)+1;
            
        $sql = "INSERT INTO student_lesion_detail(stud_les_id, stud_id, course_id, lesion_id, created_date, read_sts) values(:id, :stud_id, :course_id, :lesion_id, :created_date, :read_sts)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id'=>$id, ':stud_id' => $stud_id,':course_id' => $course_id,':lesion_id' => $lesion_id,':created_date' => $mdate,':read_sts' => 1));
        
        $count =  $query->rowCount();
        if ($count == 1) {
            return $id;
        } 
        // default return
        return false;
      
    }
    
    public function updateLesionDetails($id, $timestr)
    {
		$sql = "update student_lesion_detail set read_time=:rtime where stud_les_id=:id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':rtime'=>$timestr,':id'=>$id));
        
       
        // default return
        return false;
      
    }
    
    public function finishLesion($lesionid, $studid)
    {
		$sql = "select * from lesion_finish where stud_id=:stud_id and lesion_id=:lesion_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':stud_id'=>$studid,':lesion_id'=>$lesionid));
        $count = $query->rowCount();
        if($count<=0){
			
			$sql2 = "SELECT read_time FROM student_lesion_detail where stud_id=:stud_id and lesion_id=:lession_id";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array('stud_id'=>$studid,'lession_id'=>$lesionid));
			$time="00:00:00";
			while($row2 =  $query2->fetch())
			{
				
				$secs = strtotime($row2->read_time)-strtotime("00:00:00");
				$time = date("H:i:s",strtotime($time)+$secs);
			}
        
			$sql1 = "Insert into lesion_finish (stud_id, lesion_id, finish_sts, finish_time) values(:stud_id, :lesion_id, :finish_sts, :finish_time)";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':stud_id'=>$studid,':lesion_id'=>$lesionid, ':finish_sts'=>1,':finish_time'=>$time));
		}
       return true;
    }
    
    public function sendFeedback($id, $stud_id)
    {
		$feed = strip_tags($_POST['feeback']);
		$type = strip_tags($_POST['type']);
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "Insert into feed_back(stud_id, id, feedback, feed_type, created_date) values(:stud_id, :id, :feedback, :feed_type, :mdate)";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array(':stud_id'=>$stud_id,':id'=>$id, ':feedback'=>$feed,':feed_type'=>$type, ':mdate'=>$mdate));
		
	}

   
}
