<?php

/**
 * DiscussionModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class DiscussionModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function inbox($stud_id)
    {
        $sql = "SELECT disc_id, disc_message, disc_subject, sender_id, reciever_id, reply_disc_id, mark_read, mark_trash, sent_date FROM discussion_table WHERE reciever_id=:stud_id";
        $query = $this->db->prepare($sql);
        $query->execute(array('stud_id'=>$stud_id));
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['disc_id'] = $row->disc_id;
			$res['disc_message'] = $row->disc_message;
			$res['disc_subject'] = $row->disc_subject;
			$res['sender_id'] = $row->sender_id;
			$res['reciever_id'] = $row->reciever_id;
			$res['reply_disc_id'] = $row->reply_disc_id;
			$res['mark_read'] = $row->mark_read;
			$res['mark_trash'] = $row->mark_trash;
			$res['sent_date'] = $row->sent_date;
			
			$result[] =$res;
		}
      
        return $result;
    }
    
    public function sentBox($stud_id)
    {
        $sql = "SELECT disc_id, disc_message, disc_subject, sender_id, reciever_id, reply_disc_id, mark_read, mark_trash, sent_date FROM discussion_table WHERE sender_id =:stud_id";
        $query = $this->db->prepare($sql);
        $query->execute(array('stud_id'=>$stud_id));
	$result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['disc_id'] = $row->disc_id;
			$res['disc_message'] = $row->disc_message;
			$res['disc_subject'] = $row->disc_subject;
			$res['sender_id'] = $row->sender_id;
			$res['reciever_id'] = $row->reciever_id;
			$res['reply_disc_id'] = $row->reply_disc_id;
			$res['mark_read'] = $row->mark_read;
			$res['mark_trash'] = $row->mark_trash;
			$res['sent_date'] = $row->sent_date;
			
			
			$result[] =$res;
		}
      
        return $result;
    }
    
    public function trash($stud_id)
    {
        $sql = "SELECT disc_id, disc_message, disc_subject, sender_id, reciever_id, reply_disc_id, mark_read, mark_trash, sent_date FROM discussion_table WHERE mark_trash =:stud_id";
        $query = $this->db->prepare($sql);
        $query->execute(array('stud_id'=>$stud_id));
	$result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['disc_id'] = $row->disc_id;
			$res['disc_message'] = $row->disc_message;
			$res['disc_subject'] = $row->disc_subject;
			$res['sender_id'] = $row->sender_id;
			$res['reciever_id'] = $row->reciever_id;
			$res['reply_disc_id'] = $row->reply_disc_id;
			$res['mark_read'] = $row->mark_read;
			$res['mark_trash'] = $row->mark_trash;
			$res['sent_date'] = $row->sent_date;
			
			
			$result[] =$res;
		}
      
        return $result;
        
    }


	public function messageDetail($stud_id,$disc_id)
	{
		$count=0;
		$sql = "UPDATE discussion_table SET mark_read=:stud_id WHERE disc_id=:disc_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':stud_id' => $stud_id, ':disc_id' => $disc_id));

        $count =  $query->rowCount();
        if ($count == 1) {
			
            return true;
        } 
        // default return
        return false;
	}



public function message($disc_id)
    {
        $sql = "SELECT disc_message, sender_id, reciever_id, mark_trash, sent_date FROM discussion_table WHERE disc_id =:disc_id";
        $query = $this->db->prepare($sql);
        $query->execute(array('disc_id'=>$disc_id));
	$result =array();
        while($row = $query->fetch())
        {
			$res= array();
		
			$res['disc_message'] = $row->disc_message;
			$res['sender_id'] = $row->sender_id;
			$res['reciever_id'] = $row->reciever_id;
			$res['mark_trash'] = $row->mark_trash;
			$res['sent_date'] = $row->sent_date;
						
			$result[] =$res;
		}
      
        return $result;
        
    }



public function sendMail($stud_id)
    {
        
        	$disc_message = strip_tags($_POST['disc_message']);
		$disc_subject = strip_tags($_POST['disc_subject']);
		$reciever_id = 0;
		$sender_id = $stud_id;
		$sent_date=date("Y-m-d");
		$count=0;



		$sql = "INSERT INTO discussion_table (disc_message, disc_subject, sender_id,reciever_id, sent_date) VALUES (:disc_message, :disc_subject, :sender_id, :reciever_id, :sent_date)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':disc_message' => $disc_message, ':disc_subject' => $disc_subject, ':sender_id' => $sender_id, ':reciever_id'=>$reciever_id , ':sent_date'=>$sent_date));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_COURSE_ADDITION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_COURSE_ADDITION_FAILED;
        }
        // default return
        return false;
    }
    
public function getMails($stud_id)
    {
        $sql = "SELECT disc_message, disc_subject, sent_date FROM discussion_table";
        $query = $this->db->prepare($sql);
        $query->execute();

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }
   
   
}
