<?php

/**
 * DashboardModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class DashboardModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getDashboard($studid)
    {
		
        $result =array();
        
        $sql = "SELECT course_id FROM student_course where stud_id=:studid and sts=1";
        $query = $this->db->prepare($sql);
        $query->execute(array(':studid'=>$studid));
        
        $result['course'] = $query->rowCount();
        
        $sql = "SELECT lession_id FROM lession_table where course_id in (select course_id from student_course where stud_id=:studid and sts=1) and lession_status=1";
        $query = $this->db->prepare($sql);
        $query->execute(array(':studid'=>$studid));
        
        $result['lesion'] = $query->rowCount();
        
        $sql = "SELECT quiz_id FROM quiz_table where course_id in (select course_id from student_course where stud_id=:studid and sts=1) and quiz_status=1";
        $query = $this->db->prepare($sql);
        $query->execute(array(':studid'=>$studid));
        
        $result['quiz'] = $query->rowCount();
        
        $sql = "SELECT attempt_id FROM quiz_attempt where stud_id=:studid";
        $query = $this->db->prepare($sql);
        $query->execute(array(':studid'=>$studid));
        
        $result['quizattempt'] = $query->rowCount();
        
        return $result;
    }
    
    public function getSidebarCourse($stud_id)
    {
		
		$sql = "SELECT course_id, course_name, course_image, course_status,long_desc,short_desc, create_date, modified_date FROM course_table where course_status=1 and course_id in (SELECT course_id FROM student_course where stud_id=:stud_id and sts=1)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':stud_id'=>$stud_id));
		$result =array();
		
        while($row = $query->fetch())
        {
			$res= array();					
			
			$res['course_id'] =$row->course_id;
			$res['course_name'] =$row->course_name;	
			
			$result[] =$res;
		}
      
        return json_encode($result);
	}
	
    public function showAllAttempts($stud_id)
    {
		
		$sql = "SELECT * FROM quiz_attempt where stud_id=:stud_id and quiz_sts='FINISH' order by attempt_id desc limit 20";
        $query = $this->db->prepare($sql);
        $query->execute(array(':stud_id'=>$stud_id));
		
		//$result =array();
		$result['bar'] =array();
		$index=0;
        while($row = $query->fetch())
        {
			$res= array();
			//$res['attempt_id'] = $row->attempt_id;			
			//$res['quiz_id'] = $row->quiz_id;			
			$res['quizstart_date'] = date("d M Y",strtotime(date($row->quizstart_date)));			
			//$res['time_taken'] = $row->time_taken;
			$res['total_marks1'] = $row->total_marks;
			//$res['quiz_sts'] = $row->quiz_sts;
			//$res['quizend_time'] = $row->quizend_time;
			//$res['total_wrong'] = $row->total_wrong;
			//$res['total_correct'] = $row->total_correct;	
			//$res['total_unattempt'] = $row->total_unattempt;
			//$res['negative_marking_point'] = $row->negativ_marking_point;			
			//$res['negative_marking'] = ($row->negativ_marking_point) * ($row->total_wrong);	
				
			//$res['quiz_name'] ="";
			//$res['total_ques'] ="";
			//$res['total_time'] ="";
			$res['total_marks'] =0;
			$res['passing_score'] ="";
			//$res['negative_marking'] ="";
			$res['result'] ="0";
			$res['result_percent'] ="0";
			$res['total_percent'] ="100";
			
			$sql1 = "SELECT quiz_id, course_id, quiz_name, quiz_status, quiz_ques, total_ques, from_date, to_date, total_time, total_marks, passing_score, negative_marking, negative_markingscore, created_date, modified_date FROM quiz_table where quiz_id=:qid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':qid'=>$row->quiz_id));
			$count1 = $query1->rowCount();
			if($count1==1)
			{	
				$row1 = $query1->fetch();
				//$res['quiz_name'] = $row1->quiz_name;
				//$res['total_ques'] = $row1->total_ques;		
				//$res['total_time'] = $row1->total_time;		
				$res['total_marks'] = $row1->total_marks;		
				$res['passing_score'] = $row1->passing_score;		
				
				$percent = (($row->total_marks*100)/$row1->total_marks);
				$result1 = ($percent>=$row1->passing_score)?"Passed":"Failed"; 
				$res['result'] =$result1;
				$res['result_percent'] =$percent;
			}
			
			$result['bar'][] =$res;
		}
		
		return json_encode($result);
	}
		
	public function lesionDetails($stud_id)
    {
		
		$sql = "SELECT course_id, created_date, sum(time_to_sec(read_time)) as readtime, lesion_id FROM student_lesion_detail where stud_id=:stud_id group by created_date";
        $query = $this->db->prepare($sql);
        $query->execute(array(':stud_id'=>$stud_id));
		$result =array();
		
        while($row = $query->fetch())
        {
			$res= array();					
			$res['lesion_date'] = date("Y-m-d",strtotime(date($row->created_date)));
			$res['readtime'] = $row->readtime/60;
			//$res['lession_name'] =self::lesionName($row->lesion_id);
			//$res['course_name'] =self::courseName($row->course_id);	
			
			$result['line'][] =$res;
		}
      
        return json_encode($result);
	}
	
    public function getTimelineData($studid)
    {
		
        $result =array();
        
        $sql = "SELECT * FROM student_table where stud_id=:studid";
        $query = $this->db->prepare($sql);
        $query->execute(array(':studid'=>$studid));
        $result =array();
        while($row= $query->fetch())
        {
			$res = array();
			$res['id']=$row->stud_id;
			$res['sid']=$row->stud_id;
			$res['tag']="Profile";
			$res['datetime']=$row->created_date;
			$res['label'] 	=ucwords(strtolower($row->stud_fname." ".$row->stud_lname));
			$res['details'] =" Registered";
			$res['detailbody'] ="You have joined this portal, You can maintained your study material and take quiz to analyze your study performance";
			$result[]=$res;
		}
		
        $sql = "SELECT * FROM student_course a, course_table b where a.course_id=b.course_id and stud_id=:studid and sts=1";
        $query = $this->db->prepare($sql);
        $query->execute(array(':studid'=>$studid));
        
        while($row= $query->fetch())
        {
			$res = array();
			$res['id']=$row->course_id;
			$res['sid']=$row->course_id;
			$res['tag']="AddCourse";
			$res['datetime']=$row->created_date;
			$res['label'] 	=ucwords(strtolower($row->course_name));
			$res['details'] =" course added in your profile";
			$res['detailbody'] ="You have selected <span class='badge bg-yellow'>".ucwords(strtolower($row->course_name))."</span> course, you can study material of this course in read course link";
			$result[]=$res;
		}
        
        $sql = "SELECT * FROM student_lesion_detail where stud_id=:studid";
        $query = $this->db->prepare($sql);
        $query->execute(array(':studid'=>$studid));        
        while($row= $query->fetch())
        {
			$res = array();
			$res['id']=$row->lesion_id;
			$res['sid']=$row->course_id;
			$res['tag']="Study";
			$res['datetime']=$row->created_date;
			$res['lesion_name'] =self::lesionName($row->lesion_id);
			$res['course_name'] =self::courseName($row->course_id);			
			$res['label'] 	=$res['lesion_name'];
			$res['details'] =$row->read_time." Total reading time";
			$res['detailbody'] ="You are spending time on <span class='badge bg-yellow'>".$res['lesion_name']."</span> lesion for the day is <span class='badge bg-purple'>".$row->read_time."</span>";
			$result[]=$res;
		}
        $result['lesion'] = $query->rowCount();
        
        $sql = "SELECT * FROM quiz_attempt where stud_id=:studid";
        $query = $this->db->prepare($sql);
        $query->execute(array(':studid'=>$studid));
        while($row= $query->fetch())
        {
			$res = array();
			$res['id']=$row->attempt_id;
			$res['sid']=$row->quiz_id;
			$res['tag']="Attempt";
			$res['datetime']=$row->quizstart_date;			
			$res['label'] 	=self::quizeName($row->quiz_id);		
			$res['details'] =$row->total_marks." Total Marks Obtain";
			$res['detailbody'] ="Quiz result for this attempt was ".($row->quiz_result=="Pass"?'<span class="badge bg-green">Passed</span>':'<span class="badge bg-red">Failed</span>')." and the passing score for this quiz was <span class='badge bg-aqua'>".$row->passing_score."% </span> &nbsp;&nbsp;marks";
			$result[]=$res;
		}
        return $result;
    }
    
    
    public function lesionName($lesion_id)
    {
		$name ="";		
		$sql1 = "SELECT lession_name FROM lession_table where lession_id=:lesion_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':lesion_id'=>$lesion_id));
			$count1 = $query1->rowCount();
			if($count1==1)
			{	
				$row1 = $query1->fetch();					
				$name = ucwords(strtolower($row1->lession_name));						
			}      
        return $name;
	}
	
	public function courseName($course_id)
    {
		$name ="";		
		$sql1 = "SELECT course_name FROM course_table where course_id=:course_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':course_id'=>$course_id));
			$count1 = $query1->rowCount();
			if($count1==1)
			{	$row1 = $query1->fetch();
					
				$name = ucwords(strtolower($row1->course_name));				
				
			}      
        return $name;
	}
	public function quizeName($quiz_id)
    {
		$name ="";		
		$sql1 = "SELECT quiz_name FROM quiz_table where quiz_id=:quiz_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':quiz_id'=>$quiz_id));
			$count1 = $query1->rowCount();
			if($count1==1)
			{	$row1 = $query1->fetch();
					
				$name = ucwords(strtolower($row1->quiz_name));				
				
			}      
        return $name;
	}
    
}
