<?php

/**
 * CourseModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class CourseModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getAllCourses($flg)
    {
        $sql = "SELECT course_id, course_name, course_image, course_status,long_desc,short_desc, create_date, modified_date FROM course_table where course_status=1 order by create_date desc";
        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['course_id'] = $row->course_id;
			$res['course_name'] = $row->course_name;
			$res['short_desc'] = substr($row->short_desc, 0, 200)."...";
			$res['long_desc'] = substr($row->long_desc, 0, 200)."...";
			$res['course_image'] = $row->course_image;
			$res['course_status'] = $row->course_status;
			$res['create_date'] = $row->create_date;
			$res['modified_date'] = $row->modified_date;
			
			$sql1 = "SELECT stud_id FROM student_course where course_id =:courseid and stud_id=:studid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('courseid'=>$row->course_id, ':studid'=>$_SESSION['stud_id']));
			$count =  $query1->rowCount();
			$res['student_sts'] = $count;
			$res['student_course']=$count;
			if($flg){
				$res['student_course']=($count==1)?0:1;
			}
			$result[] =$res;
		}
      
        return $result;
    }
    
    public function getAllLesions($course_id)
    {
        $sql = "SELECT course_id, lession_id, lession_name, lession_status, create_date, modified_date FROM lession_table where lession_status=1 and course_id=:course_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_id'=>$course_id));
		$result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['course_id'] = $row->course_id;
			$res['lession_id'] = $row->lession_id;
			$res['lession_name'] = $row->lession_name;
			$res['lession_status'] = $row->lession_status;
			$res['create_date'] = $row->create_date;
			$res['modified_date'] = $row->modified_date;
			
			
			$result[] =$res;
		}
      
        return $result;
    }
    
    public function getCourse($course_id)
    {
        $sql = "SELECT course_id, course_name, course_image,course_status, create_date, modified_date, short_desc, long_desc FROM course_table WHERE course_id = :course_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_id' => $course_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }
    
    public function addCourseToStudent($stud_id, $course_id)
    {
		$mdate = date("Y-m-d");
        $sql = "INSERT INTO student_course(stud_id, course_id, created_date) values(:stud_id, :course_id, :cdate)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':stud_id' => $stud_id,':course_id' => $course_id,':cdate' => $mdate));
        
        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][] =FEEDBACK_COURSE_ADDITION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_COURSE_ADDITION_FAILED;
        }
        // default return
        return false;

    }


   
}
