<?php

/**
 * Class Question
 * The Question controller
 */
class Question extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
	
        Auth::handleLogin();

    }

   
    public function index()
    {
		$ques_model = $this->loadModel('Question');
        $this->view->quesns = $ques_model->getAllQuestions();
        $this->view->render('questions/index');
    }
	
	public function addnew($quiz_id)
    {
		$quiz_model = $this->loadModel('Quiz');
        $this->view->quiz = $quiz_model->getQuiz($quiz_id);
        
        $ques_model = $this->loadModel('Question');
        $this->view->quizques = $ques_model->getQuizQuestion($quiz_id);
        
        $this->view->render('questions/addnew');
    }
	
    public function create($quiz_id)
    {
        $ques_model = $this->loadModel('Question');
        $result =$ques_model->create($quiz_id);
        
        header('location: ' . URL . 'question/addnew/'.$quiz_id);
    }

   
    public function edit($course_id)
    {
        if (isset($course_id)) {
            // get the group that you want to edit (to show the current content)
            $course_model = $this->loadModel('Course');
            $this->view->course = $course_model->getCourse($course_id);
            $this->view->render('courses/edit');
        } else {
            header('location: ' . URL . 'course');
        }
    }

    /**
     * This method controls what happens when you move to /note/editsave(/XX) in your app.
     * Edits a note (performs the editing after form submit).
     * @param int $note_id id of the note
     */
    public function editSave($course_id)
    {
        if (isset($_POST['course_name']) && isset($course_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $course_model = $this->loadModel('Course');
            $course_model->editSave($course_id);
        }
        header('location: ' . URL . 'course');
    }

    /**
     * This method controls what happens when you move to /note/delete(/XX) in your app.
     * Deletes a note. In a real application a deletion via GET/URL is not recommended, but for demo purposes it's
     * totally okay.
     * @param int $note_id id of the note
     */
    public function delete($ques_id)
    {
        if (isset($ques_id)) {
            $ques_model = $this->loadModel('Question');
            $ques_model->delete($ques_id);
        }
        header('location: ' . URL . 'question');
    }
	
}
