<?php

/**
 * Class Index
 * The index controller
 */
class Lesion extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();
		
        Auth::handleLogin();

    }

    
    public function readLesion($course_id)
    {
		if (isset($course_id) && isset($_SESSION['stud_id'])) {
		$lesion_model = $this->loadModel('Lesion');
        $this->view->lesions = $lesion_model->getAllLesions($course_id,$_SESSION['stud_id']);
        $course_model = $this->loadModel('Course');
        $this->view->course = $course_model->getCourse($course_id);
        
        $quiz_model = $this->loadModel('Quiz');
        $this->view->quizs = $quiz_model->getAllCourseQuizs($course_id);
        
        $this->view->render('lesions/index');
        } else {
            header('location: ' . URL . 'course/creader');
        }
    }
	public function setLesionTime()
    {
		$lesion_model = $this->loadModel('Lesion');
        $this->view->lesions = $lesion_model->updateLesionDetails($_POST['id'], $_POST['timestr']);
		
		//return true;
    }
	
	
	public function details($course_id,$lesion_id)
    {
		if (isset($lesion_id)  && isset($course_id) && isset($_SESSION['stud_id'])) {
            $lesion_model = $this->loadModel('Lesion');
            $result_id = $lesion_model->setLesionDetails($_SESSION['stud_id'],$course_id,$lesion_id);
            if($result_id)
            {
				$this->view->lesion = $lesion_model->getLesion($lesion_id,$result_id,$_SESSION['stud_id']);
				$this->view->render('lesions/details');
			}else{
				header('location: ' . URL . 'course/creader');
			}
            
        } else {
            header('location: ' . URL . 'course/creader');
        }
            
    }
    
    public function finish($course_id,$lesion_id)
    {
		if (isset($lesion_id)  && isset($_SESSION['stud_id'])) {
            $lesion_model = $this->loadModel('Lesion');
            $lesion_model->finishLesion($lesion_id,$_SESSION['stud_id']);
        } 
        header('location: ' . URL . 'lesion/details/'.$course_id.'/'.$lesion_id);
            
    }
    
    public function feedback($course_id,$lesion_id)
    {
		if (isset($lesion_id)  && isset($_SESSION['stud_id'])) {
            $lesion_model = $this->loadModel('Lesion');
            $lesion_model->sendFeedback($lesion_id,$_SESSION['stud_id']);
        } 
        header('location: ' . URL . 'lesion/details/'.$course_id.'/'.$lesion_id);
            
    }
    
}
