<?php

/**
 * Class Email
 * The Email controller
 */
class Email extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();

    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    public function index()
    {
        $template_model = $this->loadModel('Template');
        $this->view->emails = $template_model->getAllTemplates('Email');
        $this->view->render('emails/index');
    }
	
	function addnew()
    {
            $this->view->render('emails/addnew');
    }
    
    public function create()
    {
        if (isset($_POST['temp_name']) AND !empty($_POST['temp_name'])) {
            $template_model = $this->loadModel('Template');
            $template_model->create("Email");
        }
        header('location: ' . URL . 'email');
    }

    public function edit($template_id)
    {
        if (isset($template_id)) {
            // get the note that you want to edit (to show the current content)
            $template_model = $this->loadModel('Template');
            $this->view->email = $template_model->getTemplate($template_id);
            $this->view->render('emails/edit');
        } else {
            header('location: ' . URL . 'email');
        }
    }

    public function editSave($template_id)
    {
        if (isset($_POST['temp_name']) && isset($template_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $template_model = $this->loadModel('Template');
            $template_model->editSave($template_id,"Email");
        }
        header('location: ' . URL . 'email');
    }

    public function delete($template_id)
    {
        if (isset($template_id)) {
            $template_model = $this->loadModel('Template');
            $template_model->delete($template_id);
        }
        header('location: ' . URL . 'email');
    }
}
