<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Discussion extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();

        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index()
    {
		if(isset($_SESSION['stud_id']))
		{
			$discussion_model = $this->loadModel('Discussion');
        		$this->view->inbox = $discussion_model->inbox($_SESSION['stud_id']);
			$this->view->sent = $discussion_model->sentBox($_SESSION['stud_id']);
			$this->view->trash = $discussion_model->trash($_SESSION['stud_id']);
			$this->view->tabid = 1;
			$this->view->render('discussion/index');
		}else{
			header('location: ' . URL . 'login');
		}
    }





  public function details($disc_id,$tab_id)
   {
	if(isset($_SESSION['stud_id']))
	{
		$discussion_model = $this->loadModel('Discussion');
		$discussion_model->messageDetail($_SESSION['stud_id'],$disc_id);
		$this->view->message = $discussion_model->message($disc_id);
		$this->view->inbox = $discussion_model->inbox($_SESSION['stud_id']);
		$this->view->sent = $discussion_model->sentBox($_SESSION['stud_id']);
		$this->view->trash = $discussion_model->trash($_SESSION['stud_id']);
		$this->view->tabid = $tab_id;
		$this->view->render('discussion/details');
	}
   }




public function getAllSentMessage()
    {
       if (isset($_SESSION['stud_id'])) {
            
            $discussion_model = $this->loadModel('Discussion');
            $discussion_model->getAllSentMessage($_SESSION['stud_id']);
        }
        header('location: ' . URL . 'discussion');
    }





public function sendMail()
    {
       if (isset($_SESSION['stud_id'])) {
            
            $discussion_model = $this->loadModel('Discussion');
            $discussion_model->sendMail($_SESSION['stud_id']);
        }
        header('location: ' . URL . 'discussion');
    }
 

public function getMails()
    {
        if (isset($_SESSION['stud_id'])) {
            
            $discussion_model = $this->loadModel('Discussion');
            $discussion_model->getMails($_SESSION['stud_id']);
        }
        header('location: ' . URL . 'discussion');
    }   
   
}
