<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Dashboard extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();

        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index()
    {
		if(isset($_SESSION['stud_id']))
		{
			$dash_model = $this->loadModel('Dashboard');
			$this->view->dash = $dash_model->getDashboard($_SESSION['stud_id']);
			$this->view->attempts = $dash_model->showAllAttempts($_SESSION['stud_id']);
			$this->view->lesions = $dash_model->lesionDetails($_SESSION['stud_id']);
			
			$this->view->render('dashboard/index');
		}else{
			header('location: ' . URL . 'login');
		}
    }
    
    function sidebardata()
    {
		if(isset($_SESSION['stud_id']))
		{
			$dash_model = $this->loadModel('Dashboard');
			//$this->view->dash = $dash_model->getDashboard($_SESSION['stud_id']);
			$this->view->dash = $dash_model->getSidebarCourse($_SESSION['stud_id']);
			echo $this->view->dash;
		}
	}
    function student_timeline()
    {
		
		if(isset($_SESSION['stud_id']))
		{
			$dash_model = $this->loadModel('Dashboard');
			$this->view->timeline = $dash_model->getTimelineData($_SESSION['stud_id']);
			
			$this->view->render('dashboard/timeline');
		}else{
			header('location: ' . URL . 'login');
		}
	}
}
