<?php

/**
 * Class Index
 * The index controller
 */
class Course extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();

    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    public function index()
    {
		$course_model = $this->loadModel('Course');
        $this->view->courses = $course_model->getAllCourses(0);
        $this->view->render('courses/index');
    }
	
	public function creader()
    {
		$course_model = $this->loadModel('Course');
        $this->view->courses = $course_model->getAllCourses(1);
        $this->view->render('courses/index');
    }
    
	public function details($course_id)
    {
		if (isset($course_id)) {
            // get the group that you want to edit (to show the current content)
            $course_model = $this->loadModel('Course');
            $this->view->course = $course_model->getCourse($course_id);
            
            $this->view->lesions = $course_model->getAllLesions($course_id);
            
            $this->view->render('courses/details');
        } else {
            header('location: ' . URL . 'course');
        }
            
    }
    
    public function addCourse($course_id)
    {
		if(isset($course_id) && isset($_SESSION['stud_id']))
		{
			$course_model = $this->loadModel('Course');
            $this->view->course = $course_model->addCourseToStudent($_SESSION['stud_id'],$course_id);
            
		}
		header('location: ' . URL . 'course');
	}
}
