/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIAptitude requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('aptitude', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/
 app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

/////////////TAS Job Ctrl/////////////
app.controller('tasjobCtrl',function($scope, $http, $timeout) {

	$scope.hastrue=false;
	
	$scope.oncreate = function()
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({name: $scope.name, description: $scope.description});
	
		$http({
			url : path+'tasjob/create',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
		//console.log(data[0]['status']);
			if(data[0]['status']){
				
				successMessage(data[0]['successMsg']);
				table.ajax.reload();
			// $timeout(function() {
			// 				window.open(path + "tasjob", "_self");
			// 			}, 500);
			}else{
			errorMessage(data[0]['errorMsg']);}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
	}

	$scope.showAddTasjobModal =function(){
		$scope.name='';
		$scope.description='';
		$scope.tasjob_id=0;
		$('#Add_tasjob').modal('show'); 
	}
	
	$scope.onupdate = function($cid)
	{
		//alert($cid);
		$scope.hastrue=true;
		var xsrf = $.param({tas_id: $cid,name: $scope.name, description: $scope.description});
	
		$http({
			url : path+'tasjob/update',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
		console.log(data[0]['status']);
			if(data[0]['status']){
				
				successMessage(data[0]['successMsg']);
			$("#Add_tasjob").modal('hide');
			table.ajax.reload();
				//  $timeout(function() {
				// 			window.open(path + "tasjob", "_self");
				// 		}, 1000); 
			}else{
			errorMessage(data[0]['errorMsg']);
		    $("#Add_tasjob").modal('hide');
				 $timeout(function() {
							window.open(path + "tasjob", "_self");
						}, 1000); }
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
	}
	
	$scope.onfetchtasjob = function()
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({name: $scope.name, description: $scope.description});
	
		$http({
			url : path+'tasjob/gettasjob',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			//console.log(data);
			$scope.tasjobarr=[];
			$scope.tasjobarr=data;
		console.log($scope.tasjobarr);
			
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
	}
	
	$scope.onfetchdata = function($c_id)
	{
		//alert($c_id);
		$scope.tasjob_id=$c_id;
		$scope.hastrue=true;
		
		$http({
			url : path+'tasjob/getalltasjob/'+$scope.tasjob_id,
			method: "POST",
			
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			console.log(data[0]['code']);
			$scope.name=data[0]['name'];
			$scope.description=data[0]['description'];
			$("#Add_tasjob").modal('show');
			
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
		
		
	}
	
	$scope.onfetchfordelete = function($c_id)
	{   
		//alert($c_id);
		$scope.tasjob_id=$c_id;
		$("#confirm-delete").modal('show');
			
	}
	
	$scope.ondelete = function($c_id)
	{
		
		$scope.tasjob_id=$c_id;
		$scope.hastrue=true;
		
		$http({
			url : path+'tasjob/delete/'+$scope.tasjob_id,
			method: "POST",
			
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			console.log(data.status);
			if(data.status){
				
				successMessage(data.successMsg);
				$("#confirm-delete").modal('hide');
				table.ajax.reload();
				//  $timeout(function() {
				// 			window.open(path + "tasjob", "_self");
				// 		}, 1000); 
			}
			else{
			errorMessage(data.errorMsg);
			$("#confirm-delete").modal('hide');
		    $timeout(function() {
				window.open(path + "tasjob", "_self");
			}, 1000);}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
		
		
		
	}
	
});




	
	
	




      





