/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIAptitude requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('question', ['ngSanitize']);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/
 app.directive('fileUpload', function () {
    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

/////////////Questionbank Ctrl/////////////
app.controller('QuestionBankCtrl',function($scope, $http, $timeout) 
{
	$scope.hastrue=false;
	$scope.levelid=0;
	$scope.skillname="";
	$scope.parentid="";
	$scope.description="";
	$scope.labelname="";
	$scope.questionarr = [];
	$scope.newquestionarr = [];
	$scope.checkedarray=[];

Array.prototype.remove = function (index) {
			this.splice(index,1);
		};
		
		
// $scope.move=function ()
// {
	// if($('.checkbox1:checked').length > 0)
	// {
		// $('#questions').modal('show');
	// }
	// else
	// {
		// alert("select atleast 1 record to move");
		// return false;
	// }
// }
		
	// $scope.copy=function ()
// {
	// if($('.checkbox1:checked').length > 0)
	// {
		// $('#questionscopy').modal('show');
	// }
	// else
	// {
		// alert("select atleast 1 record to copy");
		// return false;
	// }
// }
		
		
		
		
		
		
		
$scope.checkedquestions=function($quesid,$index)
	{
	if($('#checkbox1_'+$index).prop('checked'))
				{
					for(var i=0; i<$scope.questionarr.length; i++)
					{
						if($scope.questionarr[i].ques_id == $quesid)
						{
							$scope.newquestionarr.push($scope.questionarr[i]);
							console.log($scope.newquestionarr);
						}
					 }
				}
				else
				{
						for(var i=0; i<$scope.newquestionarr.length; i++)
							{
								if($scope.newquestionarr[i].ques_id == $quesid)
								{
									$scope.newquestionarr.remove(i);
									console.log($scope.newquestionarr);
								}
							}
				}
	}
	
		$scope.checkall=function($data)
			{
					// if($('#checkid_'+$data.Id).prop('checked'))
					// {	
				$scope.movelevelid=$data.Id;
		//		alert($('#checkid_'+$data.Id);
                    // $scope.checkedarray.push({'lvlid':$data.Id});
					// console.log($scope.checkedarray);
					//}	
					// else
					// {
					// var 	 index = $scope.checkedarray.findIndex( record => record.lvlid ===$data.Id );
							// $scope.checkedarray.remove(index);
								// console.log($scope.checkedarray);
					// }
			}

			
			
$scope.onMoveQuestion = function()
	{
		$scope.hastrue=true;
		var newquestionarr = angular.toJson($scope.newquestionarr);
		//var jsonData=angular.toJson($scope.checkedarray);
		//var levelid=$scope.checkedarray[0].lvlid;
		
		var xsrf = $.param({movelevelid: $scope.movelevelid,newquestionarr:newquestionarr});
		$http({
			url : path+'questionbank/movequestionbank',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			if(data.status){
				console.log(data.status);
				$('#questions').modal('hide');
				successMessage(data.successMsg);
			
				
				$timeout(function(){window.open(path+"questionbank/index/"+$scope.movelevelid, "_self");}, timeo);
				$scope.onfetchSkillLevels();
					$scope.selectQuestions($scope.pdata);
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
		/* errorMessage("error: "+$scope.status); */
			$scope.hastrue=false;
		});
	}
$scope.checkall1=function($data)
			{
				$scope.copylevelid=$data.Id;
					// if($('#checkid1_'+$data.Id).prop('checked'))
					// {	
		// //		alert($('#checkid_'+$data.Id);
                    // $scope.checkedarray.push({'lvlid':$data.Id});
					// console.log($scope.checkedarray);
					// }	
					// else
					// {
					// var 	 index = $scope.checkedarray.findIndex( record => record.lvlid ===$data.Id );
							// $scope.checkedarray.remove(index);
								// console.log($scope.checkedarray);
					// }
			}

$scope.onCopyQuestion = function()
	{
		$scope.hastrue=true;
		var newquestionarr = angular.toJson($scope.newquestionarr);
		//var jsonData=angular.toJson($scope.checkedarray);
		var xsrf = $.param({copylevelid: $scope.copylevelid,newquestionarr:newquestionarr});
		$http({
			url : path+'questionbank/copyquestionbank',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			if(data.status){
				
				console.log(data.status);
				$('#questionscopy').modal('hide');
				successMessage(data.successMsg);
				$timeout(function(){window.open(path+"questionbank/index/"+ $scope.copylevelid, "_self");}, timeo);
				$scope.selectQuestions($scope.pdata);
				$scope.onfetchSkillLevels();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
		/* errorMessage("error: "+$scope.status); */
			$scope.hastrue=false;
		});
	}






	
	$scope.onfetchSkillLevels=function(){
		//var xsrf = $.param({pageid: $scope.pageid,label:$labelid});
		$http({
			url: path+"skilllevel/getAllSkillLevels",
			method: "POST",
		//	data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		 }).success(function (data, status, headers, config) {
			// console.log(data.status);
				if(data.status){
					console.log(data.status);
					$scope.tree = data.data;
				}else{
					  $scope.tree = [{id: "", Name: "TSV", children: []}];
				}
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
		});
	}
	$scope.pdata=[];
	$scope.selectQuestions = function(data) {
		 console.log(data);
		 $scope.pdata = data;
		 $scope.levelid = data.Id;
		 $scope.skillname = data.Name;
		 var xsrf = $.param({levelid: $scope.levelid});
		$http({
			url: path+"questionbank/getLevelQuestions",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		 }).success(function (data, status, headers, config) {
			// console.log(data.status);
				if(data.status){
					console.log(data.status);
					$scope.questionarr = data.data;
				}else{
					  $scope.questionarr = [];
				}
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
		});
    };
	
	$scope.oncreateskilllevel = function()
	{
		$scope.hastrue=true;
		var xsrf = $.param({name : $scope.skillname , parentid : $scope.parentid, description: $scope.description});
		$http({
			url : path+'skilllevel/createSkillLevel',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			if(data.status){
				successMessage(data.successMsg);
				$scope.description = '';
				$scope.parentid = '';
				$scope.skillname = '';
				$scope.skillid = '';
				$scope.onfetchSkillLevels();
				//$timeout(function(){window.open(path+"skilllevel", "_self");}, timeo);
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
		/* errorMessage("error: "+$scope.status); */
			$scope.hastrue=false;
		});
	}
	
	
	$scope.onupdateskilllevel = function()
	{
		$scope.hastrue=true;
		var xsrf = $.param({name : $scope.skillname , parentid : $scope.parentid, description: $scope.description, skillid: $scope.skillid});
		$http({
			url : path+'skilllevel/updateSkillLevel',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			if(data.status){
				successMessage(data.successMsg);
				$scope.description = '';
				$scope.parentid = '';
				$scope.skillname = '';
				$scope.skillid = '';
				$scope.onfetchSkillLevels();
				//$timeout(function(){window.open(path+"skilllevel", "_self");}, timeo);
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
		/* errorMessage("error: "+$scope.status); */
			$scope.hastrue=false;
		});
	}
	
	$scope.ondeleteskilllevel = function()
	{
		$scope.hastrue=true;
		var xsrf = $.param({skillid: $scope.skillid});
		$http({
			url : path+'skilllevel/deleteSkillLevel',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			if(data.status){
				successMessage(data.successMsg);
				$scope.skillid = '';
				$scope.onfetchSkillLevels();
				//$timeout(function(){window.open(path+"skilllevel", "_self");}, timeo);
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
		/* errorMessage("error: "+$scope.status); */
			$scope.hastrue=false;
		});
	}
	$scope.ondelete = function($val)
	{
		$scope.que_id = $val;
		$('#confirm-delete').modal('show');
	
	}
	
	$scope.ondeletequestionbank = function()
	{
		$scope.hastrue=true;
		var xsrf = $.param({que_id: $scope.que_id});
		$http({
			url : path+'questionbank/deletequestionbank',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			if(data.status){
				successMessage(data.successMsg);
				$scope.selectQuestions($scope.pdata);
				$scope.onfetchSkillLevels();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
		/* errorMessage("error: "+$scope.status); */
			$scope.hastrue=false;
		});
	}
	
	
	$scope.letter=function(i){
        return String.fromCharCode(65+i);
    }
});

/////////////Question Ctrl/////////////
app.controller('QuestionCtrl',function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.levelid=0;
	$scope.skillname="";
	$scope.questitle="";
	$scope.quesid=0;
	$scope.optionarray=[];
	$scope.answerselected=false;
	$scope.lvlpath="";
	$scope.id = 1;
	
    $scope.addoption = function() {
		
		$scope.optionname=CKEDITOR.instances['editor2'].getData();
		if($scope.optionname=="")
			return false;
		CKEDITOR.instances['editor2'].setData('');
        $scope.optionarray.push({id: $scope.id++ , Name: $scope.optionname, answer: "0"});
    };
		Array.prototype.insert = function (index, item) {
				this.splice(index, 0, item);
			};	
			
		
		
		
	$scope.remove=function($index){ 
		  if($scope.optionarray[$index].answer==1){
			  $scope.answerselected=false;
		  }
		  $scope.optionarray.splice($index,1);     
	}
	
    $scope.selectAnswer = function($index) {
		$scope.answerselected=true;
		 angular.forEach($scope.optionarray, function (value, key) { 
		 if(key!=$index){
                value.answer="0";
		 }
       }); 
    };
	
	$scope.onCreateQuestion = function($val=1)
	{
		$scope.hastrue=true;
		$scope.questitle=CKEDITOR.instances['questitle'].getData();
		if($scope.questitle=="")
		{
			errorMessage("Please enter the question."); 
			return false;
		}
		else if($scope.optionarray.length<2)
		{
			errorMessage("Please add atleast 2 options"); 
			return false;
		}
		else if($scope.answerselected==false)
		{
			errorMessage("Please select the answer"); 
			return false;
		}
		var optionarr = angular.toJson($scope.optionarray);
		var xsrf = $.param({questitle : $scope.questitle , reference : $scope.reference, levelid : $scope.levelid, optionarray: optionarr});
		$http({
			url : path+'questionbank/createQuestion',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			if(data.status){
				$scope.quesid = data.data;
				$scope.questitle = '';
				$scope.reference = '';
				$scope.optionarray = [];
				CKEDITOR.instances['questitle'].setData('');
				if($scope.files!=""){
					$scope.uploadAttachment($scope.quesid);
				}
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"questionbank/index/"+$scope.levelid, "_self");}, timeo);
				}else{
					$timeout(function(){window.open(path+"questionbank/addnew/"+$scope.levelid, "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
		// errorMessage("error: "+$scope.status); 
			$scope.hastrue=false;
		}); 
	}
	
	$scope.onUpdateQuestion = function(){
		$scope.hastrue=true;
		$scope.questitle=CKEDITOR.instances['questitle'].getData();
		if($scope.questitle==""){
			errorMessage("Please enter the question."); 
			return false;
		}else if($scope.optionarray.length<2){
			errorMessage("Please add atleast 2 options"); 
			return false;
		}else if($scope.answerselected==false){
			errorMessage("Please select the answer"); 
			return false;
		}
		var optionarr = angular.toJson($scope.optionarray);
		var xsrf = $.param({questitle : $scope.questitle , reference : $scope.reference, levelid : $scope.levelid, quesid : $scope.quesid, optionarray: optionarr});
		$http({
			url : path+'questionbank/updateQuestion',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config)
		{
			if(data.status){
				$scope.questitle = '';
				$scope.reference = '';
				$scope.optionarray = [];
				CKEDITOR.instances['questitle'].setData('');
				if($scope.files!=""){
					$scope.uploadAttachment($scope.quesid);
				}
				successMessage(data.successMsg);
				$timeout(function(){window.open(path+"questionbank/index/"+$scope.levelid, "_self");}, timeo);
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
		// errorMessage("error: "+$scope.status); 
			$scope.hastrue=false;
		}); 
	}
	
	$scope.files = [];

	//listen for the file selected event
	$scope.$on("fileSelected", function (event, args) {
		$scope.$apply(function () {            
			//add the file object to the scope's files collection
			$scope.files.push(args.file);
		});
	});
	
		//the save method
	$scope.uploadAttachment = function($quesid) {
	$scope.hastrue=true;
		$http({
			method: 'POST',
			url: path+"questionbank/uploadQuesAttach/"+$quesid,
			//IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
			// but this is not true because when we are sending up files the request 
			// needs to include a 'boundary' parameter which identifies the boundary 
			// name between parts in this multi-part request and setting the Content-type 
			// manually will not set this boundary parameter. For whatever reason, 
			// setting the Content-type to 'false' will force the request to automatically
			// populate the headers properly including the boundary parameter.
			headers: { 'Content-Type': undefined },
			//This method will allow us to change how the data is sent up to the server
			// for which we'll need to encapsulate the model data in 'FormData'
			transformRequest: function (data) {
				var formData = new FormData();
				//need to convert our json object to a string version of json otherwise
				// the browser will do a 'toString()' on the object which will result 
				// in the value '[Object object]' on the server.
				//formData.append("model", angular.toJson(data.model));
				//now add all of the assigned files
				for (var i = 0; i < data.files.length; i++) {
					//add each file to the form data and iteratively name them
					formData.append("file" + i, data.files[i]);
				}
				
				//formData.append('emp_id', emp);
				return formData;
			},
			//Create an object that contains the model and files which will be transformed
			// in the above transformRequest method
			data: {  files: $scope.files }
		}).
		success(function (data, status, headers, config) {
			if(data.status){
				$scope.files = [];
				//successMessage(data.successMsg);
				//window.open(path+"setup/company", "_self");				
			}
			else
			{
				$scope.files = [];
			}
			
			$scope.hastrue=false;
		}).
		error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);
		   $scope.hastrue=false;
		});
	}
	
	
	
	$scope.getquestiondetails=function($quesid){
		if($quesid==0)
		{
			return false;
		}
		var xsrf = $.param({quesid: $quesid});
		$http({
			url: path+"questionbank/getQuestionDetails",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		 }).success(function (data, status, headers, config) {
			// console.log(data.status);
				if(data.status)
				{
					$scope.questitle=data.data[0]['ques_text'];
					CKEDITOR.instances['questitle'].setData($scope.questitle);
					$scope.reference=data.data[0]['Reference'];
					$scope.image=data.data[0]['Attachment'];
					$scope.levelid=data.data[0]['levelid'];
					$scope.lvlpath=data.data[0]['lvlpath'];
					$scope.optionarray=data.data[0]['options'];
					$scope.answerselected=true;
				}else{
					
				}
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
		});
	}
	$scope.getlevelpath=function($lvlid){
		var xsrf = $.param({lvlid: $lvlid});
		$http({
			url: path+"questionbank/getlevelpath",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		 }).success(function (data, status, headers, config) {
			// console.log(data.status);
				if(data.status){
					$scope.lvlpath=data.data;
				}else{
					
				}
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
		});
	}
	
	
	$scope.letter=function(i){
        return String.fromCharCode(65+i);
    }
	
});
      





