/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIAptitude requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('aptitude', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/
 app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

/////////////costcenter Ctrl/////////////
app.controller('costcenterCtrl',function($scope, $http, $timeout) {

	$scope.hastrue=false;
	$scope.parseInt = parseInt;
	
	$scope.oncreate = function()
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({code: $scope.code,name: $scope.name,description: $scope.description});
	
		$http({
			url : path+'costcenter/create',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
		//console.log(data[0]['status']);
			if(data[0]['status']){
				
				successMessage(data[0]['successMsg']);
				table.ajax.reload();
			//    $timeout(function() {
			// 				window.open(path + "costcenter", "_self");
			// 			}, 500); 
			}else{
			errorMessage(data[0]['errorMsg']);
			$timeout(function() {
				window.open(path + "costcenter", "_self");
			}, 500); }
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
	}

	$scope.showAddCostCenterModal =function(){
		$scope.name='';
		$scope.description='';
		$scope.code='';
		$scope.costcenter_id=0;
		$('#Add_costcenter').modal('show'); 
	}
	
	$scope.onupdate = function($cid)
	{
		//alert($cid);
		$scope.hastrue=true;
		var xsrf = $.param({c_id: $cid,code: $scope.code,name: $scope.name,description: $scope.description});
		// var table = $('#example1').DataTable();


	
		$http({
			url : path+'costcenter/update',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
		console.log(data[0]['status']);
			if(data[0]['status']){
				
				successMessage(data[0]['successMsg']);
			$("#Add_costcenter").modal('hide');
			    table.ajax.reload();
				//  $timeout(function() {
				// 			window.open(path + "costcenter", "_self");
				// 			//table.draw();
				// 		}, 1000); 
			}else{
			errorMessage(data[0]['errorMsg']);
			$("#Add_costcenter").modal('hide');
				 $timeout(function() {
							window.open(path + "costcenter", "_self");
						}, 1000); }
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
	}
	
	$scope.onfetchcostcenter = function()
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({code:$scope.code,name: $scope.name,description: $scope.description});
	
		$http({
			url : path+'costcenter/getcostcenter',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			//console.log(data);
			$scope.costcenterarr=[];
			$scope.costcenterarr=data;
		console.log($scope.costcenterarr);
			
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
	}
	
	$scope.onfetchdata = function($c_id)
	{
		$scope.costcenter_id=$c_id;
		$scope.hastrue=true;
		
		$http({
			url : path+'costcenter/getallcostcenter/'+$scope.costcenter_id,
			method: "POST",
			
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			console.log(data[0]['code']);
			$scope.code=data[0]['code'];
			$scope.name=data[0]['name'];
			$scope.description=data[0]['description'];
			$("#Add_costcenter").modal('show');
			
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
		
		
	}
	
	$scope.onfetchfordelete = function($c_id)
	{
		$scope.costcenter_id=$c_id;
		$("#confirm-delete").modal('show');
			
	}
	
	$scope.ondelete = function($c_id)
	{
		
		$scope.costcenter_id=$c_id;
		$scope.hastrue=true;
		
		$http({
			url : path+'costcenter/deletecost/'+$scope.costcenter_id,
			method: "POST",
			
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			console.log(data.status);
			if(data.status){
				
				successMessage(data.successMsg);
				$("#confirm-delete").modal('hide');
				   table.ajax.reload();
				//  $timeout(function() {
				// 			window.open(path + "costcenter", "_self");
				// 		}, 1000); 
			}
			else{
			errorMessage(data.errorMsg);
			$("#confirm-delete").modal('hide');
		    $timeout(function() {
				window.open(path + "costcenter", "_self");
			}, 1000);}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
		
		
	}
	
});



