<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Administrator | Lesion</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <!-- bootstrap 3.0.2 -->
        <link href="<?php echo URL;?>public/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <!-- font Awesome -->
        <link href="<?php echo URL;?>public/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <!-- Ionicons -->
        <link href="<?php echo URL;?>public/css/ionicons.min.css" rel="stylesheet" type="text/css" />
       
        <!-- Theme style -->
        <link href="<?php echo URL;?>public/css/AdminLTE.css" rel="stylesheet" type="text/css" />

       
    </head>
    <body class="skin-blue fixed">
        <!-- header logo: style can be found in header.less -->
        <?php require VIEWS_PATH . '_templates/sidebar.php'; 
				topbar();
				?>
        <div class="wrapper row-offcanvas row-offcanvas-left">
            <!-- Left side column. contains the logo and sidebar -->
            <aside class="left-side sidebar-offcanvas">                
                <!-- sidebar: style can be found in sidebar.less -->
                <?php  
				sidemenu(2);
				?>
                <!-- /.sidebar -->
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <aside class="right-side">                
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Lesion Detail
                        <small></small>
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Lesion Detail</li>
                    </ol>
                </section>

                <!-- Main content -->
                <section class="content">
                    <div class="row" >
                        <div class="col-xs-12">
                            <!-- /.box -->
                            
                            <div class="box" >
                                
                                <div class="box-body table-responsive">
									
									<?php $this->renderFeedbackMessages(); ?>
                                    <div class="box box-solid" >
										<div class="box-header">
											<i class="fa fa-text-width"></i>
											<h3 class="box-title"><?= $this->lesion->lession_name?></h3>
										</div><!-- /.box-header -->
										<div class="box-body">
											<dl class="dl-horizontal">
												
												<dt>Short Description</dt>
												<dd><?= html_entity_decode($this->lesion->short_desc)?></dd>
												
												<dt>Long Description</dt>
												<dd><?= html_entity_decode($this->lesion->long_desc)?></dd>
												<dt>Attachment</dt>
												<dd><?php
												$file= "public/uploads/lesion_files/".$this->lesion->attach;
												if(file_exists($file))
												{
													$file_info = new finfo(FILEINFO_MIME);  
													$mime_type = $file_info->buffer(file_get_contents($file));  // e.g. gives "image/jpeg"
													$temparr= explode(";", $mime_type);
													echo '<a class="btn btn-sm btn-success" data-href="'. URL . 'lesion/delete/" data-toggle="modal" data-target="#confirm-delete" href="#" title="View Attach"><i class="fa fa-book"></i> View Attach file</a>';
													
													//echo '<embed width="100%" height="400px" src="'.URL.$file.'" />';
													?>
										<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
											<div class="modal-dialog modal-lg">
												<div class="modal-content">            
													<div class="modal-body">
														<?php
														$tempmimearr = explode("/",$temparr[0]);
														if( $tempmimearr[0]=="image"){
														?>
														<img src="<?=URL.$file?>" width="100%" height="100%"/>
														<?php
														}elseif( $temparr[0]=="application/pdf"){
														?>
														<embed id="viewpdf" width="550px" height="600px" src="<?=URL.$file?>"/>
														<?php
														}elseif($tempmimearr[0]=="video"){					
														?>
														 <video width="550" height="400" controls>
														  <source src="<?=URL.$file?>" type="video/mp4">
														  
														 Your browser does not support the video tag.
														</video> 
														<?php
														}elseif($tempmimearr[0]=="audio"){
														?>
														  <audio controls>
														  <source src="<?=URL.$file?>" type="audio/mpeg">
														Your browser does not support the audio element.
														</audio> 
														<?php }?>
													</div>
													<div class="modal-footer">
														<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
													</div>
												</div>
											</div>
										</div>
													<?php
												}else{echo "not exist";}
													?></dd>
											</dl>
											
										</div><!-- /.box-body -->
										
									</div><!-- /.box -->
                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                    </div>
                    <div class="row">
						<div class="col-xs-12">
							<div class="box box-solid">
								<div class="box-header">
									<i class="fa fa-edit"></i>
									<h3 class="box-title">Feedback by Students</h3>
								</div><!-- /.box-header -->
								<div class="box-body">
											<?php if($this->feedback){				
												foreach($this->feedback as $key => $value){
											?>
											<blockquote>
												<p><?= $value['feedback']?></p>
												<small><?= $value['student_name']?> <cite title="Source Title"><?= date("d M Y H:i", strtotime(date($value['feedback_date'])))?></cite></small>
											</blockquote>
											<?php } }?>
										</div>
							</div>
						</div>
                    </div>
                </section><!-- /.content -->
            </aside><!-- /.right-side -->
        </div><!-- ./wrapper -->


        <!-- jQuery 2.0.2 -->
        <script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
        <!-- Bootstrap -->
        <script src="<?php echo URL;?>public/js/bootstrap.min.js" type="text/javascript"></script>
        
        <!-- AdminLTE App -->
        <script src="<?php echo URL;?>public/js/AdminLTE/app.js" type="text/javascript"></script>
        <script type="text/javascript">
			$('#confirm-delete').on('show.bs.modal', function(e) {
				//$(this).find('#viewpdf').attr('srf', $(e.relatedTarget).data('href'));
			});
			
        </script>

    </body>
</html>
