<?php

/**
 * Class Utils
 */
class Utils
{
public static function strip_word_html($text, $allowed_tags = '')
    {
        mb_regex_encoding('UTF-8');
        //replace MS special characters first
        $search = array('/&lsquo;/u', '/&rsquo;/u', '/&ldquo;/u',
'/&rdquo;/u', '/&mdash;/u');
        $replace = array('\'', '\'', '"', '"', '-');
        $text = preg_replace($search, $replace, $text);
        //make sure _all_ html entities are converted to the plain
ascii equivalents - it appears
        //in some MS headers, some html entities are encoded and some aren't
        $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8');
        //try to strip out any C style comments first, since these,
embedded in html comments, seem to
        //prevent strip_tags from removing html comments (MS Word
introduced combination)
        if(mb_stripos($text, '/*') !== FALSE){
            $text = mb_eregi_replace('#/\*.*?\*/#s', '', $text, 'm');
        }
        //introduce a space into any arithmetic expressions that could
be caught by strip_tags so that they won't be
        //'<1' becomes '< 1'(note: somewhat application specific)
        $text = preg_replace(array('/<([0-9]+)/'), array('< $1'), $text);
        $text = strip_tags($text, $allowed_tags);
        //eliminate extraneous whitespace from start and end of line,
or anywhere there are two or more spaces, convert it to one
        $text = preg_replace(array('/^\s\s+/', '/\s\s+$/',
'/\s\s+/u'), array('', '', ' '), $text);
        //strip out inline css and simplify style tags
        $search = array('#<(strong|b)[^>]*>(.*?)</(strong|b)>#isu',
'#<(em|i)[^>]*>(.*?)</(em|i)>#isu', '#<u[^>]*>(.*?)</u>#isu');
        $replace = array('<b>$2</b>', '<i>$2</i>', '<u>$1</u>');
        $text = preg_replace($search, $replace, $text);
        //on some of the ?newer MS Word exports, where you get
conditionals of the form 'if gte mso 9', etc., it appears
        //that whatever is in one of the html comments prevents
strip_tags from eradicating the html comment that contains
        //some MS Style Definitions - this last bit gets rid of any
leftover comments */
        $num_matches = preg_match_all("/\<!--/u", $text, $matches);
        if($num_matches){
              $text = preg_replace('/\<!--(.)*--\>/isu', '', $text);
        }
        return $text;
    }
public static function sendIcalEvent($from_name, $from_address,
$to_name, $to_address, $startTime, $endTime, $subject, $description,
$location)
{
$domain = 'exchangecore.com';

//Create Email Headers
$mime_boundary = "----Meeting Booking----".MD5(TIME());

$headers = "From: ".$from_name." <".$from_address.">\n";
$headers .= "Reply-To: ".$from_name." <".$from_address.">\n";
$headers .= "MIME-Version: 1.0\n";
$headers .= "Content-Type: multipart/alternative;
boundary=\"$mime_boundary\"\n";
$headers .= "Content-class: urn:content-classes:calendarmessage\n";
//Create Email Body (HTML)
$message = "--$mime_boundary\r\n";
$message .= "Content-Type: text/html; charset=UTF-8\n";
$message .= "Content-Transfer-Encoding: 8bit\n\n";
$message .= "<html>\n";
$message .= "<body>\n";
$message .= '<p>'.$description.'</p>';
$message .= "</body>\n";
$message .= "</html>\n";
$message .= "--$mime_boundary\r\n";

$ical = 'BEGIN:VCALENDAR' . "\r\n" .
'PRODID:-//Microsoft Corporation//Outlook 10.0 MIMEDIR//EN' . "\r\n" .
'VERSION:2.0' . "\r\n" .
'METHOD:REQUEST' . "\r\n" .
'BEGIN:VTIMEZONE' . "\r\n" .
'TZID:Eastern Time' . "\r\n" .
'BEGIN:STANDARD' . "\r\n" .
'DTSTART:20091101T020000' . "\r\n" .
'RRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=11' . "\r\n" .
'TZOFFSETFROM:-0400' . "\r\n" .
'TZOFFSETTO:-0500' . "\r\n" .
'TZNAME:EST' . "\r\n" .
'END:STANDARD' . "\r\n" .
'BEGIN:DAYLIGHT' . "\r\n" .
'DTSTART:20090301T020000' . "\r\n" .
'RRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=2SU;BYMONTH=3' . "\r\n" .
'TZOFFSETFROM:-0500' . "\r\n" .
'TZOFFSETTO:-0400' . "\r\n" .
'TZNAME:EDST' . "\r\n" .
'END:DAYLIGHT' . "\r\n" .
'END:VTIMEZONE' . "\r\n" .
'BEGIN:VEVENT' . "\r\n" .
'ORGANIZER;CN="'.$from_name.'":MAILTO:'.$from_address. "\r\n" .
'ATTENDEE;CN="'.$to_name.'";ROLE=REQ-PARTICIPANT;RSVP=TRUE:MAILTO:'.$to_address.
"\r\n" .
'LAST-MODIFIED:' . date("Ymd\TGis") . "\r\n" .
'UID:'.date("Ymd\TGis", strtotime($startTime)).rand()."@".$domain."\r\n" .
'DTSTAMP:'.date("Ymd\TGis"). "\r\n" .
'DTSTART;TZID="Eastern Time":'.date("Ymd\THis", strtotime($startTime)). "\r\n" .
'DTEND;TZID="Eastern Time":'.date("Ymd\THis", strtotime($endTime)). "\r\n" .
'TRANSP:OPAQUE'. "\r\n" .
'SEQUENCE:1'. "\r\n" .
'SUMMARY:' . $subject . "\r\n" .
'LOCATION:' . $location . "\r\n" .
'CLASS:PUBLIC'. "\r\n" .
'PRIORITY:5'. "\r\n" .
'BEGIN:VALARM' . "\r\n" .
'TRIGGER:-PT15M' . "\r\n" .
'ACTION:DISPLAY' . "\r\n" .
'DESCRIPTION:Reminder' . "\r\n" .
'END:VALARM' . "\r\n" .
'END:VEVENT'. "\r\n" .
'END:VCALENDAR'. "\r\n";
$message .= 'Content-Type:
text/calendar;name="calendar.ics";method=REQUEST'."\n";
$message .= "Content-Transfer-Encoding: 8bit\n\n";
$message .= $ical;
$mailsent = Utils::sendMailViaSMTP($to_address,$from_name,$to_address,$subject,$message);
//$mailsent = mail($to_address, $subject, $message, $headers);
return ($mailsent)?(true):(false);
}
/////////////////Send mail advance search report///////////////////////
public static function sendMailReport($to,$fname,$subject,$msg,$file="")
{
//include(LIBS_PATH."PhpMailer/class.phpmailer.php");
$hostName = "ubirecruit.com";
//$portName = "26";
$userName = "noreply@ubirecruit.com";//$email;
$password = 'Ubipass@2017#';
$fromName = $fname;
//$smtpAuth = 'false';
$smtpAuth = true;
/* $mail = new PHPMailer();
$mail->IsSMTP();
$mail->CharSet="UTF-8";
//$mail->SMTPSecure = "no";
$mail->Host = $hostName;
//$mail->Port = "$portName";
$mail->Username = $userName;
$mail->Password = $password;
$mail->SMTPAuth = $smtpAuth;
//$to = "support@ubitechsolutions.com";
$mail->From = "ubirecruit@ubihrm.com";
$mail->FromName =$fname;
$mail->AddAddress($to);
$mail->AddBCC('monika@ubitechsolutions.com');
$mail->AddReplyTo($userName,"Computer Generated Information");
$mail->AddAttachment($file);
$mail->IsHTML(true);
$mail->Subject = $subject;
$mail->AltBody = $msg;
$mail->Body = $msg; */
if(true)
{
//$err="mail not send";
//$err=$mail->ErrorInfo;
//Utils::Trace($err);
if($file!=""){
//$file_size = filesize($file);

$content = file_get_contents( $file);
$content = chunk_split(base64_encode($content));
$uid = md5(uniqid(time()));
$name = basename($file);

// header
$header = "From: ".$fname." <noreply@ubihrm.com>\r\n";
$header .= "Reply-To: ".$to."\r\n";
$header .= "MIME-Version: 1.0\r\n";
$header .= "Content-Type: multipart/mixed; boundary=\"".$uid."\"\r\n\r\n";

// message & attachment
$nmessage = "--".$uid."\r\n";
$nmessage .= "Content-type:text/plain; charset=iso-8859-1\r\n";
$nmessage .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
$nmessage .= $msg."\r\n\r\n";
$nmessage .= "--".$uid."\r\n";
$nmessage .= "Content-Type: application/octet-stream;
name=\"$subject.pdf\"\r\n";
$nmessage .= "Content-Transfer-Encoding: base64\r\n";
$nmessage .= "Content-Disposition: attachment;
filename=\"$subject.pdf\"\r\n\r\n";
$nmessage .= $content."\r\n\r\n";
$nmessage .= "--".$uid."--";


$sts1=mail($to,$subject,$nmessage,$header);
//mail('monika@ubitechsolutions.com',$subject,$msg,$headers);
if($sts1)
return true;
return false;
}else{
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$headers .= "From: $fromName<noreply@ubihrm.com>" . "\r\n";
$sts1=mail($to,$subject,$msg,$headers);
//mail('monika@ubitechsolutions.com',$subject,$msg,$headers);
if($sts1)
return true;
return false;
}
}else
{
return true;
}
}
///////////////Send mail career page candidate ///////////////
public static function
sendMailViaSMTPWithAttach($to,$fname,$email,$subject,$msg,$orgid,$file,$filename=""){
$SmtpUser ='';$count=0;
$SmtpPass ='';
if($orgid==0){
$SmtpUser = "noreply@ubirecruit.com";
$SmtpPass = "Ubipass@2017#";
$from = "noreply@ubirecruit.com";
}else
{
/* $sql = "select * from smtp_config where status=1 and org_id=?";
$query =$this->db->prepare($sql);
$query->execute(array($orgid));
$count=$query->rowCount();
if($count>=1){
$row = $query->fetch();
$from = $row->user_name;
} */
$SmtpUser = "noreply@ubirecruit.com";
$SmtpPass = "Ubipass@2017#";
$from = "noreply@ubirecruit.com";
}
if($SmtpUser!='' && $SmtpPass!='' && $file!=''){
$mail = new PHPMailer();
$mail->IsSMTP();
$mail->CharSet="UTF-8";
$mail->SMTPSecure = "ssl";
$mail->Host = "ubirecruit.com";
$mail->Port = "465";
$mail->Username = "noreply@ubirecruit.com";
$mail->Password = 'Ubipass@2017#';
$mail->SMTPAuth = true;
$mail->From = "noreply@ubirecruit.com";
$mail->FromName = $fname; //Get Company Name
$mail->AddAddress($to);
$mail->AddReplyTo($SmtpUser, 'Computer Generated Information');
$mail->AddAttachment($file);
$mail->IsHTML(true);
$mail->Subject = $subject;
$mail->AltBody = $msg;
$mail->Body = $msg;
if(!$mail->Send()) {
//Trace('sendMailViaSMTPWithAttach MAIL FAILD !..'.$to);
$erroInfo = 'Mailer Error: ' . $mail->ErrorInfo;
Trace('sendMailViaSMTPWithAttach Mailer Error: !..'.$erroInfo);
return 0;
} else {
Trace('sendMailViaSMTPWithAttach MAIL SEND !..'.$to);
return 1;
}
}else {
//Trace('////////////////STEP 2 MAIL//////////////////////// ');
return 2;
}
}
////////// hex = &#x62f;&#x2e;&#x625;sendMailViaSMTP////
public static function sendMailViaSMTP1($to,$fname,$email,$subject,$msg,$orgid)
{
//include(LIBS_PATH."PhpMailer/class.phpmailer.php");
$hostName = "ubirecruit.com";
//$portName = "26";
$userName = "noreply@ubirecruit.com";//$email;
$password = 'Ubipass@2017#';
$fromName = $fname;
$smtpAuth = true;
$mail = new PHPMailer();
$mail->IsSMTP();
$mail->CharSet="UTF-8";
//$mail->SMTPSecure = "no";
$mail->Host = $hostName;
$mail->Port = 465;
$mail->Username = $userName;
$mail->Password = $password;
$mail->SMTPAuth = $smtpAuth;
//$to = "support@ubitechsolutions.com";
$mail->From = "noreply@ubirecruit.com";
$mail->FromName = "Ubirecruit";
$mail->AddAddress($to);
$mail->AddBCC('monika@ubitechsolutions.com');
$mail->AddReplyTo($userName,"Information");
$mail->IsHTML(true);
$mail->Subject = $subject;
$mail->AltBody = $msg;
$mail->Body = $msg;
if(!$mail->Send())
{
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$headers .= "From: $fromName<noreply@ubihrm.com>" . "\r\n";
//$sts1=mail($to,$subject,$msg,$headers);
//mail('monika@ubitechsolutions.com',$subject,$msg,$headers);
return false;
}
else
{
return true;
}
}
public static function
sendMailViaSMTPoffr($to,$fname,$email,$subject,$file,$orgid,$canid,$msg)
{
try{
//$msg=$msg;
//Utils::Trace('sendMailViaSMTP MAIL TRY !..'.$to.", ".$fname.",
".$email.", ".$subject.", ".$msg.", ".$orgid);
$SmtpUser = "noaccess@ubirecruit.com";
$SmtpPass = "O!I8T1mY-M]^";
/* $SmtpUser = "noreply@ubirecruit.com";
$SmtpPass = "Ubipass@2017#"; */
$orgmail = isset($_SESSION['ubirecruit_org_email'])?$_SESSION['ubirecruit_org_email']:$SmtpUser;
if($SmtpUser!='' && $SmtpPass!='')
{
//
$mail = new PHPMailer();
$mail->SMTPDebug = 1;
$mail->IsSMTP(true);
$mail->CharSet="UTF-8";
$mail->SMTPSecure = "ssl";
$mail->Host = "mail.ubirecruit.com";
$mail->Port = "465";
$mail->Username = $SmtpUser;
$mail->Password = $SmtpPass;
$mail->SMTPAuth = true;
$mail->From = $orgmail;
$mail->FromName = $fname; //Get Company Name
//$mail->AddAddress($to);
//$mail->MsgHTML($msg);
//$to=$to;
$mail->AddAddress($to);
$mail->AddReplyTo( $SmtpUser, 'Computer Generated Information');
//$mail->SMTPDebug = 1;
$mail->IsHTML(true);
$mail->Subject = $subject;
$mail->AltBody = $msg;
$mail->Body = $msg;
//Utils::Trace($file);
$mail->AddAttachment($file);
$erroInfo = 'Mailer Error: ' . $mail->ErrorInfo;
Utils::Trace('sendMailViaSMTP Mailer Error: !..'.$erroInfo);
if(!$mail->Send())
{
Utils::Trace('sendMailViaSMTP MAIL SENT !..'.$to);
$headers = "From: ".$fname;
$semi_rand = md5(time());
$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
$headers .= "\nMIME-Version: 1.0\n" . "Content-Type:
multipart/mixed;\n" . " boundary=\"{$mime_boundary}\"";
$msg .= "This is a multi-part message in MIME format.\n\n" .
"--{$mime_boundary}\n" . "Content-Type:text/html;
charset=\"iso-8859-1\"\n" . "Content-Transfer-Encoding: 7bit\n\n" .
$msg . "\n\n";
$can=$to;
$sts = @mail($can , $subject, $msg, $headers);
if($sts){
return 1;
}else{
return 0;
}
}
else {
//Trace('sendMailViaSMTP MAIL SEND !..'.count($to));
return 1;
}
}
else{
return 2;
}
}
catch(phpmailerException $e)
{
echo $e->getMessage();
}
}
public static function
sendMailViaSMTP($toids,$fname,$email,$subject,$msg,$orgid=0)
{
$SmtpUser = "noaccess@ubirecruit.com";
$SmtpPass = "O!I8T1mY-M]^";
//$orgmail = isset($_SESSION['ubirecruit_org_email'])?$_SESSION['ubirecruit_org_email']:$SmtpUser;
$orgmail = $SmtpUser ;
if($SmtpUser!='' && $SmtpPass!='')
{
$mail = new PHPMailer();
//Enable SMTP debugging.
$mail->SMTPDebug = 1;
$mail->IsSMTP();
$mail->CharSet="UTF-8";
$mail->SMTPSecure = "ssl";
$mail->Host = "mail.ubirecruit.com";
$mail->Port = "465";
$mail->Username = $SmtpUser;
$mail->Password = $SmtpPass;
$mail->SMTPAuth = true;
$mail->From = $orgmail;
$mail->FromName = $fname; //Get Company Name
//$mail->AddAddress($to);
//$mail->MsgHTML($msg);
$to=explode(",",$toids);
// $mail->AddReplyTo( $SmtpUser, 'Computer Generated Information');
//$mail->SMTPDebug = 1;
$mail->IsHTML(true);
$mail->Subject = $subject;
$mail->AltBody = $msg;
$mail->Body = $msg;
for ($i=0; $i<count($to); $i++)
{
if($to[$i]!="")
$mail->AddAddress($to[$i]);
//Utils::Trace('sendMailViaSMTP MAIL SENT !..'.$to[$i]);
if(!$mail->Send())
{
Utils::Trace('sendMailViaSMTP MAIL SENT !..'.$msg);
Utils::Trace('sendMailViaSMTP MAIL SENT !..'.$subject);
$erroInfo = 'Mailer Error: ' . $mail->ErrorInfo;
Utils::Trace('sendMailViaSMTP Mailer Error: !..'.$erroInfo);
$headers = "From: ".$fname;
$semi_rand = md5(time());
$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
$headers .= "\nMIME-Version: 1.0\n" . "Content-Type:
multipart/mixed;\n" . " boundary=\"{$mime_boundary}\"";
$msg .= "This is a multi-part message in MIME format.\n\n" .
"--{$mime_boundary}\n" . "Content-Type:text/html;
charset=\"iso-8859-1\"\n" . "Content-Transfer-Encoding: 7bit\n\n" .
$msg . "\n\n";
$can=implode(',',$to);
$sts = mail($to[$i], $subject, $msg, $headers);
if($sts){
Utils::Trace(' MAIL  SEND  via mail function!..'.$to[$i]);
return 1;
}else{
Utils::Trace('sendMailViaSMTP MAIL NOT SEND !..'.$to[$i]);
return 0;
}
}
else {
Utils::Trace('sendMailViaSMTP MAIL SEND !..'.$to[$i]);
return 1;
}
$mail->ClearAddresses();
}
}
else{
return 2;
}
}
    public static function numberformatter($val)
    {
$code =$_SESSION['ubihrm_currencycode'];
$symbol = Utils::getCurrencySymbolHex($code);
$fomat = number_format($val,2,'.',',');
return $symbol."&nbsp;".$fomat;
    }
public static function getcurrency()
    {
$code =$_SESSION['ubihrm_currencycode'];
return Utils::getCurrencySymbolHex($code);
    }
public static function getDateformat($date)
{
$format = "dd/mm/yyyy";
$changedate=$date;
if($changedate=="" || $changedate==" "){
return $changedate;
}
else{
if($format=="dd/mm/yyyy" || $format=="mm/dd/yyyy" || $format=="yyyy/mm/dd"){
$temp = explode('/', $date);
if($format=="dd/mm/yyyy"){
$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
}elseif($format=="mm/dd/yyyy"){
$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
}elseif($format=="yyyy/mm/dd"){
$changedate=$temp[0]."-".$temp[1]."-".$temp[2];
}
}elseif($format=="dd-mm-yyyy" || $format=="mm-dd-yyyy" ||
$format=="yyyy-mm-dd"){
$temp = explode('-', $date);
if($format=="dd-mm-yyyy"){
$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
}elseif($format=="mm-dd-yyyy"){
$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
}else{
$changedate=$date;
}
}
return $changedate;
}
}
public static function getDateTimeformat($date)
{
$format = 'dd/mm/yyyy h:i';
$changedate=$date;
if($changedate==""){
return $changedate;
}
else{
if($format=="dd/mm/yyyy h:i" || $format=="mm/dd/yyyy h:i" ||
$format=="yyyy/mm/dd h:i"){
$temp1 = explode(' ', $date);
$temp = explode('/', $temp1[0]);
if($format=="dd/mm/yyyy h:i"){
$changedate=$temp[2]."-".$temp[1]."-".$temp[0]." ".$temp1[1];
}elseif($format=="mm/dd/yyyy h:i"){
$changedate=$temp[2]."-".$temp[0]."-".$temp[1]." ".$temp1[1];
}elseif($format=="yyyy/mm/dd h:i"){
$changedate=$temp[0]."-".$temp[1]."-".$temp[2]." ".$temp1[1];
}
}elseif($format=="dd-mm-yyyy h:i" || $format=="mm-dd-yyyy h:i" ||
$format=="yyyy-mm-dd h:i"){
$temp1 = explode(' ', $date);
$temp = explode('-', $temp1[0]);
if($format=="dd-mm-yyyy"){
$changedate=$temp[2]."-".$temp[1]."-".$temp[0]." ".$temp1[1];
}elseif($format=="mm-dd-yyyy"){
$changedate=$temp[2]."-".$temp[0]."-".$temp[1]." ".$temp1[1];
}else{
$changedate=$date;
}
}
return $changedate.':00';
}
}
public static function datetimeformatter($val)
    {
$result = "";
if($val!="0000-00-00 00:00:00" && $val!="")
$result = date('d/m/Y h:i',strtotime($val));
return $result;
    }
public static function timeformatter($val)
    {
$result = "";
if($val!="00:00:00" && $val!="")
$result = isset($_SESSION['ubihrm_timeformate'])?date($_SESSION['ubihrm_timeformate'],strtotime($val)):$val;
return $result;
    }
public static function dateformatter($val)
    {
$result = "";
if($val!="0000-00-00" && $val!="")
$result = date('d/m/Y',strtotime($val));
return $result;
    }
public static function monthdateformatter($val)
    {
$result = "";
if(($val!="0000-00-00") && ($val!="0000-00-00 00:00:00"))
{
$result = date("F Y",strtotime($val));
}
return $result;
    }

//Return Currency Symbol in HEX
public static function getCurrencySymbolHex($currency_code){
if (!empty(Utils::$currency_info[$currency_code]['hex']))
return (string) Utils::$currency_info[$currency_code]['hex'];
else
return '';
}
public static function encode5t($str)
{
if($str){
  for($i=0; $i<5;$i++)
  {
    $str=strrev(base64_encode($str)); //apply base64 first and then
reverse the string
  }
}
  return $str;
}
public static function decode5t($str)
{
if($str){
  for($i=0; $i<5;$i++)
  {
    $str=base64_decode(strrev($str)); //apply base64 first and then
reverse the string}
  }
}
  return $str;
}
public static function getName($id, $table, $column, $db)
{
$name ="";
$sql = "SELECT $column FROM $table WHERE Id = :id";
        $query = $db->prepare($sql);
try{
$query->execute(array(':id' => $id ));
while($row = $query->fetch())
{
$name = $row->$column;
}
}catch(Exception $e) {
}
return $name;
}
public static function getOtherName($id, $type, $db)
{
$name ="";
$sql = "SELECT DisplayName FROM OtherMaster WHERE ActualValue = ? and
OtherType = ? ";
        $query = $db->prepare($sql);
try{
$query->execute(array( $id, $type ));
while($row = $query->fetch())
{
$name = $row->DisplayName;
}
}catch(Exception $e) {
}
return $name;
}
public static function sendMail1($to, $fname, $subject, $msg)
{
include(LIBS_PATH."PhpMailer/class.phpmailer.php");
$hostName = "smtp.gmail.com";
$portName = "587";
$userName = "harish@ubitechsolutions.com";
$password = "ubipass2015";
$fromName = $fname;
$smtpAuth = true;
$mail = new PHPMailer();
$mail->IsSMTP();
$mail->CharSet="UTF-8";
$mail->Host = $hostName;
$mail->Port = $portName;
$mail->Username = $userName;
$mail->Password = $password;
$mail->SMTPAuth = $smtpAuth;
//$to = "support@ubitechsolutions.com";
$mail->From = $userName;
$mail->FromName = $fromName;
$mail->AddAddress($to);
$mail->AddCC('monika@ubitechsolutions.com');
$mail->AddReplyTo($userName,'Information');
$mail->IsHTML(true);
$mail->Subject = $subject;
$mail->AltBody = $msg;
$mail->Body = $msg;
if(!$mail->Send())
{
echo "mail not send";
}else{
echo "mail send";
}
}
public static function sendMail($to,$fname,$subject,$msg)
{
//include(LIBS_PATH."PhpMailer/class.phpmailer.php");
$hostName = "ubirecruit.com";
//$portName = "26";
$userName = "noreply@ubirecruit.com";//$email;
$password = 'Ubipass@2017#';
$fromName = $fname;
//$smtpAuth = 'false';
$smtpAuth = true;
$mail = new PHPMailer();
$mail->IsSMTP();
$mail->CharSet="UTF-8";
//$mail->SMTPSecure = "no";
$mail->Host = $hostName;
$mail->Port =465;
$mail->Username = $userName;
$mail->Password = $password;
$mail->SMTPAuth = $smtpAuth;
//$to = "support@ubitechsolutions.com";
$mail->From = "noreply@ubirecruit.com";
$mail->FromName = "UBIHRM";
$mail->AddAddress($to);
$mail->AddBCC('monika@ubitechsolutions.com');
$mail->AddReplyTo($userName,"Information");
$mail->IsHTML(true);
$mail->Subject = $subject;
$mail->AltBody = $msg;
$mail->Body = $msg;
if(!$mail->Send())
{
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$headers .= "From: $fromName<noreply@ubihrm.com>" . "\r\n";
$sts1=mail($to,$subject,$msg,$headers);
//mail('monika@ubitechsolutions.com',$subject,$msg,$headers);
return false;
}
else
{
return true;
}
}
public static function Trace($content){
try{
                        $log_path="public/logs/"; // directory name
here like /var/www/html/myfolder/logs/
if (!file_exists($log_path)) {
mkdir($log_path, 0777, true);
}
                        $today_date = date("d-M-Y");
                        $current_time = date("d-M-Y H:i");
                        $filename =  $log_path .
str_replace('-','_',$today_date) . "_log.log"; //this is a file name
                        $fp = fopen($filename, "a+"); // Open the data
file, file points at the end of file
                        $fw = fwrite($fp,$current_time . " : " .
$content . "\r\n");
                        fclose($fp);
}catch(Exception $e){
echo $e->getMessage();
}
       }
/////////////START ONBOARD,ACCEPT REJECT STATUS FUNCTION FOR CANDIDATE
OFFER LETTER///////
public static function offerLetterSts($sts)
{
$status="";
if($sts==1)
{
$status="<span class='badge bg-green'>Accepted</span>";
}
elseif($sts==2)
{
$status="<span class='badge bg-red'>Declined</span>";
}
elseif($sts==3)
{
$status="<span class='badge bg-red'>Pending</span>";
}
elseif($sts==4)
{
$status="<span class='badge bg-red'>Onboarded</span>";
}
else
{
$status="";
}
return $status;
}
public static function getMultipleName($table,$colname,$colid,$id=0, $db)
{
$name ="";
$id=rtrim($id,",");
if($id=="")
$id=0;
$sql = "SELECT $colname FROM $table WHERE $colid in ($id)";
        $query = $db->prepare($sql);
try{
$query->execute();
while($row = $query->fetch())
{
if($name=="")
$name = $row->$colname;
else
$name = $name.", ".$row->$colname;
}
}catch(Exception $e) {
}
return $name;
}
public static function getNamebyOrder($table,$colname,$colid,
$id=0,$orderby,$db)
{
$name ="";
$sql = "SELECT $colname FROM $table WHERE $colid = :id order by
$orderby desc limit 1";
        $query = $db->prepare($sql);
try{
$query->execute(array(':id' => $id ));
while($row = $query->fetch())
{
$name = $row->$colname;
}
}catch(Exception $e) {
}
return $name;
}
public static function getRecruitersPost($id,$db)
{
$name =0;
$sql = "SELECT count(post_id) as total FROM post_master WHERE
FIND_IN_SET('$id', approving_manager) and sts=1";
        $query = $db->prepare($sql);
try{
$query->execute();
while($row = $query->fetch())
{
$name = $row->total;
}
}catch(Exception $e) {
}
return $name;
}
public static function getApprovalLevelEmp($empid, $processtype, $db)
{
//processtype 2 for Jobs
$orgid = $_SESSION['ubirecruit_org_id']; //ORG ID CONTAINS IN ARRAY
SECOND VALUE;
$id = "0";
$seniorid=0;
$designation=0;
// $gethrID=Utils::getHRApproval($orgid, $db);
if($empid!="0" && $empid!="")
{
$sql = "SELECT reportto, role_id FROM user_login WHERE org_id = ? and id = ? ";
$query = $db->prepare($sql);
$query->execute(array($orgid, $empid));
while($row = $query->fetch())
{
$seniorid = $row->reportto;
$designation_id =
Utils::getName1('designation_master','designation_id','designation_id',$row->role_id,$db);
}
if($seniorid!=0 && $designation !=0)
{
$sql = "SELECT RuleCriteria FROM ApprovalProcess WHERE OrganizationId
= ? and Designation = ?  and ProcessType = ? ";
$query = $db->prepare($sql);
$query->execute(array($orgid, $designation_id, $processtype));
if($query->rowCount()>0)
{
$row = $query->fetch();
$rule = $row->RuleCriteria;
// $sts = $row->HrStatus;
$reportingto = Utils::getSeniorIds($empid, $db);
$seniorid = "";
$sql = "SELECT id, role_id FROM user_login WHERE org_id = ?  and
role_id in ( $rule )  and id in ( $reportingto ) order by
FIELD(role_id, $rule)"; /////////
///////////sts=0 for all the designation and employee,if sts=1 then
hierarchy employee will come///////
//if($sts==0)
//$sql = "SELECT Id, Designation FROM EmployeeMaster WHERE
OrganizationId = ? and DOL='0000-00-00' and Designation in ( $rule )";
$query = $db->prepare($sql);
$query->execute(array($orgid));
while($row = $query->fetch())
{
if($seniorid=="")
$seniorid = $row->id;
else
$seniorid .= ",".$row->id;
}
/* if($sts!=0){
$temp1 = explode(",", $seniorid);
for($i=0;$i<count($temp1);$i++)
{
if($temp1[$i] == $gethrID){
unset($temp1[$i]);
}
}
$seniorid.=','.$gethrID;
}else{
$seniorid;
} */
}
}
}
$seniorids=explode(",",$seniorid);
/* if(count($seniorids) ==1 )
$seniorid.=','.$gethrID; */
return $seniorid;
}
public static function getName1($table,$colname,$colid,$id=0,$db)
    {
$name = "";
        $sql = "select $colname from $table WHERE $colid = '$id'";
        $query = $db->prepare($sql);
        $query->execute();

        while($row=$query->fetch())
{
$name=$row->$colname;
}
        // default return
        return $name;
    }
public static function getSeniorIds($empid, $db)
{
$orgid = $_SESSION['ubirecruit_org_id']; //ORG ID CONTAINS IN ARRAY
SECOND VALUE;
$ids = "0";
$parentid=$empid;
if($parentid!="0" && $parentid!="")
{
while($parentid!="")
{
$sql1 = "SELECT reportto FROM user_login WHERE OrganizationId = ? and
id in ( $parentid )";
$query1 = $db->prepare($sql1);
$query1->execute(array($orgid));
$parentid="";
while($row1 = $query1->fetch())
{
if($parentid==""){
$parentid = $row1->reportto;
}else{
$parentid .= ", ".$row1->reportto;
}
if($ids==""){
$ids = $row1->reportto;
}else{
$ids .= ",".$row1->reportto;
}
}
}
}
return $ids;
}
}