<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Administrator | Courses</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <!-- bootstrap 3.0.2 -->
        <link href="<?php echo URL;?>public/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <!-- font Awesome -->
        <link href="<?php echo URL;?>public/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <!-- Ionicons -->
        <link href="<?php echo URL;?>public/css/ionicons.min.css" rel="stylesheet" type="text/css" />
        <!-- DATA TABLES -->
        <link href="<?php echo URL;?>public/css/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
        <!-- Theme style -->
        <link href="<?php echo URL;?>public/css/AdminLTE.css" rel="stylesheet" type="text/css" />

    </head>
    <body class="skin-blue fixed">
        <!-- header logo: style can be found in header.less -->
        <?php require VIEWS_PATH . '_templates/sidebar.php'; 
				topbar();
				?>
        <div class="wrapper row-offcanvas row-offcanvas-left">
            <!-- Left side column. contains the logo and sidebar -->
            <aside class="left-side sidebar-offcanvas">                
                <!-- sidebar: style can be found in sidebar.less -->
                <?php  
				sidemenu(2);
				?>
                <!-- /.sidebar -->
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <aside class="right-side">                
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Courses
                        <small></small>
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Courses</li>
                    </ol>
                </section>

                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <!-- /.box -->
                            
                            <div class="box">
                                <div class="box-header">
                                    <h3 class="box-title">Course List</h3>
									<!-- tools box -->
                                    <div class="pull-right box-tools">									
                                        <a href="<?php echo URL;?>course"><button class="btn btn-info btn-sm"  data-toggle="tooltip" title="Refresh"><i class="fa fa-refresh"></i></button></a>
                                        <a href="<?php echo URL;?>course/addnew"><button class="btn btn-info btn-sm"  data-toggle="tooltip" title="Add"><i class="fa fa-plus"></i></button></a>
                                    </div><!-- /. tools -->                                    
                                </div><!-- /.box-header -->
                                <div class="box-body table-responsive">
									
									<?php $this->renderFeedbackMessages(); ?>
                                    <table id="example1" class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
												<th>Course Image</th>
                                                <th>Course Name</th>
                                                <th>Create Date</th>
												<th>Last Modified</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
										<?php
											if ($this->courses) {
												foreach($this->courses as $key => $value) {
													echo '<tr>';
													if($value['course_image']){
														echo '<td><img src="'. URL.UPLOAD_PATH.$value["course_image"].'" class="img-circle" alt="User Image" width="30"/></td>';
													}else{
														echo '<td>-</td>';
													}
													echo '<td>' . htmlentities($value["course_name"]) . '<small class="badge pull-right bg-green">'.$value['lession_count'].'</small></td>';
													//echo '<td>'.$value['lession_count'].'</td>';
													
													echo '<td>'.date("dS M Y h:i A", strtotime(date($value['create_date']))).'</td>';
													echo '<td>'.date("dS M Y h:i A", strtotime(date($value['modified_date']))).'</td>';
													echo '<td><a data-href="'. URL . 'course/statuschange/' . $value["course_id"].'/'.$value["course_status"].'" data-toggle="modal" data-target="#confirm-change" href="#" title="';
													if($value['course_status']){
														echo 'Deactivate"><i class="fa fa-check"></i>';
													}else{
														echo 'Activate"><i class="fa fa-times"></i>';
													}
													echo '</a></td>';
													echo '<td><a href="'. URL . 'course/edit/' . $value["course_id"].'" data-toggle="tooltip" title="Edit"><i class="fa fa-edit"></i></a>';
													//if($value->user_group_id>12){
													echo '&nbsp;&nbsp;&nbsp;&nbsp;<a data-href="'. URL . 'course/delete/' . $value["course_id"].'" data-toggle="modal" data-target="#confirm-delete" href="#" title="Delete"><i class="fa fa-trash-o"></i></a>';//}
													echo '&nbsp;&nbsp;&nbsp;&nbsp;<a href="'. URL . 'course/details/' . $value["course_id"].'"  title="View"><i class="fa fa-eye"></i></a>';//}
													echo '</td></tr>';
												}
											} 
										?>
                                        </tbody>
                                        <tfoot>
                                            <tr><th>Course Image</th>
                                                <th>Course Name</th>
                                                <th>Create Date</th>
												<th>Last Modified</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                    </div>

                </section><!-- /.content -->
            </aside><!-- /.right-side -->
        </div><!-- ./wrapper -->

<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">            
            <div class="modal-body">
                <h4>Do you want to delete this course?</h4>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a href="#" class="btn btn-danger danger">Delete</a>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="confirm-change" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">            
            <div class="modal-body">
                <h4>Do you want to change the status of course?</h4>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a href="#" class="btn btn-danger danger">Change</a>
            </div>
        </div>
    </div>
</div>

        <!-- jQuery 2.0.2 -->
        <script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
        <!-- Bootstrap -->
        <script src="<?php echo URL;?>public/js/bootstrap.min.js" type="text/javascript"></script>
        <!-- DATA TABES SCRIPT -->
        <script src="<?php echo URL;?>public/js/plugins/datatables/jquery.dataTables.js" type="text/javascript"></script>
        <script src="<?php echo URL;?>public/js/plugins/datatables/dataTables.bootstrap.js" type="text/javascript"></script>
        <!-- AdminLTE App -->
        <script src="<?php echo URL;?>public/js/AdminLTE/app.js" type="text/javascript"></script>
         <!-- page script -->
        <script type="text/javascript">
			$('#confirm-delete').on('show.bs.modal', function(e) {
				$(this).find('.danger').attr('href', $(e.relatedTarget).data('href'));
			});
			$('#confirm-change').on('show.bs.modal', function(e) {
				$(this).find('.danger').attr('href', $(e.relatedTarget).data('href'));
			});
            $(function() {
                $("#example1").dataTable();
                $('#example2').dataTable({
                    "bPaginate": true,
                    "bLengthChange": false,
                    "bFilter": false,
                    "bSort": true,
                    "bInfo": true,
                    "bAutoWidth": false
                });
            });
           
        </script>

    </body>
</html>
