<?php

/**
 * UserModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class UserModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    
    public function getAllUsers()
    {
		 $org_id=$_SESSION['user_org_id'];
        $sql = "SELECT * FROM users where org_id=?";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['user_id'] = $row->user_id;
			$res['user_active'] = $row->user_active;
			$res['user_name'] = $row->user_name;
			$res['user_email'] = $row->user_email;
			$res['user_profile'] = $row->user_profile;
			$res['userprofile'] = $this->getName($row->user_profile,'userprofiles','name','Id');
			$res['user_resume'] = $row->resume;
			$res['user_password'] = Utils::decode5t($row->user_password_hash);
			$res['user_fullname'] = ucwords(strtolower($row->user_fullname));
			/* $res['user_group_id'] = $row->user_group_id;
			$res['user_group_name'] = ""; */
			
			/* $sql1 = "SELECT group_name FROM user_group where user_group_id =:groupid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('groupid'=>$row->user_group_id));
			while($row1= $query1->fetch())
			{
				$res['user_group_name'] = ucwords(strtolower($row1->group_name));
			} */
			$result[] =$res;
		}
      
        return $result;
    }

    
    public function getUser($user_id)
    {
        $sql = "SELECT user_id, user_active, user_name,user_password_hash, user_fullname, user_group_id, user_email,user_profile,resume from users WHERE user_id = :user_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_id' => $user_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }
	
	public function getusersonprofilebasis()
    {
        $org_id=$_SESSION['user_org_id'];
		$user_id=isset($_POST['profileid'])?$_POST['profileid']:'';
        $sql = "SELECT * FROM users where org_id=? AND user_profile =? ";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id,$user_id));
        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$data= array();
			$res['user_id'] = $row->user_id;
			//$res['user_active'] = $row->user_active;
			$res['user_name'] = $row->user_name;
			//$res['user_email'] = $row->user_email;
		//	$res['user_profile'] = $row->user_profile;
		//	$res['userprofile'] = $this->getName($row->user_profile,'userprofiles','name','Id');
		//	$res['user_resume'] = $row->resume;
		//	$res['user_password'] = Utils::decode5t($row->user_password_hash);
		//	$res['user_fullname'] = ucwords(strtolower($row->user_fullname));
			/* $res['user_group_id'] = $row->user_group_id;
			$res['user_group_name'] = ""; */
			
			/* $sql1 = "SELECT group_name FROM user_group where user_group_id =:groupid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('groupid'=>$row->user_group_id));
			while($row1= $query1->fetch())
			{
				$res['user_group_name'] = ucwords(strtolower($row1->group_name));
			} */
			$data[] =$res;
		}
		$result['data'] =$data;
      
        return $result;
    }

    
    public function create()
    {
		$org_id=$_SESSION['user_org_id'];
        // clean the input to prevent for example javascript within the groups.
		$user_name = strip_tags($_POST['user_name']);
		$user_fullname = strip_tags($_POST['fullname']);
		//$user_group_id = strip_tags($_POST['group_id']);
		$user_email = strip_tags($_POST['email']);
		$profile = strip_tags($_POST['profile']);
		$user_password_hash =isset($_POST['password'])?Utils::encode5t($_POST['password']):"";
		//Utils::Trace(decode5t($_POST['password']));
		$user_creation_timestamp = time();
		
		$sql1="SELECT * FROM users WHERE user_name='$user_name' and org_id='$org_id'";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array());
		$sql2="SELECT * FROM users WHERE user_email='$user_email' and org_id='$org_id'";
		$query2 = $this->db->prepare($sql2);
		$query2->execute(array());
		$count1 =  $query1->rowCount();
		$count2 =  $query2->rowCount();
		  if ($count1== 1) {
			   $_SESSION["feedback_negative"][] = 'User already exists with same User Name.';
		  }else if ($count2== 1){
			$_SESSION["feedback_negative"][] = 'User already exists with same Email.';
		  } 
			else{
        $sql = "INSERT INTO users (user_name, user_fullname, user_email, user_active, user_provider_type, user_password_hash,user_creation_timestamp,user_profile,org_id) VALUES (:user_name, :user_fullname, :user_email, :user_active, :user_provider_type, :user_password_hash, :user_creation_timestamp,:profile,:orgid)";
        $query = $this->db->prepare($sql);
		
        $query->execute(array( ':user_name'=>$user_name, ':user_fullname' =>$user_fullname, ':user_email' => $user_email, ':user_active'=>1, ':user_provider_type'=>'DEFAULT', ':user_password_hash'=>$user_password_hash, ':user_creation_timestamp'=> $user_creation_timestamp,':profile' =>$profile,':orgid'=>$org_id));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_USER_ADDITION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_USER_ADDITION_FAILED;
        }
		 
        // default return
        return false;
		 }
    }


    public function editSave($user_id)
    {
        // clean the input to prevent for example javascript within the groups.
       $count1=0;
       $user_name = strip_tags($_POST['user_name']);
		$user_fullname = strip_tags($_POST['fullname']);
		//$user_group_id = strip_tags($_POST['group_id']);
		$user_email = strip_tags($_POST['email']);
		$user_profile = strip_tags($_POST['profile']);
		
		
		
		
		$password =isset($_POST['password'])?Utils::encode5t($_POST['password']):"";
		$sql1 = "SELECT * from users WHERE user_name=:user_name and user_id != :user_id";
        $query1 = $this->db->prepare($sql1);
		$query1->execute(array(':user_name' => $user_name,':user_id' => $user_id));
		$sql2 = "SELECT * from users WHERE user_email=:user_email and user_id != :user_id";
        $query2 = $this->db->prepare($sql2);
        $query2->execute(array(':user_email' => $user_email,':user_id' => $user_id));
		 $count1 =  $query1->rowCount();
		 $count2 =  $query2->rowCount();
		Utils::Trace($count1);
		if($count1 == 1){
			$_SESSION["feedback_negative"][] = "User already exists with Same User Name.";
		}else if($count2 == 1){
			$_SESSION["feedback_negative"][] = "User already exists With Same Email.";

		}else if($count1 == 0){  
			 $sql = "UPDATE users SET user_name=:user_name, user_password_hash=:user_pass, user_fullname=:user_fullname, user_email=:user_email , user_profile=:user_profile    WHERE user_id = :user_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_name' => $user_name, ':user_pass'=> $password, ':user_fullname' => $user_fullname, ':user_email' => $user_email, ':user_profile' => $user_profile, ':user_id' => $user_id));
		 $count =  $query->rowCount();
			if ($count == 1) {			
				$_SESSION["feedback_positive"][] = FEEDBACK_USER_EDITING_SUCCESSFUL;
				/* $_SESSION["user_id"] = $user_id;
				$_SESSION["user_name"] = $user_name;
				$_SESSION["user_fullname"] = $user_fullname;
				$_SESSION["user_email"] = $user_email; */
				return true;
			} else {
				$_SESSION["feedback_negative"][] = "Problem while updating record.";
			}
		}else{
			$_SESSION["feedback_negative"][] = "User already exists.";
		}
        // default return
        return false;
    }




public function Createprofile($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $orgid=$_SESSION['user_org_id'];
		$mdate= date('Y-m-d h:i:s');
		$sql1 = "SELECT * FROM userprofiles WHERE  name = ? and org_id=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[1],$orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			$status =false;
			 $errorMsg='Profile already exists';
		}else{
			$sql = "INSERT INTO userprofiles (name, description,modified_date,created_date,org_id) VALUES (?,?,?,?,?)";
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($request[1],$request[2],$mdate,$mdate,$orgid));
				//$uid = $this->db->lastInsertId();
				//$uid = Utils::encode5t($uid);
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = 'Profile created successfully';
			} else {
			   $status =false;
			   $errorMsg='Profile not created ';
			}
		
		}
		
		//$result["data"] =$uid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	    public function gettabs($id)
    {
		//echo $id;
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$id=Utils::decode5t($id);
		 $sql1 = "SELECT * FROM userprofiles where Id='$id'";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array());
			$row1 = $query1->fetch();
        $sql = "SELECT * FROM aptitude_module";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
		$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			//$res = array();
			//$res['id'] = 0;
			//$res['sts'] = false;
			//$data[] = $res;
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['tabid'] = $row->mod_id;
				$res['tabname'] =$row->mod_name;
				$res['usergroupname'] = $row1->name;
				$data[] = $res;
			}
        }
		
	else {
           $status =false;
		   $errorMsg=USER_GROUP_MODULE_GETTABS_FAILED;
        }
		$result["data"] =$data;
		//$result["tab"] =$data1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
		 public function getModules()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
       $sql = "SELECT * FROM aptitude_sub_modules";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			//$res = array();
			//$res['id'] = 0;
			//$res['sts'] = false;
			//$data[] = $res;
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['tabid'] = $row->mod_id;
				$res['tabname'] = $row->sub_module_name;
				$res['label'] = $row->sub_module_name;
				$res['vsts'] = false;
				$res['ests'] = false;
				$res['asts'] = false;
				$res['dsts'] = false;
				
				$data[] = $res;
			}
        }
		
	else {
           $status =false;
		   $errorMsg=USER_GROUP_MODULE_GETMODULES_FAILED;
        }
		$result["data"] =$data;
		//$result["tab"] =$data1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function Updateprofile($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $orgid=$_SESSION['user_org_id'];
		$mdate= date('Y-m-d h:i:s');
		$sql1 = "SELECT * FROM userprofiles WHERE id!=? and name = ? and org_id=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[3] , $request[1],$orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			$status =false;
			 $errorMsg='Profile already exists';
		}else{
			$sql = "UPDATE userprofiles SET  name=?, description=?, modified_date=? WHERE  id=?";
			
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($request[1],$request[2],$mdate,$request[3]));
				//$uid = $this->db->lastInsertId();
				//$uid = Utils::encode5t($uid);
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = 'Profile updated successfully';
			} else {
			   $status =false;
			   $errorMsg='Profile not updated ';
			}
		
		}
		
		//$result["data"] =$uid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }


 public function getUserprofiledata()
    {
		 $org_id=$_SESSION['user_org_id'];
        $sql = "SELECT * FROM userprofiles where org_id=?";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['profile_id'] = $row->Id;
			$res['profile_name'] = $row->name;
			$res['description'] = $row->description;
			$res['userprofile_type'] = $row->user_profile_type;
			//$res['profile_active'] = $row->name;
			
			$result[] =$res;
		}
      
        return $result;
    }
	
	
	public function getActivityLog()
    {
		 $des='';
		 $des1='';
		 $des2='';
		$startdate = isset($_POST['startdate'])?$_POST['startdate']:'' ;
		$enddate = isset($_POST['enddate'])?$_POST['enddate']:'' ;
		$userid = isset($_POST['users'])?$_POST['users']:'' ;
		$profileid = isset($_POST['profile'])?$_POST['profile']:'' ;
		 $org_id=$_SESSION['user_org_id'];
		 if($userid!=0){
			 $des = "AND LastModifiedById= $userid" ;
		 }
		  if($startdate!='' && $enddate!=''){
			 $des1 = "AND Date(LastModifiedDate) between '$startdate' and '$enddate'" ;
		 }
		  if($profileid!=0){
			 $des2 = "AND user_profile_Id= $profileid" ;
		 }
        $sql = "SELECT * FROM ActivityHistoryMaster where OrganizationId=? $des $des1 $des2";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			
			$res['actionperformed'] = $row->ActionPerformed;

			$res['LastModifiedById'] =$this->getName($row->LastModifiedById,' users','user_fullname','user_id');
			$res['userprofilesname'] =$this->getName($row->user_profile_Id,' userprofiles','name','Id');
			$res['module'] = $row->Module;
			$res['moddate'] = date("d M Y h:i A",strtotime($row->LastModifiedDate));
			//$res['profile_active'] = $row->name;
			
			$result[] =$res;
		}
      
        return $result;
    }
	
	public function getUserprofile($id)
    {
		 $org_id=$_SESSION['user_org_id'];
        $sql = "SELECT * FROM userprofiles where org_id=? and id = ?";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id , $id));
        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['profile_id'] = $row->Id;
			$res['profile_name'] = $row->name;
			$res['description'] = $row->description;
			
			
			
			$result[] =$res;
		}
      
        return $result;
    }
	
	
	 public function Updatepermission($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$res = json_decode($request[2], true);
		
		
		
		  for($i=0; $i<count($res); $i++)
		  {		
			$sql1 = "SELECT * FROM userprofile_permission WHERE userprofileId = ? AND submoduleId=? and org_id=?";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array($request[3], $res[$i]['id'], $orgid));
			$count1 =  $query1->rowCount();
		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count1>=1)
			{
				$sql = "UPDATE userprofile_permission SET viewpermission=?, editpermission=?, deletepermission=?, addpermission=?, modified_date=? WHERE userprofileId=? AND submoduleId=? and org_id=?";
		
				$query = $this->db->prepare($sql);
				
				try{
									
					$query->execute(array($res[$i]['vsts'], $res[$i]['ests'], $res[$i]['dsts'], $res[$i]['asts'],$mdate, $request[3], $res[$i]['id'], $orgid));			
					$count =  $query->rowCount();
					
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}else{
				$sql = "INSERT INTO userprofile_permission (userprofileId, submoduleId, viewpermission, editpermission, deletepermission, addpermission, org_id, createdbyId, created_date, modified_date) VALUES (?,?,?,?,?,?,?,?,?,?)";
				
					try{
									
						$query = $this->db->prepare($sql);
						$query->execute(array($request[3], $res[$i]['id'], $res[$i]['vsts'], $res[$i]['ests'], $res[$i]['dsts'], $res[$i]['asts'], $orgid, $mid, $mdate, $mdate ));
				
						$count =  $query->rowCount();		
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
			}
			
		}
		if ($count >= 1) {
			$status =true;
			$successMsg = 'Set permissions successfully';
		} else {
			$status =false;
			$errorMsg='Not successfully';
		}
		
		//}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getpermissionDetail($id, $orgid)
    {
		//echo $id;
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
	
       $sql = "SELECT * FROM userprofile_permission WHERE userprofileId = '$id ' AND org_id=  '$orgid'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array());
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			//$res1 = array();
			//$res1['rolename'] = $id;
			//$data[] = $res1;
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['usergroupname'] = $this->getName($id,'userprofiles','name','Id');
				
				$res['submodule_name'] = $row->submoduleId;
				
				$res['name'] = $this->getName($row->submoduleId,'aptitude_sub_modules','sub_module_name','Id');
				//$res['name'] = $this->getName('aptitude_sub_modules','sub_module_name','Id',$row->submoduleId);
				
				$res['vsts'] = (int)$row->viewpermission;
				$res['ests'] = (int)$row->editpermission;
				$res['dsts'] = (int)$row->deletepermission;
				$res['asts'] = (int)$row->addpermission;
				
				$data[] = $res;
			}
        	}
		
		if ($count >= 1) {
           $status =true;
		   $successMsg =' User profile module got permission successfully';
        } else {
           $status =false;
		   $errorMsg='User group module getpermission failed';
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getAllUsersprofile()
    {
		 $org_id=$_SESSION['user_org_id'];
        $sql = "SELECT * FROM userprofiles where org_id=? ";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['profile_id'] = $row->Id;
			$res['profile_name'] = $row->name;
			$res['description'] = $row->description;
			
			
			
			$result[] =$res;
		}
      
        return $result;
    }
    /**
     * Deletes a specific group
     * @param int $group_id id of the group
     * @return bool feedback (was the group deleted properly ?)
     */
    public function delete($user_id)
    {
		$org_id=$_SESSION['user_org_id'];
		$count1=0;
		$sql1 = "SELECT * FROM schedule_candidate WHERE 	assessorid = $user_id and org_id=$org_id";
        $query1 = $this->db->prepare($sql1);
		$query1->execute(array());
		
		$count1 =  $query1->rowCount();
		if($count1>=1)
		{
			$_SESSION["feedback_negative"][] = 'User is used for scheduled candidate';
			 return false;
		}
		else{
        $sql = "DELETE FROM users WHERE user_id = :user_id and org_id=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_id' => $user_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_USER_DELETION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_USER_DELETION_FAILED;
        }
        // default return
			}
        return false;
	
    }
    
	
	 public function deleteprofile($user_id)
    {
		

		$count1=0;
		$org_id=$_SESSION['user_org_id'];
		$sql1 = "SELECT * FROM users WHERE 	user_profile=$user_id and org_id=$org_id";
        $query1 = $this->db->prepare($sql1);
		$query1->execute(array());
		
		$count1 =  $query1->rowCount();
		if($count1>=1)
		{
			$_SESSION["feedback_negative"][] = 'This Profile is used by User ';	
				
			
		}else{
			
		$sql = "DELETE FROM userprofile_permission  WHERE userprofileId = :user_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_id' => $user_id));
		
		
        $sql = "DELETE FROM userprofiles WHERE Id = :user_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_id' => $user_id));

        $count =  $query->rowCount();
   

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = 'User Profile deleted successfully';
            return true;
        } else {
            $_SESSION["feedback_negative"][] = 'User Profile not deleted ';
        }
		// default return
	}
        return false;
	
}
	
    public function changestatus($user_id, $status)
    {
		$status = ($status==1)?0:1;
        $sql = "update users set user_active=:sts WHERE user_id = :user_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':user_id' => $user_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_USER_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_USER_CHANGE_STATUS_FAILED;
        }
        // default return
        return false;
    }
	
	public  function decrypt($string , $key="ubitech")
			{
			   $result='';
			   $string=base64_decode($string);
			   for($i=0; $i<strlen($string); $i++)
			   {
					$char = substr($string, $i,1);
					$keychar =substr($key, ($i % strlen($key))-1,1);
					$char = chr(ord($char)-ord($keychar));
					$result.=$char;
			   }
			   return $result;
		   }
		 public  function encrypt($string, $key="ubitech")
	{
		  $result = '';
		  for($i=0; $i<strlen($string); $i++)
		  {
			$char = substr($string, $i, 1);
			$keychar = substr($key, ($i % strlen($key))-1, 1);
			$char = chr(ord($char)+ord($keychar));
			$result.=$char;
		  }
		  return base64_encode($result);
	}
	public function Changepwd($id){
	
        $old=isset($_REQUEST['opassword'])?Utils::encode5t($_REQUEST['opassword']):"";
        $new=isset($_REQUEST['npassword'])?Utils::encode5t($_REQUEST['npassword']):"";
        
        $sql = "UPDATE users set user_password_hash=? where user_password_hash=? and user_id=?";
        $query = $this->db->prepare($sql);
        $query->execute(array($new,$old,$id));        
        $count = $query->rowCount();
		if ($count == 1) {
			$_SESSION["feedback_positive"][] = "Password has been changed successfully";
            return true;
        } else {
            $_SESSION["feedback_negative"][] = "There is some problem while changing password";
        }
        // default return
        return false;
			
		
	}
	public function getName($id,$table,$field,$where){
			$name="";
			$sql = "select $field from $table where $where = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array($id));
			while($row=$query->fetch())
			{
				$name=$row->$field;
			}
			return $name;
	}
	
}
?>