<?php

/**
 * CourseModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class TestlevelModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getAllTestlevel()
    {
		
       // $sql = "SELECT * FROM designation_table ";
		$org_id=$_SESSION['user_org_id'];
		$sql = "SELECT * FROM test_level WHERE org_id=? and status=1 order by id asc";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['id'] = $row->id;
			//echo "<script> alert($row->id); </script>";
			$res['level'] = $row->level;
			$res['status'] = $row->status;
			$res['description'] = $row->Description;
			$res['createdDate'] = $row->createdDate;
			$res['updatedDate'] = $row->updatedDate;
			$result[] =$res;
		}
        return $result;
    }
	
	 public function getAlllevel($val)
    {
		
       // $sql = "SELECT * FROM designation_table ";
		$org_id=$_SESSION['user_org_id'];
		$sql = "SELECT * FROM test_level WHERE org_id=? and  id =$val ";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['id'] = $row->id;
			//echo "<script> alert($row->id); </script>";
			$res['level'] = $row->level;
			$res['status'] = $row->status;
			$res['description'] = $row->Description;
			$res['createdDate'] = $row->createdDate;
			$res['updatedDate'] = $row->updatedDate;
			$result[] =$res;
		}
        return $result;
    }
	
	 public function getAllTestlevelforposition($pos_id)
    {
		//echo $pos_id;
		
       // $sql = "SELECT * FROM designation_table ";
		$org_id=$_SESSION['user_org_id'];
		$sql = "SELECT *  FROM `test_level` WHERE id not in (select testlevel_id from set_test where designation_id = ? and org_id = ?) ";
        $query = $this->db->prepare($sql);
        $query->execute(array($pos_id , $org_id));
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['id'] = $row->id;
			//echo "<script> alert($row->id); </script>";
			$res['level'] = $row->level;
			$res['status'] = $row->status;
			$res['createdDate'] = $row->createdDate;
			$res['updatedDate'] = $row->updatedDate;
			$data[] =$res;
		}
		$result['data']=$data;
        return $result;
    }
	  public function getAllCurrentTestlevel()
    {
		
       // $sql = "SELECT * FROM designation_table ";
		$org_id=$_SESSION['user_org_id'];
		$sql = "SELECT * FROM test_level order by id";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
        $result =array();
		$i=1;
        while($row = $query->fetch())
        {
			
			if($i==1){
				$res= array();
					$res['id'] = 0;
			$res['level'] = "Not Tested";
	$result[] =$res;
	$res['id'] = 99;
			$res['level'] = "Not Scheduled";
	$result[] =$res;
			}
			$res= array();
			$res['id'] = $row->id;
			$res['level'] = $row->level;
				
			$result[] =$res;
			$i++;
		}
     
        return $result;
    }
	
    /**
     * Getter for a single group
     * @param int $group_id id of the specific group
     * @return object a single object (the result)
     */
    public function getTestLevel($id)
    {
		
		
      $sql = "SELECT * FROM test_level WHERE id = :id ";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id' => $id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }

    /**
     * Setter for a group (create)
     * @param string $group_text group text that will be created
     * @return bool feedback (was the group created properly ?)
     */
    public function create()
    {
        // clean the input to prevent for example javascript within the groups.
		$level = isset($_POST['level']) ? ($_POST['level']): "";
		$description = isset($_POST['description']) ? ($_POST['description']): "";
		$sts=1;
		$org_id=$_SESSION['user_org_id'];
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		$count1=0;
		
		 $sql = "SELECT * FROM test_level WHERE level=:level and org_id=:orgid and status=1";
        $query = $this->db->prepare($sql);
        $query->execute(array(':level' => $level, ':orgid'=>$org_id));

       $count1 =  $query->rowCount();
   
		if( $count1==1){
			 $res["errorMsg"] = "Skill Level already exists";
			 $res["status"] =false;
		}
		else{
        $sql = "INSERT INTO test_level(level,Description, status,createdDate, updatedDate,org_id) VALUES (:level,:description, :sts, :cdate, :mdate, :orgid)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':level' => $level,':description'=>$description,':sts'=>$sts, ':cdate'=>$mdate, ':mdate'=>$mdate, ':orgid'=>$org_id));

        $count =  $query->rowCount();
        if ($count == 1) {
			$res["successMsg"] = "Skill Level added successfully.";
            $res["status"] =true;
        } else {
            $res["errorMsg"]= "There is some problem while adding this Skill Level.";
			$res["status"] =false;
        }
		}
        // default return
       return $res;
	
    }


   public function updateLevel()
    {
        // clean the input to prevent for example javascript within the groups.
		$level = isset($_POST['level']) ? ($_POST['level']): "";
		$description = isset($_POST['description']) ? ($_POST['description']): "";
		$lev_id = isset($_POST['lev_id']) ? ($_POST['lev_id']): "";
		$sts=1;
		$org_id=$_SESSION['user_org_id'];
		$user_id=$_SESSION['user_id'];
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		$count1=0;
		
		 $sql = "SELECT * FROM test_level WHERE id!=:levid and level=:level and org_id=:orgid and status=1";
        $query = $this->db->prepare($sql);
        $query->execute(array(':levid' => $lev_id,':level' => $level, ':orgid'=>$org_id));

       $count1 =  $query->rowCount();
   
		if( $count1==1){
			 $res["errorMsg"] = "Skill Level already exists";
			 $res["status"] =false;
		}
		else{
        $sql = "UPDATE test_level SET level= :level, Description=:description , updatedDate=:mdate , updatedbyid=:uid WHERE id= :levid and org_id=:orgid";
       //$sql = "UPDATE test_level(level,Description, status,createdDate, updatedDate,org_id) VALUES (:level,:description, :sts, :cdate, :mdate, :orgid)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':level' => $level,':description'=>$description,':mdate'=>$mdate,':uid'=>$user_id,':levid'=>$lev_id, ':orgid'=>$org_id));

        $count =  $query->rowCount();
        if ($count == 1) {
			$res["successMsg"] = "Skill Level updated successfully.";
            $res["status"] =true;
        } else {
            $res["errorMsg"]= "There is some problem while updating this Skill Level .";
			$res["status"] =false;
        }
		}
        // default return
       return $res;
	
    }
	
	public function deleteLevel()
    {
        // clean the input to prevent for example javascript within the groups.
		
		$lev_id = isset($_POST['lev_id']) ? ($_POST['lev_id']): "";
		$sts=0;
		$org_id=$_SESSION['user_org_id'];
		$user_id=$_SESSION['user_id'];
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		
		$sql="SELECT * FROM candidate_table WHERE skill_area=$lev_id and org_id=:orgid";
		$query = $this->db->prepare($sql);
		$query->execute(array(':orgid'=>$org_id));
		$count =  $query->rowCount();
		if($count>=1){
			$res["errorMsg"] = "Skill Level used for candidate.";
            $res["status"] =false;
		}
		else{
		
		
        $sql = "UPDATE test_level SET status= :sts, updatedDate=:mdate , updatedbyid=:uid WHERE id= :levid and org_id=:orgid";
       //$sql = "UPDATE test_level(level,Description, status,createdDate, updatedDate,org_id) VALUES (:level,:description, :sts, :cdate, :mdate, :orgid)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $sts,':mdate'=>$mdate,':uid'=>$user_id,':levid'=>$lev_id, ':orgid'=>$org_id));

        $count =  $query->rowCount();
        if ($count == 1) {
			$res["successMsg"] = "Skill Level deleted successfully.";
            $res["status"] =true;
        } else {
            $res["errorMsg"]= "There is some problem while deleted this Skill Level .";
			$res["status"] =false;
        }
		}
        // default return
       return $res;
	
    }

    /**
     * Setter for a group (update)
     * @param int $group_id id of the specific group
     * @param string $group_text new text of the specific group
     * @return bool feedback (was the update successful ?)
     */
    public function editSave($id)
    {
        // clean the input to prevent for example javascript within the groups.
		$level = isset($_POST['level']) ? ($_POST['level']): "";
		//$sts = isset($_POST['desi_status']) ? ($_POST['desi_status']): "";
		$org_id=$_SESSION['user_org_id'];
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		
        $sql = "UPDATE test_level SET level = :level, updatedDate=:mdate WHERE id = :id";
         $query = $this->db->prepare($sql);
		$query->execute(array(':level' => $level, ':mdate'=>$mdate, ':id'=>$id));
        $count =  $query->rowCount();
	
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = "Test level updated successfully";
            return true;
        } else {
            $_SESSION["feedback_negative"][] = "Test level update failed.";
        }
        // default return
        return false;
    }
    
    /**
     * Deletes a specific group
     * @param int $group_id id of the group
     * @return bool feedback (was the group deleted properly ?)
     */
    public function delete($id)
    {
		$count1=0;
		
		$sql= "select * from set_test where testlevel_id=:testlevel_id";
		$query = $this->db->prepare($sql);
        $query->execute(array(':testlevel_id' => $id));
		$count1 =  $query->rowCount();
		if($count1 ==1)
		{
			$_SESSION["feedback_negative"][] = "Testlevel can’t be deleted. It has been allotted to Set Test.";
			return false;
		}
        $sql = "DELETE FROM test_level WHERE id = :id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id' => $id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = "Test level deleted successfully.";
            return true;
        } else {
            $_SESSION["feedback_negative"][] = "Test level deleted failed.";
        }
        // default return
        return false;
    }
    
    public function changestatus($designation_id, $status)
    {
		$status = ($status==1)?0:1;
        $sql = "update designation_table set status=:sts WHERE designation_id = :designation_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':designation_id' => $designation_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_DESIGNATION_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_DESIGNATION_CHANGE_STATUS_FAILED;
        }
	}
	 public function changests($designation_id, $status)
    {
		$status = ($status==1)?2:1;
        $sql = "update designation_table set sts=:sts WHERE designation_id = :designation_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':designation_id' => $designation_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_DESIGNATION_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_DESIGNATION_CHANGE_STATUS_FAILED;
        }
	}
	///////////Get Selected Candidate feedback table/////////////
	public function getselectcandidate($level,$desig)
    {
		$result=array();
		$org_id=$_SESSION['user_org_id'];
        $sql = "SELECT * FROM feed_back WHERE candidate_id in (select candidate_id from candidate_table where designation_id=$desig and org_id=$org_id) and level =($level-1)  order by overall_rating desc ";
        $query = $this->db->prepare($sql);
        $query->execute();
		$data=array();
		while($row=$query->fetch())
		{
			
			$res['candidate_id']=$row->candidate_id;
			$res['level']=$row->level;
			$res['overall_rating']=$row->overall_rating;
			$res['candidate_fullname']=$this->getName($row->candidate_id,'candidate_table','candidate_fname','candidate_id ');
			$result[]=$res;
		}
		
		
        return $result;
    }
	public function getName($id,$table,$field,$where)
    {
		$name="";
        $sql = "select $field from $table where $where = ?";
        $query = $this->db->prepare($sql);
        $query->execute(array($id));
		while($row=$query->fetch())
		{
			$name=$row->$field;
		}

        return $name;
    }
}

?>