<?php

/**
 * UserModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class TasjobModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function create()
    {
		$count1=0;$count=0;
		$org_id=$_SESSION['user_org_id'];
		$userid=$_SESSION['user_id'];
        // clean the input to prevent for example javascript within the groups.
		$name =$_POST['name'];
		$description =$_POST['description'];
		$date=date('Y-m-d h:i:s a');
		
		$sql1 = "SELECT * FROM TAS_job WHERE tasjob_name=:name and org_id=:org_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array( ':name' =>$name, ':org_id'=>$org_id));

       $count1 =  $query1->rowCount();
		if($count1>=1){
			 $res["status"]=false;		
				$res["errorMsg"]="TAS Job already exists ";
			
		}else
		{
        $sql = "INSERT INTO TAS_job (tasjob_name, Description, created_date, CreatedById, org_id) VALUES (:name, :description, :createddate, :uid,:org_id)";
        $query = $this->db->prepare($sql);
        $query->execute(array( ':name' =>$name, ':description' =>$description, ':createddate' => $date, ':uid'=>$userid,':org_id'=>$org_id));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$res['status']=true;		
				$res['successMsg']="TAS Job created successfully";
			
        } else {
           $res['status']=false;		
				$res['errorMsg']="TAS Job not created ";
        }
		
		}
		
		$data[]=$res;
		//print_r($data);
        // default return
        return $data;
    }
	
	 public function update()
    {
		$count1=0;$count=0;
		$org_id=$_SESSION['user_org_id'];
		$userid=$_SESSION['user_id'];
        // clean the input to prevent for example javascript within the groups.
		$name =$_POST['name'];
		$description =$_POST['description'];
		$tas_id =$_POST['tas_id'];
		$date=date('Y-m-d h:i:s a');
		
		$sql1 = "SELECT * FROM TAS_job WHERE Id!=:tas_id and tasjob_name=:name and org_id=:org_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array(':tas_id' =>$tas_id, ':name' =>$name, ':org_id' =>$org_id));

       $count1 =  $query1->rowCount();
		if($count1>=1){
			 $res["status"]=false;		
				$res["errorMsg"]="TAS Job already exists ";
			
		}else
		{
    $sql = "UPDATE TAS_job SET tasjob_name=:name, Description=:description, modified_date=:modified_date,LastModifiedById=:uid,org_id=:org_id WHERE Id=$tas_id ";
        $query = $this->db->prepare($sql);
        $query->execute(array(':name' =>$name, ':modified_date' => $date, ':description' =>$description, ':uid'=>$userid,':org_id'=>$org_id));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$res['status']=true;		
				$res['successMsg']="TAS Job Updated successfully";
			
        } else {
           $res['status']=false;		
				$res['errorMsg']="TAS Job not updated ";
        }
		
		}
		
		$data[]=$res;
		//print_r($data);
        // default return
        return $data;
    }
	
	 public function delete($tas_id)
    {
		$count1=0;
		$org_id=$_SESSION['user_org_id'];
		
		$sql1 = "SELECT * FROM candidate_table WHERE TAS_job=$tas_id and org_id=$org_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array());

      $count1 =  $query1->rowCount();
		if($count1>=1){
			 $data["status"]=false;		
				$data["errorMsg"]="This TAS Job is used for candidate ";
			
		}
		else
		{
    $sql = "DELETE FROM `TAS_job` WHERE Id=$tas_id and org_id=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute(array());

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$data['status']=true;		
				$data['successMsg']="TAS Job deleted successfully";
			
        } else {
           $data['status']=false;		
				$data['errorMsg']="TAS Job not deleted ";
        } 
		
	}
		
		
        return $data;
    }

public function gettasjob($editper,$deleteper)
    {
		$org_id=$_SESSION['user_org_id'];
		$edit_per=$editper;
		$delete_per=$deleteper;
	$sql = "SELECT * FROM TAS_job WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['name'] = $row->tasjob_name;
		   $res['description'] = $row->Description;
		   $res['tas_id'] = $row->Id;
		   $edit="";$delete="";
		   if($edit_per){
		       $edit="<a rel='tooltip' title='Edit'  onclick='angular.element(this).scope().onfetchdata(".$row->Id.")'  href='#' data-original-title='Edit' class='label bg-green'><i class='fa fa-edit'></i></a>&nbsp;&nbsp;&nbsp;&nbsp;"; }
		   if($delete_per)
		   {
			   $delete="<a rel='tooltip' title='Delete' onclick='angular.element(this).scope().onfetchfordelete(\"".$row->Id."\")' data-toggle='modal' data-target='#confirm' href='#' data-original-title='Delete' class='label bg-red'><i class='fa fa-trash-o'></i></a>";
		   }
		   $res['action']=$edit.$delete;
		   $data[]=$res;
	   }
	   $d['data']=$data;  	
	   //echo json_encode($d); 
	   return $d; 
    }

 public function getalltasjob($id)
    {
		$org_id=$_SESSION['user_org_id'];
	
	$sql = "SELECT * FROM TAS_job WHERE org_id=$org_id and Id='$id'";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['name'] = $row->tasjob_name;
		   $res['description'] = $row->Description;
		   $res['tas_id'] = $row->Id;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
}
