<?php

/**
 * StudentModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class StudentModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    
    public function getAllStudents()
    {
        $sql = "SELECT * FROM student_table";
        $query = $this->db->prepare($sql);
        $query->execute();        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['stud_id'] = $row->stud_id;
			$res['stud_zip'] = $row->stud_zip;
			$res['enroll_no'] = $row->enroll_no;
			$res['stud_fname'] = ucwords(strtolower($row->stud_fname));
			$res['stud_lname'] = ucwords(strtolower($row->stud_lname));
			$res['stud_fullname'] = ucwords(strtolower($row->stud_fname." ".$row->stud_lname));
			
			$res['stud_address'] = $row->stud_address;
			$res['stud_contact'] = $row->stud_contact;
			$res['stud_city'] = $row->stud_city;
			$res['stud_email'] =$row->stud_email;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			$res['stud_status'] = $row->stud_status;
			$res['stud_img'] = $row->stud_img;
			
			
			$sql1 = "SELECT course_id FROM student_course where stud_id =:stud_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('stud_id'=>$row->stud_id));
			$res['courses'] = $query1->rowCount();
			
			$result[] =$res;
		}
      
        return $result;
    }
    
    public function sendmail()
    {
		$to = strip_tags($_POST['email_to']);
		$subject = strip_tags($_POST['email_subject']);
		$msg = $_POST['message'];			
			$uid = md5(uniqid(time()));
				// header
				$headers = "MIME-Version: 1.0" . "\r\n";
				$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";	
				$headers .= "From:SAEI APTITUDE <noreply@ubihrm.com>\r\n";
				$headers .= "Reply-To: ".$to."\r\n";
							
		//$sts=Utils::sendMail($to,"UBIAPTITUDE",$subject,$msg);
		$sts=Utils::sendMailViaSMTP($to,"SAEI ",$to,$subject,$msg);
		//$sts=Utils::Trace($to,"SAEI",$to,$subject,$msg);
		
		
		//$sts = Utils::sendMailViaSMTP($email_id[$i],$comp_name,$email_id[$i],$subject,$msg,$orgid);
		if($sts){
			$_SESSION["feedback_positive"][] = "Mail Sent Successfully";
		}else{
			$_SESSION["feedback_negative"][] = "Sorry, there was an error while sending your mail.";
		}
	/* 	if(mail( $to , $subject, $msg , $headers)){
			$_SESSION["feedback_positive"][] = "Mail Sent Successfully";
		}else{
			$_SESSION["feedback_negative"][] = "Sorry, there was an error while sending your mail.";
		} */
	}
	public function sendmessage()
    {
		$to = strip_tags($_POST['email_to']);
		$cc = strip_tags($_POST['email_cc']);
		$subject = strip_tags($_POST['email_subject']);
		$msg = strip_tags($_POST['message']);
		
		//if(mail($to, $subject, $msg)){
		//	$_SESSION["feedback_positive"][] = "Mail successfully sent";
		//}else{
			$_SESSION["feedback_negative"][] = "Sorry, there was an error sending your message.";
		//}
		
	}
    public function getAllStudentsEmails()
    {
		$courseid = strip_tags($_REQUEST['courseid']);
		$duration =strip_tags($_REQUEST['duration']);
		$cond="";
		$cond1="";
		
		if($duration!=""){
			$datear = explode("-", $duration);
			$cond=" created_date between '".date('Y-m-d',strtotime(date(trim($datear[0]))))."' and '".date('Y-m-d',strtotime(date(trim($datear[1]))))."'";
		}
		if($courseid!="")
		{
			$cond1 =" stud_id in (select stud_id from student_course where course_id in ($courseid))";
		}
		if($cond!=""){
			$cond = " where ".$cond;
			if($cond1!="")
				$cond .= " and ".$cond1;
		}else{
			if($cond1!="")
				$cond = " where ".$cond1;
		}
		
			
        $sql = "SELECT * FROM student_table $cond";
        $query = $this->db->prepare($sql);
        $query->execute();        
        $result ="";
        while($row = $query->fetch())
        {
			$res= array();
			//$res['stud_email'] =$row->stud_email;
			if($result=="")
				$result = $row->stud_email;
			else
				$result .= "; ".$row->stud_email;
			
			
		}
      
        return $result ;
    }
    
    public function getAllStudentsContact()
    {
		$courseid = strip_tags($_REQUEST['courseid']);
		$duration =strip_tags($_REQUEST['duration']);
		$cond="";
		$cond1="";
		
		if($duration!=""){
			$datear = explode("-", $duration);
			$cond=" created_date between '".date('Y-m-d',strtotime(date(trim($datear[0]))))."' and '".date('Y-m-d',strtotime(date(trim($datear[1]))))."'";
		}
		if($courseid!="")
		{
			$cond1 =" stud_id in (select stud_id from student_course where course_id in ($courseid))";
		}
		if($cond!=""){
			$cond = " where ".$cond;
			if($cond1!="")
				$cond .= " and ".$cond1;
		}else{
			if($cond1!="")
				$cond = " where ".$cond1;
		}
		
			
        $sql = "SELECT * FROM student_table $cond";
        $query = $this->db->prepare($sql);
        $query->execute();        
        $result ="";
        while($row = $query->fetch())
        {
			$res= array();
			//$res['stud_contact'] =$row->stud_contact;
			if($result=="")
				$result = $row->stud_contact;
			else
				$result .= "; ".$row->stud_contact;
			
			
		}
      
        return $result ;
    }
    
    public function getStudent($stud_id)
    {
        $sql = "SELECT * FROM student_table where stud_id=:stud_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(":stud_id"=>$stud_id));    
          
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['stud_id'] = $row->stud_id;
			$res['stud_zip'] = $row->stud_zip;
			$res['enroll_no'] = $row->enroll_no;
			$res['stud_fname'] = ucwords(strtolower($row->stud_fname));
			$res['stud_lname'] = ucwords(strtolower($row->stud_lname));
			$res['stud_fullname'] = ucwords(strtolower($row->stud_fname." ".$row->stud_lname));
			
			$res['stud_address'] = $row->stud_address;
			$res['stud_contact'] = $row->stud_contact;
			$res['stud_city'] = $row->stud_city;
			$res['stud_email'] =$row->stud_email;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			$res['stud_status'] = $row->stud_status;
			$res['stud_img'] = $row->stud_img;
						
			$result[] =$res;
		}
      
        return $result;
    }
    
    public function create()
    {
        
            $fname = strip_tags($_POST['fname']);
            $lname = strip_tags($_POST['lname']);
            $user_email = strip_tags($_POST['user_email']);
			$contact = strip_tags($_POST['user_phone']);
            $address = strip_tags($_POST['address']);
			$city = strip_tags($_POST['city']);
			$zipcode = strip_tags($_POST['zipcode']);
			
            $hash_cost_factor = (defined('HASH_COST_FACTOR') ? HASH_COST_FACTOR : null);
            $user_password_hash = password_hash($_POST['pwd'], PASSWORD_DEFAULT, array('cost' => $hash_cost_factor));

           
            // check if email already exists
            $query = $this->db->prepare("SELECT stud_id FROM student_table WHERE stud_email = :email");
            $query->execute(array(':email' => $user_email));
            $count =  $query->rowCount();
            if ($count == 1) {
                $_SESSION["feedback_negative"][] = FEEDBACK_USER_EMAIL_ALREADY_TAKEN;
                return false;
            }
            
            $query = $this->db->prepare("select coalesce(max(stud_id),0) as maxid from student_table");
            $query->execute();
            $maxr= $query->fetch();
            

            
            $enroll = date('Ymd').(($maxr->maxid)+1).dechex( mt_rand( 99999999, 9999999999 ));
            $mdate = date("Y-m-d");
            $enroll = strtoupper($enroll);

            // write new users data into database
            $sql = "INSERT INTO student_table (stud_fname, stud_lname, enroll_no, stud_pass, stud_email, stud_contact, stud_zip, stud_address, stud_city, stud_status, created_date, modified_date)
                    VALUES (:stud_fname, :stud_lname, :enroll, :stud_pass, :stud_email, :stud_contact, :stud_zip, :stud_address, :stud_city, 1, :created_date, :modified_date)";
            $query = $this->db->prepare($sql);
            $query->execute(array(':stud_fname' => $fname,
                                  ':stud_lname' => $lname,
                                  ':enroll' => $enroll,
                                  ':stud_pass' => $user_password_hash,
                                  ':stud_email' => $user_email,
                                  ':stud_contact' => $contact,
                                  ':stud_zip'=>$zipcode,
                                  ':stud_address'=>$address,
                                  ':stud_city'=>$city,
                                  ':created_date' => $mdate,
								  ':modified_date' => $mdate));
            $count =  $query->rowCount();
            if ($count != 1) {
                $_SESSION["feedback_negative"][] = FEEDBACK_ACCOUNT_CREATION_FAILED;
                return false;
            }
			return true;
            
    }
    
    
    public function editSave($stud_id)
    {        
            $fname = strip_tags($_POST['fname']);
            $lname = strip_tags($_POST['lname']);
            $user_email = strip_tags($_POST['user_email']);
			$contact = strip_tags($_POST['user_phone']);
            $address = strip_tags($_POST['address']);
			$city = strip_tags($_POST['city']);
			$zipcode = strip_tags($_POST['zipcode']);
			$mdate = date("Y-m-d");
            
            $sql = "UPDATE student_table SET stud_fname=:stud_fname, stud_lname=:stud_lname, stud_contact=:stud_contact, stud_zip=:stud_zip, stud_address=:stud_address, stud_city=:stud_city, modified_date=:mdate where stud_id=:stud_id";
            
            $query = $this->db->prepare($sql);
            $query->execute(array(':stud_fname' => $fname,
                                  ':stud_lname' => $lname,
                                  ':stud_contact' => $contact,
                                  ':stud_zip'=>$zipcode,
                                  ':stud_address'=>$address,
                                  ':stud_city'=>$city,
            					  ':mdate' => $mdate,
            					  ':stud_id' => $stud_id));
            $count =  $query->rowCount();
            
            if ($count != 1) {
                $_SESSION["feedback_negative"][] = FEEDBACK_ACCOUNT_CREATION_FAILED;
                return false;
            }
			return true;
            
    }
    
    public function delete($stud_id)
    {
        $sql = "DELETE FROM student_table WHERE stud_id = :stud_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':stud_id' => $stud_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_STUDENT_DELETION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_STUDENT_DELETION_FAILED;
        }
        // default return
        return false;
    }
    
    public function changestatus($stud_id, $status)
    {
		$status = ($status==1)?0:1;
        $sql = "update student_table set stud_status=:sts WHERE stud_id = :stud_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':stud_id' => $stud_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_STUDENT_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_STUDENT_CHANGE_STATUS_FAILED;
        }
        // default return
        return false;
    }
   
}
