<?php

/**
 * CourseModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SkillLevelModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getAllSkillLevels()
    {
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
        $sql = "SELECT Id,Name,ParentId,Description,Level_Path FROM  Levels where org_id=? and Delete_Sts!=1";
        $query = $this->db->prepare($sql);
        $query->execute(array($orgid));
		$count =  $query->rowCount();
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['Id'] = $row->Id;
			$res['Name'] = $row->Name;
			$res['ParentId'] = $row->ParentId;
			$res['Description'] = $row->Description;
			$res['level_path'] = $row->Level_Path;
			$res['totalques'] = Utils::getTotalQuesByLevel($res['Id'],$this->db);
			$res['quescount'] = Utils::getTotalQuesAtALevel($res['Id'],$this->db);
			//$res['totalques'] = $row->totalques;
			$data[] =$res;
		} 
		$tree = $this->buildTree($data);
		//print_r($tree);
		if ($count >= 1) {
           $status =true;
		   $successMsg ="Data get successfully";
        } else {
           $status =false;
		   $errorMsg="There are some problem";
        }
		$result["data"] =$tree;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	
	function buildTree(array $elements, $parentId = 0) {
		$branch = array();
		foreach ($elements as $element) {
			if ($element['ParentId'] == $parentId) {
				$children = $this->buildTree($elements, $element['Id']);
				if ($children) {
					$element['children'] = $children;
				}else{
					$element['children'] = array();
				}
				$branch[] = $element;
			}
		}

		return $branch;
	}
	
	public function createSkillLevel()
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
        $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		$name = isset($_POST['name'])?$_POST['name']:'';
		$parentid = isset($_POST['parentid'])?$_POST['parentid']:'0';
		$description= isset($_POST['description'])?$_POST['description']:'';
		
		$level_path= Utils::getQuestionPathById($parentid,$this->db);
		$level_path=$level_path.' > '.$name;
		
		$sql1= "SELECT Name from Levels where org_id=? and Name=? and ParentId=? and Delete_Sts!=1"; 
			$query = $this->db->prepare($sql1);
			$query->execute(array($orgid,$name,$parentid));
			$count1 =  $query->rowCount();
			if($count1>=1)
			{
				$status =false;
			    $errorMsg="Level with same name already exist in the same level";
			}
			else
			{
				$sql = "INSERT INTO Levels (Name, ParentId, Description,Level_Path, org_id, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?,?)";
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($name, $parentid, $description,$level_path,$orgid,$mdate,$mid));
				$count =  $query->rowCount();		
			}
			catch(Exception $e) 
			{
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			}
			
			if ($count == 1) 
			{
			   $status =true;
			   $successMsg = "Questions Structure Level Created Successfully";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while creating Questions Structure level.";
			}
		
		
		$result["data"] =$data;
		//print_r($result["data"] );
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	public function updateSkillLevel()
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
        $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		
		$name = isset($_POST['name'])?$_POST['name']:'';
		$parentid = isset($_POST['parentid'])?$_POST['parentid']:'0';
		$description= isset($_POST['description'])?$_POST['description']:'';
		$skillid= isset($_POST['skillid'])?$_POST['skillid']:'';
			
		$level_path= Utils::getQuestionPathById($skillid,$this->db);
		
		$sql1= "SELECT Name from Levels where org_id=? and Name=? and ParentId=? and Id!=? and Delete_Sts!=1"; 
			$query = $this->db->prepare($sql1);
			$query->execute(array($orgid,$name,$parentid,$skillid));
			$count1 =  $query->rowCount();
			if($count1>=1){
				$status =false;
			    $errorMsg="Level with same name already exist in the same level";
			}else{
				$sql = "Update Levels Set Name=?, Description=?, Level_Path=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($name, $description,$level_path, $mdate, $mid,$skillid));
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Questions Structure Level Updated Successfully";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while updating Questions Structure level.";
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
        // default return
        return $result;
    }

	
	public function deleteSkillLevel()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
        $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		$skillid= isset($_POST['skillid'])?$_POST['skillid']:'';
		
			$sql = "Update Levels Set Delete_Sts=1, LastModifiedDate=?, LastModifiedById=? where Id=?";
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($mdate, $mid,$skillid));
				$count =  $query->rowCount();		
				if($count>=1){
					$sql1 = "Update Levels Set Delete_Sts=1, LastModifiedDate=?, LastModifiedById=? where ParentId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($mdate, $mid,$skillid));
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Questions Structure Level deleted Successfully";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while deleting Questions Structure level.";
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
        // default return
        return $result;
    }

}
      