<?php

/**
 * CourseModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SetTestModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }
	///////////get test according to candidate designation////////
	 public function getAllTests($sts=0)
    {
		$result=array();
		$candidate_id=isset($_REQUEST['candidate_id'])?$_REQUEST['candidate_id']:"";
	
		$desig=$this->getName($candidate_id,'candidate_table','designation_id','candidate_id');
		if($candidate_id==""){
			$desig=isset($_REQUEST['designation_id'])?$_REQUEST['designation_id']:"";
		}
		
		$designame=$this->getName($desig,'designation_table','designation_name','designation_id');
		$sql="";
		if($sts==0){
        $sql = "SELECT * FROM set_test WHERE designation_id = :desig_id";
		}else{
		  $sql = "SELECT * FROM set_test WHERE designation_id = :desig_id and testlevel_id=1";	
		}
        $query = $this->db->prepare($sql);
        $query->execute(array(':desig_id' => $desig));
		$data=array();
		while($row=$query->fetch())
		{
			$test_id = $row->tests_id;
			$test= explode(',', $test_id);
			$res=array();
			$tests="";	
			foreach($test as $value)
			{
				if($tests=="")
					$tests=$this->getName($value,'test_category_child','cat_name','cat_id');
				else
					$tests.=", ".$this->getName($value,'test_category_child','cat_name','cat_id');
			}
			$res['id']=$test_id;
			$res['name']=$tests;
			$data[]=$res;
		}
		$result['data']=$data;
		$result['designame']=$designame;
        return $result;
    }
	
	/* public function getAllTestbyLevel($level,$desig)
    {
		$result=array();		
        $sql = "SELECT * FROM set_test WHERE designation_id = :desig_id and testlevel_id=:level";
        $query = $this->db->prepare($sql);
        $query->execute(array(':desig_id' => $desig,':level' => $level));
		$data=array();
		while($row=$query->fetch())
		{
			$test_id = $row->tests_id;
			$test= explode(',', $test_id);
			$res=array();
			$tests="";	
			foreach($test as $value)
			{
				if($tests=="")
					$tests=$this->getName($value,'test_category_child','cat_name','cat_id');
				else
					$tests.=", ".$this->getName($value,'test_category_child','cat_name','cat_id');
			}
			$res['id']=$test_id;
			$res['name']=$tests;
			$data[]=$res;
		}
		$result['data']=$data;
		
        return $result;
    } */
	
	public function getAllTestbyLevel($level,$desig)
    {
		$result=array();		
        $sql = "SELECT * FROM set_test WHERE designation_id = :desig_id and testlevel_id=:level";
        $query = $this->db->prepare($sql);
        $query->execute(array(':desig_id' => $desig,':level' => $level));
		$data=array();
		while($row=$query->fetch())
		{
			$test_id_array = $row->tests_id;
			$test= explode(',', $test_id_array);
			$res=array();
			$tests="";	
			foreach($test as $value)
			{
				$test_name=$this->getName($value,'test_category_child','cat_name','cat_id');
				$test_id=$value;
				$res['id']=$test_id;
				$res['name']=$test_name;
				$data[]=$res;
			}
		}
		$result['data']=$data;
		
        return $result;
    }
	
	public function fetchAllTestPaper()
	{
		$result=array();		
		$org_id=$_SESSION['user_org_id'];
		$sql = "SELECT * FROM test_category WHERE org_id=:org_id ";
		$query = $this->db->prepare($sql);
		$query->execute(array(':org_id' => $org_id));
		$testarr=array();		
		while($row=$query->fetch())
		{
			$data=array();
			$data['cat_id']=$cat_id=$row->test_id;
			$data['cat_name']=$row->test_name;
			$sql1 = "SELECT * FROM test_category_child WHERE test_id=:cat_id ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':cat_id'=> $cat_id));
			$testpaperarr=array();
			while($row1=$query1->fetch())
			{		
					$res=array();			
					$res['id']=$row1->cat_id;
					$res['name']=$row1->cat_name;
					$testpaperarr[]=$res;
			}
			$data['testpaper']=$testpaperarr;
			$testarr[]=$data;
		}
			$result['data']=$testarr;
		return $result;
	}
	
		public function fetchDefaultTestPaper($positionid)
	{
		$result="";		
		$org_id=$_SESSION['user_org_id'];
		$sql = "SELECT TestPaper FROM DefaultPosition WHERE Id=(select DefaultPositionId from designation_table where designation_id=$positionid)";
		$query = $this->db->prepare($sql);
		$query->execute(array(':org_id' => $org_id));
		$testarr=array();
		
		if($row=$query->fetch())
		{
			$result=$row->TestPaper;
		}
			
		return $result;
	}
	
    public function getAllSetTest($sts)
    {
		$org_id=$_SESSION['user_org_id'];
		$sts1="";
		if($sts==0){
			$sts1="where sts=2";
		}elseif($sts==1){
			$sts1="where sts=1";
		}else{
			$sts1="where 1=1";
		}
        $sql="SELECT settest_id, designation_id,category_id, tests_id, testlevel_id,create_date, modified_date FROM set_test where designation_id in(select designation_id from designation_table $sts1) and org_id=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['settest_id'] = $row->settest_id;
			$res['designation_id'] = $row->designation_id;
			$res['level'] = $this->getName($row->testlevel_id,'test_level','level','id');
			$res['category_id'] = $row->category_id;
			$res['tests_id'] = "";//$row->tests_id;
			$per=$row->tests_id;
			$res['create_date'] = $row->create_date;
			$res['modified_date'] = $row->modified_date;
			$res['designation_name']="";
			$res['category_name']="";
			$sql1="SELECT designation_name,sts FROM designation_table WHERE designation_id=:designationid";
			$query1= $this->db->prepare($sql1);
			$query1->execute(array(':designationid'=>$row->designation_id));
			while($row1=$query1->fetch())
			{
				$res['designation_name'] = $row1->designation_name;
				$res['designation_status'] = $row1->sts;
			}
			if($per != "")
			{
				$sql2="SELECT cat_name FROM test_category_child where cat_id in($per)";
				$query2= $this->db->prepare($sql2);
				$query2->execute();
				while($row2=$query2->fetch())
				{
					 $res['category_name'] .= $row2->cat_name.", ";
				}
				$res['category_name']=($res['category_name']!="")?substr($res['category_name'],0 ,-2):""; // To remove last comma with space (2 characters from last string)
			}	
			
				
			$result[] =$res;
		}
      
        return $result;
    }
	
	
	 public function getAllTestName($edit_per,$delete_per)
		{
		$org_id=$_SESSION['user_org_id'];
		$sql ="SELECT `Id`, `Name`, `Duration`, `Total_ques`, `Passing_marks`, `Description`, `org_id` FROM `Test_paper` WHERE `org_id`=? and testpaper_sts=1";
		
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
        $result =array();
			$d= array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['id'] = $row->Id;
			$res['name'] = $row->Name;
			$res['duration'] = $row->Duration;
		//	$res['totalques'] = $row->Total_ques." / ".$row->Total_ques;
			$res['totalques'] = $row->Total_ques;
			$res['passmarks'] = $row->Passing_marks;
			 $edit="";
		   $delete="";
		   if($edit_per){
		   $edit='<a href="'. URL . 'settest/edittestpaper/' . $row->Id.'" data-toggle="tooltip" title="Edit Test" class="label bg-orange"><i class="fa fa-edit"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;';
			}
		
		   if($delete_per)
{
		   $delete="<a rel='tooltip' title='Delete' onclick='angular.element(this).scope().ondelete(\"".$row->Id."\")'  data-toggle='modal'  href='#' data-original-title='Delete' class='label bg-red'><i class='fa fa-trash-o'></i></a>";
			}
		   $res['action']=$edit.$delete;
		   
			$result[] =$res;
		}
       $d['data']=$result;  	
		//echo json_encode($d); 
		return $d; 
    }
	
	
	
	public function deletetestpaper()
    {
			$org_id=$_SESSION['user_org_id'];
			$mid=$_SESSION['user_id'];
		$mdate= date('Y-m-d h:i:s');
		$id = isset($_POST['id'])?$_POST['id']:0;
		
		
			$sql1 = "SELECT * FROM schedule_candidate WHERE  tests=$id and org_id=$org_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array());

      $count1 =  $query1->rowCount();
		if($count1>=1)
		{
			   $status =false;
			   $errorMsg="This Test Paper is already scheduled";
			    $result['errorMsg']=$errorMsg;
				return $result;
		}
		
		
		
		$sql = "Update Test_paper Set testpaper_sts=0, modified_date=? where Id = ?";
		$query = $this->db->prepare($sql);
		$query->execute(array($mdate,$id));
		$count =  $query->rowCount();	
		//////////////////// ACTIVITY LOG///////////////////////////////
				/* $test = $this->getName($id,'Test_paper','Name','Id');
				$msg="<b>$test</b> test paper has been deleted";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Test Paper", $msg, $org_id));  */

		
			if ($count >= 1) {
			   $status =true;
			   $successMsg = "Test Paper Deleted Successfully";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while deleting testpaper.";
			     $result['errorMsg']=$errorMsg;
			}
			
		$result["data"] =$id;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
        return $result;
			
    
	}
	
	
	
	
	
	
	
	public function getSetTestEdit()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
		$testid = isset($_POST['testid'])?$_POST['testid']:'0';
        $sql = "SELECT * FROM `Test_paper` WHERE Id = ? and 	org_id=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($testid,$orgid));
			$count =  $query->rowCount();
			}
			catch(Exception $e) 
			{
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['duration'] = $row->Duration;
				$res['totalques'] = $row->Total_ques;
				$res['passmarks'] = $row->Passing_marks;
				$res['desc'] = $row->Description;
				
				$sqlans = "SELECT * FROM `Test_paper_child` WHERE Testpaper_id=?";
				$queryans = $this->db->prepare($sqlans);
				$queryans->execute(array($testid));
				$countans =  $queryans->rowCount();
				while($rowans = $queryans->fetch())
				{
					$res1 = array();
					$res1['test_id'] =$rowans->Id;
					$res1['Testpaper_id'] =$rowans->Testpaper_id;
					$res1['lvlid'] =$rowans->Level_id;
					$res1['Name'] =Utils::getName($rowans->Level_id,'Levels','Name',$this->db);
					$res1['percent'] =$rowans->Question_per;
					$res1['lvl_path'] =Utils::getName($rowans->Level_id,'Levels','Level_Path',$this->db);
				//	$res1['totalques'] =Utils::getName($rowans->Level_id,'Levels','TotalQues',$this->db);
					$res1['totalques'] =Utils::getTotalQuesByLevel($rowans->Level_id,$this->db);
					$res1['noofquestion'] =$rowans->Total_Ques;
					$res['levels'][]=$res1;
				}
				$data[] = $res;
			}
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	
	// public function getSetTestEdit($id)
    // {
        // $sql = "SELECT * FROM `Test_paper` WHERE Id = :id";
        // $query = $this->db->prepare($sql);
        // $query->execute(array(':id' => $id));
		// $result =array();
        // while($row = $query->fetch())
        // {
			// $res= array();
			// $res['id'] = $row->Id;
			// $res['name'] = $row->Name;
			// $res['duration'] = $row->Duration;
			// $res['totalques'] = $row->Total_ques;
			// $res['passmarks'] = $row->Passing_marks;
			// $res['desc'] = $row->Description;
			// // $sql1 = "SELECT * FROM criteria_table where test_id =:quiz_id";
			// // $query1 = $this->db->prepare($sql1);
			// // $query1->execute(array('quiz_id'=>$quiz_id));
			// // $crite=array();
			// // while($row1 =  $query1->fetch()){
				// // $res1=array();
				// // $res1['id'] = $row1->id;
				// // $res1['test_id'] = $row1->test_id;
				// // $res1['criteria_from'] = $row1->criteria_from;
				// // $res1['criteria_to'] = $row1->criteria_to;
				// // $res1['criteria_rating'] = $row1->rating;
				// // $res1['desc1'] = $row1->Interpretation;
				// // $crite[]=$res1;
			// // }
			// // $res['criteriaupdate']=$crite;
			 // $result[] =$res;
		// }	
        // // fetch() is the PDO method that gets a single result
        // return $result;
		
    // }
    
	
	
	
	
	
	
	
	
	
	
	
	
	public function getAllTestPaper($val="")
    {
		
		$org_id=$_SESSION['user_org_id'];
		$positionSts = isset($_POST["positionSts"])?$_POST["positionSts"]:1;
		$position = isset($_POST["position"])?$_POST["position"]:0;
		$sort = isset($_POST["sort"])?$_POST["sort"]:2;
		
		$whr="";
			$whr1="";
			$whr2="";
			$whr3="";
			$ordrby="";
			if($sort!=0){
				if($sort==1)
				{
					$ordrby=" order by created_date";
				}
				else
				{
					$ordrby=" order by cat_name";
				}
				
			}
			if($val!=""){
				$whr3=" and cat_name like '$val%'";
			}
		if($positionSts!=0){
			if($positionSts==1){
				
				if($position!=0)
				{
					$whr=" and designation_id=$position";
				}
				
			}
			if($positionSts==2)
			{
				if($position!=0){
					$whr1=" and test_id=$position";
				}
				
			}
			
			if($positionSts==3){
				
				if($position!=0){
					
					$whr2=" and testlevel_id=$position";
					
				}
				
			}
			
		}
		
       $sql = "SELECT settest_id, designation_id,category_id, tests_id, testlevel_id,create_date, modified_date FROM set_test where org_id=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
		$testpapers="";
        while($row = $query->fetch())
        {
			
			
		
		
			if($testpapers==""){
				$testpapers=$row->tests_id;
			}else{
				$testpapers=$testpapers.",".$row->tests_id;
			}
			
			
		}
			if($testpapers != ""){
				$sql2="SELECT * FROM test_category_child where cat_id in($testpapers) $whr1 $whr3 $ordrby";
				$query2= $this->db->prepare($sql2);
				$query2->execute();
				while($row2=$query2->fetch())
				{
					$res= array();
					 $res['testPaperName'] = $row2->cat_name;
					 $cat_id=$row2->cat_id;
					  $sql = "SELECT quiz_id, test_id,  cat_id,quiz_status, quiz_ques, total_ques, total_time, total_marks, passing_score, negative_marking, negative_markingscore, created_date, modified_date FROM quiz_table where org_id=? and cat_id=$cat_id";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));

       
        if($row = $query->fetch())
        {
			$res['quiz_id'] = $row->quiz_id;
			$res['test_id'] = $row->test_id;
			$res['cat_id'] = $row->cat_id;
			$res['quiz_status'] = $row->quiz_status;
			$res['quiz_ques'] = $row->quiz_ques;
			$res['total_ques'] = $row->total_ques;
			$res['total_time'] = $row->total_time;
			$res['total_marks'] = $row->total_marks;
			$res['passing_score'] = $row->passing_score;
			$res['negative_marking'] = $row->negative_marking;
			$res['negative_markingscore'] = $row->negative_markingscore;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			
			$res['totalques'] =0;
			$sql1 = "SELECT count(ques_id) as totalques,sum(marks) as totalmarks FROM question_table where cat_id =$cat_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array());
			while($row1 = $query1->fetch()){
				$res['totalques'] = $row1->totalques;
				$res['totalmarks'] = $row1->totalmarks;
			}

			
		}
					 
					 $result[] =$res;
				}
				
			}
		
        return $result;
    }
	
    /**
     * Getter for a single group
     * @param int $group_id id of the specific group
     * @return object a single object (the result)
     */
	 ////////// for edit date///////////
    public function getSetTest($settest_id)
    {
        $sql = "SELECT * FROM set_test WHERE settest_id = :settest_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':settest_id' => $settest_id));		
        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }
	
	public function getTestPaperByFilter()
    {
       $positionSts = isset($_POST["positionSts"])?$_POST["positionSts"]:0;	   
	   $org_id=$_SESSION['user_org_id'];
	   $sql="";
	   if($positionSts==1)
	   {
		   $sql="select * from designation_table where sts=1";
	   }elseif($positionSts==2){
		    $sql="select * from test_category";		   
	   }else{
		   $sql="select * from test_level";
	   }
	   
	   $result=array();
	   $data=array();
	   if($sql!=""){
			$query1 = $this->db->prepare($sql);
			$query1->execute(array());
			while($row1 = $query1->fetch()){
				$res=array();
				if($positionSts==1)
				{
					$res['id'] = $row1->designation_id;
					$res['name'] = $row1->designation_name;
				}
				if($positionSts==2)
				{
					$res['id'] = $row1->test_id;
					$res['name'] = $row1->test_name;
				}
				if($positionSts==3)
				{
					$res['id'] = $row1->id;
					$res['name'] = $row1->level;
				}
				$data[]=$res;
			}
	   }
	   $result['data']=$data;
	   return $result;
    }
	 ////////// for edit date///////////
	/*  public function getDesignationSetTest($designation_id)
    {
		$result =array();
		$sql = "SELECT * FROM set_test WHERE designation_id = :designation_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':designation_id' => $designation_id));
       
        return $query->fetchAll();
    } */
    /**
     * Setter for a group (create)
     * @param string $group_text group text that will be created
     * @return bool feedback (was the group created properly ?)
     */
	 
	 	 ///////////////////////////////////////////////////////        VANSHIKA THAKRAL  /////////////////////////////////////////////////
	 
	   public function createTest()
    {
	
	$result=array();$count1=0; $count=0; $errorMsg=""; $successMsg=""; $per=0;$status=false;
	$test = isset($_POST['test']) ? $_POST['test'] : "";
	$data=array();
	$question = isset($_POST['question']) ? $_POST['question'] : "";
	$time = isset($_POST['time']) ? $_POST['time'] : "";
	$passingmarks = isset($_POST['passingmarks']) ? $_POST['passingmarks'] : "";
	$editor1 = isset($_POST['editor1']) ? $_POST['editor1'] : ""; 
	
	$org_id=$_SESSION['user_org_id'];
	$mid=$_SESSION['user_id'];
	$mdate = date("Y-m-d H:i:s");   
	$skilllevelarray= isset($_POST['jsonData'])?json_decode($_POST['jsonData'], true):'';
//	print_r($skilllevelarray[0]['Name']);
	$userid=$_SESSION['user_id'];
	

	/////////////Check Categroy already exit ////////
	$query = $this->db->prepare("SELECT * FROM Test_paper WHERE 	Name=? AND testpaper_sts=1");
	$query->execute(array($test));
	$count =  $query->rowCount();
	if ($count == 1) {
		$res=array();
		$status=false;
		$errorMsg="This Test Paper already exists";
		$result[]=$res;
		$result['status']=$status;
		$result['errorMsg']=$errorMsg;
		return $result;
	}
	
	
	if($question<$passingmarks)
					{
						$res=array();
						$status=false;
						$errorMsg="Passing Marks should be less than the no. of questions";
						$result[]=$res;
						$result['status']=$status;
						$result['errorMsg']=$errorMsg;
						return $result;
					}
	
	
	
		
	
	for($i=0; $i<count($skilllevelarray); $i++)
				{
					if($skilllevelarray[$i]['totalques']<$skilllevelarray[$i]['noofquestion'])
					{
						$res=array();
						$status=false;
						$errorMsg= $skilllevelarray[$i]['Name']." level have only " .$skilllevelarray[$i]['totalques']. ' questions';
						$result[]=$res;
						$result['status']=$status;
						$result['errorMsg']=$errorMsg;
						return $result;
					}
				}
	
		for($i=0; $i<count($skilllevelarray); $i++)
				{
					if($skilllevelarray[$i]['noofquestion']=="" || $skilllevelarray[$i]['noofquestion']==0)
					{
			$res=array();
			$status=false;
			$errorMsg="No. of Question should  not  be zero and blank";
			$result[]=$res;
			$result['status']=$status;
			$result['errorMsg']=$errorMsg;
			return $result;
					}
				}
		
		
	
	for($i=0; $i<count($skilllevelarray); $i++)
				{
				$per=$per+$skilllevelarray[$i]['noofquestion'];
				}
				
		if($per!=$question)
		{
		$res=array();
		$status=false;
		$errorMsg="No. of Question should be equal to Total Question";
		$result[]=$res;
		$result['status']=$status;
		$result['errorMsg']=$errorMsg;
		return $result;
		}
		
	$sql1 = "INSERT INTO `Test_paper`(`Name`, `Duration`, `Total_ques`, `Passing_marks`, `Description`,`org_id`,created_date,modified_date,CreatedById,LastModifiedById) VALUES (:name,:duration,:totalques,:passmarks,:desc,:org_id,:created_date, :modified_date,:CreatedById,:LastModifiedById)";
	try
	{
		//echo 'ok'.'<br/>';
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array(':name'=>$test ,':duration'=>$time ,':totalques'=>$question,':passmarks'=>$passingmarks,':desc'=>$editor1,':org_id'=>$org_id,':created_date'=>$mdate,':modified_date'=>$mdate,':CreatedById'=>$userid,':LastModifiedById'=>$userid));
		$count1 =  $query1->rowCount();
		$testpaperid=$this->db->lastinsertid();
			if ($count1 >= 1)
			{
				//echo $count1.'<br/>';
				for($i=0; $i<count($skilllevelarray); $i++)
				{
				//	$no_of_question=($skilllevelarray[$i]['percent']/100)*$question;
						$sql = "INSERT INTO `Test_paper_child`(`Testpaper_id`, `Level_id`,Total_Ques) VALUES (:testpaperid,:levelid,:Total_Ques)";
						$query = $this->db->prepare($sql);
						$query->execute(array( ':testpaperid'=>$testpaperid, ':levelid'=>$skilllevelarray[$i]['lvlid'], ':Total_Ques'=>$skilllevelarray[$i]['noofquestion']));	
							
				}
			}
	}
	catch(Exception $e)
			{
				$errorMsg = 'Message: ' .$e->getMessage();
			}
   
			
			//////////////////// ACTIVITY LOG///////////////////////////////
				
				/* $msg="<b>$test</b> test paper has been added";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Test Paper", $msg, $org_id));  */
			
			if ($count1 >= 1) 
			{
				//echo 'kk'.'<br/>';
			   $status =true;
			   $successMsg = "Test paper added Successfully";
			} else {
			   $status =false;
			   $errorMsg="Test Addition Failed";
			}
		
		$result['data'] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		//print_r($result);
		//print_r($result['successMsg']);
        return $result;
		 }

	 /////////////////////////////////////////////////////// VANSHIKA THAKRAL  /////////////////////////////////////////////////
	 
	
	
	public function editTestPaperSave($id)
    {
	$result=array();$count1=0; $count=0; $errorMsg=""; $successMsg=""; $status=false;$per=0;
	$test = isset($_POST['test']) ? $_POST['test'] : "";
	$question = isset($_POST['question']) ? $_POST['question'] : "";
	$time = isset($_POST['time']) ? $_POST['time'] : "";
	
	$passingmarks = isset($_POST['passingmarks']) ? $_POST['passingmarks'] : "";
	$editor1 = isset($_POST['editor1']) ? $_POST['editor1'] : ""; 
	$org_id=$_SESSION['user_org_id'];
	$mid=$_SESSION['user_id'];
	$mdate = date("Y-m-d H:i:s");   
	$skilllevelarray= isset($_POST['jsonData'])?json_decode($_POST['jsonData'], true):'';	
	$userid=$_SESSION['user_id'];


				if($question<$passingmarks)
					{
						$res=array();
						$status=false;
						$errorMsg="Passing Marks should be less than the no. of questions";
						$result[]=$res;
						$result['status']=$status;
						$result['errorMsg']=$errorMsg;
						return $result;
					}
	



for($i=0; $i<count($skilllevelarray); $i++)
				{
				
					if($skilllevelarray[$i]['totalques']<$skilllevelarray[$i]['noofquestion'])
					{
						
						$res=array();
						$status=false;
						//$errorMsg="Don't have much more question in " .$skilllevelarray[$i]['Name']. ' level';
						$errorMsg= $skilllevelarray[$i]['Name']." level have only " .$skilllevelarray[$i]['totalques']. ' questions';
						$result[]=$res;
						$result['status']=$status;
						$result['errorMsg']=$errorMsg;
						return $result;
					}
				}
	
		for($i=0; $i<count($skilllevelarray); $i++)
				{
					if($skilllevelarray[$i]['noofquestion']=="")
					{
					$res=array();
		$status=false;
		$errorMsg="No. of Question should  not  be zero";
		$result[]=$res;
		$result['status']=$status;
		$result['errorMsg']=$errorMsg;
		return $result;
					}
				}
		
		
	
	for($i=0; $i<count($skilllevelarray); $i++)
				{
				$per=$per+$skilllevelarray[$i]['noofquestion'];
				}
				
		if($per!=$question)
		{
		$res=array();
		$status=false;
		$errorMsg="No. of Question should be equal to Total Question";
		$result[]=$res;
		$result['status']=$status;
		$result['errorMsg']=$errorMsg;
		return $result;
		}
			
	
	
	$sql = "UPDATE `Test_paper` SET `Name`=:name,`Duration`=:time,`Total_ques`=:totalques,`Passing_marks`=:passmarks,`Description`=:desc,created_date=:created_date,modified_date=:modified_date,CreatedById=:CreatedById,LastModifiedById=:LastModifiedById  WHERE Id=:id";
	try
	{
    $query = $this->db->prepare($sql);
    $query->execute(array( ':name'=>$test, ':time'=>$time, ':totalques'=>$question, ':passmarks'=>$passingmarks, ':desc'=>$editor1,':created_date'=>$mdate, ':modified_date'=>$mdate,  ':CreatedById'=>$userid, ':LastModifiedById'=>$userid,':id'=>$id));
    $count =  $query->rowCount();
	
	
			if($count>=1)
			{
					if(isset($skilllevelarray))
					{
						$sql1 = "DELETE FROM Test_paper_child WHERE Testpaper_id = ?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($id));
						for($i=0; $i<count($skilllevelarray); $i++)
						  {	
					  		$no_of_question=($skilllevelarray[$i]['percent']/100)*$question;
							$sql = "INSERT INTO `Test_paper_child`(`Testpaper_id`, `Level_id`,Total_Ques) VALUES (:testpaperid,:levelid,:Total_Ques)";
							$query = $this->db->prepare($sql);
							$query->execute(array( ':testpaperid'=>$id, ':levelid'=>$skilllevelarray[$i]['lvlid'],':Total_Ques'=>$skilllevelarray[$i]['noofquestion']));	
						  }
					}
				}
	
		}
		catch(Exception $e) 
		{$errorMsg = 'Message: ' .$e->getMessage();}
		
				//////////////////// ACTIVITY LOG///////////////////////////////
				
				/* $msg="<b>$test</b> test paper has been updated";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Test Paper", $msg, $org_id));  */
		
		if ($count >= 1) 
			{
			   $status =true;
			   $successMsg = "Test paper updated Successfully";
			} 
			else 
			{
			   $status =false;
			   $errorMsg="Test updation Failed";
			}
		
			$result['id']=$id;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        return $result;
		
}
////////////////////////////////////////////      vanshika thakral      //////////////////////////////////////////////////////////////////////////// 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
    public function create()
    {
		$data=array();
		$org_id=$_SESSION['user_org_id'];
        // clean the input to prevent for example javascript within the groups.
		$designation_id = isset($_POST['designation']) ? $_POST['designation'] : "";
		$level = isset($_POST['level']) ? $_POST['level'] : "";
		//$category_id = isset($_POST['category']) ?implode(',',$_POST['category']) : "";
		$test_id = isset($_POST['alltestpaper']) ?implode(',',$_POST['alltestpaper']) : "";
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		$sql1 = "select * from set_test where designation_id = ? and testlevel_id = ? and org_id=?";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array($designation_id,$level,$org_id));
		if(($query1->rowCount())>=1)
		{
			$data["status"]=false;
			$data["errorMsg"]=	$_SESSION["feedback_negative"][] = "Test for this test level of this position is already exist.";
		
		}else{
			$sql = "INSERT INTO set_test (designation_id, tests_id, testlevel_id, create_date, modified_date, org_id) VALUES (:designation_id, :test_id,:level, :cdate, :mdate ,$org_id)";
			$query = $this->db->prepare($sql);
			$query->execute(array(':designation_id' => $designation_id, ':test_id' => $test_id,':level' => $level,':cdate'=>$mdate, ':mdate'=>$mdate));
			$count =  $query->rowCount();
			if ($count == 1) {
				$data["status"]=true;
				$data["successMsg"]=$_SESSION["feedback_positive"][] = FEEDBACK_SETTEST_ADDITION_SUCCESSFUL;            
			} else {
				$data["status"]=false;
				$data["errorMsg"]=$_SESSION["feedback_negative"][] = FEEDBACK_SETTEST_ADDITION_FAILED;
			}
		}
        // default return
        return $data;
    }

    /**
     * Setter for a group (update)
     * @param int $group_id id of the specific group
     * @param string $group_text new text of the specific group
     * @return bool feedback (was the update successful ?)
     */
    public function editSave($settest_id)
    {
		$data=array();
        // clean the input to prevent for example javascript within the groups.
		$org_id=$_SESSION['user_org_id'];
	/* 	$designation_id = isset($_POST['designation']) ? $_POST['designation'] : "";
		$level = isset($_POST['level']) ? $_POST['level'] : "";
		$category_id = isset($_POST['category']) ?implode(',',$_POST['category']) : ""; */
		$test_id = isset($_POST['alltestpaper']) ?implode(',',$_POST['alltestpaper']) : "";

		$mdate = date("Y-m-d H:i:s");
		$count=0;
		
        $sql = "UPDATE set_test SET tests_id = :test_id, modified_date=:mdate, org_id=$org_id WHERE settest_id = :settest_id";
        $query = $this->db->prepare($sql);
        $query->execute(array( ':test_id' => $test_id, ':mdate'=>$mdate, ':settest_id' => $settest_id ));
        $count =  $query->rowCount();
	
        if ($count == 1) {
			$data["status"]=true;
			$data["successMsg"]=$_SESSION["feedback_positive"][] = FEEDBACK_SETTEST_EDITING_SUCCESSFUL;
            
        } else {
            $data["status"]=false;
			$data["errorMsg"]=$_SESSION["feedback_negative"][] = FEEDBACK_SETTEST_EDITING_FAILED;
        }
        // default return
        return $data;
    }
    
    public function getName($id,$table,$field,$where)
    {
		$name="";
        $sql = "select $field from $table where $where = ?";
        $query = $this->db->prepare($sql);
        $query->execute(array($id));
		while($row=$query->fetch())
		{
			$name=$row->$field;
		}

        return $name;
    }
	
    /**
     * Deletes a specific group
     * @param int $group_id id of the group
     * @return bool feedback (was the group deleted properly ?)
     */
    public function delete($settest_id)
    {
        $sql = "DELETE FROM set_test WHERE settest_id = :settest_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':settest_id' => $settest_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = "Test for this position deleted successfully";
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_SETTEST_DELETION_FAILED;
        }
        // default return
        return false;
    }
    
   
}
