<?php

/**
 * UserModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ScheduleModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    
    public function getAllUsers()
    {
        $sql = "SELECT * FROM users";
        $query = $this->db->prepare($sql);
        $query->execute();
        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['user_id'] = $row->user_id;
			$res['user_active'] = $row->user_active;
			$res['user_name'] = $row->user_name;
			$res['user_email'] = $row->user_email;
			$res['user_password'] = Self::decrypt($row->user_password_hash);
			$res['user_fullname'] = ucwords(strtolower($row->user_fullname));
			$res['user_group_id'] = $row->user_group_id;
			$res['user_group_name'] = "";
			$sql1 = "SELECT group_name FROM user_group where user_group_id =:groupid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('groupid'=>$row->user_group_id));
			while($row1= $query1->fetch())
			{
				$res['user_group_name'] = ucwords(strtolower($row1->group_name));
			}
			$result[] =$res;
		}
      
        return $result;
    }


public function gettestpaper()
    {
		$org_id=$_SESSION["user_org_id"];
        $sql = "SELECT * FROM Test_paper WHERE org_id=$org_id and testpaper_sts=1";
        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['papername'] = $row->Name;
			$res['paper_id'] = $row->Id;
			$result[] =$res;
		}
        return $result;
	}
	
	
	public function getassesors()
    {
		$org_id=$_SESSION["user_org_id"];
        $sql = "SELECT * FROM users WHERE org_id=$org_id and user_profile= (Select Id from userprofiles where user_profile_type='2')";
        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
		$res['username'] = $row->user_name;
			$res['id'] = $row->user_id;
			$result[] =$res;
		}
        return $result;
	}
	
	public function gettestprofile()
    {
		$org_id=$_SESSION["user_org_id"];
        $sql = "SELECT * FROM DefaultPosition WHERE OrganizationId=$org_id ";
        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['name'] = $row->PositionName;
			$res['id'] = $row->Id;
			$result[] =$res;
		}
        return $result;
	}
	public function getAllCandidatesgivingtest()
    {
		//echo $sts;
		$org_id=$_SESSION['user_org_id'];
		$sql="";
	    $designation_id =isset($_POST['position'])?($_POST['position']):0;
		//echo $designation_id ;
		$tlevel =isset($_POST['level'])?($_POST['level']):"0";
		$candidate_id =isset($_POST['candidate_id'])?($_POST['candidate_id']):0;
		$testpaper =isset($_POST['tests'])?($_POST['tests']):0;
		$positionSts =isset($_POST['positionSts'])?($_POST['positionSts']):0;
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		$sortby = isset($_POST["sortby"])?$_POST["sortby"]:"0";
		$datecondn="";
		$paper='';
		if($startdate!="" && $enddate!=""){
					//$datecondn="and date(s.schedule_date) between '$startdate' and '$enddate'";
					$datecondn="and date(c.created_date) between '$startdate' and '$enddate'";
		}
		if($testpaper !=0)
		{
			 $paper=" and test_id = $testpaper";
			// $paper="and candidate_id in(select candidate_id from schedule_candidate where tests= $testpaper)";
		}
		
		
		$showdate="";
		if($startdate!="" && $enddate!="")
		{
		$showdate= "and  created_date between '$startdate' and  '$enddate' ";
		}


		$des="";
		   if($designation_id!=0)
		 {
		 $des=" and candidate_id in (select candidate_id from candidate_table where designation_id=$designation_id)";
		  }
		
		if($candidate_id!=0)// this line is executed for filtering individual candidates added on 17/7/2017 by abhinav
		{
		$des=$des." and candidate_id = $candidate_id";
		}
	
		
		
	
	$sql2 = "SELECT candidate_id,schedule_id,test_id from test_attempt where test_sts='START' and DATE(teststart_date) = CURDATE() and now() < (teststart_date + INTERVAL  2  HOUR) and org_id=? $paper ";
	
	$query2 = $this->db->prepare($sql2);
	$query2->execute(array($org_id));
	$count= $query2->rowCount();
	$result =array();
	while($row2 = $query2->fetch())
	{
	
    
	//$sql = "SELECT * FROM candidate_table where candidate_id in (select candidate_id from test_attempt where test_sts='START' and DATE(teststart_date) = CURDATE()) and org_id=?";
	$sql = "SELECT * FROM candidate_table where candidate_id =? and org_id=$org_id $des  ";
	
        $query = $this->db->prepare($sql);
        $query->execute(array($row2->candidate_id));        
       // $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['candidate_id'] = $row->candidate_id;
			//$res['schedule_id'] = $row->schedule_id;
			//$sql = "SELECT * FROM candidate_table where candidate_id =? ";
			$res['designation_id'] =$row->designation_id;
			$res['candidate_zip'] = $row->candidate_zip;
			$res['enroll_no'] = $row->enroll_no;
			$res['candidate_fname'] = ucwords(strtolower($row->candidate_fname));
			$res['candidate_lname'] = ucwords(strtolower($row->candidate_lname));
			$res['candidate_fullname'] = ucwords(strtolower($row->candidate_fname." ".$row->candidate_lname));
			$res['candidate_address'] = $row->candidate_address;
			$res['candidate_contact'] = $row->candidate_contact;
			$res['candidate_city'] = $row->candidate_city;
			$res['candidate_email'] =$row->candidate_email;
			$res['candidate_pass'] =$row->candidate_pass;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			$res['candidate_status'] = $row->candidate_status;
			$res['location'] ='Any Location';
			
			$assesorid='';
			// $testlocation= "";
			// $testlocation= $row->Location;
			 $sql9="SELECT location, schedule_date , assessorid  FROM schedule_candidate WHERE id=:schedule_id";
			 $query9 = $this->db->prepare($sql9);
			 $query9->execute(array(':schedule_id'=>$row2->schedule_id));
			 $row9=$query9->fetch();
			 if($row9->location)
			 {
				$res['location'] = $row9->location;
			
				
			 }
			 $assesorid = $row9->assessorid;
			$res['schedule_date'] = date("d M Y h:i A",strtotime($row9->schedule_date));
			$res['assessorname'] = $this->getName($assesorid,'users','user_name','	user_id');
			$sql8="SELECT test_id FROM test_attempt WHERE schedule_id= :schedule_id and test_sts='START'";
			$query8 = $this->db->prepare($sql8);
			$query8->execute(array(':schedule_id'=>$row2->schedule_id));
			$row8=$query8->fetch();
			$tests= $row8->test_id;
			
			
			
			$res['testname']=$this->getName($tests,'Test_paper','Name','Id');
			$res['PRN'] =$row->candidate_id;
			$res['image'] = $row->image;
			$res['resume'] = $row->resume;
			//$res['desig'] = $designation_id;
			$res['designation_name']="";
			$sql1="SELECT PositionName FROM DefaultPosition WHERE Id=:designationid";
			$query1= $this->db->prepare($sql1);
			$query1->execute(array(':designationid'=>$res['designation_id']));
			while($row1=$query1->fetch())
			{
				$res['designation_name'] = $row1->PositionName;
				//$res['desistatus'] = $row1->sts;
			}
			$sql4="SELECT test_sts FROM test_attempt WHERE schedule_id=  :schedule_id";
			$query4= $this->db->prepare($sql4);
			$query4->execute(array(':schedule_id'=>$row2->schedule_id));
			while($row4=$query4->fetch())
			{
				$res['teststatus'] = $row4->test_sts;
			}
			//$res['testname']=$tests;
			$res['positionSts']=$positionSts;
			$res['startdate']=$startdate;
			$res['enddate']=$enddate;
			
			
			$result[] =$res;
			
		}

	}
		    return $result;
        
    }

    
    public function getScheduledCandidates($sts)
    {
		
		$org_id=$_SESSION["user_org_id"];
	 	$designation_id =isset($_POST['position'])?($_POST['position']):0;
	
		$testpaper =isset($_POST['tests'])?($_POST['tests']):0;
		$candidate_id =isset($_POST['candidate_id'])?($_POST['candidate_id']):0;// this line is executed for filtering indivisual candidates added on 17/7/2017 by abhinav
		$candidate_email=isset($value["candidate_email"])? $value["candidate_email"] :"";
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		$paper='';
		if($testpaper !=0)
		{
			$paper=" and tests = $testpaper";
		}
		
	/* 	if($enddate=="")
		{
		$enddate=date('Y-m-d',(strtotime ( '+30 day',strtotime(date('Y-m-d'))) ));
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		
		$showdate=" ";
		if($startdate!='' && $enddate!=''){
			$showdate = "and date(schedule_date) between '$startdate' and  '$enddate' " ;
		}
		
		$date1=date('Y-m-d H:i:s');
		$date2=strtotime($date1);
		$date3=$date2-(60*60*12);
		$date=date("Y-m-d H:i:s", $date3);
		$des="";
		$des1="";
		   if($designation_id!=0)
		 {
		 $des1=" and designation_id=$designation_id";
		  }
		// if($testlevel!=0)
		// {
		// $des=$des." and testlevel = $testlevel";
		// } 
		if($candidate_id!=0)// this line is executed for filtering individual candidates added on 17/7/2017 by abhinav
		{
		$des=$des." and candidate_id = $candidate_id";
		}
		
		$loginduration = 1;
		$durationtype = 1;
		
		$sql1="select * from company_master where id = ?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $org_id));
		if($row1 = $query1->fetch()){
		$loginduration = $row1->LoginDuration;
		$durationtype = $row1->DurationType;
		}
		if($durationtype==1){
			$durationtype="DAY";
		}else{
			$durationtype="HOUR";
		}
		
		$sql="";
		$sts;
		if($sts==1)///////not appeared
		{
			$sql = "SELECT * from schedule_candidate WHERE org_id = ? and NOW() > DATE_ADD(schedule_date, INTERVAL $loginduration $durationtype) and teststs=0 and candidate_id in (select candidate_id from candidate_table where org_id = $org_id $des1)  $paper $showdate ORDER BY  schedule_date desc";
		}else{
			/////////awaiting candidates
			$sql = "SELECT * from schedule_candidate WHERE org_id = ? and NOW() <= DATE_ADD(schedule_date, INTERVAL $loginduration $durationtype) and teststs=0 and candidate_id in (select candidate_id from candidate_table where org_id = $org_id $des1) $paper $showdate  ORDER BY  schedule_date desc";
		}
		
		
        $query = $this->db->prepare($sql);
        $query->execute(array( $org_id));

       $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['schedule_id'] = $row->id;
			$res['candidate_id'] = $row->candidate_id;
			$res['assessorid'] = $row->assessorid;
			$res['schedule_date'] = date("d M Y h:i A",strtotime($row->schedule_date));
			$fname = $this->getName($row->candidate_id,'candidate_table','candidate_fname','candidate_id');
			$lname = $this->getName($row->candidate_id,'candidate_table','candidate_lname','candidate_id');
			$res['candidate_name'] = ucwords(strtolower($fname." ".$lname));
			$res['candidate_email'] = $this->getName($row->candidate_id,'candidate_table','candidate_email','candidate_id');
			$res['candidate_contact'] = $this->getName($row->candidate_id,'candidate_table','candidate_contact','candidate_id');
			
			$desig = $this->getName($row->candidate_id,'candidate_table','designation_id','candidate_id');
	
			$res['candidate_desig'] = $this->getName($desig,'DefaultPosition','PositionName','Id');
			
			$res['assessorname'] = $this->getName($row->assessorid,'users','user_name','	user_id');
		//	$res['level'] = $this->getName($row->testlevel,'test_level','level','id');
				$tests=$this->getName($row->tests,'Test_paper','Name','Id');  
		
		/* 	$test_id = $row->tests;
			$test= explode(',', $test_id);
			$tests="";	
			foreach($test as $value)
			{
				if($tests=="")
					$tests=$this->getName($value,'test_category_child','cat_name','cat_id');
				else
					$tests.=", ".$this->getName($value,'test_category_child','cat_name','cat_id');
			} */
			
			$res['testname']=$tests;
			$res['ipsts'] = $row->ipsts;
			$res['location'] ='Any Location';
			if($row->location!='')
			{
			$res['location'] = $row->location;
			}
			$res['minip'] = $row->minip;
			$res['maxip'] = $row->maxip;
			
			$result[] =$res;
		}
      
        return $result;
    }



public function getTable($sts=0)
	{
	

		$org_id=$_SESSION['user_org_id'];
		$date=date('Y-m-d H:i:s');
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$position = isset($_POST["position"])?$_POST["position"]:0;
		//$positionSts =isset($_POST['positionSts'])?($_POST['positionSts']):0;
		$pos="";
		$posSts="";
		if($position!=0)
		{
		$pos="and d.Id=".$position;
		}
		
				
		/* if($positionSts!=0)
		{
			if($positionSts==1){
				$posSts=" and d.sts=1";
			}elseif($positionSts==2){
				$posSts=" and d.sts=2";
			}else{
				$posSts="";
			}
		
		
		} */
       $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
	   $showdate=" ";
		if($startdate!='' && $enddate!=''){
			$showdate="and date(s.schedule_date)  between '$startdate'  and  '$enddate' ";
		}
		/* if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		$sql="";
		if($sts==1)
		{
		$sql = "select c.candidate_id as candidate_id, c.candidate_fname as candidate_name,c.candidate_lname as candidate_lname, d.designation_name as designation_name, s.schedule_date as schedule_date, s.testlevel as level from designation_table d, candidate_table c, schedule_candidate s where c.candidate_id=s.candidate_id and c.designation_id=d.designation_id and s.schedule_date >='$date' and c.org_id=$org_id $pos order by s.schedule_date asc";
		}elseif($sts==2)
		{
			$sql = "select c.candidate_id as candidate_id, c.candidate_fname as candidate_name,c.candidate_lname as candidate_lname, d.designation_name as designation_name, s.schedule_date as schedule_date, s.testlevel as level from designation_table d, candidate_table c, schedule_candidate s where c.candidate_id=s.candidate_id and c.designation_id=d.designation_id and month(s.schedule_date)=month(current_date()) and c.org_id=$org_id order by s.schedule_date asc";
		}if($sts==3)
		{
		$sql = "select c.candidate_id as candidate_id, c.candidate_fname as candidate_name,c.candidate_lname as candidate_lname, d.PositionName as designation_name, s.schedule_date as schedule_date, s.testlevel as level from DefaultPosition d, candidate_table c, schedule_candidate s where c.candidate_id=s.candidate_id and c.designation_id=d.Id $showdate and c.org_id=$org_id $pos  order by s.schedule_date desc";
		}
		else{
		$sql = "select c.candidate_id as candidate_id, c.candidate_fname as candidate_name,c.candidate_lname as candidate_lname, d.designation_name as designation_name, s.schedule_date as schedule_date, s.testlevel as level from designation_table d, candidate_table c, schedule_candidate s where c.candidate_id=s.candidate_id and c.designation_id=d.designation_id and date(s.schedule_date)>=curdate() and c.org_id=$org_id and s.id not in (select schedule_id from test_attempt) order by s.schedule_date asc";
		}
		$query = $this->db->prepare($sql);
        $query->execute();        
        $result =array();
		
        while($row = $query->fetch())
        {
			$res= array();
			$res['designation_name'] =$row->designation_name;
			$res['candidate'] =$row->candidate_name;
		$res['candidate_fullname'] = ucwords(strtolower($row->candidate_name." ".$row->candidate_lname));
			$res['schedule_date']=$row->schedule_date;
		$res['candidate_id']=$row->candidate_id;
				$res["startdate"]	=$startdate;
			$res["enddate"]	=$enddate;
			$res['level']=$this->getName($row->level,'test_level','level','id');
			$result[] =$res;
		}
      
        return $result;
	}
	
	
     public function getSchedule($schedule_id)
    {
		$org_id=$_SESSION["user_org_id"];
		$date=date('Y-m-d H:i:s');
		$sql = "SELECT * from schedule_candidate WHERE org_id = ? and id=$schedule_id";
		$query = $this->db->prepare($sql);
        $query->execute(array( $org_id));

       $result =array();
        if($row = $query->fetch())
        {
			$res= array();
			$res['schedule_id'] = $row->id;
			$res['candidate_id'] = $row->candidate_id;
			$res['location'] = $row->location;
			$res['schedule_date'] = date("Y-m-d h:i A",strtotime($row->schedule_date));
			$res['candidate_fullname'] = $this->getName($row->candidate_id,'candidate_table','candidate_fname','candidate_id');
		//	$res['assessor'] = $this->getName($row->assessorid,'users','user_name','user_id');
			$res['assessor'] = $row->assessorid;
			//$desig = $this->getName($row->candidate_id,'candidate_table','designation_id','candidate_id');
			//$res['candidate_desig'] = $this->getName($desig,'designation_table','designation_name','designation_id');
			$res['candidate_desig'] = $row->positionid;
			$res['testlevel'] = $row->testlevel;
			$res['tests'] = $row->tests;
			$res['location'] = $row->location;
			
			$test_id_array = $row->tests;
			$test= explode(',', $test_id_array);
			$testpaperarr=array();
			$tests="";	
			foreach($test as $value)
			{
				$res1=array();
				$test_name=$this->getName($value,'test_category_child','cat_name','cat_id');
				$test_id=$value;
				$res1['id']=$test_id;
				$res1['name']=$test_name;
				$testpaperarr[]=$res1;
			}
			$res['testpaperarr']=$testpaperarr;
		
			/* $test_id = $row->tests;
			
			$test= explode(',', $test_id);
			$tests="";	
			foreach($test as $value)
			{
				if($tests=="")
					$tests=$this->getName($value,'test_category_child','cat_name','cat_id');
				else
					$tests.=", ".$this->getName($value,'test_category_child','cat_name','cat_id');
			}
			 */
			
		
			//$res['testname']=$tests;
			//$res['tests']=$tests;
			$res['ipsts'] = $row->ipsts;
			$res['minip'] = $row->minip;
			$res['maxip'] = $row->maxip;
			
			$result[] =$res;
		}
      
        return $result;
    }
    public function createSchedule()
    {
		try{	
        // clean the input to prevent for example javascript within the groups.
		$org_id=$_SESSION["user_org_id"];
		$mid=$_SESSION["user_id"];
		$skip=0; 
		$add=0;
		$sts=isset($_POST['ipsts'])?($_POST['ipsts']):0;
		$minip=isset($_POST['minip'])?($_POST['minip']):"";
		$maxip=isset($_POST['maxip'])?($_POST['maxip']):"";
		$location=isset($_POST['location'])?($_POST['location']):"";
		$assessor=isset($_POST['assessor'])?($_POST['assessor']):"";
		//print_r($_POST['candidateid']);
		
		$scheduledatetime =isset($_POST['scheduledatetime'])?$_POST['scheduledatetime']:"";
		$date = strtotime($scheduledatetime);
	    $new_date = date('Y-m-d H:i', $date);
	    $new_date1 = date('Y-m-d', $date);
	
		if(date('Y-m-d', $date)>=date('Y-m-d')){
			/*
			$minip =isset($_POST['minip'])?($_POST['minip']):"";
			$maxip =isset($_POST['maxip'])?($_POST['maxip']):"";
			
			$alwip =isset($_POST['alwip'])?($_POST['alwip']):0; */  
			$testid =isset($_POST['tests'])?($_POST['tests']):"";  
		//	$position =isset($_POST['position'])?($_POST['position']):"";  
		   // $testlevel =isset($_POST['testlevel'])?($_POST['testlevel']):"";  
			/* $testid="";
			foreach($tests as $value){
				if($testid==""){
					$testid=$value;
				}else{
					$testid.=",".$value;					
				}
			}		 */	
		///////////////     vanshika      ////////////	
			$loginduration = 1;
		$durationtype = 1;
		
		$sql1="select * from company_master where id = ?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $org_id));
		if($row1 = $query1->fetch()){
		$loginduration = $row1->LoginDuration;
		$durationtype = $row1->DurationType;
		}
		if($durationtype==1){
			$durationtype="DAY";
		}else{
			$durationtype="HOUR";
		}
		///////////////////////////////////////////////////////////////////////////
		
			$candidateids =json_decode(isset($_POST['candidateid'])?($_POST['candidateid']):"");			
		
			foreach($candidateids as $value){
				//echo 'ok';
				
				if($value->sts){
					//echo 'ghgh';
				//////////////checking the candidate with the same date is entered in schdule test or not///// if yes then we are inserting the data,if not then we will insert data////		
				//echo "SELECT * from schedule_candidate WHERE candidate_id = $value->candidate_id  and teststs = 0 and NOW() < DATE_ADD(schedule_date, INTERVAL $loginduration $durationtype) ";
				
				$sql = "SELECT * from schedule_candidate WHERE candidate_id = ? and  teststs = ? and NOW() <  DATE_ADD(schedule_date, INTERVAL $loginduration $durationtype)";
				
				
				
				$query = $this->db->prepare($sql);
				$query->execute(array( $value->candidate_id, 0));
				$row = $query->fetch();
				$count =  $query->rowCount();
			
		
				if($count  >= 1)
				{
			
					$skip++;
				}
				else{
		
				$sql = "INSERT INTO schedule_candidate (org_id, candidate_id, schedule_date, tests,ipsts,minip,maxip,location,assessorid,createdbyid) VALUES (?,?,?,?,?,?,?,?,?,?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($org_id, $value->candidate_id, $new_date, $testid,$sts, $minip, $maxip,$location,$assessor,$mid));
				$count =  $query->rowCount();
				if($count==1){
				$sql = "SELECT * from template_table WHERE temp_id = ?";
				$query = $this->db->prepare($sql);
				$query->execute(array(0));
				$candidate_email="";
				$candidate_subject="";
				$candidate_text="";
				$canidate_name="";
				$candidate_enroll="";
				$candidate_pass="";
				if($row = $query->fetch())
				{
					$candidate_subject=$row->temp_subject;
					$candidate_text=$row->temp_text;
				}		 
				
				$sql11 = "SELECT * from candidate_table WHERE candidate_id =  ?";
				$query11 = $this->db->prepare($sql11);
				$query11->execute(array($value->candidate_id));
			
				if($row11 = $query11->fetch())
				{
					$candidate_email=$row11->candidate_email;
					$candidate_enroll=$row11->enroll_no;
					$candidate_pass=$this->decrypt($row11->candidate_pass);
					$candidate_name=$row11->candidate_fname;
				}
				
				$candidate_subject=	str_replace("[Name]", $candidate_name, $candidate_subject);
				$candidate_subject=	str_replace("[Date]", $new_date, $candidate_subject);
				$candidate_text=	str_replace("[Enroll]", $candidate_enroll, $candidate_text);
				$candidate_text=	str_replace("[Pass]", $candidate_pass, $candidate_text);
				
				mail("vanshika@ubitechsolutions.com", $candidate_subject, $candidate_text);
				}
					$add++;
				}
				
			}
			
			
			//////////////////// ACTIVITY LOG///////////////////////////////
				
				$counttt=0;
				$sql2 = "SELECT * FROM ActivityHistoryMaster where OrganizationId=? AND LastModifiedById=? AND Module='Scheduled Candidate'";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($org_id,$mid));
			 	$counttt = $query2->rowcount();
			
				if($counttt==0){
				$sql1 = "SELECT COUNT(id) as totalcan FROM schedule_candidate where org_id=? AND createdbyid=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($org_id,$mid));
				$row1 = $query1->fetch();
				$total = $row1->totalcan;
   
				$msg=" $total Candidate have been scheduled for test";
				$profileid=$this->getName($mid ,'users','user_profile','user_id');
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed, user_profile_Id, OrganizationId) VALUES (?, ?, ?, ?,?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Scheduled Candidate",$msg,$profileid, $org_id)); 
				}
				else{
					$sql1 = "SELECT COUNT(id) as totalcan FROM schedule_candidate where org_id=? AND createdbyid=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($org_id,$mid));
				$row1 = $query1->fetch();
				$total = $row1->totalcan;
   
				$msg="$total  Candidate have been scheduled for test";
				$profileid=$this->getName($mid ,'users','user_profile','user_id');
				$sql = "UPDATE ActivityHistoryMaster SET ActionPerformed=? WHERE Module='Scheduled Candidate'  AND 	LastModifiedById	= ?";
				$query = $this->db->prepare($sql);
				$query->execute(array($msg,$mid)); 
				}
		}
			
			
		
		}else{
			$_SESSION["feedback_negative"][] = "Can't schedule for previous date";
			return false;
		}
		
		if ($add >= 1) {
			//	echo 'lolo';
			$_SESSION["feedback_positive"][] = FEEDBACK_SCHEDULE_ADDITION_SUCCESSFUL;
			
		} 
		if ($skip >= 1)  {
				
			$_SESSION["feedback_negative"][] = "Candidate are already schedule for same  date.";
			
		}
		
		return true;
		
		}catch(Exception $e){
			
		}
         //default return;
        
    }

	 public function createImportedSchedule()
    {
	
        // clean the input to prevent for example javascript within the groups.
		$org_id=$_SESSION["user_org_id"];
		
		$ipsts=array();
		$ipsts[]=$this->getIpsts();
		$sts=$ipsts[0][0]['ipsts'];
		$minip=$ipsts[0][0]['minip'];
		$maxip=$ipsts[0][0]['maxip'];
		
		//$count =isset($_POST['count'])?($_POST['count']):1;
		$check_hidden =isset($_POST['check_hidden'])?($_POST['check_hidden']):"";
		
		$candidate_id_hidden =isset($_POST['candidate_id_hidden'])?($_POST['candidate_id_hidden']):"";
		
		$designation_id_hidden =isset($_POST['designation_id_hidden'])?($_POST['designation_id_hidden']):"";
		
		$scheduledatetime_hidden =isset($_POST['scheduledatetime_hidden'])?($_POST['scheduledatetime_hidden']):"";
	
		$tests_hidden =isset($_POST['tests_hidden'])?($_POST['tests_hidden']):"";
		$assessor_hidden =isset($_POST['assessor_hidden'])?($_POST['assessor_hidden']):"";
			
		$check_array =(explode(',', $check_hidden));
		$candidate_id_array =(explode(',', $candidate_id_hidden));
		$designatiton_id_array =(explode(',', $designation_id_hidden));
		$scheduledatetime_array =(explode(',', $scheduledatetime_hidden));
		$tests_array =(explode('|', $tests_hidden));
		$assessor_array =(explode(',', $assessor_hidden));
		
		$count=count($check_array);
		$count--;
		$posifeed=0;
		$negifeed=0;
		while($count>=0)
		{	
			$check_box =isset($check_array[$count])?($check_array[$count]):"";
			if($check_box==1){
			
			
       
			
		
		$candidate_id=isset($candidate_id_array[$count])?($candidate_id_array[$count]):"";
		$position=isset($designatiton_id_array[$count])?($designatiton_id_array[$count]):0;
			$scheduledatetime =isset($scheduledatetime_array[$count])?($scheduledatetime_array[$count]):"";
			$date = strtotime($scheduledatetime);
			$new_date = date('Y-m-d H:i', $date);
				/*
			$minip =isset($_POST['minip'])?($_POST['minip']):"";
		$maxip =isset($_POST['maxip'])?($_POST['maxip']):"";
		$alwip =isset($_POST['alwip'])?($_POST['alwip']):0;   */
		$tests =isset($tests_array[$count])?($tests_array[$count]):""; 
		$assessor =isset($assessor_array[$count])?($assessor_array[$count]):""; 
		
        
			
  
			//////////////checking the candidate with the same date is entered in schdule test or not///// if yes then we are inserting the data,if not then we will insert data////		
		 $sql = "SELECT * from schedule_candidate WHERE candidate_id = ? and tests=?";
        $query = $this->db->prepare($sql);
        $query->execute(array( $candidate_id, $tests));

        $result =array();
        if($row = $query->fetch())
        {
		//$_SESSION["feedback_negative"][] = "This candidate has already scheduled for this test";
		$negifeed++;	
        }else{
			
		$sql = "INSERT INTO schedule_candidate (org_id, candidate_id, schedule_date, tests,ipsts,minip,maxip, testlevel,assessorid) VALUES (?,?,?,?,?,?,?,?,?)";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id,$candidate_id,$new_date,$tests,$sts,$minip,$maxip,0,$assessor));

        $count1 =  $query->rowCount();
        if ($count1 == 1) {
			$posifeed++;
			//$_SESSION["feedback_positive"][] = FEEDBACK_SCHEDULE_ADDITION_SUCCESSFUL;
           
        } else {
			$negifeed++;
            //$_SESSION["feedback_negative"][] = FEEDBACK_SCHEDULE_ADDITION_FAILED;
			
        }
           
        } 
		
		
			}
		$count--;
				
		}
		 if ($posifeed != 0) {
			//$posifeed++;
			$_SESSION["feedback_positive"][] = "$posifeed ".FEEDBACK_SCHEDULE_ADDITION_SUCCESSFUL;
           
        } if ($negifeed != 0) {
			//$negifeed++;
            $_SESSION["feedback_negative"][] = "$negifeed ".FEEDBACK_SCHEDULE_ADDITION_FAILED;
			
        }
		
		return true;
        // default return
        
    }
	
public function updateSchedule($id)
    {
		try{
        // clean the input to prevent for example javascript within the groups.
		$org_id=$_SESSION["user_org_id"];
		$mid=$_SESSION["user_id"];
		$candidateids =isset($_POST['candidateid'])?($_POST['candidateid']):"";
		$scheduledatetime =isset($_POST['scheduledatetime'])?($_POST['scheduledatetime']):"";
		$assessorid =isset($_POST['assessor'])?($_POST['assessor']):"";
		$ipsts =isset($_POST['ipsts'])?($_POST['ipsts']):"";
		$minip =isset($_POST['minip'])?($_POST['minip']):"";
		$maxip =isset($_POST['maxip'])?($_POST['maxip']):"";
		$location =isset($_POST['location'])?($_POST['location']):"";
		$date = strtotime($scheduledatetime);
	    $new_date = date('Y-m-d H:i', $date);
		if(date('Y-m-d', $date)>=date('Y-m-d')){
				/*$minip =isset($_POST['minip'])?($_POST['minip']):"";
				$maxip =isset($_POST['maxip'])?($_POST['maxip']):"";
				$alwip =isset($_POST['alwip'])?($_POST['alwip']):0;*/
				
				$testid =isset($_POST['tests'])?($_POST['tests']):""; 
			//	$position =isset($_POST['position'])?($_POST['position']):""; 
				//$testlevel =isset($_POST['testlevel'])?($_POST['testlevel']):""; 
			/* 	$testid="";
				foreach($tests as $value){
					if($testid==""){
						$testid=$value;
					}else{
						$testid.=",".$value;					
					}
				} */
				/* for($i=0;$i<count($candidateids);$i++){
					$sql = "update schedule_candidate set candidate_id=?, schedule_date=?, tests=?, positionid=? ,testlevel=? where id=?";
					$query = $this->db->prepare($sql);
					$query->execute(array( $candidateids[$i], $new_date, $tests,$position ,$testlevel, $id));
				} */
				
				$sql = "SELECT * from schedule_candidate WHERE candidate_id = ?  and schedule_date = ? and id !=$id";
				$query = $this->db->prepare($sql);
				$query->execute(array( $candidateids, $testlevel, $new_date));
			if($row = $query->fetch())
			{
				$_SESSION["feedback_negative"][] = "Candidate is already scheduled for the same position and level.";
				return false;
			}else{
				$sql = "update schedule_candidate set schedule_date=?,tests=?,teststs=?,ipsts=?,minip=?,maxip=?,location=?,assessorid=? where id=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($new_date,$testid,0,$ipsts,$minip,$maxip,$location,$assessorid, $id));
				$count =  $query->rowCount();
				
				//////////////////// ACTIVITY LOG///////////////////////////////
				/* $scheduledate = date("d M Y h:i A",strtotime($new_date));
				$fname=$this->getName($candidateids,'candidate_table','candidate_fname','candidate_id');
				$lname=$this->getName($candidateids,'candidate_table','candidate_lname','candidate_id');
				$msg="<b>$fname $lname</b>  has been re-scheduled for test on <b>$scheduledate </b>";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Schedule Candidate", $msg, $org_id));  */
				
				
				if ($count == 1) {
					$_SESSION["feedback_positive"][] = FEEDBACK_SCHEDULE_ADDITION_SUCCESSFUL;
					return true;
				} else {
					$_SESSION["feedback_negative"][] = FEEDBACK_SCHEDULE_ADDITION_FAILED;
					return false;
				}
			}
		}else{
				$_SESSION["feedback_negative"][] = "Can't schedule for previous date";
				return false;
		}
        // default return
        }catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
    }
	
	
	 public function setLocation()
    {
        // clean the input to prevent for example javascript within the groups.
		$org_id=$_SESSION["user_org_id"];
		
		$ipsts =isset($_POST['ipsts'])?($_POST['ipsts']):0;
		if($ipsts!=0)
		{
		$minip =isset($_POST['minip'])?($_POST['minip']):"";
		$maxip =isset($_POST['maxip'])?($_POST['maxip']):"";
		$sql = "update company_master set  minip=?, maxip=?, ipsts=? where id=?";
        
		$query = $this->db->prepare($sql);
        $query->execute(array($minip, $maxip, $ipsts, $org_id));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = "Test Location is set for specific location";
       
        } else {
            $_SESSION["feedback_negative"][] = "Test Location for this location is already set or improper network_id";
			
        }
		
		}else{
			$sql = "update company_master set ipsts=0 where id=?";
        
		$query = $this->db->prepare($sql);
        $query->execute(array($org_id));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = "Test Location is set for any location";
       
        } else {
            $_SESSION["feedback_negative"][] = "Test Location is not set properly";
			
        }
		
			
		}
		return true;
		}
		
				
		
        
        // default return
        
     public function getIpsts()
    {
        // clean the input to prevent for example javascript within the groups.
		$org_id=$_SESSION["user_org_id"];
		$sql = "SELECT * from company_master WHERE id = ?";
		$query = $this->db->prepare($sql);
        $query->execute(array( $org_id));
		$result =array();
        if($row = $query->fetch())
        {
			$res=array();
			$res["currlocation"]=$row->address;
			$res["ipsts"]=$row->ipsts;
			$res["minip"]=$row->minip;
			$res["maxip"]=$row->maxip;
		}
		$result[]=$res;
		return $result;
	}
	
	
    public function editSave($user_id)
    {
        // clean the input to prevent for example javascript within the groups.
       
       $user_name = strip_tags($_POST['user_name']);
		$user_fullname = strip_tags($_POST['fullname']);
		$user_group_id = strip_tags($_POST['group_id']);
		$user_email = strip_tags($_POST['email']);
		$password =isset($_POST['password'])?Self::encrypt($_POST['password']):"";
		
        $sql = "UPDATE users SET user_name=:user_name, user_password_hash=:user_pass, user_fullname=:user_fullname, user_group_id=:user_group_id, user_email=:user_email WHERE user_id = :user_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_name' => $user_name, ':user_pass'=> $password, ':user_fullname' => $user_fullname, ':user_group_id' => $user_group_id, ':user_email' => $user_email, ':user_id' => $user_id));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_USER_EDITING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_USER_EDITING_FAILED;
        }
        // default return
        return false;
    }

    /**
     * Deletes a specific group
     * @param int $group_id id of the group
     * @return bool feedback (was the group deleted properly ?)
     */
    public function delete($candidate_id)
    {
		
		$org_id=$_SESSION["user_org_id"];
		$mid=$_SESSION["user_id"];
        $sql = "DELETE FROM schedule_candidate WHERE id =?";
        $query = $this->db->prepare($sql);
        $query->execute(array($candidate_id));

        $count =  $query->rowCount();
					
					//////////////////// ACTIVITY LOG///////////////////////////////
				
				
				/* $canid=$this->getName($candidate_id,'schedule_candidate','candidate_id','id');
				$fname=$this->getName($canid,'candidate_table','candidate_fname','candidate_id');
				$lname=$this->getName($canid,'candidate_table','candidate_lname','candidate_id');
				$msg="<b>$fname $lname</b>  has been deleted from schedule";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Schedule Candidate", $msg, $org_id));  */
		
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_SCHEDULE_DELETION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_SCHEDULE_DELETION_FAILED;
        }
        // default return
        return false;
    }
    
    public function changestatus($user_id, $status)
    {
		$status = ($status==1)?0:1;
        $sql = "update users set user_active=:sts WHERE user_id = :user_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':user_id' => $user_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_USER_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_USER_CHANGE_STATUS_FAILED;
        }
        // default return
        return false;
    }
	public function getName($id,$table,$field,$where)
    {
		$name="";
        $sql = "select $field from $table where $where = ?";
        $query = $this->db->prepare($sql);
        $query->execute(array($id));
		while($row=$query->fetch())
		{
			$name=$row->$field;
		}

        return $name;
    }
	public function get_client_ip() {
		$ipaddress = '';
		if (getenv('HTTP_CLIENT_IP'))
			$ipaddress = getenv('HTTP_CLIENT_IP');
		else if(getenv('HTTP_X_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_X_FORWARDED_FOR');
		else if(getenv('HTTP_X_FORWARDED'))
			$ipaddress = getenv('HTTP_X_FORWARDED');
		else if(getenv('HTTP_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_FORWARDED_FOR');
		else if(getenv('HTTP_FORWARDED'))
			$ipaddress = getenv('HTTP_FORWARDED');
		else if(getenv('REMOTE_ADDR'))
			$ipaddress = getenv('REMOTE_ADDR');
		else
			$ipaddress = 'UNKNOWN';
		return $ipaddress;
	}

	public  function decrypt($string , $key="ubitech")
			{
			   $result='';
			   $string=base64_decode($string);
			   for($i=0; $i<strlen($string); $i++)
			   {
					$char = substr($string, $i,1);
					$keychar =substr($key, ($i % strlen($key))-1,1);
					$char = chr(ord($char)-ord($keychar));
					$result.=$char;
			   }
			   return $result;
		   }
public  function encrypt($string, $key="ubitech")
	{
		  $result = '';
		  for($i=0; $i<strlen($string); $i++)
		  {
			$char = substr($string, $i, 1);
			$keychar = substr($key, ($i % strlen($key))-1, 1);
			$char = chr(ord($char)+ord($keychar));
			$result.=$char;
		  }
		  return base64_encode($result);
	}
}
?>