<?php

/**
 * UserModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SalarygradeModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function create()
    {
		$count1=0;$count=0;
		$org_id=$_SESSION['user_org_id'];
		$userid=$_SESSION['user_id'];
        // clean the input to prevent for example javascript within the groups.
		$code = $_POST['code'];
		$name =$_POST['name'];
		$description =$_POST['description'];
		$date=date('Y-m-d h:i:s a');
		
		$sql1 = "SELECT * FROM salary_grad WHERE salarygrad_code=:code and org_id=:org_id";
        $query1 = $this->db->prepare($sql1);
		$query1->execute(array( ':code'=>$code,':org_id'=>$org_id));
		
		$sql2 = "SELECT * FROM salary_grad WHERE salarygrad_name=:name and org_id=:org_id";
        $query2 = $this->db->prepare($sql2);
        $query2->execute(array( ':name'=>$name,':org_id'=>$org_id));

	   $count1 =  $query1->rowCount();
	   $count2 =  $query2->rowCount();
		if($count1>=1){
			 $res["status"]=false;		
				$res["errorMsg"]="Salary Grade Code already exists ";
			
		}else if($count2>=1){
			$res["status"]=false;		
				$res["errorMsg"]="Salary Grade Name already exists ";

		}else
		{
        $sql = "INSERT INTO salary_grad (salarygrad_code, salarygrad_name, Description, created_date, CreatedById, org_id) VALUES (:code, :name, :description, :createddate, :uid,:org_id)";
        $query = $this->db->prepare($sql);
        $query->execute(array( ':code'=>$code, ':name' =>$name, ':description' =>$description, ':createddate' => $date, ':uid'=>$userid,':org_id'=>$org_id));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$res['status']=true;		
				$res['successMsg']="Salary Grade created successfully";
			
        } else {
           $res['status']=false;		
				$res['errorMsg']="Salary Grade not created ";
        }
		
		}
		
		$data[]=$res;
		//print_r($data);
        // default return
        return $data;
    }
	
	 public function update()
    {
		$count1=0;$count=0;
		$org_id=$_SESSION['user_org_id'];
		$userid=$_SESSION['user_id'];
        // clean the input to prevent for example javascript within the groups.
		$code = $_POST['code'];
		$name =$_POST['name'];
		$description =$_POST['description'];
		$sg_id =$_POST['sg_id'];
		$date=date('Y-m-d h:i:s a');
		
		$sql1 = "SELECT * FROM salary_grad WHERE Id!=:sg_id and salarygrad_code=:code and org_id=:org_id";
        $query1 = $this->db->prepare($sql1);
		$query1->execute(array(':sg_id' =>$sg_id ,':code'=>$code, ':org_id' =>$org_id));
		
		$sql2 = "SELECT * FROM salary_grad WHERE Id!=:sg_id and salarygrad_name=:name and org_id=:org_id";
        $query2 = $this->db->prepare($sql2);
        $query2->execute(array(':sg_id' =>$sg_id , ':name' =>$name, ':org_id' =>$org_id));

	   $count1 =  $query1->rowCount();
	   $count2 =  $query2->rowCount();
		if($count1>=1){
			 $res["status"]=false;		
				$res["errorMsg"]="Salary Grade Code already exists ";
			
		}else if($count2>=1){
			$res["status"]=false;		
				$res["errorMsg"]="Salary Grade Name already exists ";

		}else
		{
    $sql = "UPDATE salary_grad SET salarygrad_code=:code,salarygrad_name=:name, Description=:description, modified_date=:modified_date,LastModifiedById=:uid,org_id=:org_id WHERE Id=$sg_id ";
        $query = $this->db->prepare($sql);
        $query->execute(array( ':code'=>$code, ':name' =>$name, ':modified_date' => $date, ':description' =>$description, ':uid'=>$userid,':org_id'=>$org_id));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$res['status']=true;		
				$res['successMsg']="Salary Grade Updated successfully";
			
        } else {
           $res['status']=false;		
				$res['errorMsg']="Salary Grade not updated ";
        }
		
		}
		
		$data[]=$res;
		//print_r($data);
        // default return
        return $data;
    }
	
	 public function delete($sg_id)
    {
		$count1=0;
		$org_id=$_SESSION['user_org_id'];
		
		$sql1 = "SELECT * FROM candidate_table WHERE salary_grad=$sg_id and org_id=$org_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array());

      $count1 =  $query1->rowCount();
		if($count1>=1){
			 $data["status"]=false;		
				$data["errorMsg"]="This Salary Grade is used for candidate ";
			
		}
		else
		{
    $sql = "DELETE FROM `salary_grad` WHERE Id=$sg_id and org_id=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute(array());

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$data['status']=true;		
				$data['successMsg']="Salary Grade deleted successfully";
			
        } else {
           $data['status']=false;		
				$data['errorMsg']="Salary Grade not deleted ";
        } 
		
	}
		
		
        return $data;
    }

public function getsalarygrade($editper,$deleteper)
    {
		$org_id=$_SESSION['user_org_id'];
		$edit_per=$editper;
		$delete_per=$deleteper;
	$sql = "SELECT * FROM salary_grad WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['code'] = $row->salarygrad_code;
		   $res['name'] = $row->salarygrad_name;
		   $res['description'] = $row->Description;
		   $res['sg_id'] = $row->Id;
		   $edit="";$delete="";
		   if($edit_per){
		   $edit="<a rel='tooltip' title='Edit'  onclick='angular.element(this).scope().onfetchdata(".$row->Id.")'  href='#' data-original-title='Edit' class='label bg-green'><i class='fa fa-edit'></i></a>&nbsp;&nbsp;&nbsp;&nbsp;";}
		   if($delete_per){
			$delete="<a rel='tooltip' title='Delete' onclick='angular.element(this).scope().onfetchfordelete(\"".$row->Id."\")' data-toggle='modal' data-target='#confirm' href='#' data-original-title='Delete' class='label bg-red'><i class='fa fa-trash-o'></i></a>";
		   }
		   $res['action']=$edit.$delete;
		   $data[]=$res;
	   }
	   $d['data']=$data;  	
	   //echo json_encode($d); 
	   return $d; 
    }

 public function getallsalarygrade($id)
    {
		$org_id=$_SESSION['user_org_id'];
	
	$sql = "SELECT * FROM salary_grad WHERE org_id=$org_id and Id='$id'";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['code'] = $row->salarygrad_code;
		   $res['name'] = $row->salarygrad_name;
		   $res['description'] = $row->Description;
		   $res['sg_id'] = $row->Id;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
}
