<?php

/**
 * CourseModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class RatingcriteriaModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getAllRatingcriterias()
    {
		try{
			$org_id=$_SESSION['user_org_id'];
			$sql = "SELECT * FROM RatingCriteria where org_id=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($org_id));
			$result =array(); $data =array(); $status=false;
			while($row1 = $query->fetch())
			{
				$status=true;
				$res1=array();
				$res1['id'] = $row1->Id;
				$res1['minmarks'] = (int)$row1->MinMarks;
				$res1['maxmarks'] = (int)$row1->MaxMarks;
				$res1['result'] = $row1->Result;
				$res1['rating'] =(int) $row1->Rating;
				
				$result[] =$res1;
			}
		}
		catch(Exception $e)
		{
		
		}
		$data['data']=$result;
		$data['status']=$status;
        return $data;
    }

	
   
    public function save()
    {
		$org_id=$_SESSION['user_org_id'];
       // INSERTING AND UPDATING ASSESSMENT RESULT IF PASSED AS AN JSON 
		$aresult = json_decode($_POST['result'], true); 
		$count=0; $result=array();
		$sql2="delete from RatingCriteria  where  org_id=:org_id";
		$query2= $this->db->prepare($sql2);
		$query2->execute(array(':org_id' =>$org_id));
		for($i=0; $i<count($aresult); $i++)
		{
			if(  $aresult[$i]['result']!=""){
				$record = array();
				$record[0] = $aresult[$i]['minmarks'];
				$record[1] = $aresult[$i]['maxmarks'];
				$record[2] = $aresult[$i]['result'];
				$record[3] = $aresult[$i]['rating'];
				$record[4] = $org_id;
				$id = $aresult[$i]['id'];
				
				/* if($id){
					$sqlaresult = " UPDATE RatingCriteria SET  MinMarks=?, MaxMarks=?, Result=?, Rating=? where Id=?";
					$queryaresult = $this->db->prepare($sqlaresult);
					$queryaresult->execute(array($aresult[$i]['minmarks'],$aresult[$i]['maxmarks'],$aresult[$i]['result'],$aresult[$i]['rating'], $id));
				}else{ */
					$sqlaresult = " INSERT INTO RatingCriteria (  MinMarks, MaxMarks, Result,Rating,org_id) values (?, ?, ? ,? ,?)";
					$queryaresult = $this->db->prepare($sqlaresult);
					$queryaresult->execute($record);
				//}
				$count+=$queryaresult->rowCount();
			}
		}	
		
        if ($count >= 1) {
			
			$_SESSION["feedback_positive"][] = "Criteria has been saved successfully";
				$status=true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_TEST_CATEGORY_ADDITION_FAILED;
			$status=false;
        }
		$result['data']="";
		$result['status']=$status;
		
        return $result;
        
    }

    
}
        // default retur