<?php

/**
 * QuizModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class QuestionbankModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    
	public function createQuestion()
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
        $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		$questitle = isset($_POST['questitle'])?$_POST['questitle']:'';
		$reference = isset($_POST['reference'])?$_POST['reference']:'0';
		$levelid = isset($_POST['levelid'])?$_POST['levelid']:'0';
		$optionarray= isset($_POST['optionarray'])?json_decode($_POST['optionarray'], true):'';
		$quesid=0;
			$sql = "INSERT INTO question_table (ques_text, LevelId, Reference, org_id, ques_type, created_date, CreatedById) VALUES (?,?,?,?,?,?,?)";
			try
			{
				$query = $this->db->prepare($sql);
				$query->execute(array($questitle,$levelid, $reference,$orgid,2,$mdate,$mid));
				$quesid=$this->db->lastinsertid();
				$count =  $query->rowCount();		
				if($count>=1)
				{
					for($i=0; $i<count($optionarray); $i++)
					  {	
							$sqlans = "INSERT INTO answer_table (ques_id, answert_type, answer_text, weightage, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?)";
							$queryans = $this->db->prepare($sqlans);
							$queryans->execute(array($quesid,$i+1,$optionarray[$i]['Name'], $optionarray[$i]['answer'], $mdate,$mid));
					  }
				}
			}
			catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			
			//////////////////// ACTIVITY LOG///////////////////////////////
				$levelname = $this->getName($levelid,'Levels' , 'Name' , 'Id');
				$counttt=0;
				$sql2 = "SELECT * FROM ActivityHistoryMaster where OrganizationId=? AND LastModifiedById=? AND Module='Add Question'";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($orgid,$mid));
			 	$counttt = $query2->rowcount();
			
				if($counttt==0){
				$sql1 = "SELECT COUNT(ques_id) as totalque FROM question_table where org_id=? AND CreatedById=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid,$mid));
				$row1 = $query1->fetch();
				$total = $row1->totalque;
   
				$msg=" $total Question have been added in $levelname";
				$profileid=$this->getName($mid ,'users','user_profile','user_id');
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed, user_profile_Id, OrganizationId) VALUES (?, ?, ?, ?,?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Add Question",$msg,$profileid, $orgid)); 
				}
				else{
					$sql1 = "SELECT COUNT(ques_id) as totalque FROM question_table where org_id=? AND CreatedById=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid,$mid));
				$row1 = $query1->fetch();
				$total = $row1->totalque;
   
				$msg=" $total Question have been added in $levelname               ";
				$profileid=$this->getName($mid ,'users','user_profile','user_id');
				$sql = "UPDATE ActivityHistoryMaster SET ActionPerformed=? WHERE Module='Add Question'  AND 	LastModifiedById	= ?";
				$query = $this->db->prepare($sql);
				$query->execute(array($msg,$mid)); 
				}
			
			
			if ($count >= 1) 
			{
			   $status =true;
			   $successMsg = "Question Created Successfully";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while creating question.";
			}
		
		
		$result["data"] =$quesid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function updateQuestion()
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
        $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		$quesid = isset($_POST['quesid'])?$_POST['quesid']:0;
		$questitle = isset($_POST['questitle'])?$_POST['questitle']:'';
		$reference = isset($_POST['reference'])?$_POST['reference']:'0';
		$levelid = isset($_POST['levelid'])?$_POST['levelid']:'0';
		$optionarray= isset($_POST['optionarray'])?json_decode($_POST['optionarray'], true):'';
		
		$sql = "Update question_table Set ques_text=?, Reference=?, modified_date=?, LastModifiedById=? where ques_id = ?";
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($questitle, $reference,$mdate,$mid,$quesid));
				$count =  $query->rowCount();		
				if($count>=1)
				{
					if(isset($optionarray)){
						$sql1 = "DELETE FROM answer_table WHERE ques_id = ?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($quesid));
						for($i=0; $i<count($optionarray); $i++)
						  {	
								$sqlans = "INSERT INTO answer_table (ques_id, answert_type, answer_text, weightage, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?)";
								$queryans = $this->db->prepare($sqlans);
								$queryans->execute(array($quesid,$i+1,$optionarray[$i]['Name'], $optionarray[$i]['answer'], $mdate,$mid));
						  }
					}
				}
			}
			catch(Exception $e) 
			{
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count >= 1) {
			   $status =true;
			   $successMsg = "Question Updated Successfully";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while creating question.";
			}
		
		
		$result["data"] =$quesid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	
	public function deleteQuestion()
    {
		 $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		$quesid = isset($_POST['que_id'])?$_POST['que_id']:0;
		
		$sql = "Update question_table Set ques_status=0, modified_date=?, LastModifiedById=? where ques_id = ?";
		$query = $this->db->prepare($sql);
		$query->execute(array($mdate,$mid,$quesid));
		$count =  $query->rowCount();		
			if ($count >= 1) {
			   $status =true;
			   $successMsg = "Question Deleted Successfully";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while deleting question.";
			     $result['errorMsg']=$errorMsg;
			
			}
		$result["data"] =$quesid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
        return $result;
			
    }
	
	
	public function movequestionbank()
    {
			$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		 $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		  $orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
		  $movelevelid=isset($_POST['movelevelid'])?$_POST['movelevelid']:"";
	
		$newquestionarr= isset($_POST['newquestionarr'])?json_decode($_POST['newquestionarr'], true):'';
		
	
		for($i=0; $i<count($newquestionarr); $i++)
            {
			$quesid = $newquestionarr[$i]['ques_id'];
			$ques_text = $newquestionarr[$i]['ques_text'];
			$Reference = $newquestionarr[$i]['Reference'];
			$sql = "Update question_table Set LevelId=?,modified_date=?, LastModifiedById=? where ques_id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array($movelevelid,$mdate,$mid,$quesid));
			$count =  $query->rowCount();
            }
			
			
			
			//////////////////// ACTIVITY LOG///////////////////////////////
				/* $total = count($newquestionarr);
				$msg="<b>$total</b> question has been moved from ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Question Bank", $msg, $orgid));  */
		
			if ($count >= 1) {
			   $status =true;
			   $successMsg = "Question Successfully Moved";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while moving question.";
			     $result['errorMsg']=$errorMsg;
			
			}
	
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		
        return $result;
			
    }
	
	
	
	public function copyquestionbank()
    {
			$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		 $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		  $orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
		  $copylevelid=isset($_POST['copylevelid'])?$_POST['copylevelid']:"";
	
		$newquestionarr= isset($_POST['newquestionarr'])?json_decode($_POST['newquestionarr'], true):'';
		//$jsonData= isset($_POST['jsonData'])?json_decode($_POST['jsonData'], true):'';
	
		
		for($i=0; $i<count($newquestionarr); $i++)
            {
			$quesid = $newquestionarr[$i]['ques_id'];
			$ques_text = $newquestionarr[$i]['ques_text'];
			$Reference = $newquestionarr[$i]['Reference'];
			
			$sql = "INSERT INTO question_table (ques_text, LevelId, Reference, org_id, ques_type, created_date, CreatedById) VALUES (?,?,?,?,?,?,?)";
			
										$query = $this->db->prepare($sql);
										$query->execute(array($ques_text,$copylevelid,$Reference,$orgid,2,$mdate,$mid));
										$quesid=$this->db->lastinsertid();
										$count1=  $query->rowCount();		
										if($count1>=1)
										{
											for($j=0; $j<count($newquestionarr[$i]['options']); $j++)
												   {	
													$sqlans = "INSERT INTO answer_table (ques_id, answert_type, answer_text, weightage, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?)";
													$queryans = $this->db->prepare($sqlans);
													$queryans->execute(array($quesid,$j+1,$newquestionarr[$i]['options'][$j]['name'], $newquestionarr[$i]['options'][$j]['weightage'], $mdate,$mid));
													}
										}
									
						
			
			
            }
			
			//////////////////// ACTIVITY LOG///////////////////////////////
			/* 	$total = count($newquestionarr);
				$msg="<b>$total</b> question has been copied ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Question Bank", $msg, $orgid));  */
			
			
		
			if ($count1 >= 1) {
			   $status =true;
			   $successMsg = "Question  Copied Successfully ";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while copy question.";
			     $result['errorMsg']=$errorMsg;
			
			}
	
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		
        return $result;
			
    }
	
	
	
	
	
	
	
	
	
	
	////function to upload user image/////
	  
	public function uploadQuesAttach($quesid)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
        $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		
		$new_name="";
		
		if (!file_exists("uploads/question")) {
			mkdir("uploads/question" ,  0777,true);
		}
		
		$dir="uploads/question";
		$filename="";
		
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				if ($ext=='png' || $ext=='PNG' || $ext=='jpg' || $ext=='JPG' || $ext=='gif' || $ext=='GIF' || $ext=='MOV' || $ext=='tif' || $ext=='TIF' || $ext=='jpeg' || $ext=='ico'){
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext1 = end((explode(".", $filename)));
								if($filename=='question_'."$quesid.$ext1")
								{
									unlink("uploads/question/$filename");
								}
							}
						closedir($dh);
						}
					}
					$new_name="question_$quesid.$ext";
					$file_size =$_FILES['file0']['size'];
					$file_tmp =$_FILES['file0']['tmp_name'];
					$file_type=$_FILES['file0']['type'];   
					$location="uploads/question/";
					if($file_size > 5097152){
					$errors[]='File size must be less than 5 MB';
					}	
					if (!file_exists("uploads/question/$new_name")) {
						unlink("uploads/question/$new_name");
					}
					if(empty($errors)==true){
					
						if(move_uploaded_file($file_tmp, $location.$new_name))
						{
							$count++;
						}
						
					}
					else{
						print_r($errors);
					}
				}
				else{
					$status =false;
					$successMsg = "Choose Only Image File Format like jpg,png,gif..etc";
				}				
			}
			//////////////updating path of employee profile picture in database/////////////
			
			$sql = "UPDATE question_table SET Attachment=?, modified_date=?, LastModifiedById=? where ques_id=?";	
            $query = $this->db->prepare($sql);
			try{
				$query->execute(array($new_name,$mdate,$mid,$quesid));			
				$count1 =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if ($count >= 1) {
			   $status =true;
			   $successMsg = "Record updated successfully";
			} else {
			   $status =false;
			   $errorMsg .= "There is some problem while updating record.";
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		// default return
        return $result;
	
	} 
	
	
	public function getLevelQuestions()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
        $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		$levelid = isset($_POST['levelid'])?$_POST['levelid']:'0';
        $sql = "SELECT * FROM question_table WHERE org_id =? and LevelId = ? and ques_status = 1 order by ques_id asc";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid,$levelid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['ques_id'] =$row->ques_id;
				$res['ques_text'] =$row->ques_text;
				$res['Reference'] =$row->Reference;
				$res['Attachment'] =$row->Attachment;
				if($row->Attachment!=''){
					$res['Attachment'] ='uploads/question/'.$row->Attachment;
				}
				$sqlans = "SELECT * FROM answer_table WHERE ques_id =? order by answert_type asc";
				$queryans = $this->db->prepare($sqlans);
				$queryans->execute(array($res['ques_id']));
				$countans =  $queryans->rowCount();
				while($rowans = $queryans->fetch())
				{
					$res1 = array();
					$res1['id'] =$rowans->Id;
					$res1['name'] =$rowans->answer_text;
					$res1['answert_type'] =$rowans->answert_type;
					$res1['weightage'] =$rowans->weightage;
					$res['options'][]=$res1;
				}
				$data[] = $res;
			}
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	 public function getExcelData()
	{	
			$result = array();
			$count=0;
			$data = array();
			
			$file_name = "";
			
			if(isset($_FILES['file'])){
				$errors= array();
				$file_name = $_FILES['file']['name'];
			
				$ext = end((explode(".", $file_name))); 
				
				$storage_name="question.$ext";
				if (file_exists($storage_name))
				{ unlink($storage_name); 
				} 
				$file_size =$_FILES['file']['size'];
				$file_tmp =$_FILES['file']['tmp_name'];
				$file_type=$_FILES['file']['type'];   
				$location="public/uploads/";
				if($file_size > 2097152){
				$errors[]='File size must be less than 2 MB';
				}	
				
				if(empty($errors)==true){
				
					move_uploaded_file($file_tmp, $location.$storage_name );
					chmod($location.$storage_name, 0777);
					
				}else{
					print_r($errors);
				}
				
			}		
		//$actual_date = "candidate_details_".$_REQUEST['org_id'];
		//$org_id = isset($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
		//$fileName=isset ($_REQUEST['fileName'])	? $_REQUEST['fileName'] : '';
		$ext = pathinfo($file_name, PATHINFO_EXTENSION);
		if ($ext=='csv'){
		
		$fp =$location.$storage_name;
	
		
			
			$i=0;
		try{
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
				$row = 1;
				$ind=1;
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
							$record 	= array();				
							$qname=$data[0];
							if($ind==1)
							{
								$ind++;
								continue;
							}
									$record['question_name'] = $qname;
									$record['ques_ref'] = $data[1];
									$record['ques_ans1'] = $data[2];
									$record['ques_ans2'] = $data[3];
									$record['ques_ans3'] = $data[4];
									$record['ques_ans4'] = $data[5];
									$record['answer'] = $data[6];
							
							$result[] = $record;			
							$ind++;	
					
				}
				
				
				
			
			}
		}catch(Exception $e) {
		$errorMsg = 'Message: ' .$e->getMessage();
	}
		}
		else{
			
			 $_SESSION["feedback_negative"][] = "Improper, file format.";
			
		}
		
		
			return $result;
	}
	
	
	
	
	 /*public function importQuestion($lvlid)
    {
		$result=array();
		$orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
        $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		$countttt=0;
		$check_hidden =isset($_POST['check_hidden'])?($_POST['check_hidden']):"";
		
		$question_name_hidden =isset($_POST['question_name_hidden'])?($_POST['question_name_hidden']):"";
		$ques_ans1_hidden =isset($_POST['ques_ans1_hidden'])?($_POST['ques_ans1_hidden']):"";
		$ques_ans2_hidden =isset($_POST['ques_ans2_hidden'])?($_POST['ques_ans2_hidden']):"";
		$ques_ans3_hidden =isset($_POST['ques_ans3_hidden'])?($_POST['ques_ans3_hidden']):"";
		$ques_ans4_hidden =isset($_POST['ques_ans4_hidden'])?($_POST['ques_ans4_hidden']):"";
		
	
		$answer_hidden =isset($_POST['answer_hidden'])?($_POST['answer_hidden']):"";
		$ques_ref_hidden =isset($_POST['ques_ref_hidden'])?($_POST['ques_ref_hidden']):"";
	
	
		$check_array =(explode(',', $check_hidden));
		$question_name_array =(explode(',', $question_name_hidden));
		$ques_ans1_array =(explode(',', $ques_ans1_hidden));
		$ques_ans2_array =(explode(',', $ques_ans2_hidden));
		
		$ques_ans3_array =(explode(',', $ques_ans3_hidden));
		$ques_ans4_array =(explode(',', $ques_ans4_hidden));
		
		$answer_array =(explode(',', $answer_hidden));
	

		$ques_ref_array =(explode(',', $ques_ref_hidden));
		
	
		$count=count($check_array);
		
			$count--;
			$posifeed=0;
			$negifeed=0;
			$already=0;
			$countaa=0;
		while($count>=0)
		{	
			$res=array();
			$check_box =isset($check_array[$count])?($check_array[$count]):"";
			
			if($check_box==1)
			{
				$question_name=isset($question_name_array[$count])?($question_name_array[$count]):"";
				$ques_ans1=isset($ques_ans1_array[$count])?($ques_ans1_array[$count]):"";
				$ques_ans2=isset($ques_ans2_array[$count])?($ques_ans2_array[$count]):"";
				$ques_ans3=isset($ques_ans3_array[$count])?($ques_ans3_array[$count]):"";
				$ques_ans4=isset($ques_ans4_array[$count])?($ques_ans4_array[$count]):"";
				$answer=isset($answer_array[$count])?($answer_array[$count]):"";
				$ques_ref=isset($ques_ref_array[$count])?($ques_ref_array[$count]):"";
				$ques_anss=array($ques_ans1,$ques_ans2 ,$ques_ans3,$ques_ans4);
				
				$sql = "SELECT ques_id from question_table WHERE ques_text = ? and org_id=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($question_name,$orgid));
				if($row = $query->fetch())
				{
					for($i=0;$i<=3;$i++)
					{
					$ques_id=$row->ques_id;
					$sql = "SELECT ques_id from answer_table WHERE answer_text = ? and ques_id=? ";
					$queryaa = $this->db->prepare($sql);
					$queryaa->execute(array($ques_anss[$i],$ques_id));
					$countaa =  $queryaa->rowCount();
					}
							if($countaa == 1)
							{
								$countaa++;
							}
							else if($count==0)
							{
								$sql = "INSERT INTO question_table (ques_text, LevelId, Reference, org_id, ques_type, created_date, CreatedById) VALUES (?,?,?,?,?,?,?)";
								$query = $this->db->prepare($sql);
								$query->execute(array($question_name, $lvlid, $ques_ref,$orgid,2,$mdate,$mid));
								$quesid=$this->db->lastinsertid();
								$count1 =  $query->rowCount();
								if($count1>=1)
								{
									for($i=0;$i<=3;$i++)
									{
										if(($i+1)==$answer)
											{
											$weightage=1;
											$sqlans = "INSERT INTO answer_table (ques_id, answert_type, answer_text, weightage, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?)";
											$queryans = $this->db->prepare($sqlans);
											$queryans->execute(array($quesid,$i+1,$ques_anss[$i],$weightage,$mdate,$mid));
											$countttt =  $queryans->rowCount();
											}
											else
											{
											$weightage=0;
											$sqlans = "INSERT INTO answer_table (ques_id, answert_type, answer_text, weightage, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?)";
											$queryans = $this->db->prepare($sqlans);
											$queryans->execute(array($quesid,$i+1,$ques_anss[$i],$weightage,$mdate,$mid));
											$countttt =  $queryans->rowCount();
											}
									}
								}
			
					if ($countttt == 1)
						{
							$posifeed++;
						}
						$result[]=$res;	
							}
					
				}
				
		else{
			$sql = "INSERT INTO question_table (ques_text, LevelId, Reference, org_id, ques_type, created_date, CreatedById) VALUES (?,?,?,?,?,?,?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($question_name, $lvlid, $ques_ref,$orgid,2,$mdate,$mid));
				$quesid=$this->db->lastinsertid();
				$count1 =  $query->rowCount();
				if($count1>=1)
				{
					for($i=0;$i<=3;$i++)
					{
						if(($i+1)==$answer)
							{
							$weightage=1;
							$sqlans = "INSERT INTO answer_table (ques_id, answert_type, answer_text, weightage, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?)";
							$queryans = $this->db->prepare($sqlans);
							$queryans->execute(array($quesid,$i+1,$ques_anss[$i],$weightage,$mdate,$mid));
							$countttt =  $queryans->rowCount();
							}
							else
							{
							$weightage=0;
							$sqlans = "INSERT INTO answer_table (ques_id, answert_type, answer_text, weightage, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?)";
							$queryans = $this->db->prepare($sqlans);
							$queryans->execute(array($quesid,$i+1,$ques_anss[$i],$weightage,$mdate,$mid));
							$countttt =  $queryans->rowCount();
							}
					}
				}
				
				
						if ($countttt == 1)
							{
								$posifeed++;
							}
					else {
								$negifeed++;
							}
	   
			$result[]=$res;	
		}
			}
				$count--;
		}
	
	
	
	
	
		if ($posifeed !=0) 
		{
			$_SESSION["feedback_positive"][] = $posifeed."  Questions  successfully imported";
		}
	else if ($negifeed !=0)  {
          $_SESSION["feedback_negative"][] = $negifeed."  Questions not imported";
        }
	else  if ($countaa !=0) 
					{
					$_SESSION["feedback_negative"][] = $countaa."  Already Exists";
					}
		
		return $result;
      
        
    }
	*/
	
	
	
	public function importQuestion($lvlid)
    {
		$result=array();
		$orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
        $mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		$mdate= date('Y-m-d h:i:s');
		$countttt=0;
		$check_hidden =isset($_POST['check_hidden'])?($_POST['check_hidden']):"";
		
		$question_name_hidden =isset($_POST['question_name_hidden'])?($_POST['question_name_hidden']):"";
		$ques_ans1_hidden =isset($_POST['ques_ans1_hidden'])?($_POST['ques_ans1_hidden']):"";
		$ques_ans2_hidden =isset($_POST['ques_ans2_hidden'])?($_POST['ques_ans2_hidden']):"";
		$ques_ans3_hidden =isset($_POST['ques_ans3_hidden'])?($_POST['ques_ans3_hidden']):"";
		$ques_ans4_hidden =isset($_POST['ques_ans4_hidden'])?($_POST['ques_ans4_hidden']):"";
		
	
		$answer_hidden =isset($_POST['answer_hidden'])?($_POST['answer_hidden']):"";
		$ques_ref_hidden =isset($_POST['ques_ref_hidden'])?($_POST['ques_ref_hidden']):"";
	
	
		$check_array =(explode(',', $check_hidden));
		$question_name_array =(explode(',', $question_name_hidden));
		$ques_ans1_array =(explode(',', $ques_ans1_hidden));
		$ques_ans2_array =(explode(',', $ques_ans2_hidden));
		
		$ques_ans3_array =(explode(',', $ques_ans3_hidden));
		$ques_ans4_array =(explode(',', $ques_ans4_hidden));
		
		$answer_array =(explode(',', $answer_hidden));
	

		$ques_ref_array =(explode(',', $ques_ref_hidden));
		
	
		$count=count($check_array);
		
			$count--;
			$posifeed=0;
			$negifeed=0;
		
			$countaa=0;
		while($count>=0)
		{	
			$res=array();
			$check_box =isset($check_array[$count])?($check_array[$count]):"";
			
			if($check_box==1)
			{
				$question_name=isset($question_name_array[$count])?($question_name_array[$count]):"";
				$ques_ans1=isset($ques_ans1_array[$count])?($ques_ans1_array[$count]):"";
				$ques_ans2=isset($ques_ans2_array[$count])?($ques_ans2_array[$count]):"";
				$ques_ans3=isset($ques_ans3_array[$count])?($ques_ans3_array[$count]):"";
				$ques_ans4=isset($ques_ans4_array[$count])?($ques_ans4_array[$count]):"";
				$answer=isset($answer_array[$count])?($answer_array[$count]):"";
				$ques_ref=isset($ques_ref_array[$count])?($ques_ref_array[$count]):"";
				$ques_anss=array($ques_ans1,$ques_ans2 ,$ques_ans3,$ques_ans4);
				
			$sql = "INSERT INTO question_table (ques_text, LevelId, Reference, org_id, ques_type, created_date, CreatedById) VALUES (?,?,?,?,?,?,?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($question_name, $lvlid, $ques_ref,$orgid,2,$mdate,$mid));
				$quesid=$this->db->lastinsertid();
				$count1 =  $query->rowCount();
				if($count1>=1)
				{
					for($i=0;$i<=3;$i++)
					{
						if(($i+1)==$answer)
							{
							$weightage=1;
							$sqlans = "INSERT INTO answer_table (ques_id, answert_type, answer_text, weightage, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?)";
							$queryans = $this->db->prepare($sqlans);
							$queryans->execute(array($quesid,$i+1,$ques_anss[$i],$weightage,$mdate,$mid));
							$countttt =  $queryans->rowCount();
							}
							else
							{
							$weightage=0;
							$sqlans = "INSERT INTO answer_table (ques_id, answert_type, answer_text, weightage, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?)";
							$queryans = $this->db->prepare($sqlans);
							$queryans->execute(array($quesid,$i+1,$ques_anss[$i],$weightage,$mdate,$mid));
							$countttt =  $queryans->rowCount();
							}
					}
				}
				
				
						if ($countttt == 1)
							{
								$posifeed++;
							}
					else {
								$negifeed++;
							}
	   
			$result[]=$res;	
		
			}
				$count--;
		}
	
	//////////////////// ACTIVITY LOG///////////////////////////////
			
			/* 	$msg="<b>$posifeed</b> questions has been imported ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Question Bank", $msg, $orgid));  */
			
	
	
	
	
		if ($posifeed !=0) 
		{
			$_SESSION["feedback_positive"][] = $posifeed."  Questions  successfully imported";
		}
	else if ($negifeed !=0)  {
          $_SESSION["feedback_negative"][] = $negifeed."  Questions not imported";
        }
	
		
		return $result;
      
        
    }
	
	
	
	
	
	
	
	
	
	
	
	
	public function getQuestionDetails()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
        //$mid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"1";
		//$mdate= date('Y-m-d h:i:s');
		$quesid = isset($_POST['quesid'])?$_POST['quesid']:'0';
        $sql = "SELECT * FROM question_table WHERE ques_id =? and org_id = ?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($quesid,$orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['ques_id'] =$row->ques_id;
				$res['ques_text'] =$row->ques_text;
				$res['Reference'] =$row->Reference;
				$res['levelid'] =$row->LevelId;
				$res['Attachment'] ='public/img/noimage.png';
				$res['lvlpath'] =Utils::getQuestionPathById($row->LevelId,$this->db);
				if($row->Attachment!=''){
					$res['Attachment'] ='uploads/question/'.$row->Attachment;
				}
				
				$sqlans = "SELECT * FROM answer_table WHERE ques_id =? order by answert_type asc";
				$queryans = $this->db->prepare($sqlans);
				$queryans->execute(array($res['ques_id']));
				$countans =  $queryans->rowCount();
				while($rowans = $queryans->fetch())
				{
					$res1 = array();
					$res1['id'] =$rowans->Id;
					$res1['Name'] =$rowans->answer_text;
					$res1['answert_type'] =$rowans->answert_type;
					$res1['answer'] =$rowans->weightage;
					$res['options'][]=$res1;
				}
				$data[] = $res;
			}
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	public function getlevelpath()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=true;
		$data = array();
		$orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"1";
		$lvlid = isset($_POST['lvlid'])?$_POST['lvlid']:'0';
		$lvlpath =Utils::getQuestionPathById($lvlid,$this->db);
		$result["data"] =$lvlpath;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	
    public function getAllQuizs()
    {
		$org_id=$_SESSION['user_org_id'];
        $sql = "SELECT quiz_id, test_id,  cat_id,quiz_status, quiz_ques, total_ques, total_time, total_marks, passing_score, negative_marking, negative_markingscore, created_date, modified_date,testtype FROM quiz_table where org_id=? order by test_id";
		
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['quiz_id'] = $row->quiz_id;
			$res['test_id'] = $row->test_id;
			$res['cat_id'] = $row->cat_id;
			$res['quiz_status'] = $row->quiz_status;
			$res['quiz_ques'] = $row->quiz_ques;
			$res['total_ques'] = $row->total_ques;
			$res['total_time'] = $row->total_time;
			$res['total_marks'] = $row->total_marks;
			$res['passing_score'] = $row->passing_score;
			$res['negative_marking'] = $row->negative_marking;
			$res['negative_markingscore'] = $row->negative_markingscore;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			$res['testtype'] = $row->testtype;
			$res['test_name']="";
			$res['cat_name'] ="";
			$sql1 = "SELECT test_name FROM test_category where test_id =:testid ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('testid'=>$row->test_id));
			while($name =  $query1->fetch()){
				$res['test_name'] = $name->test_name; 
			}
			$sql2 = "SELECT cat_name FROM test_category_child where cat_id =:catid ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array('catid'=>$row->cat_id));
			while($name1 =  $query2->fetch()){
				 $res['cat_name'] = $name1->cat_name; 
			}
			
			$res['totalques'] =0;
			$sql1 = "SELECT count(ques_id) as totalques,sum(marks) as totalmarks FROM question_table where cat_id =:catid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('catid'=>$row->cat_id));
			while($row1 = $query1->fetch()){
				$res['totalques'] = $row1->totalques;
				$res['totalmarks'] = $row1->totalmarks;
			}

			$result[] =$res;
		}
        return $result;
    }
	
	
	public function getAllRatingcriterias($testid=0)
    {
		try{
			$org_id=$_SESSION['user_org_id'];
			//echo $org_id;
			$sql = "SELECT * FROM criteria_table where test_id=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($testid));
			$result =array(); $data =array(); $status=false;
			$con=$query->rowCount();
			//echo $con;
			if($con>0)
			{
				
				while($row1 = $query->fetch())
				{
					//echo 'ok';
					$status=true;
					$res1=array();
					$res1['id'] = $row1->id;
					//print_r($res1['id']);
					$res1['minmarks'] = (int)$row1->criteria_from;
					$res1['maxmarks'] = (int)$row1->criteria_to;
					$res1['rating'] =(int) $row1->rating;
					$res1['result'] =$row1->Interpretation;
					$res1['desc'] =$row1->description;
					$result[] = $res1;
				}
			}
			else{
				
				$sql = "SELECT * FROM RatingCriteria where org_id=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($org_id));
				$result =array(); $data =array(); $status=false;
				while($row1 = $query->fetch())
				{
					$status=true;
					$res1=array();
					$res1['id'] = $row1->Id;
					$res1['minmarks'] = (int)$row1->MinMarks;
					$res1['maxmarks'] = (int)$row1->MaxMarks;
					$res1['rating'] =(int) $row1->Rating;
					$res1['result'] = $row1->Result;
					$res1['desc'] ="";
					$result[] =$res1;
				}	
			
			}
		}
		catch(Exception $e)
		{
		
		}
		$data['data']=$result;
		$data['status']=$status;
        return $data;
    }

	public function testname($cat_id)
	{
		$sql1 = "SELECT test_name FROM test_category where test_id =:catid ";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array('catid'=>$cat_id));
		while($name =  $query1->fetch()){
			
			$catname = $name->test_name; 
		}
		return $catname;
	}
	
	public function getAlltest($cat_id)
    {
        $sql = "SELECT * FROM quiz_table WHERE test_id=:cat_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':cat_id'=>$cat_id));

        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['quiz_id'] = $row->quiz_id;
			$res['test_id']="";
			$res['test_id'] = $row->test_id;
			$res['cat_id']="";
			$res['cat_id'] = $row->cat_id;
			$res['quiz_status'] = $row->quiz_status;
			$res['quiz_ques'] = $row->quiz_ques;
			$res['total_ques'] = $row->total_ques;
			$res['total_time'] = $row->total_time;
			$res['total_marks'] = $row->total_marks;
			$res['passing_score'] = $row->passing_score;
			$res['negative_marking'] = $row->negative_marking;
			$res['negative_markingscore'] = $row->negative_markingscore;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			$res['test_name']="";
			 $res['cat_name']="";
			$sql1 = "SELECT test_name FROM test_category where test_id =:testid ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('testid'=>$row->test_id));
			while($name =  $query1->fetch()){
				$res['test_name'] =isset($name->test_name)?$name->test_name:"" ; 
			}
			$sql2 = "SELECT cat_name FROM test_category_child where cat_id =:catid ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array('catid'=>$row->cat_id));
			while($name1 =  $query2->fetch()){
				 $res['cat_name'] =isset( $name1->cat_name)? $name1->cat_name:""; 
			}
			
			$res['totalques'] =0;
			$sql1 = "SELECT count(ques_id) as totalques FROM question_table where cat_id =:catid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('catid'=>$row->cat_id));
			while($row1 = $query1->fetch()){
				$res['totalques'] = $row1->totalques;
			}

			$result[] =$res;
		}
        return $result;
    }
	
	public function getAllCategorys($category_id)
    {
		$org_id=$_SESSION['user_org_id'];
		//echo $category_id;
		$sql = "SELECT * from test_category_child WHERE org_id=? and test_id in($category_id) ORDER BY cat_name ASC";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
		$result =array();
		/* echo'<option>--Select Category--<option>';  */
		while($row = $query->fetch())
		{	
	if($row->cat_name!=""){
			$res= array();
			$res['cat_name'] = $row->cat_name; 
			$res['cat_id'] = $row->cat_id;
			$res['category_id']=$category_id;
			$res['sts']=0;
		echo '<option value="'.$res['cat_id'].'">'.$res['cat_name'].'</option>';
			$result[] =$res;
	}
		}
		if(count($result)==0)
			echo '<option value="addnew">Add new Test paper</option>';
        // fetch() is the PDO method that gets a single result
        return $result ;
    }
	
	 public function getCatrgoryName()
    {
        $sql = "SELECT * from test_category_child ";
        $query = $this->db->prepare($sql);
        $query->execute();
		$result =array();
		/* echo'<option>--Select Category--<option>';  */
		while($row = $query->fetch())
		{	
			$res= array();
			$res['cat_name'] = $row->cat_name; 
			$res['cat_id'] = $row->cat_id;
			$result[] =$res;
		}
			
        // fetch() is the PDO method that gets a single result
        return $result;
    }
     public function getCatrgoryName1($cat_id=0)
    {
		$result =array();
		//$result="" ;
		$sql="";
		if($cat_id==0)
		{
		$sql = "SELECT * from test_category_child";
		}else{
        $sql = "SELECT * from test_category_child where cat_id=$cat_id";
		}
        $query = $this->db->prepare($sql);
        $query->execute(array());
		
		/* echo'<option>--Select Category--<option>';  */
		while($row = $query->fetch())
		{	
	if($row->cat_name!=""){
			$res= array();
			$res['cat_name'] = $row->cat_name; 
			$res['cat_id'] = $row->cat_id;
			$result[] =$res;
		}
		}
			
        // fetch() is the PDO method that gets a single result
        return $result ;
    }
	 public function getName($id,$table,$field,$where)
    {
		$name="";
        $sql = "select $field from $table where $where = ?";
        $query = $this->db->prepare($sql);
        $query->execute(array($id));
		while($row=$query->fetch())
		{
			$name=$row->$field;
		}

        return $name;
    }
    public function getQuiz($cat_id)
    {
		$org_id=$_SESSION['user_org_id'];
        $sql = "SELECT quiz_id, test_id, cat_id , quiz_status, quiz_ques, total_ques,total_time, total_marks, passing_score, negative_marking, negative_markingscore, created_date, modified_date,testtype from quiz_table WHERE cat_id = :cat_id and org_id=:org_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':cat_id' => $cat_id,':org_id' => $org_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
		
    }
	public function getQuizEdit($quiz_id)
    {
        $sql = "SELECT * from quiz_table WHERE quiz_id = :quiz_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':quiz_id' => $quiz_id));
		$result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['quiz_id'] = $row->quiz_id;
			$res['test_id'] = $row->test_id;
			$res['cat_id'] = $row->cat_id;
			$res['cat_name'] = $this->getName($row->cat_id,"test_category_child","cat_name","cat_id");
			$res['quiz_status'] = $row->quiz_status;
			$res['total_ques'] = $row->total_ques;
			$res['total_time'] = $row->total_time;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			$res['checkoverall'] = $row->checkoverall;
			$res['testtype'] = $row->testtype;
			$res['guideline'] = $row->guideline;
			$sql1 = "SELECT * FROM criteria_table where test_id =:quiz_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('quiz_id'=>$quiz_id));
			$crite=array();
			while($row1 =  $query1->fetch()){
				$res1=array();
				$res1['id'] = $row1->id;
				$res1['test_id'] = $row1->test_id;
				$res1['criteria_from'] = $row1->criteria_from;
				$res1['criteria_to'] = $row1->criteria_to;
				$res1['criteria_rating'] = $row1->rating;
				$res1['desc1'] = $row1->Interpretation;
				$crite[]=$res1;
			}
			$res['criteriaupdate']=$crite;
			 $result[] =$res;
		}	
        // fetch() is the PDO method that gets a single result
        return $result;
		
    }
    
    public function create()
    {
	$result=array();$count1=0; $count=0;
	// clean the input to prevent for example javascript within the groups.
	$category = isset($_POST['category']) ? $_POST['category'] : "";
	$test = isset($_POST['test']) ? $_POST['test'] : "";
	$testtype = isset($_POST['testtype']) ? $_POST['testtype'] : "";
	$question = isset($_POST['question']) ? $_POST['question'] : "";
	$time = isset($_POST['time']) ? $_POST['time'] : "";
	$checkoverall = isset($_POST['checkoverall']) ? $_POST['checkoverall'] : 0;
	$criteriavalue = isset($_POST['criteriavalue']) ? $_POST['criteriavalue'] : "";
	$editor1 = isset($_POST['editor1']) ? $_POST['editor1'] : "";
	$org_id=$_SESSION['user_org_id'];

	$mdate = date("Y-m-d H:i:s");
	
	/////////////Check Categroy already exit ////////
	$query = $this->db->prepare("SELECT * FROM test_category_child WHERE 	test_id=? and cat_name = ? ");
	$query->execute(array($category , $test));
	$count =  $query->rowCount();
	if ($count == 1) {
		$res=array();
		$res['status']=false;
		$res['msg'] ="This Test is already exist";
		$result[]=$res;
		return $result;
	}
	
	
   
		//////////////insert test paper child table//////////
		$sql1 = "INSERT INTO test_category_child (test_id,cat_name,  created_date, modified_date,org_id) VALUES (:test_id,:cat_id, :created_date, :modified_date, :orgid)";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array( ':test_id'=>$category, ':cat_id'=>$test, ':created_date'=>$mdate, ':modified_date'=>$mdate, ':orgid'=>$org_id));
		$count1 =  $query1->rowCount();
		$testpaperid=$this->db->lastinsertid();
		
		if ($count1 == 1) {
			$sql = "INSERT INTO quiz_table (test_id,cat_id, quiz_status,total_ques, total_time, created_date, modified_date,org_id,checkoverall,testtype,guideline) VALUES (:test_id,:cat_id, :quiz_status, :total_ques, :total_time, :created_date, :modified_date, :orgid, :checkoverall,:testtype,:editor1)";
			$query = $this->db->prepare($sql);
			$query->execute(array( ':test_id'=>$category, ':cat_id'=>$testpaperid, 	':quiz_status'=>1, ':total_ques'=>$question, ':total_time'=>$time, ':created_date'=>$mdate, ':modified_date'=>$mdate, ':orgid'=>$org_id, ':checkoverall'=>$checkoverall, ':testtype'=>$testtype,':editor1'=>$editor1));

			$count =  $query->rowCount();
			$test_id=$this->db->lastinsertid();
		
			if ($count == 1) {
				////////////////// insert criteria //////////////
				foreach($criteriavalue as $value)
				{
					$sql1="INSERT INTO criteria_table(test_id, criteria_from, criteria_to, rating, Interpretation, created_date,description)value(:test_id, :criteria_from, :criteria_to, :rating, :Interpretation, :created_date,:desc)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array(':test_id'=>$testpaperid, ':criteria_from'=>$value['minmarks'], ':criteria_to'=>$value['maxmarks'], ':rating'=>$value['rating'], ':Interpretation'=>$value['result'], ':created_date'=>$mdate, ':desc'=>$value['desc']));
					$count =  $query1->rowCount();
				}
				/////open for counting questions to open modal///////
				
				
				$sql1= "SELECT count(cat_id) as catid FROM question_table WHERE cat_id=:cat_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':cat_id'=>$test));
			$count1 =  $query1->rowCount();
			if($count1==1){
				$row1 = $query1->fetch();
				$res['status']=true;
				$countqun= $row1->catid;
			}
			
			
			//$_SESSION["feedback_positive"][] = FEEDBACK_TEST_ADDITION_SUCCESSFUL;

			$result['question']=$question;
			$result['countqun']=$countqun;
				
				/////close for counting questions to open modal///////
				$res['status']=true;
				$res['msg']=" Test paper added Successfully";
				//$_SESSION["feedback_positive"][] = FEEDBACK_TEST_ADDITION_SUCCESSFUL;
				$result[]=$res;
				$result['test']=$test;
				$result['testpaperid']=$testpaperid;
				return $result;
			} else {
				$res['status']=false;
				$res['msg']=" Test Addition Failed";
				$result[]=$res;
				return $result;
				//$_SESSION["feedback_negative"][] = FEEDBACK_TEST_ADDITION_FAILED;
			}
			  return false;
		 }
       
        // default return
       
    }


    public function editSave($quiz_id)
    {
        // clean the input to prevent for example javascript within the groups.
		try{
		$checkoverall = isset($_POST['checkoverall']) ? $_POST['checkoverall'] : 0;
	
	$result=array();$count1=0; $count=0;
	$category = isset($_POST['category']) ? $_POST['category'] : "";
	$test = isset($_POST['test']) ? $_POST['test'] : "";
	$testtype = isset($_POST['testtype']) ? $_POST['testtype'] : "";
	
	$test_id = isset($_POST['test_id']) ? $_POST['test_id'] : "";
	$question = isset($_POST['question']) ? $_POST['question'] : "";
	$time = isset($_POST['time']) ? $_POST['time'] : "";
	$criteriavalue = isset($_POST['criteriavalue']) ? $_POST['criteriavalue'] : "";
	$guideline = isset($_POST['editor1']) ? $_POST['editor1'] : "";
	$mdate = date("Y-m-d H:i:s");
	/////////////!Check Categroy already exit ////////   
	$query = $this->db->prepare("SELECT * FROM test_category_child WHERE 	test_id=? and cat_name = ? and cat_id<>?");
	$query->execute(array($category , $test , $test_id ));
	$count =  $query->rowCount();
	if ($count == 1) {
		$res=array();
		$res['status']=false;
		$res['msg'] ="This Test is already exist";
		$result[]=$res;
		return $result;
	}else{
		
	
	/* $query = $this->db->prepare("SELECT quiz_id FROM quiz_table WHERE cat_id= :cat_id and quiz_id!=$quiz_id");
	$query->execute(array(':cat_id' => $test ));
	$count =  $query->rowCount();
	if ($count == 1) {
		$res=array();
		$res['status']=false;
		$res['msg'] ="This Test is already exist";
		$result[]=$res;
		return $result;
	} */
	$sql = "update test_category_child set test_id=:test_id, cat_name=:cat_name , modified_date=:modified_date where cat_id=:cat_id";
    $query = $this->db->prepare($sql);
    $query->execute(array( ':test_id'=>$category, ':cat_name'=>$test, ':modified_date'=>$mdate, ':cat_id'=>$test_id));
    $count =  $query->rowCount();
	if ($count == 1) {
		$sql = "update quiz_table set test_id=:test_id, cat_id=:cat_id,  total_ques=:total_ques, total_time=:total_time, modified_date=:modified_date, checkoverall=:checkoverall, testtype=:testtype,guideline=:guideline where quiz_id=:quiz_id";
        $query1 = $this->db->prepare($sql);
        $query1->execute(array( ':test_id'=>$category, ':cat_id'=>$test_id, ':total_ques'=>$question,':total_time'=>$time, ':modified_date'=>$mdate, ':quiz_id'=>$quiz_id,':checkoverall'=>$checkoverall,':guideline'=>$guideline,':testtype'=>$testtype));
        $count =  $query1->rowCount();
		$id='0';
        if ($count == 1) {
		
			$sql2="delete from criteria_table  where  test_id=:quiz_id";
			$query2= $this->db->prepare($sql2);
			$query2->execute(array(':quiz_id' =>$test_id));
			foreach($criteriavalue as $value)
			{
				//if($value['id']==0)
				//{
				$sql1="INSERT INTO criteria_table(test_id, criteria_from, criteria_to, rating, Interpretation, description, created_date) value (?,?,?,?,?,?,?)";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($test_id, $value['minmarks'],$value['maxmarks'], $value['rating'], $value['result'], $value['desc'], $mdate));
				//}
				/* else{
					$sql4="UPDATE criteria_table SET test_id = :test_id , criteria_from = :criteria_from, criteria_to=:criteria_to , rating=:rating, Interpretation=:Interpretation,desc=:desc WHERE id = :id";
					$query4 = $this->db->prepare($sql4);
				
					$query4->execute(array(':test_id'=>$quiz_id,':criteria_from'=>$value['minmarks'], ':criteria_to'=>$value['maxmarks'], ':rating'=>$value['rating'], ':Interpretation'=>$value['result'], ':desc'=>$desc,':id' =>$value['id']));
					 $count =  $query4->rowCount();
				} */
			
			}
			$sql1= "SELECT count(cat_id) as catid FROM question_table WHERE cat_id=:cat_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':cat_id'=>$test));
			$count1 =  $query1->rowCount();
			if($count1==1){
				$row1 = $query1->fetch();
				$res['status']=true;
				$countqun= $row1->catid;
			}
			$res['status']=true;
			$res['msg']=" Test details updated Successfully";
			//$_SESSION["feedback_positive"][] = FEEDBACK_TEST_ADDITION_SUCCESSFUL;
			$result[]=$res;
			$result['question']=$question;
			$result['countqun']=$countqun;
			$result['test']=$test;
			return $result;
		} else {
            $res['status']=false;
			$res['msg']="Test updation Failed";
			$result[]=$res;
            return $result;
        }
        // default return
        //return false;
	}else{
		$res['status']=false;
			$res['msg']="Problem while updating";
			$result[]=$res;
            return $result;
	}
	}
		}catch(Exception $e){
			$res['status']=false;
			$res['msg']=$e->getMessage();
			$result[]=$res;
            return $result;
		}	
		
}

   
    public function delete($quiz_id)
    {
		$sql1 = "SELECT * from quiz_table where quiz_id=$quiz_id ";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array());
		$testpaperid=0;
		if($row1 = $query1->fetch()){
			$testpaperid=$row1->cat_id;		 
		}
		$sql3 = "SELECT * from test_attempt where test_id=$testpaperid ";
        $query3 = $this->db->prepare($sql3);
        $query3->execute();
		$count3 =  $query3->rowCount();
			
			//if(true)
			if($count3==0)
			{
			$sql2 = "DELETE FROM test_category_child WHERE cat_id = $testpaperid";
		
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array());

			$count =  $query2->rowCount();
			
     
	   

		
	
        if ($count == 1) {
			
			$sql = "DELETE FROM quiz_table WHERE quiz_id = :quiz_id";
			$query = $this->db->prepare($sql);
			$query->execute(array(':quiz_id' => $quiz_id));
			$count =  $query->rowCount();
			if($count==1){
			$_SESSION["feedback_positive"][] = FEEDBACK_TEST_DELETION_SUCCESSFUL;
            return true;
			}else{
				  $_SESSION["feedback_negative"][] = FEEDBACK_TEST_DELETION_FAILED;
			}

        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_TEST_DELETION_FAILED;
        }
		}
		else
		{
			 $_SESSION["feedback_negative"][] = "This test paper can not be deleted as it is already assigned to a candidate.";
		}
        // default return
        return false;
    }
    
    public function changestatus($quiz_id, $status)
    {
		$status = ($status==1)?0:1;
        $sql = "update quiz_table set quiz_status=:sts WHERE quiz_id = :quiz_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':quiz_id' => $quiz_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_TEST_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_TEST_CHANGE_STATUS_FAILED;
        }
        // default return
        return false;
    }
}
