<?php

/**
 * QuestionModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class QuestionModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getAllQuestions($id)
    {
		$org_id=$_SESSION['user_org_id'];
        $sql = "SELECT * FROM question_table where cat_id=? and org_id=?";
        $query = $this->db->prepare($sql);
        $query->execute(array($id, $org_id));
		$result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['ques_id'] = $row->ques_id;
			$res['ques_type'] = $row->ques_type;
			$res['ques_text'] = $row->ques_text;
			$res['ques_status'] = $row->ques_status;
			$res['cat_id'] = $row->cat_id;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			$res['ques_title'] = $row->ques_title;
			$res['quiz_name'] ="";
			$res['ques_type_name'] = "";
			$res['marks'] = $row->marks;
			if($row->ques_type==1)
				$res['ques_type_name'] = "Descriptive";
			else if($row->ques_type==2)
				$res['ques_type_name'] = "Multiple Choice";
			else if($row->ques_type==3)
				$res['ques_type_name'] = "True/false";	
			else if($row->ques_type==4)
				$res['ques_type_name'] = "Fill-in-the-blank";	
			else if($row->ques_type==5)
				$res['ques_type_name'] = "Indicative";			
			
			
			$sql1 = "SELECT cat_name FROM test_category_child where cat_id =:catid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('catid'=>$row->cat_id));
			while($row1 = $query1->fetch()){
				$res['cat_name'] = $row1->cat_name;
			}
			$result[] =$res;
		}
		return $result;
    }
    
    public function getAllQuizQues($cat_id)
    {
        $sql = "SELECT *  FROM question_table where cat_id=:cat_id";
        $query = $this->db->prepare($sql);
        $query->execute(array('cat_id'=>$cat_id));
		$result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['ques_id'] = $row->ques_id;
			$res['ques_type'] = $row->ques_type;
			$res['ques_text'] = $row->ques_text;
			$res['ques_status'] = $row->ques_status;
			$res['cat_id'] = $row->cat_id;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			$res['ques_title'] = $row->ques_title;
			$res['quiz_name'] ="";
			$res['ques_type_name'] = "";
			$res['marks'] = $row->marks;
			if($row->ques_type==1)
				$res['ques_type_name'] = "Descriptive";
			else if($row->ques_type==2)
				$res['ques_type_name'] = "Multiple Choice";
			else if($row->ques_type==3)
				$res['ques_type_name'] = "True/false";	
			else if($row->ques_type==4)
				$res['ques_type_name'] = "Fill-in-the-blank";	
			else if($row->ques_type==5)
				$res['ques_type_name'] = "Indicative";			
			
			
			$sql1 = "SELECT ques_id, answert_type, answer_text,answer_status,weightage from answer_table where ques_id=:ques_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':ques_id'=>$row->ques_id));
			
			$res['options'] =array();
			while($row1 = $query1->fetch())
			{
				$res1= array();
				$res1['ques_id'] = $row1->ques_id;
				$res1['answer_type'] = $row1->answert_type;
				$res1['answer_status'] = $row1->answer_status;
				$res1['weightage'] = $row1->weightage;
				$res1['answer_text'] = html_entity_decode($row1->answer_text);
				$res['options'][]=$res1;
			}
			
			
			$result[] =$res;
		}
		return $result;
    }
    public function getQuestion($ques_id)
    {
        $sql = "SELECT * FROM question_table WHERE ques_id = :ques_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':ques_id' => $ques_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }
	 public function getQuestionAll()
    {
		$org_id=$_SESSION['user_org_id'];
        $sql = "SELECT * FROM question_table where ques_status=1 and org_id=?";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
		$result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['ques_id'] = $row->ques_id;
			$res['ques_type'] = $row->ques_type;
			$res['ques_text'] = $row->ques_text;
			$res['ques_status'] = $row->ques_status;
			$res['cat_id'] = $row->cat_id;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			$res['ques_title'] = $row->ques_title;
			$res['marks'] = $row->marks;
			
			$result[] =$res;
		}
		return $result;
    }
    
    public function getAnswers($ques_id)
    {
        $sql = "SELECT * FROM answer_table WHERE ques_id = :ques_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':ques_id' => $ques_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetchAll();
    }
    public function getQuizQuestion($cat_id)
    {
        $sql = "SELECT cat_id FROM question_table WHERE cat_id = :cat_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':cat_id' => $cat_id));
		// fetch() is the PDO method that gets a single result
        return $query->fetchAll();
    }



public function resizeAvatarImage(
        $source_image, $destination_filename, $width = 150, $height = 150, $quality = 85, $crop = true)
    {
        $image_data = getimagesize($source_image);
        if (!$image_data) {
            return false;
        }

        // set to-be-used function according to filetype
        switch ($image_data['mime']) {
            case 'image/gif':
                $get_func = 'imagecreatefromgif';
                $suffix = ".gif";
            break;
            case 'image/jpeg';
                $get_func = 'imagecreatefromjpeg';
                $suffix = ".jpg";
            break;
            case 'image/png':
                $get_func = 'imagecreatefrompng';
                $suffix = ".png";
            break;
        }

        $img_original = call_user_func($get_func, $source_image );
        $old_width = $image_data[0];
        $old_height = $image_data[1];
        $new_width = $width;
        $new_height = $height;
        $src_x = 0;
        $src_y = 0;
        $current_ratio = round($old_width / $old_height, 2);
        $desired_ratio_after = round($width / $height, 2);
        $desired_ratio_before = round($height / $width, 2);

        if ($old_width < $width OR $old_height < $height) {
             // the desired image size is bigger than the original image. Best not to do anything at all really.
            return false;
        }

        // if crop is on: it will take an image and best fit it so it will always come out the exact specified size.
        if ($crop) {
            // create empty image of the specified size
            $new_image = imagecreatetruecolor($width, $height);

            // landscape image
            if ($current_ratio > $desired_ratio_after) {
                $new_width = $old_width * $height / $old_height;
            }

            // nearly square ratio image
            if ($current_ratio > $desired_ratio_before AND $current_ratio < $desired_ratio_after) {

                if ($old_width > $old_height) {
                    $new_height = max($width, $height);
                    $new_width = $old_width * $new_height / $old_height;
                } else {
                    $new_height = $old_height * $width / $old_width;
                }
            }

            // portrait sized image
            if ($current_ratio < $desired_ratio_before) {
                $new_height = $old_height * $width / $old_width;
            }

            // find ratio of original image to find where to crop
            $width_ratio = $old_width / $new_width;
            $height_ratio = $old_height / $new_height;

            // calculate where to crop based on the center of the image
            $src_x = floor((($new_width - $width) / 2) * $width_ratio);
            $src_y = round((($new_height - $height) / 2) * $height_ratio);
        }
        // don't crop the image, just resize it proportionally
        else {
            if ($old_width > $old_height) {
                $ratio = max($old_width, $old_height) / max($width, $height);
            } else {
                $ratio = max($old_width, $old_height) / min($width, $height);
            }

            $new_width = $old_width / $ratio;
            $new_height = $old_height / $ratio;
            $new_image = imagecreatetruecolor($new_width, $new_height);
        }

        // create avatar thumbnail
        imagecopyresampled($new_image, $img_original, 0, 0, $src_x, $src_y, $new_width, $new_height, $old_width, $old_height);

        // save it as a .jpg file with our $destination_filename parameter
        imagejpeg($new_image, $destination_filename, $quality);

        // delete "working copy" and original file, keep the thumbnail
        imagedestroy($new_image);
        imagedestroy($img_original);

        if (file_exists($destination_filename)) {
            return true;
        }
        // default return
        return false;
    }
    
    
    public function create($cat_id)
    {
        // clean the input to prevent for example javascript within the groups.
		
		$ques_type = isset($_POST['qtype']) ? ($_POST['qtype']):"";
		$ques_title = isset($_POST['questitle']) ? ($_POST['questitle']):"";
		$ques_text = isset($_POST['temp_text']) ? ($_POST['temp_text']):"";
		$marks = isset($_POST['marks']) ? ($_POST['marks']):"";
		$filests = isset($_POST['filests']) ? ($_POST['filests']):"";
		$org_id=$_SESSION['user_org_id'];
		
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		$sql2 = "select coalesce(max(ques_id), 0) as maxid from question_table";
        $query2 = $this->db->prepare($sql2);
        $query2->execute();
        $row1 = $query2->fetch();
        $quesid =$row1->maxid+1;
		
        $sql = "INSERT INTO question_table (ques_id, ques_type, ques_text, cat_id, created_date, modified_date, ques_title, org_id ,marks,filests) VALUES (:ques_id, :ques_type, :ques_text, :cat_id, :cdate, :mdate, :ques_title, :org_id,:marks,:filests)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':ques_id' => $quesid,':ques_type' => $ques_type,  ':ques_text' => $ques_text, ':cat_id'=>$cat_id,':cdate'=>$mdate, ':mdate'=>$mdate,':ques_title' => $ques_title, ':org_id' => $org_id, ':marks' => $marks, ':filests' => $filests  ));

        $count =  $query->rowCount();
        
        if(isset($_POST['anstext'])){
			$ans = $_POST['ans'];
			$wt = $_POST['wt'];
			$ind=0;
			foreach($_POST['anstext'] as $value){
				
				$sql1 = "INSERT INTO answer_table (ques_id, answert_type, answer_text, weightage, answer_status) VALUES (:ques_id, :answert_type, :answer_text,:wt , :answer_status)";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':ques_id' => $quesid, ':answert_type'=>($ind+1), ':answer_text' => $value, ":wt"=>$wt[$ind], ':answer_status' =>$ans[$ind]));
				++$ind;
			}
		}
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_QUESTION_ADDITION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_QUESTION_ADDITION_FAILED;
        }
        // default return
        return false;
    }



    public function editSave($ques_id)
    {
        // clean the input to prevent for example javascript within the groups.
        //$quiz_id = strip_tags($_POST['quiz_name']);
		$ques_type = isset($_POST['qtype']) ? ($_POST['qtype']):"";
		$ques_title = isset($_POST['questitle']) ? ($_POST['questitle']):"";
		$ques_text = isset($_POST['temp_text']) ? ($_POST['temp_text']):"";
		$marks = isset($_POST['marks']) ? ($_POST['marks']):"";
		$filests = isset($_POST['filests']) ? ($_POST['filests']):"";
		
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		
		$sql = "update question_table set ques_type=:ques_type, ques_text=:ques_text, modified_date=:mdate, ques_title=:ques_title, marks=:marks,filests=:filests where ques_id=:ques_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':ques_type' => $ques_type, ':ques_text' => $ques_text, ':mdate'=>$mdate, ':ques_title' => $ques_title, ':marks' => $marks, ':filests' => $filests, ':ques_id' => $ques_id));
        $count =  $query->rowCount();
	
        if(isset($_POST['anstext'])){
			$sql1 = "DELETE FROM answer_table WHERE ques_id = :ques_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':ques_id' => $ques_id));
			$wt = $_POST['wt'];
			$ans = $_POST['ans'];
			$ind=0;
			foreach($_POST['anstext'] as $value){
				
			  $sql1 = "INSERT INTO answer_table (ques_id, answert_type, answer_text,weightage, answer_status) VALUES (:ques_id, :answert_type, :answer_text,:wt , :answer_status)";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':ques_id' => $ques_id, ':answert_type'=>($ind+1), ':answer_text' => $value, ":wt"=>$wt[$ind], ':answer_status' =>($ans[$ind])));
				++$ind;
			  
			}
		}
		
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_QUESTION_EDITING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_QUESTION_EDITING_FAILED;
        }
        // default return
        return false;
    }
    
    
    public function delete($ques_id)
    {
	$sql2="SELECT test_id from test_attempt WHERE test_id IN (SELECT quiz_id from quiz_attempt_ques WHERE ques_id = :ques_id )";
	$query2 = $this->db->prepare($sql2);
    $query2->execute(array(':ques_id' => $ques_id));
    $count1 =  $query2->rowCount();
     if($count1 >= 1)
    {
	$_SESSION["feedback_negative"][] = "Question cannot be deleted because it is already attemped by someone ";
	return true;
     }else{
		$sql = "DELETE FROM question_table WHERE ques_id = :ques_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':ques_id' => $ques_id));
        
        $sql1 = "DELETE FROM answer_table WHERE ques_id = :ques_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array(':ques_id' => $ques_id));
        
        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_QUESTION_DELETION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_QUESTION_DELETION_FAILED;
        }
        // default return
        return false;
}
    }
    
    public function changestatus($ques_id, $status)
    {
		$status = ($status==1)?0:1;
        $sql = "update question_table set ques_status=:sts WHERE ques_id = :ques_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':ques_id' => $ques_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_QUESTION_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_QUESTION_CHANGE_STATUS_FAILED;
        }
        // default return
        return false;
    }
}
