<?php

/**
 * CourseModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class PageModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

	public function getPositionlabel($page_id) {
		try{	
		
			$result = array();
			$count=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$org_id=$_SESSION['user_org_id'];
			
			$sql = "SELECT * FROM pagedetail WHERE pageid  = ? and org_id=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($page_id,$org_id));
				
			while($row = $query->fetch()){ 
				$status=true;
				$res= array();
				$res['pageid'] = $row->pageid;
				$res['idValue'] = $row->idValue;
				$res['content'] = $row->content;
				$res['create_date'] = $row->modified_date	;
				$res['modified_date'] = $row->modified_date;
				$data[] =$res;
			}
		}catch(Exception $e){}
		$result["data"] =$data;
		$result['status']=$status;
		return $result;
    }
	
	
	public function getlabelvalue($request) {
		try{	
		
			$result = array();
			$count=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$org_id=$_SESSION['user_org_id'];
			
			$sql = "SELECT * FROM pagedetail WHERE pageid  = ? and idValue=? and org_id=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[1],$request[2],$org_id));
				
			while($row = $query->fetch()){
				$status=true;
				$res= array();
				$res['pageid'] = $row->pageid;
				$res['idValue'] = $row->idValue;
				$res['content'] = $row->content;
				$res['modified_date'] = $row->modified_date;
				$data[] =$res;
			}
		}catch(Exception $e){}
		$result["data"] =$data;
		$result['status']=$status;
		return $result;
    }
    
	
  
    public function Createlabel($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$org_id=$_SESSION['user_org_id'];
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "SELECT * FROM pagedetail WHERE pageid  = ? and idValue=? and org_id=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($request[1],$request[2],$org_id));
		$count =  $query->rowCount();
		if($count==0){
			$sql = "INSERT INTO pagedetail(pageid, idValue, content, org_id,  modified_date) VALUES (?,?,?,?,?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[1], $request[2],$request[3],$org_id,$mdate));
			$count =  $query->rowCount();	
		}else{
			$sql = "UPDATE pagedetail SET  content=? , modified_date =? WHERE pageid  = ? and idValue=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[3],$mdate,$request[1], $request[2],  ));$count =  $query->rowCount();
		}
		if ($count == 1) {
			$status =true;
			$successMsg = "Label Update Successfully";
		} else {
			$status =false;
			$errorMsg= "Some problem to update record";
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
}

?>