<?php

/**
 * UserModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class LoanccModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function create()
    {
		$count1=0;$count=0;
		$org_id=$_SESSION['user_org_id'];
		$userid=$_SESSION['user_id'];
        // clean the input to prevent for example javascript within the groups.
		$code = $_POST['code'];
		$name =$_POST['name'];
		$description =$_POST['description'];
		$date=date('Y-m-d h:i:s a');
		
		$sql1 = "SELECT * FROM loan_cc WHERE loancc_code=:code and org_id=:org_id";
        $query1 = $this->db->prepare($sql1);
		$query1->execute(array( ':code'=>$code,  ':org_id'=>$org_id));
		
		$sql2 = "SELECT * FROM loan_cc WHERE loancc_name=:name and org_id=:org_id";
        $query2 = $this->db->prepare($sql2);
        $query2->execute(array( ':name' =>$name, ':org_id'=>$org_id));

	   $count1 =  $query1->rowCount();
	   $count2 =  $query2->rowCount();
		if($count1>=1){
			 $res["status"]=false;		
				$res["errorMsg"]="Loan CC Code already exists ";
			
		}else if($count2>=1){
			$res["status"]=false;		
				$res["errorMsg"]="Loan CC Name already exists ";

		}else
		{
        $sql = "INSERT INTO loan_cc (loancc_code, loancc_name,Description, created_date, CreatedById, org_id) VALUES (:code, :name,:description, :createddate, :uid,:org_id)";
        $query = $this->db->prepare($sql);
        $query->execute(array( ':code'=>$code, ':name' =>$name,':description' =>$description, ':createddate' => $date, ':uid'=>$userid,':org_id'=>$org_id));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$res['status']=true;		
				$res['successMsg']="Loan CC created successfully";
			
        } else {
           $res['status']=false;		
				$res['errorMsg']="Loan CC not created ";
        }
		
		}
		
		$data[]=$res;
		//print_r($data);
        // default return
        return $data;
    }
	
	 public function update()
    {
		$count1=0;$count=0;
		$org_id=$_SESSION['user_org_id'];
		$userid=$_SESSION['user_id'];
        // clean the input to prevent for example javascript within the groups.
		$code = $_POST['code'];
		$name =$_POST['name'];
		$description =$_POST['description'];
		$lc_id =$_POST['lc_id'];
		$date=date('Y-m-d h:i:s a');
		
		$sql1 = "SELECT * FROM loan_cc WHERE Id!=:lc_id and loancc_code=:code and org_id=:org_id";
        $query1 = $this->db->prepare($sql1);
		$query1->execute(array(':lc_id' =>$lc_id ,':code'=>$code, ':org_id' =>$org_id));
		
		$sql2 = "SELECT * FROM loan_cc WHERE Id!=:lc_id and loancc_name=:name and org_id=:org_id";
        $query2 = $this->db->prepare($sql2);
        $query2->execute(array(':lc_id' =>$lc_id ,':name' =>$name, ':org_id' =>$org_id));

	   $count1 =  $query1->rowCount();
	   $count2 =  $query2->rowCount();
		if($count1>=1){
			 $res["status"]=false;		
				$res["errorMsg"]="Loan CC Code already exists ";
			
		}else if($count2>=1){
			$res["status"]=false;		
				$res["errorMsg"]="Loan CC Name already exists ";

		}else
		{
    $sql = "UPDATE loan_cc SET loancc_code=:code,loancc_name=:name,Description=:description, modified_date=:modified_date,LastModifiedById=:uid,org_id=:org_id WHERE Id=$lc_id ";
        $query = $this->db->prepare($sql);
        $query->execute(array( ':code'=>$code, ':name' =>$name,':description' =>$description, ':modified_date' => $date, ':uid'=>$userid,':org_id'=>$org_id));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$res['status']=true;		
				$res['successMsg']="Loan CC Updated successfully";
			
        } else {
           $res['status']=false;		
				$res['errorMsg']="Loan CC not updated ";
        }
		
		}
		
		$data[]=$res;
		//print_r($data);
        // default return
        return $data;
    }
	
	 public function delete($lc_id)
    {
		$count1=0;
		$org_id=$_SESSION['user_org_id'];
		
		$sql1 = "SELECT * FROM candidate_table WHERE Loan_CC=$lc_id and org_id=$org_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array());

      $count1 =  $query1->rowCount();
		if($count1>=1){
			 $data["status"]=false;		
				$data["errorMsg"]="This Loan CC is used for candidate ";
			
		}
		else
		{
    $sql = "DELETE FROM `loan_cc` WHERE Id=$lc_id and org_id=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute(array());

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$data['status']=true;		
				$data['successMsg']="Loan CC deleted successfully";
			
        } else {
           $data['status']=false;		
				$data['errorMsg']="Loan CC not deleted ";
        } 
		
	}
		
		
        return $data;
    }

public function getloancc($editper,$deleteper)
    {
		$org_id=$_SESSION['user_org_id'];
		$edit_per=$editper;
		$delete_per=$deleteper;
	$sql = "SELECT * FROM loan_cc WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['code'] = $row->loancc_code;
		   $res['name'] = $row->loancc_name;
		   $res['description'] = $row->Description;
		   $res['lc_id'] = $row->Id;
		   $edit=""; $delete="";
		   if($edit_per){
		      $edit="<a rel='tooltip' title='Edit'  onclick='angular.element(this).scope().onfetchdata(".$row->Id.")'  href='#' data-original-title='Edit' class='label bg-green'><i class='fa fa-edit'></i></a>&nbsp;&nbsp;&nbsp;&nbsp;";
			} 
			if($delete_per){
			   $delete="<a rel='tooltip' title='Delete' onclick='angular.element(this).scope().onfetchfordelete(\"".$row->Id."\")' data-toggle='modal' data-target='#confirm' href='#' data-original-title='Delete' class='label bg-red'><i class='fa fa-trash-o'></i></a>";
			}
			$res['action']=$edit.$delete;
		   $data[]=$res;
	   }
	   $d['data']=$data;  	
	   //echo json_encode($d); 
	   return $d;
    }

 public function getallloancc($id)
    {
		$org_id=$_SESSION['user_org_id'];
	
	$sql = "SELECT * FROM loan_cc WHERE org_id=$org_id and Id='$id'";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['code'] = $row->loancc_code;
		   $res['name'] = $row->loancc_name;
		   $res['description'] = $row->Description;
		   $res['lc_id'] = $row->Id;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
}
