<?php

/**
 * LesionModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class LesionModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getAllLesions()
    {
        $sql = "SELECT course_id, lession_id, lession_name, lession_status, create_date, modified_date, duration FROM lession_table";
        $query = $this->db->prepare($sql);
        $query->execute();
		$result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['course_id'] = $row->course_id;
			$res['lession_id'] = $row->lession_id;
			$res['lession_name'] = $row->lession_name;
			$res['lession_status'] = $row->lession_status;
			$res['create_date'] = $row->create_date;
			$res['duration'] = $row->duration;
			$res['modified_date'] = $row->modified_date;
			$res['course_name']="";
			
			$sql1 = "SELECT course_name FROM course_table where course_id =:courseid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('courseid'=>$row->course_id));
			while($name =  $query1->fetch())
			{
				$res['course_name'] = $name->course_name;
			}
			$result[] =$res;
		}
      
        return $result;
    }

    public function getLesion($lession_id)
    {
        $sql = "SELECT * FROM lession_table WHERE lession_id = :lession_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':lession_id' => $lession_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }
    public function getCourseLesion2($course_id)
    {
		$result =array();
		$sql = "SELECT lession_name, lession_id FROM lession_table WHERE course_id = :course_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_id' => $course_id));
        while($row =  $query->fetch())
			{
				$res =array();
				$res['lession_id'] = $row->lession_id;
				$res['lession_name'] = $row->lession_name;
				$result[] = $res;
			}
        // fetch() is the PDO method that gets a single result
        return $result;
    }
    public function getCourseLesion($course_id)
    {
		$result =array();
		$sql = "SELECT lession_name, lession_id FROM lession_table WHERE course_id = :course_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_id' => $course_id));
       
        return $query->fetchAll();
    }
    
    public function getLesionFeedback($lesion_id)
    {
		$result =array();
		$sql = "SELECT * FROM feed_back where id=:lesion_id and feed_type='LESION'";
        $query = $this->db->prepare($sql);
        $query->execute(array(':lesion_id' => $lesion_id));
		while($row =  $query->fetch())
			{
				$res =array();
				$res['feedback'] = $row->feedback;
				$res['student_name'] = self::getStudentName($row->stud_id);
				$res['feedback_date'] = $row->created_date;
				$result[] = $res;
			}
        return $result;
    }
    public function getStudentName($stud_id)
    {
        $sql = "SELECT * FROM student_table where stud_id=:stud_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':stud_id'=>$stud_id));        
        $result ="";
        while($row = $query->fetch())
        {
			$result=ucwords(strtolower($row->stud_fname." ".$row->stud_lname));
		}
		
		return $result;
	}
    
    public function create()
    {
        // clean the input to prevent for example javascript within the groups.
         $course_id = strip_tags($_POST['course_name']);
        $lession_name = strip_tags($_POST['lesion_name']);
         $lesion_duration = strip_tags($_POST['lesion_duration']);
		$short_desc = htmlspecialchars($_POST['short_desc']);
		$long_desc = htmlspecialchars($_POST['long_desc']);
		$attype = "";//strip_tags($_POST['attach_type']);
		//$prerequisite = strip_tags($_POST['prerequisite']);
		$mdate = date("Y-m-d H:i:s");
		$filename ="";
		$prerequisite ="";
         if(isset($_POST['pre'])){
			foreach($_POST['pre'] as $value){
				if($prerequisite=="")
					$prerequisite=$value;
				else
					$prerequisite .= ",".$value;
			}
		}
		
		if (!empty($_FILES['fileToUpload']['tmp_name']) ) {
			$target_dir = "public/uploads/lesion_files/";
			$path = $_FILES['fileToUpload']['name'];
			$ext = pathinfo($path, PATHINFO_EXTENSION);
			$attype =$ext;
			$filename =  mt_rand(1000, 9999).round(microtime(true) * 1000).".".$ext;
			$target_file = $target_dir .$filename;
			
			if (!is_dir($target_dir) OR !is_writable($target_dir)) {
				$_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_FOLDER_DOES_NOT_EXIST_OR_NOT_WRITABLE;
				return false;
			}
			// if input file too big (>5MB)
			if ($_FILES['fileToUpload']['size'] > 5000000 ) {
				$_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_TOO_BIG;
				return false;
			}
			 if (move_uploaded_file($_FILES["fileToUpload"]["tmp_name"], $target_file)) {
				$_SESSION["feedback_positive"][] = "The file ". $target_file. " has been uploaded.";
			} else {
				$_SESSION["feedback_negative"][] = "Sorry, there was an error uploading your file.";
				return false;
			}
			
			 
		}
		
        $sql = "INSERT INTO lession_table (course_id, attach_type, attach, lession_name, short_desc, long_desc, lession_status, create_date, modified_date, duration, prerequisite) VALUES (:course_id, :atype, :attach, :lession_name, :short_desc, :long_desc, :csts, :cdate, :mdate, :duration, :prerequisite)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_id'=>$course_id, ':atype'=>$attype, ':attach'=>$filename, ':lession_name' => $lession_name, ':short_desc' => $short_desc, ':long_desc' => $long_desc, ':csts'=>1, ':cdate'=>$mdate, ':mdate'=>$mdate, ':duration'=>$lesion_duration,':prerequisite'=>$prerequisite));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][] =FEEDBACK_LESION_ADDITION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_LESION_ADDITION_FAILED;
        }
        // default return
        return false;
    }

  
    public function editSave($lession_id)
    {
        // clean the input to prevent for example javascript within the groups.
        $course_id = strip_tags($_POST['course_name']);
        $lession_name = strip_tags($_POST['lesion_name']);
		$short_desc = htmlspecialchars($_POST['short_desc']);
		$long_desc = htmlspecialchars($_POST['long_desc']);
		$attype = "";//strip_tags($_POST['attach_type']);
		//$prerequisite = strip_tags($_POST['prerequisite']);
        $lesion_duration = strip_tags($_POST['lesion_duration']);
        $prerequisite ="";
         if(isset($_POST['pre'])){
			foreach($_POST['pre'] as $value){
				if($prerequisite=="")
					$prerequisite=$value;
				else
					$prerequisite .= ",".$value;
			}
		}
		$count =0;
		$mdate = date("Y-m-d H:i:s");
		$filename ="";
		
		if (!empty($_FILES['fileToUpload']['tmp_name']) ) {
			$target_dir = "public/uploads/lesion_files/";
			if (!is_dir($target_dir) OR !is_writable($target_dir)) {
				$_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_FOLDER_DOES_NOT_EXIST_OR_NOT_WRITABLE;
				return false;
			}
			// if input file too big (>5MB)
			if ($_FILES['fileToUpload']['size'] > 5000000 ) {
				$_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_TOO_BIG;
				return false;
			}
			
			$path = $_FILES['fileToUpload']['name'];
			$ext = pathinfo($path, PATHINFO_EXTENSION);
			$attype =$ext;
			$filename =  mt_rand(1000, 9999).round(microtime(true) * 1000).".".$ext;
			$target_file = $target_dir .$filename;
			
			 if (move_uploaded_file($_FILES["fileToUpload"]["tmp_name"], $target_file)) {
				$_SESSION["feedback_positive"][] = $target_file;"The file ". basename( $_FILES["fileToUpload"]["name"]). " has been uploaded.";
				
				$sql1 = "SELECT attach FROM lession_table WHERE lession_id = :lession_id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':lession_id' => $lession_id));
				$row2 = $query1->fetch();
				try{
					$file =$target_dir.$row2->attach;
					unlink($file);
				}catch(Exception $e){}

			} else {
				$_SESSION["feedback_negative"][] = "Sorry, there was an error uploading your file.";
			}
			
			 
			 $sql = "UPDATE lession_table SET course_id = :course_id, lession_name = :lession_name, short_desc = :short_desc, long_desc = :long_desc, attach=:file, attach_type=:atype, modified_date=:mdate, prerequisite=:prerequisite, duration=:lesion_duration WHERE lession_id = :lession_id";
			$query = $this->db->prepare($sql);
			$query->execute(array(':course_id' => $course_id, ':lession_name' => $lession_name, ':long_desc' => $long_desc, ':short_desc' => $short_desc, ':file' => $filename, ':atype'=>$attype, ':mdate'=>$mdate, ':prerequisite'=>$prerequisite,  ':lesion_duration'=> $lesion_duration, ':lession_id' => $lession_id ));

			$count =  $query->rowCount();
		}else{
    
        $sql = "UPDATE lession_table SET course_id = :course_id, lession_name = :lession_name, short_desc = :short_desc, long_desc = :long_desc,  modified_date=:mdate, prerequisite=:prerequisite, duration=:lesion_duration WHERE lession_id = :lession_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_id' => $course_id, ':lession_name' => $lession_name, ':long_desc' => $long_desc, ':short_desc' => $short_desc, ':mdate'=>$mdate, ':prerequisite'=>$prerequisite,  ':lesion_duration'=> $lesion_duration, ':lession_id' => $lession_id ));

        $count =  $query->rowCount();
	}
        if ($count == 1) {
			$_SESSION["feedback_positive"][] =FEEDBACK_LESION_EDITING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_LESION_EDITING_FAILED;
        }
        // default return
        return false;
    }

   
    public function delete($lession_id)
    {
        $sql = "DELETE FROM lession_table WHERE lession_id = :lession_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':lession_id' => $lession_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_LESION_DELETION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_LESION_DELETION_FAILED;
        }
        // default return
        return false;
    }
    
    public function changestatus($lession_id, $status)
    {
		$status = ($status==1)?0:1;
        $sql = "update lession_table set lession_status=:sts WHERE lession_id = :lession_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':lession_id' => $lession_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_LESION_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_LESION_CHANGE_STATUS_FAILED;
        }
        // default return
        return false;
    }
}
