<?php

/**
 * CourseModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ImageModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getAllimages()
    {
		$org_id=$_SESSION['user_org_id'];
        $sql = "SELECT test_id, test_name, status, create_date, modified_date FROM test_category where org_id=?";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
        $result = array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['test_id'] = $row->test_id;
			$res['test_name'] = $row->test_name;
			$res['status'] = $row->status;
			$res['create_date'] = $row->create_date;
			$res['modified_date'] = $row->modified_date;
			$res['sts'] = 0;
			$result[] =$res;
		}
      
        return $result;
    }

	
    /**
     * Getter for a single group
     * @param int $group_id id of the specific group
     * @return object a single object (the result)
     */
    public function getTestCategory($test_id)
    {
       $sql = "SELECT test_id, test_name, status, create_date, modified_date FROM test_category WHERE test_id=:test_id  ";
        $query = $this->db->prepare($sql);
        $query->execute(array(':test_id'=>$test_id));
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['test_id'] = $row->test_id;
			$res['test_name'] = $row->test_name;
			$res['status'] = $row->status;
			$res['create_date'] = $row->create_date;
			$res['modified_date'] = $row->modified_date;
			
			$sql1="SELECT * FROM test_category_child WHERE test_id=:test_id ";
			$query1 = $this->db->prepare($sql1);
        	$query1->execute(array(':test_id'=>$test_id));
			$cate=array();
			while($row1 = $query1->fetch())
			{
				$res1= array();
				$res1['catid'] = $row1->cat_id;
				$res1['catname'] = $row1->cat_name;	
				$cate[]=$res1;
			}
			$res['category_child'] = $cate;
			$result[] =$res;
			
		}
      
        return $result;
    }
	public function getTest($test_id)
    {
       $sql = "SELECT cat_id, cat_name, status, created_date, modified_date FROM test_category_child WHERE test_id=:test_id  ";
        $query = $this->db->prepare($sql);
        $query->execute(array(':test_id'=>$test_id));
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['test_id'] = $test_id;
			$res['cat_id'] = $row->cat_id;
			$res['cat_name'] = $row->cat_name;
			$res['status'] = $row->status;
			$res['create_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			
			$result[] =$res;
			
		}
      
        return $result;
    }

    /**
     * Setter for a group (create)
     * @param string $group_text group text that will be created
     * @return bool feedback (was the group created properly ?)
     */
	  public function Create()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $orgid=isset($_SESSION['user_org_id'])?$_SESSION['user_org_id']:"0";
        $userid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"0";
        $name=isset($_POST['filename'])?$_POST['filename']:"";
		$location=isset($_POST['location'])?$_POST['location']:"";
		$mdate = date("Y-m-d H:i:s");
		
		$file_name = $_FILES['journalfile']['name'];
	    $file_size =$_FILES['journalfile']['size'];
	    $file_tmp =$_FILES['journalfile']['tmp_name'];
	    $file_type=$_FILES['journalfile']['type']; 
		$file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
		
		if($file_size > 1048576){
	    	$errorMsg='File size grater than 1 MB';
			$_SESSION['feedback_negative'][]= $errorMsg;
	    }
		else{
			$path = "../uploads/".$orgid."/myfiles/";
			
			if (!is_dir($path) OR !is_writable($path)) {
				mkdir($path,true);
				chmod($path,0755);
			}
			$file_name = $orgid."_".round(microtime(true)*1000).".".$file_ext;
			$sts = move_uploaded_file($file_tmp, $path."/".$file_name);
			
			$path .= $file_name;
			if($sts){
				$sql = "INSERT INTO image_master ( img_name, img_path, file_size, org_id,  file_type, created_date, created_by) VALUES (?, ?, ?, ?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array( $name, $path, $file_size, $orgid, $file_type, $mdate, $userid));
				$status=true;
				$_SESSION['feedback_positive'][]= "File uploaded successfully";
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	 
	 
	 
	 
    public function create1()
    {
		$result = array();
        // clean the input to prevent for example javascript within the groups.
        $test_name= isset($_POST['test']) ? $_POST['test'] :"";
		$count=0;$errorMsg=""; $successMsg=""; $status=false;
		$mdate = date("Y-m-d H:i:s");
	try{	//$category_name= isset($_POST['category']) ? $_POST['category']:"";
		$org_id=$_SESSION['user_org_id'];
		//print_r($category_name); exit();
		$sql="select test_name from test_category where test_name=? and org_id=?";
		$query = $this->db->prepare($sql);
			$query->execute(array($test_name,$org_id));
			$count =  $query->rowCount();
			if ($count >=1)
			{	
		
		$result['status']=false;
		$result['successMsg']="Inserted successfully";
		$result['errorMsg']="This category is already exist";
		// $_SESSION["feedback_negative"][] = FEEDBACK_TEST_CATEGORY_ADDITION_FAILED;
		
			}else{
        $sql = "INSERT INTO test_category (test_name, create_date, modified_date, org_id) VALUES (:test_name, :cdate, :mdate , :orgid)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':test_name' => $test_name,':cdate'=>$mdate, ':mdate'=>$mdate, ':orgid'=>$org_id));
        $count =  $query->rowCount();
			if ($count >=0)
			{	
		
		
		$result['status']=true;
		$result['successMsg']="Inserted successfully";
		$result['errorMsg']="This category is already exist";
		// $_SESSION["feedback_negative"][] = FEEDBACK_TEST_CATEGORY_ADDITION_FAILED;
		
			}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$test_id=$this->db->lastinsertid();
			
       /*  if ($count >= 1) {
			/* foreach($category_name as $value)
			{
				$sql1="INSERT INTO test_category_child (test_id, cat_name , created_date, modified_date, org_id) VALUES (:test_id, :cat_name, :cdate, :mdate , :orgid)";
				$query1 = $this->db->prepare($sql1);
				
				$query1->execute(array(':test_id' => $test_id, ':cat_name' => $value['catname'], ':cdate'=>$mdate, ':mdate'=>$mdate, ':orgid'=>$org_id)); 
			} */
			
			/*$_SESSION["feedback_positive"][] = FEEDBACK_TEST_CATEGORY_ADDITION_SUCCESSFUL;
				return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_TEST_CATEGORY_ADDITION_FAILED;
       return false;
        
		} */
        // default return
        return $result;
    }

    /**
     * Setter for a group (update)
     * @param int $group_id id of the specific group
     * @param string $group_text new text of the specific group
     * @return bool feedback (was the update successful ?)
     */
    public function editSave($test_id)
    {
			$result = array();
        // clean the input to prevent for example javascript within the groups.
		$test_name= isset($_POST['test']) ? $_POST['test'] :"";
		//$category_name= isset($_POST['category']) ? $_POST['category']:"";
		$errorMsg=""; $successMsg=""; $status=false;
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		try{	//$category_name= isset($_POST['category']) ? $_POST['category']:"";
		$org_id=$_SESSION['user_org_id'];
		//print_r($category_name); exit();
		$sql="select test_name from test_category where test_name=? and org_id=?";
		$query = $this->db->prepare($sql);
			$query->execute(array($test_name,$org_id));
			$count =  $query->rowCount();
			if ($count >=1)
			{	
		
		
		$result['status']=false;
		$result['successMsg']="Category already exist";
		$result['errorMsg']="";
		// $_SESSION["feedback_negative"][] = FEEDBACK_TEST_CATEGORY_ADDITION_FAILED;
		
			}
       else{ $sql = "UPDATE test_category SET test_name = :test_name, modified_date=:mdate WHERE test_id = :test_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':test_name' => $test_name, ':mdate'=>$mdate, ':test_id' => $test_id ));
        $count =  $query->rowCount();
		
		$catid='0';
	  
        if ($count >= 1) {
			
		$result['status']=true;
		$result['successMsg']="This category updated successfully";
		$result['errorMsg']="";
		 }
		 else
		 {
			$result['status']=false;
		$result['successMsg']="";
		$result['errorMsg']="Problem while updating"; 
		 }
			/* foreach($category_name as $value)
			{
				$catid .=','.$value['catid'];
			}
			$sql2="delete from test_category_child  where cat_id not in($catid) and test_id=:test_id";
			$query2= $this->db->prepare($sql2);
			$query2->execute(array(':test_id' => $test_id)); */
				
			/* foreach($category_name as $value)
			{
				if($value['catid']==0)
				{
				$sql1="INSERT INTO test_category_child (test_id, cat_name , created_date, modified_date) VALUES (:test_id, :cat_name, :cdate, :mdate )";
				$query1 = $this->db->prepare($sql1);
				
				$query1->execute(array(':test_id' => $test_id, ':cat_name' => $value['catname'], ':cdate'=>$mdate, ':mdate'=>$mdate)); 
				
				}
				else
				{
				$sql2="UPDATE test_category_child SET test_id = :test_id, cat_name=:cat_name , modified_date=:mdate WHERE cat_id = :cat_id";
					$query2 = $this->db->prepare($sql2);
				
					$query2->execute(array(':test_id' => $test_id,  ':cat_name' => $value['catname'] , ':mdate'=>$mdate, ':cat_id' =>$value['catid']));
					$count =  $query->rowCount();
				}
			} */
			
			//$_SESSION["feedback_positive"][] = FEEDBACK_TEST_CATEGORY_EDITING_SUCCESSFUL;
            //return true;
        }} catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
        return $result;
        // default return
       
    }
    
    /**
     * Deletes a specific group
     * @param int $group_id id of the group
     * @return bool feedback (was the group deleted properly ?)
     */
    public function delete($test_id)
    {
    	$count1=0;
		
		$sql= "select * from quiz_table where test_id=:test_id";
		$query = $this->db->prepare($sql);
        $query->execute(array(':test_id' => $test_id));
		$count1 =  $query->rowCount();
		if($count1 ==1)
		{
			
			$_SESSION["feedback_negative"][] = FEEDBACK_TEST_CATEGORY_ALREADY_TAKEN;
			return false;
		}
		else{
      //$sql = "DELETE test_category , test_category_child FROM test_category INNER JOIN test_category_child WHERE test_category.test_id=test_category_child.test_id and test_category.test_id=:test_id";
	  $sql="DELETE  FROM test_category where test_id=:test_id";
	  $count=0;
        $query = $this->db->prepare($sql);
       $query->execute(array(':test_id' => $test_id));
       $count =  $query->rowCount();
	
        if ($count >= 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_TEST_CATEGORY_DELETION_SUCCESSFUL;
            return true;
       } else {
		  
            $_SESSION["feedback_negative"][] = FEEDBACK_TEST_CATEGORY_DELETION_FAILED;
            return false;
        }
        	}
    }
    
    public function changestatus($test_id, $status)
    {
		$status = ($status==1)?0:1;
        $sql = "update test_category set status=:sts WHERE test_id = :test_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':test_id' => $test_id));

        $count =  $query->rowCount();

        if ($count == 1){
			
			$_SESSION["feedback_positive"][] = FEEDBACK_TEST_CATEGORY_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_TEST_CATEGORY_CHANGE_STATUS_FAILED;
        }
	}
}
        // default retur