<?php

/**
 * GroupModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class GroupModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Getter for all groups (groups are an implementation of example data, in a real world application this
     * would be data that the user has created)
     * @return array an array with several objects (the results)
     */
    public function getAllGroups()
    {
        $sql = "SELECT user_group_id, group_name, permission FROM user_group";
        $query = $this->db->prepare($sql);
        $query->execute();
		$result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['user_group_id'] = $row->user_group_id;
			$res['group_name'] = $row->group_name;
			$res['permission'] = "";
			
			
			// $sql1 = "SELECT mod_name FROM module_name where mod_id in ($row->permission)";
			// $query1 = $this->db->prepare($sql1);
			// $query1->execute();
			// while($row1 = $query1->fetch())
			// {
			// 	$res['permission'] .= $row1->mod_name.", ";
			// }
			
			$result[] =$res;
		}
      
        return $result;
    }
    
    public function getAllModules()
    {
        $sql = "SELECT mod_id, mod_name FROM module_name";
        $query = $this->db->prepare($sql);
        $query->execute();
		
      
        return  $query->fetchAll();
    }
	
	public function getGroup($group_id)
    {
        $sql = "SELECT user_group_id, group_name, permission FROM user_group WHERE user_group_id = :user_group_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_group_id' => $group_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }

    
    public function create()
    {
        // clean the input to prevent for example javascript within the groups.
        $group_name = strip_tags($_POST['group_name']);
        $group_permission = "";
        
       
        if(isset($_POST['group_permission'])){
			
			foreach($_POST['group_permission'] as $value){			 
				if( $group_permission == "")
					 $group_permission = $value;
				else
					 $group_permission .= ", ".$value;
			}
		}
        $sql = "INSERT INTO user_group (group_name, permission) VALUES (:group_name, :group_permission)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':group_name' => $group_name, ':group_permission' => $group_permission));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_GROUP_CREATION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_GROUP_CREATION_FAILED;
        }
        // default return
        return false;
    }

    
    public function editSave($group_id)
    {
        // clean the input to prevent for example javascript within the groups.
        $group_name = strip_tags($_POST['group_name']);
        $group_permission = "";
        
       
        if(isset($_POST['group_permission'])){
			
			foreach($_POST['group_permission'] as $value){			 
				if( $group_permission == "")
					 $group_permission = $value;
				else
					 $group_permission .= ", ".$value;
			}
		}
		
        $sql = "UPDATE user_group SET group_name = :group_name, permission=:permission  WHERE user_group_id = :group_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':group_name' => $group_name,':permission' => $group_permission, ':group_id' => $group_id));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_GROUP_EDITING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_GROUP_EDITING_FAILED;
        }
        // default return
        return false;
    }

    /**
     * Deletes a specific group
     * @param int $group_id id of the group
     * @return bool feedback (was the group deleted properly ?)
     */
    public function delete($group_id)
    {
        $sql = "DELETE FROM user_group WHERE user_group_id = :user_group_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_group_id' => $group_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_GROUP_DELETION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_GROUP_DELETION_FAILED;
        }
        // default return
        return false;
    }
}
