<?php

/**
 * UserModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class EmployeetypeModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function create()
    {
		$count1=0;$count=0;
		$org_id=$_SESSION['user_org_id'];
		$userid=$_SESSION['user_id'];
        // clean the input to prevent for example javascript within the groups.
		$name =$_POST['name'];
		$description =$_POST['description'];
		$date=date('Y-m-d h:i:s a');
		
		$sql1 = "SELECT * FROM employee_type WHERE Name=:name and org_id=:org_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array( ':name' =>$name,':org_id'=>$org_id));

       $count1 =  $query1->rowCount();
		if($count1>=1){
			 $res["status"]=false;		
				$res["errorMsg"]="Employee Type already exists ";
			
		}else
		{
        $sql = "INSERT INTO employee_type (Name, Description, created_date, createdById, org_id) VALUES (:name, :description, :createddate, :uid,:org_id)";
        $query = $this->db->prepare($sql);
        $query->execute(array( ':name' =>$name, ':description' =>$description, ':createddate' => $date, ':uid'=>$userid,':org_id'=>$org_id));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$res['status']=true;		
				$res['successMsg']="Employee Type created successfully";
			
        } else {
           $res['status']=false;		
				$res['errorMsg']="Employee Type not created ";
        }
		
		}
		
		$data[]=$res;
		//print_r($data);
        // default return
        return $data;
    }
	
	 public function update()
    {
		$count1=0;$count=0;
		$org_id=$_SESSION['user_org_id'];
		$userid=$_SESSION['user_id'];
        // clean the input to prevent for example javascript within the groups.
		$name =$_POST['name'];
		$description =$_POST['description'];
		$employeetype_id =$_POST['employeetype_id'];
		$date=date('Y-m-d h:i:s a');
		
		$sql1 = "SELECT * FROM employee_type WHERE Id!=:employeetype_id and Name=:name and org_id=:org_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array(':employeetype_id' =>$employeetype_id, ':name' =>$name, ':org_id' =>$org_id));

       $count1 =  $query1->rowCount();
		if($count1>=1){
			 $res["status"]=false;		
				$res["errorMsg"]="Employee Type already exists ";
			
		}else
		{
    $sql = "UPDATE employee_type SET Name=:name, Description=:description, modified_date=:modified_date,modifiedbyid=:uid,org_id=:org_id WHERE Id=$employeetype_id ";
        $query = $this->db->prepare($sql);
        $query->execute(array(':name' =>$name, ':modified_date' => $date, ':description' =>$description, ':uid'=>$userid,':org_id'=>$org_id));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$res['status']=true;		
				$res['successMsg']="Employee Type Updated successfully";
			
        } else {
           $res['status']=false;		
				$res['errorMsg']="Employee Type not updated ";
        }
		
		}
		
		$data[]=$res;
		//print_r($data);
        // default return
        return $data;
    }
	
	 public function delete($employeetype_id)
    {
		$count1=0;
		$org_id=$_SESSION['user_org_id'];
		
		$sql1 = "SELECT * FROM candidate_table WHERE emp_type=$employeetype_id and org_id=$org_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array());

      $count1 =  $query1->rowCount();
		if($count1>=1){
			 $data["status"]=false;		
				$data["errorMsg"]="This Employee Type is used for candidate ";
			
		}
		else
		{
    $sql = "DELETE FROM `employee_type` WHERE Id=$employeetype_id and org_id=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute(array());

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$data['status']=true;		
				$data['successMsg']="Employee Type deleted successfully";
			
        } else {
           $data['status']=false;		
				$data['errorMsg']="Employee Type not deleted ";
        } 
		
	}
		
		
        return $data;
    }

public function getemployeetype($editper,$deleteper)
    {
		$org_id=$_SESSION['user_org_id'];
		$edit_per=$editper;
		$delete_per=$deleteper;
	$sql = "SELECT * FROM employee_type WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['name'] = $row->Name;
		   $res['description'] = $row->Description;
		   $res['employeetype_id'] = $row->Id;
		   $edit="";$delete="";
		   if($edit_per){
		   $edit="<a rel='tooltip' title='Edit'  onclick='angular.element(this).scope().onfetchdata(".$row->Id.")'  href='#' data-original-title='Edit' class='label bg-green'><i class='fa fa-edit'></i></a>&nbsp;&nbsp;&nbsp;&nbsp;";
			} 
			if($delete_per){
				$delete="<a rel='tooltip' title='Delete' onclick='angular.element(this).scope().onfetchfordelete(\"".$row->Id."\")' data-toggle='modal' data-target='#confirm' href='#' data-original-title='Delete' class='label bg-red'><i class='fa fa-trash-o'></i></a>";
			}
			$res['action']=$edit.$delete;
		   $data[]=$res;
	   }
	   $d['data']=$data;  	
	   //echo json_encode($d); 
	   return $d;
    }

 public function getallemployeetype($id)
    {
		$org_id=$_SESSION['user_org_id'];
	
	$sql = "SELECT * FROM employee_type WHERE org_id=$org_id and Id='$id'";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['name'] = $row->Name;
		   $res['description'] = $row->Description;
		   $res['employeetype_id'] = $row->Id;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
}
