<?php

/**
 * DashboardModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class DashboardModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getDashboard()
    {
		$org_id=$_SESSION['user_org_id'];
        $result =array();
        
        $sql = "SELECT Id FROM DefaultPosition where OrganizationId=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute();
        
        $result['designation'] = $query->rowCount();
        
       /*  $sql = "SELECT lession_id FROM lession_table where  lession_status=1";
        $query = $this->db->prepare($sql);
        $query->execute();
        
        $result['lesion'] = $query->rowCount(); */
        
        $sql = "SELECT test_id FROM test_category where status=1";
        $query = $this->db->prepare($sql);
        $query->execute();
        
        $result['test_name'] = $query->rowCount();
		
        
        $sql = "SELECT attempt_id FROM quiz_attempt";
        $query = $this->db->prepare($sql);
        $query->execute();
        
        $result['quizattempt'] = $query->rowCount();
        
        return $result;
    }
    
    public function getAllTestThisMonth()
	{
		///////////checking attempted tests,which are on START phase for finishing them/////
			
		$sql="UPDATE `test_attempt` set `test_sts`='FINISH' where `teststart_date` < curdate() and `test_sts`='START'";
		$sth = $this->db->prepare($sql);
		$sth->execute(array());
		
		///////////////////////////////
	$org_id=$_SESSION['user_org_id'];
     $startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
     $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		$result=array();
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		
		
		
 //  $sql = "SELECT  DISTINCT(schedule_id) ,candidate_id  FROM test_attempt  where org_id=$org_id and schedule_id in (select id from schedule_candidate where candidate_id in(select candidate_id from candidate_table where org_id=$org_id )) and date(teststart_date) between '$startdate' and '$enddate'";
   $sql = "SELECT  DISTINCT(schedule_id) ,candidate_id, teststart_date  FROM test_attempt where org_id=$org_id and schedule_id in(select id from schedule_candidate where candidate_id in(select candidate_id from candidate_table where org_id=$org_id) and date(schedule_date) between '$startdate' and '$enddate' )   order by teststart_date desc";
        $query = $this->db->prepare($sql);
        $query->execute();
        $result['totaltest'] = $query->rowCount();
		$result['startdate']=$startdate;
		$result['enddate']=$enddate;
		
		return $result;
	
	}
    public function getAllResultCurrPosition()
	{
		$org_id=$_SESSION['user_org_id'];
		 $startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
       $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		
		$date1=date('Y-m-d H:i:s');
		$date2=strtotime($date1);
		$date3=$date2-(60*60*12);
		$date=date("Y-m-d H:i:s", $date3);
		
		$loginduration = 1;
		$durationtype = 1;
		
		$sql1="select * from company_master where id = ?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $org_id));
		if($row1 = $query1->fetch()){
		$loginduration = $row1->LoginDuration;
		$durationtype = $row1->DurationType;
		}
		if($durationtype==1){
			$durationtype="DAY";
		}else{
			$durationtype="HOUR";
		}
	/* 	$sql = "SELECT * from schedule_candidate WHERE org_id = $org_id and schedule_date>=STR_TO_DATE('$date', '%Y-%m-%d %H:%i:%s') and id not in (select schedule_id from test_attempt)"; */
		$sql = "SELECT * from schedule_candidate WHERE org_id = ? and NOW() <= DATE_ADD(schedule_date, INTERVAL $loginduration $durationtype) and teststs=0   and date(schedule_date) between '$startdate' and '$enddate' ";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));
        $result = $query->rowCount();
		return $result;
	
	}
	public function getTopResultThisMonth()
	{
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
       $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		$org_id=$_SESSION['user_org_id'];
		$sql="SELECT * from test_attempt where rating >3 and candidate_id in (select candidate_id from candidate_table where 	org_id=$org_id  and date(teststart_date) between '$startdate' and '$enddate')";
		
        $query = $this->db->prepare($sql);
        $query->execute();
        $result = $query->rowCount();
		return $result;
	
	}
	
	public function getcandidategivingtest()
    {
		$org_id=$_SESSION["user_org_id"];
		$designation_id =isset($_POST['position'])?($_POST['position']):0;
		$testpaper =isset($_POST['tests'])?($_POST['tests']):0;
		//$testlevel =isset($_POST['level'])?($_POST['level']):0;
		$candidate_id =isset($_POST['candidate_id'])?($_POST['candidate_id']):0;// this line is executed for filtering indivisual candidates added on 17/7/2017 by abhinav
		$candidate_email=isset($value["candidate_email"])? $value["candidate_email"] :"";
		
		
		
	/* 	if($enddate=="")
		{
		$enddate=date('Y-m-d',(strtotime ( '+30 day',strtotime(date('Y-m-d'))) ));
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		
		$paper='';
		if($testpaper !=0)
		{
			$paper=" and test_id = $testpaper";
		}
		
	
		
		
		$des="";
		if($designation_id!=0)
		{
		$des=" and candidate_id in (select candidate_id from candidate_table where designation_id=$designation_id)";
		}
		/* if($testlevel!=0)
		{
		$des=$des." and testlevel = $testlevel";
		} */
		if($candidate_id!=0)// this line is executed for filtering individual candidates added on 17/7/2017 by abhinav
		{
		$des=$des." and candidate_id = $candidate_id";
		}
		
		
		
		$sql="";
		
			$sql = "SELECT candidate_id,schedule_id,test_id from test_attempt where test_sts='START' and DATE(teststart_date) = CURDATE() and now() < (teststart_date + INTERVAL  2  HOUR) and org_id=? $paper  $des";
		
		
		
        $query = $this->db->prepare($sql);
        $query->execute(array( $org_id));

       $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['schedule_id'] = $row->schedule_id;
			$res['candidate_id'] = $row->candidate_id;
			
			$res['candidate_fname'] = ucwords(strtolower($this->getName($row->candidate_id,'candidate_table','candidate_fname','candidate_id')));
			$res['candidate_lname'] = ucwords(strtolower($this->getName($row->candidate_id,'candidate_table','candidate_lname','candidate_id')));
			$res['candidate_fullname'] = ucwords(strtolower($res['candidate_fname']." ".$res['candidate_lname']));
		
			$res['candidate_email'] = $this->getName($row->candidate_id,'candidate_table','candidate_email','candidate_id');
			$desig = $this->getName($row->candidate_id,'candidate_table','designation_id','candidate_id');
	
			$res['candidate_desig'] = $this->getName($desig,'DefaultPosition','PositionName','Id');
			
			$res['candidate_contact'] = $this->getName($row->candidate_id,'candidate_table','candidate_contact','candidate_id');
			
			$sql9="SELECT location, schedule_date FROM schedule_candidate WHERE id=:schedule_id";
			 $query9 = $this->db->prepare($sql9);
			 $query9->execute(array(':schedule_id'=>$row->schedule_id));
			 $row9=$query9->fetch();
			 $res['location'] ='Any Location';
			 if($row9->location!='')
			 {
				$res['location'] = $row9->location;
			 }
			$res['schedule_date'] = date("d M Y h:i A",strtotime($row9->schedule_date));
			$test_id = $row->test_id;
			$tests=$this->getName($test_id,'Test_paper','Name','Id');
			
			$res['testname']=$tests;
			
			
			$result[] =$res;
		}
      
        return $result;
    }
	
	public function getscheduleTest($startdate,$enddate)
    {
		$org_id=$_SESSION["user_org_id"];
		$designation_id =isset($_POST['position'])?($_POST['position']):0;
		$testpaper =isset($_POST['tests'])?($_POST['tests']):0;
		//$testlevel =isset($_POST['level'])?($_POST['level']):0;
		$candidate_id =isset($_POST['candidate_id'])?($_POST['candidate_id']):0;// this line is executed for filtering indivisual candidates added on 17/7/2017 by abhinav
		$candidate_email=isset($value["candidate_email"])? $value["candidate_email"] :"";
		
		
		
	/* 	if($enddate=="")
		{
		$enddate=date('Y-m-d',(strtotime ( '+30 day',strtotime(date('Y-m-d'))) ));
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		
		$paper='';
		if($testpaper !=0)
		{
			$paper=" and tests = $testpaper";
		}
		
		$showdate=" ";
		if($startdate!='' && $enddate!=''){
			$showdate = "and date(schedule_date) between '$startdate' and  '$enddate' " ;
		}
		
		$date1=date('Y-m-d H:i:s');
		$date2=strtotime($date1);
		$date3=$date2-(60*60*12);
		$date=date("Y-m-d H:i:s", $date3);
		$des="";
		if($designation_id!=0)
		{
		$des=" and candidate_id in (select candidate_id from candidate_table where designation_id=$designation_id)";
		}
		/* if($testlevel!=0)
		{
		$des=$des." and testlevel = $testlevel";
		} */
		if($candidate_id!=0)// this line is executed for filtering individual candidates added on 17/7/2017 by abhinav
		{
		$des=$des." and candidate_id = $candidate_id";
		}
		
		$loginduration = 1;
		$durationtype = 1;
		
		$sql1="select * from company_master where id = ?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $org_id));
		if($row1 = $query1->fetch()){
		$loginduration = $row1->LoginDuration;
		$durationtype = $row1->DurationType;
		}
		if($durationtype==1){
			$durationtype="DAY";
		}else{
			$durationtype="HOUR";
		}
		
		$sql="";
		
			$sql = "SELECT * from schedule_candidate WHERE org_id = ? and NOW() <= DATE_ADD(schedule_date, INTERVAL $loginduration $durationtype) and teststs=0 $paper $des  $showdate ";
		
		
		
        $query = $this->db->prepare($sql);
        $query->execute(array( $org_id));

       $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['schedule_id'] = $row->id;
			$res['candidate_id'] = $row->candidate_id;
			$res['schedule_date'] = date("d M Y h:i A",strtotime($row->schedule_date));
			$res['candidate_name'] = $this->getName($row->candidate_id,'candidate_table','candidate_fname','candidate_id');
			$res['candidate_email'] = $this->getName($row->candidate_id,'candidate_table','candidate_email','candidate_id');
			$desig = $this->getName($row->candidate_id,'candidate_table','designation_id','candidate_id');
	
			$res['candidate_desig'] = $this->getName($desig,'DefaultPosition','PositionName','Id');
			$res['level'] = $this->getName($row->testlevel,'test_level','level','id');
			$res['assessorname'] = $this->getName($row->assessorid,'users','user_name','	user_id');
			$res['candidate_contact'] = $this->getName($row->candidate_id,'candidate_table','candidate_contact','candidate_id');
			$test_id = $row->tests;
			$tests=$this->getName($test_id,'Test_paper','Name','Id');
			$res['location'] ='Any Location';
			if($row->location!='')
			{
			$res['location'] = $row->location;
			}
			$res['testname']=$tests;
			$res['ipsts'] = $row->ipsts;
			$res['minip'] = $row->minip;
			$res['maxip'] = $row->maxip;
			
			$result[] =$res;
		}
      
        return $result;
    }
	public function getCurrentPositions()
	{
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
       $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		$org_id=$_SESSION['user_org_id'];
		$sql = "select * from DefaultPosition where OrganizationId=$org_id";
		
        $query = $this->db->prepare($sql);
        $query->execute();
        $result = $query->rowCount();
		return $result;
	
	}
	
	public function getcountcandidategivingtest()
	{
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
       $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		$org_id=$_SESSION['user_org_id'];
		$sql = "SELECT candidate_id,schedule_id,test_id from test_attempt where test_sts='START' and DATE(teststart_date) = CURDATE() and now() < (teststart_date + INTERVAL  2  HOUR) and org_id=$org_id";
		
        $query = $this->db->prepare($sql);
        $query->execute();
        $result = $query->rowCount();
		return $result;
	
	}
	public function getExcellent(){
	
        
        $sql = "SELECT * FROM feed_back where overall_rating=5";
        $query = $this->db->prepare($sql);
        $query->execute();
        
        $result = $query->rowCount();
		
		return $result;
	}
	public function getVeryGood(){
	
        
        $sql = "SELECT * FROM feed_back where overall_rating=4";
        $query = $this->db->prepare($sql);
        $query->execute();
        
        $result = $query->rowCount();
		
		return $result;
	}
	public function getGood(){
	
        
        $sql = "SELECT * FROM feed_back where overall_rating=3";
        $query = $this->db->prepare($sql);
        $query->execute();
        
        $result = $query->rowCount();
		
		return $result;
	}
	public function getAverage(){
	
        
        $sql = "SELECT * FROM feed_back where overall_rating=2";
        $query = $this->db->prepare($sql);
        $query->execute();
        
        $result = $query->rowCount();
		
		return $result;
	}
	public function getPoor(){
	
        
        $sql = "SELECT * FROM feed_back where overall_rating=1";
        $query = $this->db->prepare($sql);
        $query->execute();        
        $result = $query->rowCount();
		
		return $result;
	}
	public function getBar()
	{
		$org_id=$_SESSION['user_org_id'];
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
       $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
	$sql = "SELECT * FROM DefaultPosition where OrganizationId=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute();        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			
			$res['designation_id'] =$row->Id;
			$res['designation_name'] = $row->PositionName;
			$desg_id=$res['designation_id'];
			$sql1="SELECT * FROM feed_back WHERE candidate_id in (select candidate_id from candidate_table where designation_id=$desg_id and org_id=$org_id) and overall_rating=5";
			$query1 = $this->db->prepare($sql1);
        	$query1->execute();        
       		$res['distinction'] = $query1->rowCount();
			
			$sql2="SELECT * FROM feed_back WHERE candidate_id in (select candidate_id from candidate_table where designation_id=$desg_id and org_id=$org_id) and overall_rating=4";
			$query2 = $this->db->prepare($sql2);
        	$query2->execute();        
       		$res['excellent'] = $query2->rowCount();
			
			$sql3="SELECT * FROM feed_back WHERE candidate_id in (select candidate_id from candidate_table where designation_id=$desg_id and org_id=$org_id) and overall_rating=3";
			$query3 = $this->db->prepare($sql3);
        	$query3->execute();        
       		$res['verygood'] = $query3->rowCount();
			
			$sql4="SELECT * FROM feed_back WHERE candidate_id in (select candidate_id from candidate_table where designation_id=$desg_id and org_id=$org_id) and overall_rating=2";
			$query4 = $this->db->prepare($sql4);
        	$query4->execute();        
       		$res['good'] = $query4->rowCount();
			
			$sql5="SELECT * FROM feed_back WHERE candidate_id in (select candidate_id from candidate_table where designation_id=$desg_id and org_id=$org_id) and overall_rating=1";
			$query5 = $this->db->prepare($sql5);
        	$query5->execute();        
       		$res['poor'] = $query5->rowCount();
			
			$result[] =$res;
		}
      
        return $result;
	}
	
	/////Level wise bar chart/////////
	public function getLevelBar()
	{
		$org_id=$_SESSION['user_org_id'];
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
       $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
	$sql = "SELECT * FROM DefaultPosition where OrganizationId=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute();
		$data=array();     
$res1=array();
$data1=array();		
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			
			$res['designation_id'] =$row->Id;
			$res['designation_name'] = $row->PositionName;
			$desg_id=$res['designation_id'];
			/* $sql1="SELECT * FROM feed_back WHERE candidate_id in (select candidate_id from candidate_table where designation_id=$desg_id and org_id=$org_id) and overall_rating=5";
			$query1 = $this->db->prepare($sql1);
        	$query1->execute();        
       		$res['excellent'] = $query1->rowCount();
			
			$sql2="SELECT * FROM feed_back WHERE candidate_id in (select candidate_id from candidate_table where designation_id=$desg_id and org_id=$org_id) and overall_rating=4";
			$query2 = $this->db->prepare($sql2);
        	$query2->execute();        
       		$res['verygood'] = $query2->rowCount(); */
			
			$sql3="SELECT * FROM feed_back WHERE candidate_id in (select candidate_id from candidate_table where designation_id=$desg_id and org_id=$org_id) and level=3";
			$query3 = $this->db->prepare($sql3);
        	$query3->execute();        
       		$res['advance'] = $query3->rowCount();
			
			$sql4="SELECT * FROM feed_back WHERE candidate_id in (select candidate_id from candidate_table where designation_id=$desg_id and org_id=$org_id) and level=2";
			$query4 = $this->db->prepare($sql4);
        	$query4->execute();        
       		$res['medium'] = $query4->rowCount();
			
			$sql5="SELECT * FROM feed_back WHERE candidate_id in (select candidate_id from candidate_table where designation_id=$desg_id and org_id=$org_id) and level 
			=1";
			$query5 = $this->db->prepare($sql5);
        	$query5->execute();        
       		$res['basic'] = $query5->rowCount();
			
			$data[] =$res;
		}
		
			$res1['advancename'] =$this->getName(3,'test_level','level','id');
			$res1['mediumname'] =$this->getName(2,'test_level','level','id');
			$res1['basicname'] =$this->getName(1,'test_level','level','id');
			$data1[] =$res1;
			$result['levelname'] =$data1;
			$result['leveldata'] =$data;
        return $result;
	}
	
	/////CLose Level wise bar chart/////////
	
	public function getPie1()
	{
		$result =array();
		
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
       $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		$org_id=$_SESSION['user_org_id'];
		
		$sql5 = "SELECT * FROM Test_paper where  org_id=$org_id  and date(created_date) between '$startdate'  and '$enddate' ";
        $query5 = $this->db->prepare($sql5);
        $query5->execute();   
		while($row5 = $query5->fetch()){
			$res= array();
			
		$testpaperid = $row5->Id;
		$res['testpaper'] =  $row5->Name;

		$sql = "SELECT * FROM test_attempt where candidate_id in (select candidate_id from candidate_table where org_id=$org_id)   and test_id=$testpaperid and date(teststart_date) between '$startdate'  and '$enddate' ";
        $query = $this->db->prepare($sql);
        $query->execute();     
		$res['candidate_no']=$query->rowCount();
        
		/* $sql1 = "SELECT * FROM test_attempt where candidate_id in (select candidate_id from candidate_table where  org_id=$org_id) and rating=4 and test_id=$testpaperid and test_id=$testpaperid and date(teststart_date) between '$startdate'  and '$enddate' ";
        $query1 = $this->db->prepare($sql1);
        $query1->execute();     
		$res['verygood']=$query1->rowCount();
		
		
		$sql2 = "SELECT * FROM test_attempt where candidate_id in (select candidate_id from candidate_table where  org_id=$org_id) and rating=3 and test_id=$testpaperid and date(teststart_date) between '$startdate'  and '$enddate' ";
        $query2 = $this->db->prepare($sql2);
        $query2->execute();     
		$res['good']=$query2->rowCount();
		
		$sql3 = "SELECT * FROM test_attempt where candidate_id in (select candidate_id from candidate_table where org_id=$org_id) and rating=2 and test_id=$testpaperid and date(teststart_date) between '$startdate'  and '$enddate' ";
        $query3 = $this->db->prepare($sql3);
        $query3->execute();     
		$res['average']=$query3->rowCount();
		
		$sql4 = "SELECT * FROM test_attempt where candidate_id in (select candidate_id from candidate_table where  org_id=$org_id) and rating=1 and test_id=$testpaperid  and date(teststart_date) between '$startdate'  and '$enddate' ";
        $query4 = $this->db->prepare($sql4);
        $query4->execute();     
		$res['poor']=$query4->rowCount(); */
			$result[] =$res;
		}
        
			
			
			
		
        return $result;
	}
	
	public function getPie2()
	{
		$org_id=$_SESSION['user_org_id'];
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
       $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		$sql = "select * from DefaultPosition where  OrganizationId=$org_id and date(CreatedDate) between  '$startdate' and '$enddate'";
   
		$query = $this->db->prepare($sql);
        $query->execute();        
        $result =array();
		
        while($row = $query->fetch())
        {
			$res= array();
			$res['positionname'] =$row->PositionName;
			$desig_id=$row->Id;
			$sql1 = "select * from candidate_table where designation_id=$desig_id and org_id=$org_id";
			
        $query1 = $this->db->prepare($sql1);
        $query1->execute();     
		$res['candidate_no']=$query1->rowCount();
					
			
			$result[] =$res;
		}
      
        return $result;
	}
	
	
	////function for level wise pie chart/////
	public function getPie3()
	{
		$result =array();
		$res= array();
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		$org_id=$_SESSION['user_org_id'];
		
		$sql= "SELECT * FROM DefaultPosition where OrganizationId=$org_id ";
        $query= $this->db->prepare($sql);
        $query->execute(); 
		
		while($row=$query->fetch()){
			$desigid = $row->Id;
		$res['desig']=$row->PositionName;
		
		$sql4 = "SELECT * FROM test_attempt where candidate_id in (select candidate_id from candidate_table where designation_id =$desigid  and org_id=$org_id ) ";
        $query4 = $this->db->prepare($sql4);
        $query4->execute();     
		$res['total']=$query4->rowCount();
		$result[] =$res;
		}
		
		/* $sql = "SELECT * FROM feed_back where candidate_id in (select candidate_id from candidate_table where designation_id in (select Id from DefaultPosition where  OrganizationId=$org_id  ) and org_id=$org_id) and level=3";
        $query = $this->db->prepare($sql);
        $query->execute();     
		$res['advance']=$query->rowCount();
        
		$sql1 = "SELECT * FROM feed_back where candidate_id in (select candidate_id from candidate_table where designation_id in (select Id from DefaultPosition where OrganizationId=$org_id   ) and org_id=$org_id) and level=2";
        $query1 = $this->db->prepare($sql1);
        $query1->execute();     
		$res['medium']=$query1->rowCount();
		
		
		$sql2 = "SELECT * FROM feed_back where candidate_id in (select candidate_id from candidate_table where designation_id in (select Id from DefaultPosition where OrganizationId=$org_id) and org_id=$org_id) and level=1";
        $query2 = $this->db->prepare($sql2);
        $query2->execute();     
		$res['basic']=$query2->rowCount();
		
		/* $sql3 = "SELECT * FROM feed_back where candidate_id in (select candidate_id from candidate_table where designation_id in (select designation_id from designation_table where ((date(startdate)<='$startdate' and date(enddate)>='$startdate') or (date(startdate)<='$enddate' and date(enddate)>='$enddate') ) ) and org_id=$org_id) and overall_rating=2";
        $query3 = $this->db->prepare($sql3);
        $query3->execute();     
		$res['average']=$query3->rowCount();
		
		$sql4 = "SELECT * FROM feed_back where candidate_id in (select candidate_id from candidate_table where designation_id in (select designation_id from designation_table where ((date(startdate)<='$startdate' and date(enddate)>='$startdate') or (date(startdate)<='$enddate' and date(enddate)>='$enddate') ) ) and org_id=$org_id) and overall_rating=1";
        $query4 = $this->db->prepare($sql4);
        $query4->execute();     
		$res['poor']=$query4->rowCount();
		
        
			 */
			
			
			
        return $result;
	}
	
	///////overall Candidates piechart/////////
	public function getPie4()
	{
		$org_id=$_SESSION['user_org_id'];
		$result =array();
		$res= array();
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		$date1=date('Y-m-d H:i:s');
		$date2=strtotime($date1);
		$date3=$date2-(60*60*12);
		$date=date("Y-m-d H:i:s", $date3);
		
		/* $loginduration = 1;
		$durationtype = 1;
		
		$sql1="select * from company_master where id = ?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $org_id));
		if($row1 = $query1->fetch()){
		$loginduration = $row1->LoginDuration;
		$durationtype = $row1->DurationType;
		}
		if($durationtype==1){
			$durationtype="DAY";
		}else{
			$durationtype="HOUR";
		} */
		
		
		$loginduration = 1;
		$durationtype = 1;
		
		$sql1="select * from company_master where id = ?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $org_id));
		if($row1 = $query1->fetch()){
		$loginduration = $row1->LoginDuration;
		$durationtype = $row1->DurationType;
		}
		if($durationtype==1){
			$durationtype="DAY";
		}else{
			$durationtype="HOUR";
		}
	
		//$sql4 = "SELECT * FROM schedule_candidate where positionid in (select designation_id from designation_table where (('$startdate'   between startdate and  enddate) OR  ('$enddate'   between startdate and  enddate) OR (startdate between '$startdate' and '$enddate') OR  (enddate between '$startdate' and '$enddate'))  ) and org_id=$org_id";
		//$sql4 = "SELECT * FROM schedule_candidate where  org_id=$org_id and date(schedule_date) between '$startdate' and '$enddate'";
		
		$sql4 = "SELECT * from schedule_candidate WHERE org_id = $org_id and NOW() <= DATE_ADD(schedule_date, INTERVAL $loginduration $durationtype) and teststs=0 and candidate_id in (select candidate_id from candidate_table where org_id = $org_id)  and date(schedule_date) between '$startdate' and  '$enddate'  ";
        $query4 = $this->db->prepare($sql4);
        $query4->execute(); 
		$res['scheduled']=$query4->rowCount();
	
		//$sql = "SELECT * from schedule_candidate WHERE org_id = $org_id and schedule_date>=STR_TO_DATE('$date', '%Y-%m-%d %H:%i:%s') and id not in (select schedule_id from test_attempt where org_id=$org_id) and date(schedule_date) between '$startdate' and '$enddate'";
		$sql = "SELECT * from test_attempt where test_sts='START' and DATE(teststart_date) = CURDATE() and org_id=$org_id ";
        $query = $this->db->prepare($sql);
        $query->execute();     
		$res['awaiting']=$query->rowCount();
		
		$sql1 = "SELECT * from schedule_candidate WHERE org_id = $org_id and NOW() > DATE_ADD(schedule_date, INTERVAL $loginduration $durationtype) and teststs=0 and candidate_id in (select candidate_id from candidate_table where   org_id=$org_id)  and date(schedule_date) between '$startdate' and '$enddate' ";
        $query1 = $this->db->prepare($sql1);
        $query1->execute();     
		$res['notappeared']=$query1->rowCount();
		
		
	/* 	$sql2 = "SELECT  DISTINCT(schedule_id) ,candidate_id  FROM test_attempt where org_id=$org_id and schedule_id in (select id from schedule_candidate where candidate_id in(select candidate_id from candidate_table where designation_id in(select Id from DefaultPosition where OrganizationId=$org_id)) and date(schedule_date) between '$startdate' and '$enddate')";
        $query2 = $this->db->prepare($sql2);
        $query2->execute();     
		$res['takentest']=$query2->rowCount(); */
		
		//$sql3 = "SELECT  DISTINCT(schedule_id) ,candidate_id  FROM test_attempt  where org_id=$org_id and schedule_id in (select id from schedule_candidate where candidate_id in(select candidate_id from candidate_table where designation_id in(select designation_id from designation_table where sts=1 and org_id=$org_id) ) and date(schedule_date) between '$startdate' and '$enddate') and schedule_id  in  (select schedule_id from feed_back)";
		
		
		
	//	$sql3 = "SELECT  DISTINCT(schedule_id) ,candidate_id  FROM test_attempt  where org_id=$org_id and schedule_id in (select id from schedule_candidate where candidate_id in(select candidate_id from candidate_table where designation_id in(select designation_id from designation_table where (('$startdate'   between startdate and  enddate) OR  ('$enddate'   between startdate and  enddate) OR (startdate between '$startdate' and '$enddate') OR  (enddate between '$startdate' and '$enddate'))  and org_id=$org_id) ) ) and schedule_id  in  (select schedule_id from feed_back)";
	
		$sql3 = "SELECT  DISTINCT(schedule_id) ,candidate_id  FROM test_attempt  where org_id=$org_id  and schedule_id in (select id from schedule_candidate where candidate_id in(select candidate_id from candidate_table where org_id=$org_id) and date(schedule_date) between '
		$startdate' and '$enddate') ";
		
        $query3 = $this->db->prepare($sql3);
        $query3->execute();     
	$res['declared']=$query3->rowCount();
		
		
//$sql4 = "SELECT  DISTINCT(schedule_id) ,candidate_id  FROM test_attempt where org_id=$org_id and schedule_id in (select id from schedule_candidate where positionid in (select Id from DefaultPosition where  OrganizationId=$org_id ) and date(schedule_date) between '$startdate' and '$enddate') and schedule_id not in (select schedule_id from feed_back)";
		//$sql4 = "SELECT  DISTINCT(schedule_id) ,candidate_id  FROM test_attempt where org_id=$org_id and schedule_id in (select id from schedule_candidate where  date(schedule_date) between '$startdate' and '$enddate') and schedule_id not in (select schedule_id from feed_back)";
/*         $query4 = $this->db->prepare($sql4);
        $query4->execute();     
		$res['awaitingres']=$query4->rowCount();
		 */
        
			 
			
			
			$result[] =$res;
			//$result[] =$res;
        return $result;
		
	}
	
	
	public function getTopPerformer()
	{
		$result=array();
		$org_id=$_SESSION['user_org_id'];
	 	$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
      $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
	   if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
	  /*  $whr=" and curdate() between startdate and enddate";
		if($enddate!="" and $startdate!="")
		{
			$whr=" and  (('$startdate'   between startdate and  enddate) OR  ('$enddate'   between startdate and  enddate) OR (startdate between '$startdate' and '$enddate') OR  (enddate between '$startdate' and '$enddate')) ";
		} */
		$data=array();
	//	$data1=array();
			/////for levels//////
			/* //$sql1 = "select distinct f.level as level from candidate_table c , feed_back f where c.candidate_id=f.candidate_id and f.overall_rating >3 and c.org_id=$org_id and c.designation_id in(select Id from DefaultPosition where OrganizationId=$org_id  ) and date(f.created_date) between '$startdate' and '$enddate' order by level";
			$sql1 = "select  * from test_attempt where candidate_id in()";
			Utils::Trace($sql1);
			$query1 = $this->db->prepare($sql1);
			$query1->execute(); 
			$count1 = $query1->rowCount();
			while($row1 = $query1->fetch())
			{
				$res= array();
				$res['levelid'] =$row1->level;
				$res['level'] =$this->getName($res['levelid'],'test_level','level','id');
				$data1[] =$res;
			} */
			/////close for levels//////
			
			
			
		$sql="SELECT * from test_attempt where rating >3 and candidate_id in (select candidate_id from candidate_table where   org_id=$org_id ) and date(teststart_date) between '$startdate' and '$enddate' ";
		
        $query = $this->db->prepare($sql);
        $query->execute(array());        
        $result =array();
		$data=array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['candidate_id'] = $row->candidate_id;
			$res['schedule_id'] = $row->schedule_id;
			$sql1="SELECT candidate_fname,candidate_lname,image FROM candidate_table WHERE candidate_id=:candidateid ";
			$query1= $this->db->prepare($sql1);
			$query1->execute(array(':candidateid'=>$row->candidate_id));
			while($row1=$query1->fetch())
			{
				$res['candidate_fname'] = $row1->candidate_fname;
				$res['candidate_lname'] = $row1->candidate_lname;
				$res['image'] = $row1->image;
				$res['candidate_fullname'] = ucwords(strtolower($row1->candidate_fname." ".$row1->candidate_lname));
				
			}
				
			
	
			$desig=$this->getName($res['candidate_id'],'candidate_table','designation_id','candidate_id');
			$res['designation_id']=$this->getName($desig,'DefaultPosition','PositionName','Id');
			$sql3 = "SELECT * FROM test_attempt WHERE candidate_id=:candidate_id and schedule_id=:scheduled_id";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array(':candidate_id' => $res['candidate_id'], ':scheduled_id'=>$res['schedule_id']));
			
				
			
			while($row3=$query3->fetch())
			{
				
				$res['schedule_id'] = $row->schedule_id;
				$test_id = $row3->test_id;
				$res['rating'] = $row3->rating;
			
			
					
			}
			//$res['testname']=$tests;
			$data[] =$res;
		}
			
			/* $sql = "select c.image as image, c.candidate_id as candidate_id, c.candidate_fname as candidate_fname,c.candidate_lname as candidate_lname, c.designation_id as designation_id ,f.rating as overall_rating, f.schedule_id as schedule_id from candidate_table c , test_attempt f where c.candidate_id=f.candidate_id and f.rating >3 and c.org_id=$org_id  and f.teststart_date between '$startdate' and '$enddate' ";
 //Utils::Trace($sql);
			$query = $this->db->prepare($sql);
			$query->execute(); 
			$count = $query->rowCount();			
			
			
			while($row = $query->fetch())
			{
				$res1= array();
				$res1['candidate_id'] =$row->candidate_id;
				$res1['candidate_name'] =$row->candidate_fname;
				$res1['candidate_fullname'] = ucwords(strtolower($row->candidate_fname." ".$row->candidate_lname));
				$res1['designation_id'] =$this->getName($row->designation_id,'DefaultPosition','PositionName','Id');
				$res1['rating']=$row->overall_rating;		
				$res1['schedule_id']=$row->schedule_id;	
				//$res1['level']=$row->testlevel;
				$res1['image']=$row->image;
				$data[] =$res1;
			} */
			
			
			
		
		$result['desi']=$data;
		//$result['levelarr']=$data;
		//print_r($result);
			return $result;
			
		
        
	}
	
	public function getTopPerformerold()
	{
		$result=array();
		$org_id=$_SESSION['user_org_id'];
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
       $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
			$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		$sql1 ="select * from DefaultPosition where Id in(select designation_id from candidate_table where candidate_id in (select candidate_id from feed_back where overall_rating >=2 ) and org_id=$org_id) and org_id=$org_id ";
		$query1 = $this->db->prepare($sql1);
        $query1->execute();  $count=0;$data=array();
		while($row1 = $query1->fetch())	{
			
			$desi =$row1->designation_id;
			$sql = "select c.candidate_id as candidate_id, c.candidate_fname as candidate_fname,c.candidate_lname as candidate_lname, c.designation_id as designation_id ,f.overall_rating as overall_rating from candidate_table c , feed_back f where c.candidate_id=f.candidate_id and c.designation_id =$desi  and f.overall_rating >=2 and c.org_id=$org_id";
 
			$query = $this->db->prepare($sql);
			$query->execute(); 
			$count = $query->rowCount();			
			
			$res=array();
			$res['designation_id'] =$this->getName($desi,'DefaultPosition','PositionName','Id');
			$designations=array();
			while($row = $query->fetch())
			{
				$res1= array();
				$res1['candidate_id'] =$row->candidate_id;
				$res1['candidate_name'] =$row->candidate_fname;
				$res1['candidate_fullname'] = ucwords(strtolower($row->candidate_fname." ".$row->candidate_lname));
				
				$res1['rating']=$row->overall_rating;					
				$designations[] =$res1;
			}
			$res['emparray']=$designations;
			$data[] =$res;
			
		}
		$result['desi']=$data;
		//print_r($result);
			return $result;
			
		
        
	}
	
	public function getTest($startdate,$enddate)
	{
		
		$org_id=$_SESSION['user_org_id'];
		$designation_id =isset($_POST['position'])?($_POST['position']):0;
		$candidate_id =isset($_POST['candidate_id'])?($_POST['candidate_id']):0;
		$testpaper =isset($_POST['tests'])?($_POST['tests']):0;
		$des="";
		$lev="";
		if($designation_id!=0)
		{
		$des=" and designation_id = $designation_id";
		
		}
		
		if($candidate_id!=0)
		{
		$des=$des." and candidate_id = $candidate_id";
	
		}
		
		$scheduledate="";
		if($startdate!='' && $enddate!=''){
			$scheduledate = " and date(schedule_date) between '$startdate' and '$enddate' ";
		}
		
		$tes='';
		if($testpaper!=0)
		{
			$tes=" and test_id = $testpaper";		
		} 
		
$des1='';
		if($designation_id!=0)
		{
			// $des=" and designation_id = $designation_id";
			$des1=" and candidate_id in (select candidate_id from candidate_table where designation_id= $designation_id)";
		}		
			
       $sql = "SELECT  DISTINCT(schedule_id) ,candidate_id, teststart_date  FROM test_attempt where org_id=? and schedule_id in(select id from schedule_candidate where candidate_id in(select candidate_id from candidate_table where org_id=$org_id $des) $scheduledate)   $tes $des1  order by teststart_date desc";
	
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['candidate_id'] = $row->candidate_id;
			$res['schedule_id'] = $row->schedule_id;
			
			/* $sql1="SELECT candidate_fname,candidate_lname,designation_id FROM candidate_table WHERE candidate_id=:candidateid ";
			$query1= $this->db->prepare($sql1);
			$query1->execute(array(':candidateid'=>$row->candidate_id));
			while($row1=$query1->fetch())
			{
				$res['candidate_fname'] = $row1->candidate_fname;
				$res['candidate_lname'] = $row1->candidate_lname;
				$res['candidate_fullname'] = ucwords(strtolower($row1->candidate_fname." ".$row1->candidate_lname));
					$res['candidate_desig'] = $this->getName($row1->designation_id,'designation_table','designation_name','designation_id');
			} */
			$sql1="SELECT * FROM schedule_candidate WHERE id=:schedule_id ";
			$query1= $this->db->prepare($sql1);
			$query1->execute(array(':schedule_id'=>$row->schedule_id));
			while($row1=$query1->fetch())
			{
				
				$fname=$this->getName($row1->candidate_id,'candidate_table','candidate_fname','candidate_id');
				$lname=$this->getName($row1->candidate_id,'candidate_table','candidate_lname','candidate_id');
				$res['candidate_fullname'] = ucwords(strtolower($fname." ".$lname));
				
				$res['level'] =$this->getName($row1->testlevel ,'test_level','level','id');;
				//$res['candidate_fullname'] = $row1->candidate_fname;
				//$res['candidate_lname'] = $row1->candidate_lname;
				//$res['candidate_fullname'] = ucwords(strtolower($row1->candidate_fname." ".$row1->candidate_lname));
		$desigId = $this->getName($row1->candidate_id,'candidate_table','designation_id','candidate_id');
				//$res['overallpercent'] = $this->showresult($row->candidate_id,$row->schedule_id);
				$res['checkedsts']=$this->checkedstatus($res['candidate_id'],$res['schedule_id']);
				$res['candidate_desig'] = $this->getName($desigId,'DefaultPosition','PositionName','Id');
				$res['schedule_date'] = date("d M Y h:i A",strtotime($row1->schedule_date));
			}	
			
			
			$res['overallpercent']=$this->overallpercentage($res['candidate_id'],$res['schedule_id']);
			$sql3 = "SELECT * FROM test_attempt WHERE candidate_id=:candidate_id and schedule_id=:schedule_id";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array(':candidate_id' => $res['candidate_id'],':schedule_id' => $res['schedule_id']));
			$data=array();
				$tests="";
			
			while($row3=$query3->fetch())
			{
				$test_id = $row3->test_id;
				
				$res['feedback'] = $row3->remark;
				$res['overall_rating'] = $row3->rating;
				$res['candidatefeedback'] = $this->getName($row3->attempt_id,'feedback','feedback','attempt_id');
				$res['Interpretation'] = $row3->interpretation;
				$marks_obtained = $row3->	marks_obtained;
				$Passing_marks=$this->getName($test_id,'Test_paper','Passing_marks','Id');
			$tests=$this->getName($test_id,'Test_paper','Name','Id');
			}
			
			if($marks_obtained >=$Passing_marks){
					$res['final_res']='Pass';
				}
				else{
					$res['final_res']='Fail';
				}
			
			
			$res['testname']=$tests;
			$result[] =$res;
		}
      
        return $result;
	}
	
	
	public function checkedstatus($candidate_id,$schedule_id)
	{
		
			$sql3 = "SELECT checkedSts FROM test_attempt WHERE candidate_id=:candidate_id and schedule_id=:schedule_id  
			 order by checkedSts asc";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array(':candidate_id' => $candidate_id,':schedule_id' => $schedule_id));
			
			$checked=array();
			$unchecked=array();
			$parchecked=array();
			$count=0;
			while($row3=$query3->fetch())
			{
				
				if($row3->checkedSts==0)
				{
					$unchecked[]=$row3->checkedSts;
					
				}
				else if($row3->checkedSts==1)
				{
					$checked[]=$row3->checkedSts;
				}
				else
				{
					$parchecked[]=$row3->checkedSts;
				}
				$count++;
				
			}
			if($count==count($unchecked))
				return 0;
			else if($count==count($checked))
				return 1;
			else
				return 2;
			
			// $count =  $query3->rowCount();
			
			// if($count>1)
			// {
				// $checked=2;	
			// }
			
			// else if($count==1)
			// {
				// if($row3->checkedSts==1)
					// {
						// $checked=1;
					// }
					// else{
						 // $checked=0;
					// }
			// }
			// return $checked;
	}
	
	public function overallpercentage($candidate_id,$schedule_id)
    {
		$org_id=$_SESSION['user_org_id']; 
		$sql = "SELECT count(test_id) as total_test ,sum(total_ques) as total_ques , SEC_TO_TIME( SUM( TIME_TO_SEC(time_taken) ) )as time_taken , sum(total_unattempt) as total_unattempt   FROM test_attempt where candidate_id=? and schedule_id=?";
        $query = $this->db->prepare($sql);
        $query->execute(array($candidate_id,$schedule_id));
       // $result1 =array();
		$totaltest=0;
		while($row = $query->fetch())
		{
			$res=array();
			$totaltest=$res['total_test']=$row->total_test;
			//$result1[] =$res;
		} 
		$alltests="";
		$overallpercent=0; $overallflg=0;	
		$sql1 = "SELECT * FROM test_attempt where candidate_id=? and schedule_id=?"; 
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array($candidate_id,$schedule_id));
		while($row1=$query1->fetch())
		{
			
				$testid=$row1->test_id;
			$attempt_id=$res['attempt_id']=$row1->attempt_id; 
			$marksobtain=$row1->marks_obtained; 
			
		//	$marksobtain=0; 
			//$totalmarks=self::getTotalmarks($testid);
			$totalmarks=$row1->total_marks; 
			//////////////////getting marks obtained by candidate///////
			$sql = "SELECT * FROM quiz_attempt_ques where quiz_id=:test_id and attempt_id=:attempt_id";
			$query = $this->db->prepare($sql);
			$query->execute(array(":test_id"=>$testid, ":attempt_id"=>$attempt_id)); 
			
			while($row = $query->fetch())
			{
				$ques_type=self::getName($row->ques_id,"question_table","ques_type","ques_id");
				$ans_marks= $this->getAnswerSts($attempt_id,$row->ques_id,$row->result,$ques_type);
			//	$marksobtain=$marksobtain+$ans_marks;	
				
			}
			
			//////geting overallresult check status
			
			/* $sql4 = "SELECT * FROM quiz_table where cat_id=$testid";
			$query4 = $this->db->prepare($sql4);
			$query4->execute(array(":test_id"=>$testid));
			$checkoverall=0;
			while($row4 = $query4->fetch())
			{
				$checkoverall=$row4->checkoverall; 
			} */
				
				$totalpersent=0;							
			if($totalmarks!=0){
				$totalpersent=($marksobtain/$totalmarks)*100;
							}
						
			
			$totalpersent= round($totalpersent,2);
			
			/* if($checkoverall==1)////include in overall result
			{
				$overallflg++;
				$overallpercent=$overallpercent+$totalpersent;
				
			}  */
			
			
		}		
			
		
		
		///////result criteria for overall test////////////////
		//$overall=($overallpercent/$totaltest);
		//$overall= round($overall,2);
		
		$res['overallpercent'] = $totalpersent;
		return $res;	
				
		
	
	}
	
	
	public function showresult($candidate_id,$schedule_id)
    {
		$org_id=$_SESSION['user_org_id']; 
		$sql = "SELECT count(test_id) as total_test ,sum(total_ques) as total_ques , SEC_TO_TIME( SUM( TIME_TO_SEC(time_taken) ) )as time_taken , sum(total_unattempt) as total_unattempt   FROM test_attempt where candidate_id=? and schedule_id=?";
        $query = $this->db->prepare($sql);
        $query->execute(array($candidate_id,$schedule_id));
       // $result1 =array();
		$totaltest=0;
		while($row = $query->fetch())
		{
			$res=array();
			$totaltest=$res['total_test']=$row->total_test;
			//$result1[] =$res;
		} 
		$alltests="";
		$overallpercent=0; $overallflg=0;	
		$sql1 = "SELECT * FROM test_attempt where candidate_id=? and schedule_id=?"; 
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array($candidate_id,$schedule_id));
		while($row1=$query1->fetch())
		{
			
				$testid=$row1->test_id;
			$attempt_id=$res['attempt_id']=$row1->attempt_id; 
			
			$marksobtain=0; 
			$totalmarks=self::getTotalmarks($testid);
			//////////////////getting marks obtained by candidate///////
			$sql = "SELECT * FROM quiz_attempt_ques where quiz_id=:test_id and attempt_id=:attempt_id";
			$query = $this->db->prepare($sql);
			$query->execute(array(":test_id"=>$testid, ":attempt_id"=>$attempt_id)); 
			
			while($row = $query->fetch())
			{
				$ques_type=self::getName($row->ques_id,"question_table","ques_type","ques_id");
				$ans_marks= $this->getAnswerSts($attempt_id,$row->ques_id,$row->result,$ques_type);
				$marksobtain=$marksobtain+$ans_marks;	
				
			}
			
			//////geting overallresult check status
			
			$sql4 = "SELECT * FROM quiz_table where cat_id=$testid";
			$query4 = $this->db->prepare($sql4);
			$query4->execute(array(":test_id"=>$testid));
			$checkoverall=0;
			while($row4 = $query4->fetch())
			{
				$checkoverall=$row4->checkoverall; 
			}
				
				$totalpersent=0;							
			if($totalmarks!=0){
				$totalpersent=($marksobtain/$totalmarks)*100;
							}
						
			
			$totalpersent= round($totalpersent,2);
			
			if($checkoverall==1)////include in overall result
			{
				$overallflg++;
				$overallpercent=$overallpercent+$totalpersent;
				
			}
			
			
		}		
			
		
		
		///////result criteria for overall test////////////////
		$overall=($overallpercent/$totaltest);
		$overall= round($overall,2);
		
		$res['overallpercent'] = $overall;
		return $res;	
				
		
	
	}
	public function getTotalmarks($testid)
    {
		$name="";
        $sql = "select sum(marks) as totalmarks from question_table where cat_id = ?";
        $query = $this->db->prepare($sql);
        $query->execute(array($testid));
		while($row=$query->fetch())
		{
			$name=$row->totalmarks;
		}
        return $name;
    }
	
	public function getAnswerSts($attempt_id,$quesid,$candidateans,$questype)
    {
		
		if($questype==1)
		{
			$sql2="SELECT * FROM quiz_attempt_ques WHERE ques_id=:quesid and attempt_id=:aid";
			$query2= $this->db->prepare($sql2);
			$query2->execute(array(':quesid'=>$quesid,':aid'=>$attempt_id));
			$result1=array();
			while($row2=$query2->fetch())
			{
				if($row2->checkTestSts==0 && $row2->rating==0){
					return "";
				}
				else
				{
					return $row2->rating;
				}
				
			}
		}else{
			$sql2="SELECT * FROM answer_table WHERE ques_id=:quesid and weightage>=1";
			$query2= $this->db->prepare($sql2);
			$query2->execute(array(':quesid'=>$quesid));
			$result1=array();
			while($row2=$query2->fetch())
			{
				$ans=$row2->answert_type;
				if($candidateans==$ans)
				{
					return $row2->weightage;
				}

			}
			
		}	

        return 0;
    }
	
public function getTable($sts=0)
	{
	
		$org_id=$_SESSION['user_org_id'];
		$date=date('Y-m-d H:i:s');
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$position = isset($_POST["position"])?$_POST["position"]:0;
		$positionSts =isset($_POST['positionSts'])?($_POST['positionSts']):0;
		$pos="";
		$posSts="";
		if($position!=0)
		{
		$pos="and d.Id=".$position;
		}
		
				
		if($positionSts!=0)
		{
			if($positionSts==1){
				$posSts=" and d.sts=1";
			}elseif($positionSts==2){
				$posSts=" and d.sts=2";
			}else{
				$posSts="";
			}
		
		
		}
       $enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
	   $showdate=" ";
		if($startdate!='' && $enddate!=''){
			$showdate="and date(s.schedule_date)  between '$startdate'  and  '$enddate' ";
		}
		/* if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		$sql="";
		if($sts==1)
		{
		$sql = "select c.candidate_id as candidate_id, c.candidate_fname as candidate_name,c.candidate_lname as candidate_lname, d.PositionName as designation_name, s.schedule_date as schedule_date, s.testlevel as level from DefaultPosition d, candidate_table c, schedule_candidate s where c.candidate_id=s.candidate_id and c.designation_id=d.designation_id and s.schedule_date >='$date' and c.org_id=$org_id $pos order by s.schedule_date asc";
		}elseif($sts==2)
		{
			$sql = "select c.candidate_id as candidate_id, c.candidate_fname as candidate_name,c.candidate_lname as candidate_lname, d.PositionName as designation_name, s.schedule_date as schedule_date, s.testlevel as level from DefaultPosition d, candidate_table c, schedule_candidate s where c.candidate_id=s.candidate_id and c.designation_id=d.designation_id and month(s.schedule_date)=month(current_date()) and c.org_id=$org_id order by s.schedule_date asc";
		}if($sts==3)
		{
		$sql = "select c.candidate_id as candidate_id, c.candidate_fname as candidate_name,c.candidate_lname as candidate_lname, d.PositionName as designation_name, s.schedule_date as schedule_date, s.testlevel as level from DefaultPosition d, candidate_table c, schedule_candidate s where c.candidate_id=s.candidate_id and c.designation_id=d.Id $showdate and c.org_id=$org_id $pos  order by s.schedule_date desc";
		}
		else{
		$sql = "select c.candidate_id as candidate_id, c.candidate_fname as candidate_name,c.candidate_lname as candidate_lname, d.PositionName as designation_name, s.schedule_date as schedule_date, s.testlevel as level from DefaultPosition d, candidate_table c, schedule_candidate s where c.candidate_id=s.candidate_id and c.designation_id=d.designation_id and date(s.schedule_date)>=curdate() and c.org_id=$org_id and s.id not in (select schedule_id from test_attempt) order by s.schedule_date asc";
		}
		$query = $this->db->prepare($sql);
        $query->execute();        
        $result =array();
		
        while($row = $query->fetch())
        {
			$res= array();
			$res['designation_name'] =$row->designation_name;
			$res['candidate'] =$row->candidate_name;
		$res['candidate_fullname'] = ucwords(strtolower($row->candidate_name." ".$row->candidate_lname));
			$res['schedule_date']=$row->schedule_date;
		$res['candidate_id']=$row->candidate_id;
				$res["startdate"]	=$startdate;
			$res["enddate"]	=$enddate;
			$res['level']=$this->getName($row->level,'test_level','level','id');
			$result[] =$res;
		}
      
        return $result;
	}
	public function getProfile(){
	
        $userid=isset($_SESSION['user_id'])?$_SESSION['user_id']:"0";
        $sql = "SELECT * FROM users where user_id=?";
        $query = $this->db->prepare($sql);
        $query->execute(array($userid));        
        $result = $query->fetch();
		
		return $result;
	}
	
	public function getDeclearedResult($startdate,$enddate)
    {
		//$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		//$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		
		
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		//echo $startdate;
		$org_id=$_SESSION['user_org_id'];
		$sql="SELECT * from test_attempt where rating >3 and candidate_id in (select candidate_id from candidate_table where   org_id=$org_id ) and date(teststart_date) between '$startdate' and '$enddate' ";
		
        $query = $this->db->prepare($sql);
        $query->execute(array());        
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['candidate_id'] = $row->candidate_id;
			$res['schedule_id'] = $row->schedule_id;
			$sql1="SELECT candidate_fname,candidate_lname FROM candidate_table WHERE candidate_id=:candidateid ";
			$query1= $this->db->prepare($sql1);
			$query1->execute(array(':candidateid'=>$row->candidate_id));
			while($row1=$query1->fetch())
			{
				$res['candidate_fname'] = $row1->candidate_fname;
				$res['candidate_lname'] = $row1->candidate_lname;
				$res['candidate_fullname'] = ucwords(strtolower($row1->candidate_fname." ".$row1->candidate_lname));
				
			}
				
			
	
			$desig=$this->getName($res['candidate_id'],'candidate_table','designation_id','candidate_id');
			$res['candidate_desig']=$this->getName($desig,'DefaultPosition','PositionName','Id');
			$sql3 = "SELECT * FROM test_attempt WHERE candidate_id=:candidate_id and schedule_id=:scheduled_id";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array(':candidate_id' => $res['candidate_id'], ':scheduled_id'=>$res['schedule_id']));
			$data=array();
				$tests="";
			
			while($row3=$query3->fetch())
			{
				
					$res['schedule_id'] = $row->schedule_id;
				$test_id = $row3->test_id;
				$res['overall_rating'] = $row3->rating;
				$res['feedback'] = $row3->remark;
				$res['candidatefeedback'] = $this->getName($row3->attempt_id,'feedback','feedback','attempt_id');
				$res['Interpretation'] = $row3->interpretation;
				$tests=$this->getName($test_id,'Test_paper','Name','Id');
					
			}
			$res['testname']=$tests;
			$result[] =$res;
		}
      
        return $result;
    }
	
	 public function getAllDesignations($from,$to)
    {
		try{	
		$result =array();	
		$startdate = $from;
     $enddate = $to;
	
		if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		}
		
		$org_id=$_SESSION['user_org_id'];
		/* $sql = "select * from designation_table where ((date(startdate)<='$startdate' and date(enddate)>='$startdate') or (date(startdate)<='$enddate' and date(enddate)>='$enddate') ) and org_id=$org_id and sts=1"; */
		$sql = " select * from DefaultPosition where OrganizationId=$org_id  ";
		
        $query = $this->db->prepare($sql);
        $query->execute();
			
			while($row = $query->fetch())
			{
				
				$res= array();
				$res['designation_id'] = $row->Id;
				$res['designation_name'] = $row->PositionName;
				//$res['status'] = $row->status;
				//$res['create_date'] = $row->create_date;
				//$res['modified_date'] = $row->modified_date;
				//$res['sts'] = $row->sts;
				//$res['startdate'] = ($row->startdate!="0000-00-00")?$row->startdate:"";
				//$res['enddate'] = ($row->enddate!="0000-00-00")?$row->enddate:"";
				//$res['startdate1'] = $startdate;
				//echo  $res['startdate1'];
				//$res['enddate1'] = $enddate;
				 
				$result[] =$res;
			}
		}
		catch(Exception $e){
		}
        return $result;
    }
	
	public function getName($id,$table,$field,$where)
    {
		$name="";
        $sql = "select $field from $table where $where = ?";
        $query = $this->db->prepare($sql);
        $query->execute(array($id));
		while($row=$query->fetch())
		{
			$name=$row->$field;
		}

        return $name;
    }
	
	
}
