<?php

/**
 * CourseModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class CourseModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getAllCourses()
    {
        $sql = "SELECT course_id, course_name, course_image, course_status, create_date, modified_date FROM course_table";
        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['course_id'] = $row->course_id;
			$res['course_name'] = $row->course_name;
			$res['course_image'] = $row->course_image;
			$res['course_status'] = $row->course_status;
			$res['create_date'] = $row->create_date;
			$res['modified_date'] = $row->modified_date;
			
			$sql1 = "SELECT lession_id FROM lession_table where course_id =:courseid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array('courseid'=>$row->course_id));
			$count =  $query1->rowCount();
			$res['lession_count'] = $count;
			$result[] =$res;
		}
      
        return $result;
    }

    /**
     * Getter for a single group
     * @param int $group_id id of the specific group
     * @return object a single object (the result)
     */
    public function getCourse($course_id)
    {
        $sql = "SELECT course_id, course_name, course_image,course_status, create_date, modified_date, short_desc, long_desc FROM course_table WHERE course_id = :course_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_id' => $course_id));

        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }

    /**
     * Setter for a group (create)
     * @param string $group_text group text that will be created
     * @return bool feedback (was the group created properly ?)
     */
    public function create()
    {
        // clean the input to prevent for example javascript within the groups.
        $course_name = strip_tags($_POST['course_name']);
		$short_desc = htmlspecialchars($_POST['short_desc']);
		$long_desc = htmlspecialchars($_POST['long_desc']);
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		
		$target_dir = UPLOAD_PATH;
		//$ext = pathinfo($_FILES["fileToUpload"]["tmp_name"],PATHINFO_EXTENSION);
		$filename =  "";//mt_rand(1000, 9999).round(microtime(true) * 1000).".".$ext;
		//$target_file = $target_dir .$filename;
		
		if (!empty($_FILES['fileToUpload']['tmp_name']) ) {
			
		 if (!is_dir($target_dir) OR !is_writable($target_dir)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_FOLDER_DOES_NOT_EXIST_OR_NOT_WRITABLE;
            return false;
        }

        if (!isset($_FILES['fileToUpload']) OR empty ($_FILES['fileToUpload']['tmp_name'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_FAILED;
            return false;
        }

        // get the image width, height and mime type
        $image_proportions = getimagesize($_FILES['fileToUpload']['tmp_name']);

        // if input file too big (>5MB)
        if ($_FILES['fileToUpload']['size'] > 5000000 ) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_TOO_BIG;
            return false;
        }
        // if input file too small
        if ($image_proportions[0] < IMAGE_SIZE OR $image_proportions[1] < IMAGE_SIZE) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_TOO_SMALL;
            return false;
        }

        if ($image_proportions['mime'] == 'image/jpeg' || $image_proportions['mime'] == 'image/png') {
            // create a jpg file in the avatar folder
            $filename = mt_rand(1000, 9999).round(microtime(true) * 1000) . ".jpg";
            $target_file_path = $target_dir .  $filename;
            $this->resizeAvatarImage($_FILES['fileToUpload']['tmp_name'], $target_file_path, IMAGE_SIZE, IMAGE_SIZE, IMAGE_JPEG_QUALITY, true);
            
            //Session::set('user_avatar_file', $this->getUserAvatarFilePath());
            $_SESSION["feedback_positive"][] = FEEDBACK_IMAGE_UPLOAD_SUCCESSFUL;
            //return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_WRONG_TYPE;
            return false;
        }
       
	}
	
        $sql = "INSERT INTO course_table (course_name, short_desc, long_desc,course_image, course_status, create_date, modified_date) VALUES (:course_name, :short_desc, :long_desc, :file, :csts, :cdate, :mdate)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_name' => $course_name, ':short_desc' => $short_desc, ':long_desc' => $long_desc, ':csts'=>1,':file' => $filename, ':cdate'=>$mdate, ':mdate'=>$mdate));

        $count =  $query->rowCount();
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_COURSE_ADDITION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_COURSE_ADDITION_FAILED;
        }
        // default return
        return false;
    }

    /**
     * Setter for a group (update)
     * @param int $group_id id of the specific group
     * @param string $group_text new text of the specific group
     * @return bool feedback (was the update successful ?)
     */
    public function editSave($course_id)
    {
        // clean the input to prevent for example javascript within the groups.
        $course_name = strip_tags($_POST['course_name']);
		$short_desc = htmlspecialchars($_POST['short_desc']);
		$long_desc = htmlspecialchars($_POST['long_desc']);
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		
		$target_dir = UPLOAD_PATH;
		//$ext = pathinfo($_FILES["fileToUpload"]["tmp_name"],PATHINFO_EXTENSION);
		$filename =  "";//mt_rand(1000, 9999).round(microtime(true) * 1000).".".$ext;
		//$target_file = $target_dir .$filename;
		
		if (!empty($_FILES['fileToUpload']['tmp_name']) ) {
			
		 if (!is_dir($target_dir) OR !is_writable($target_dir)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_FOLDER_DOES_NOT_EXIST_OR_NOT_WRITABLE;
            return false;
        }

        if (!isset($_FILES['fileToUpload']) OR empty ($_FILES['fileToUpload']['tmp_name'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_FAILED;
            return false;
        }

        // get the image width, height and mime type
        $image_proportions = getimagesize($_FILES['fileToUpload']['tmp_name']);

        // if input file too big (>5MB)
        if ($_FILES['fileToUpload']['size'] > 5000000 ) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_TOO_BIG;
            return false;
        }
        // if input file too small
        if ($image_proportions[0] < IMAGE_SIZE OR $image_proportions[1] < IMAGE_SIZE) {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_TOO_SMALL;
            return false;
        }

        if ($image_proportions['mime'] == 'image/jpeg' || $image_proportions['mime'] == 'image/png') {
            // create a jpg file in the avatar folder
            $filename = mt_rand(1000, 9999).round(microtime(true) * 1000) . ".jpg";
            $target_file_path = $target_dir .  $filename;
            $this->resizeAvatarImage($_FILES['fileToUpload']['tmp_name'], $target_file_path, IMAGE_SIZE, IMAGE_SIZE, IMAGE_JPEG_QUALITY, true);
            
            //Session::set('user_avatar_file', $this->getUserAvatarFilePath());
            $_SESSION["feedback_positive"][] = FEEDBACK_IMAGE_UPLOAD_SUCCESSFUL;
            //return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_IMAGE_UPLOAD_WRONG_TYPE;
            return false;
        }
        $sql = "UPDATE course_table SET course_name = :course_name, short_desc = :short_desc, long_desc = :long_desc, course_image=:file, modified_date=:mdate WHERE course_id = :course_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_name' => $course_name, ':long_desc' => $long_desc, ':short_desc' => $short_desc, ':file' => $filename, ':mdate'=>$mdate, ':course_id' => $course_id ));
        $count =  $query->rowCount();
	}else{
		$sql = "UPDATE course_table SET course_name = :course_name, short_desc = :short_desc, long_desc = :long_desc, modified_date=:mdate WHERE course_id = :course_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_name' => $course_name, ':long_desc' => $long_desc, ':short_desc' => $short_desc, ':mdate'=>$mdate, ':course_id' => $course_id ));
        $count =  $query->rowCount();
	}
        

        
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_COURSE_EDITING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_COURSE_EDITING_FAILED;
        }
        // default return
        return false;
    }
    
    
	public function resizeAvatarImage(
        $source_image, $destination_filename, $width = 150, $height = 150, $quality = 85, $crop = true)
    {
        $image_data = getimagesize($source_image);
        if (!$image_data) {
            return false;
        }

        // set to-be-used function according to filetype
        switch ($image_data['mime']) {
            case 'image/gif':
                $get_func = 'imagecreatefromgif';
                $suffix = ".gif";
            break;
            case 'image/jpeg';
                $get_func = 'imagecreatefromjpeg';
                $suffix = ".jpg";
            break;
            case 'image/png':
                $get_func = 'imagecreatefrompng';
                $suffix = ".png";
            break;
        }

        $img_original = call_user_func($get_func, $source_image );
        $old_width = $image_data[0];
        $old_height = $image_data[1];
        $new_width = $width;
        $new_height = $height;
        $src_x = 0;
        $src_y = 0;
        $current_ratio = round($old_width / $old_height, 2);
        $desired_ratio_after = round($width / $height, 2);
        $desired_ratio_before = round($height / $width, 2);

        if ($old_width < $width OR $old_height < $height) {
             // the desired image size is bigger than the original image. Best not to do anything at all really.
            return false;
        }

        // if crop is on: it will take an image and best fit it so it will always come out the exact specified size.
        if ($crop) {
            // create empty image of the specified size
            $new_image = imagecreatetruecolor($width, $height);

            // landscape image
            if ($current_ratio > $desired_ratio_after) {
                $new_width = $old_width * $height / $old_height;
            }

            // nearly square ratio image
            if ($current_ratio > $desired_ratio_before AND $current_ratio < $desired_ratio_after) {

                if ($old_width > $old_height) {
                    $new_height = max($width, $height);
                    $new_width = $old_width * $new_height / $old_height;
                } else {
                    $new_height = $old_height * $width / $old_width;
                }
            }

            // portrait sized image
            if ($current_ratio < $desired_ratio_before) {
                $new_height = $old_height * $width / $old_width;
            }

            // find ratio of original image to find where to crop
            $width_ratio = $old_width / $new_width;
            $height_ratio = $old_height / $new_height;

            // calculate where to crop based on the center of the image
            $src_x = floor((($new_width - $width) / 2) * $width_ratio);
            $src_y = round((($new_height - $height) / 2) * $height_ratio);
        }
        // don't crop the image, just resize it proportionally
        else {
            if ($old_width > $old_height) {
                $ratio = max($old_width, $old_height) / max($width, $height);
            } else {
                $ratio = max($old_width, $old_height) / min($width, $height);
            }

            $new_width = $old_width / $ratio;
            $new_height = $old_height / $ratio;
            $new_image = imagecreatetruecolor($new_width, $new_height);
        }

        // create avatar thumbnail
        imagecopyresampled($new_image, $img_original, 0, 0, $src_x, $src_y, $new_width, $new_height, $old_width, $old_height);

        // save it as a .jpg file with our $destination_filename parameter
        imagejpeg($new_image, $destination_filename, $quality);

        // delete "working copy" and original file, keep the thumbnail
        imagedestroy($new_image);
        imagedestroy($img_original);

        if (file_exists($destination_filename)) {
            return true;
        }
        // default return
        return false;
    }
    /**
     * Deletes a specific group
     * @param int $group_id id of the group
     * @return bool feedback (was the group deleted properly ?)
     */
    public function delete($course_id)
    {
        $sql = "DELETE FROM course_table WHERE course_id = :course_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':course_id' => $course_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_COURSE_DELETION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_COURSE_DELETION_FAILED;
        }
        // default return
        return false;
    }
    
    public function changestatus($course_id, $status)
    {
		$status = ($status==1)?0:1;
        $sql = "update course_table set course_status=:sts WHERE course_id = :course_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sts' => $status, ':course_id' => $course_id));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_COURSE_CHANGE_STATUS_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_COURSE_CHANGE_STATUS_FAILED;
        }
        // default return
        return false;
    }
}
