<?php

/**
 * UserModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class CostcenterModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function create()
    {
		$count1=0;$count=0;
		$org_id=$_SESSION['user_org_id'];
		$userid=$_SESSION['user_id'];
        // clean the input to prevent for example javascript within the groups.
		$code = $_POST['code'];
		$name =$_POST['name'];
		$description =$_POST['description'];
		$date=date('Y-m-d h:i:s a');
		
		$sql1 = "SELECT * FROM cost_center WHERE code=:code and org_id=:org_id";
        $query1 = $this->db->prepare($sql1);
		$query1->execute(array( ':code'=>$code,':org_id'=>$org_id));
		
		$sql2 = "SELECT * FROM cost_center WHERE name=:name and org_id=:org_id";
        $query2 = $this->db->prepare($sql2);
        $query2->execute(array( ':name' =>$name,':org_id'=>$org_id));

	   $count1 =  $query1->rowCount();
	   $count2 =  $query2->rowCount();
		if($count1>=1){
			 $res["status"]=false;		
				$res["errorMsg"]="Cost Center Code already exists";
			
		}else if($count2>=1)
		{
			$res["status"]=false;		
			$res["errorMsg"]="Cost Center Name already exists";

		}else
		{
        $sql = "INSERT INTO cost_center (code, name,Description, created_date, created_by_id,org_id) VALUES (:code, :name, :description ,:createddate, :uid,:org_id)";
        $query = $this->db->prepare($sql);
        $query->execute(array( ':code'=>$code, ':name' =>$name, ':description' =>$description, ':createddate' => $date, ':uid'=>$userid,':org_id'=>$org_id));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$res['status']=true;		
				$res['successMsg']="Cost Center created successfully";
			
        } else {
           $res['status']=false;		
				$res['errorMsg']="Cost Center not created ";
        }
		
		}
		
		$data[]=$res;
		//print_r($data);
        // default return
        return $data;
    }
	
	 public function update()
    {
		$count1=0;$count=0;
		$org_id=$_SESSION['user_org_id'];
		$userid=$_SESSION['user_id'];
        // clean the input to prevent for example javascript within the groups.
		$code = $_POST['code'];
		$name =$_POST['name'];
		$c_id =$_POST['c_id'];
		$description =$_POST['description'];
		$date=date('Y-m-d h:i:s a');
		
		$sql1 = "SELECT * FROM cost_center WHERE Id!=:c_id and org_id=:org_id and code=:code";
        $query1 = $this->db->prepare($sql1);
		$query1->execute(array(':c_id' =>$c_id ,':code'=>$code,':org_id'=>$org_id));
		
		$sql2 = "SELECT * FROM cost_center WHERE Id!=:c_id and org_id=:org_id  and name=:name ";
        $query2 = $this->db->prepare($sql2);
        $query2->execute(array(':c_id' =>$c_id , ':name' =>$name,':org_id'=>$org_id));

	   $count1 =  $query1->rowCount();
	   $count2 =  $query2->rowCount();
		if($count1>=1){
			 $res["status"]=false;		
				$res["errorMsg"]="Cost Center Code already exists ";
			
		}else if($count2>=1){
			$res["status"]=false;		
				$res["errorMsg"]="Cost Center Name already exists ";

		}else
		{
    $sql = "UPDATE cost_center SET code=:code,Name=:name, Description=:description, modified_date=:modified_date,modifiedbyid=:uid,org_id=:org_id WHERE Id=$c_id ";
        $query = $this->db->prepare($sql);
        $query->execute(array( ':code'=>$code, ':name' =>$name,':description' =>$description, ':modified_date' => $date, ':uid'=>$userid,':org_id'=>$org_id));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$res['status']=true;		
				$res['successMsg']="Cost Center Updated successfully";
			
        } else {
           $res['status']=false;		
				$res['errorMsg']="Cost Center not updated ";
        }
		
		}
		
		$data[]=$res;
		//print_r($data);
        // default return
        return $data;
    }
	
	 public function deletecost($c_id)
    {
		$count1=0;
		$org_id=$_SESSION['user_org_id'];
		$sql1 = "SELECT * FROM candidate_table WHERE 	CostCenter=$c_id and org_id=$org_id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array());

      $count1 =  $query1->rowCount();
		if($count1>=1)
		{
			 $data["status"]=false;		
				$data["errorMsg"]="This Cost Center is used for candidate ";
			
		}
		else
		{
    $sql = "DELETE FROM `cost_center` WHERE Id=$c_id and org_id=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute(array( ));

       $count =  $query->rowCount();
   
        if ($count == 1) {
			$data['status']=true;		
				$data['successMsg']="Cost Center deleted successfully";
			
        } else {
           $data['status']=false;		
				$data['errorMsg']="Cost Center not deleted ";
        } 
		
	}
		
		
        return $data;
    }

public function getcostcenter($editper,$deleteper)
    {
	$org_id=$_SESSION['user_org_id'];
	$edit_per= $editper;
	$delete_per= $deleteper;
	$sql = "SELECT * FROM cost_center WHERE org_id=$org_id";
	
        $query= $this->db->prepare($sql);
		$query->execute();
		$d= array();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res = array();
		   $res['code'] = $row->code;
		   $res['name'] = $row->Name;
		   $res['c_id'] = $row->Id;
		   $res['description'] = $row->Description;
		   $edit="";
		   $delete="";
		   if($edit_per){
		   $edit="<a rel='tooltip' title='Edit'  onclick='angular.element(this).scope().onfetchdata(".$row->Id.")'  href='#' data-original-title='Edit' class='label bg-green'><i class='fa fa-edit'></i></a>&nbsp;&nbsp;&nbsp;&nbsp;";
			}
		   if($delete_per){
		   $delete="<a rel='tooltip' title='Delete' onclick='angular.element(this).scope().onfetchfordelete(\"".$row->Id."\")' data-toggle='modal' data-target='#confirm' href='#' data-original-title='Delete' class='label bg-red'><i class='fa fa-trash-o'></i></a>";
			}
		   $res['action']=$edit.$delete;
		   $data[]=$res;
	   }
	   $d['data']=$data;  	
		//echo json_encode($d); 
		return $d; 
		
        
    }

 public function getallcostcenter($id)
    {
	$org_id=$_SESSION['user_org_id'];
	$sql = "SELECT * FROM cost_center WHERE org_id=$org_id and Id='$id'";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['code'] = $row->code;
		   $res['name'] = $row->Name;
		   $res['c_id'] = $row->Id;
		   $res['description'] = $row->Description;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////all down functions are used for candidate dropdown/////////////////////////////////////////////////////////////////////////////////////////////////////////
	public function getcostcenterforcan()
    {
	$org_id=$_SESSION['user_org_id'];
	$sql = "SELECT * FROM cost_center WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['code'] = $row->code;
		   $res['name'] = $row->Name;
		   $res['c_id'] = $row->Id;
		   $res['description'] = $row->Description;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
	public function getlocationforcan()
    {
	$org_id=$_SESSION['user_org_id'];
	$sql = "SELECT * FROM location WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['code'] = $row->location_code;
		   $res['name'] = $row->location_name;
		   $res['loc_id'] = $row->Id;
		   $res['description'] = $row->Description;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
	public function getcostloanforcan()
    {
	$org_id=$_SESSION['user_org_id'];
	$sql = "SELECT * FROM loan_cc WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['code'] = $row->loancc_code;
		   $res['name'] = $row->loancc_name;
		   $res['loancc_id'] = $row->Id;
		   $res['description'] = $row->Description;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
	public function getloanlocforcan()
    {
	$org_id=$_SESSION['user_org_id'];
	$sql = "SELECT * FROM loan_loc WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['code'] = $row->loanloc_code;
		   $res['name'] = $row->loanloc_name;
		   $res['loanloc_id'] = $row->Id;
		   $res['description'] = $row->Description;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
	public function getemptypeforcan()
    {
	$org_id=$_SESSION['user_org_id'];
	$sql = "SELECT * FROM employee_type WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		 
		   $res['name'] = $row->Name;
		   $res['emp_id'] = $row->Id;
		   $res['description'] = $row->Description;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
	public function getsalarygradeforcan()
    {
	$org_id=$_SESSION['user_org_id'];
	$sql = "SELECT * FROM salary_grad WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		 
		   $res['code'] = $row->salarygrad_code;
		   $res['name'] = $row->salarygrad_name;
		   $res['sg_id'] = $row->Id;
		   $res['description'] = $row->Description;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
	public function getspecialityforcan()
    {
	$org_id=$_SESSION['user_org_id'];
	$sql = "SELECT * FROM speciality WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		 
		
		   $res['name'] = $row->speciality_name;
		   $res['sp_id'] = $row->Id;
		   $res['description'] = $row->Description;
		   $data[]=$res;
	   }
		
        return $data;
    }
	public function gettasjobforcan()
    {
	$org_id=$_SESSION['user_org_id'];
	$sql = "SELECT * FROM TAS_job WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['name'] = $row->tasjob_name;
		   $res['tas_id'] = $row->Id;
		   $res['description'] = $row->Description;
		   $data[]=$res;
	   }
		
        return $data;
    }
	
	public function getworkareaforcan()
    {
	$org_id=$_SESSION['user_org_id'];
	$sql = "SELECT * FROM work_area WHERE org_id=$org_id ";
	
        $query= $this->db->prepare($sql);
        $query->execute();
		$data =array();
	   while($row=$query->fetch())
	   {
		   $res =array();
		   $res['name'] = $row->workarea_name	;
		   $res['work_id'] = $row->Id;
		   $res['description'] = $row->Description;
		   $data[]=$res;
	   }
	     return $data;
	}
	
}