<?php

/**
 * RoleModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class CompanyModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
	 
    public function __construct(Database $db)
    {
        $this->db = $db;
    }
	
    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
	public function getcompanydetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $sql = "SELECT * FROM company_master WHERE id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['orgid'] =$id;
				$res['country'] =$row->country;
				$res['state'] =$row->state;
				$res['city'] =$row->city;
				$res['id'] = $row->id;
				$orgid= $res['id'];
				$res['companyname'] = $row->company_name;
				$res['address'] = $row->address;
				$res['phone'] = $row->phone;
				$res['email'] = $row->email;
				$res['website'] = $row->website;
				$res['logo'] = $row->logo;
				$res['curr_id'] =$row->curr_id;
				/* $res['positions'] =$this->getName('designation_master','count(*)','org_id',$row->id);
				$res['branches'] =$this->getName('employee_branch_master','count(*)','org_id',$row->id);
				$res['applicants'] =$this->getName('candidate_master','count(*)','org_id',$row->id); */
				$data[] = $res;
			}
        }
		if ($count == 1) {
           $status =true;
		   $successMsg = "Company profile fetched successfully.";
        } else {
           $status =false;
		   $errorMsg= "Problem while fetching company profile.";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }

public function getcompanybranchdetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $sql = "SELECT * FROM employee_branch_master WHERE branch_id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['country'] =$row->country_id;
				$res['state'] =$row->state_id;
				$res['city'] =$row->city_id;
				$res['branch'] = $row->branch_name;
				$res['branchaddress'] = $row->address;
				$res['phoneno'] = $row->telephone_no;
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = COMPANY_BRANCH_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg= COMPANY_BRANCH_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

     public function getAllCountry()
    {
		
		//$username=isset($_SESSION['ubirecruit_org_id'])?$_SESSION['ubirecruit_org_id']:'';
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$date= date("d/m/Y");
		$sql = "select * from country_master order by country_name";
		$query = $this->db->prepare($sql);
		try{
			$query->execute();
			$count =  $query->rowCount();
			while($res = $query->fetch())
			{
				$result=array();
				$result['id']=$res->id;
				$result['country_name']=$res->country_name;
				$data[]=$result;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." Record found";
        }else{
			$status=true;
			$successMsg = 'There may some error(s) in fetching record';
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

  public function getAllCurrency()
    {
		
		//$username=isset($_SESSION['ubirecruit_org_id'])?$_SESSION['ubirecruit_org_id']:'';
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$date= date("d/m/Y");
		$sql = "select * from currency_master order by name";
		$query = $this->db->prepare($sql);
		try{
			$query->execute();
			$count =  $query->rowCount();
			while($res = $query->fetch())
			{
				$result=array();
				$result['id']=$res->id;
				$result['currency_name']=$res->name."(".$res->currency_code.")";
				$data[]=$result;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." Record found";
        }else{
			$status=true;
			$successMsg = 'There may some error(s) in fetching record';
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
  public function getAllState($id)
    {
		//$username=isset($_SESSION['ubirecruit_org_id'])?$_SESSION['ubirecruit_org_id']:'';
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$date= date("d/m/Y");
		$sql = "select * from state_master where country_id in ($id) order by state_name";
		$query = $this->db->prepare($sql);
		try{
			$query->execute();
			$count =  $query->rowCount();
			while($res = $query->fetch())
			{
				$result=array();
				$result['id']=$res->id;
				$result['state_name']=$res->state_name;
				$data[]=$result;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." Record found";
        }else{
			$status=true;
			$successMsg = 'There may some error(s) in fetching record';
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    
     public function getAllCity($id)
    {
		
		//$username=isset($_SESSION['ubirecruit_org_id'])?$_SESSION['ubirecruit_org_id']:'';
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$date= date("d/m/Y");
		$sql = "select * from city_master where country_id in ($id) order by city_name";
		$query = $this->db->prepare($sql);
		try{
			$query->execute();
			$count =  $query->rowCount();
			while($res = $query->fetch())
			{
				$result=array();
				$result['id']=$res->id;
				$result['city_name']=$res->city_name;
				$data[]=$result;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." Record found";
        }else{
			$status=true;
			$successMsg = 'There may some error(s) in fetching record';
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	 public function getCity($id)
    {
		
		//$username=isset($_SESSION['ubirecruit_org_id'])?$_SESSION['ubirecruit_org_id']:'';
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$date= date("d/m/Y");
		$sql = "select * from city_master where id in ($id) order by city_name";
		$query = $this->db->prepare($sql);
		try{
			$query->execute();
			$count =  $query->rowCount();
			while($res = $query->fetch())
			{
				$result=array();
				$result['id']=$res->id;
				$result['city_name']=$res->city_name;
				$data[]=$result;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." Record found";
        }else{
			$status=true;
			$successMsg = 'There may some error(s) in fetching record';
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	///function for fetching company branches
	
	

public function getName($table,$colname,$colid,$id=0)
    {
		$name = "";
        $sql = "select $colname from $table WHERE $colid = '$id'";
        $query = $this->db->prepare($sql);
        $query->execute();

        while($row=$query->fetch())
		{
			$name=$row->$colname;
		}
        // default return
        return $name;
    }	
 
	public function Updatecompany($request)
    {
		$result = array();
		$count=0;  $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['user_org_id'];
		$mdate = date("Y-m-d H:i:s");
		$sql = "UPDATE company_master SET  company_name=?, address=?,country=?, state=?, city=?, phone=?, email=?, website=?, modified_date=? WHERE id=?";
		$query = $this->db->prepare($sql);
			try{
				$query->execute(array($request[1], $request[2], $request[3], $request[4], $request[5], $request[6], $request[7], $request[8], $mdate, $orgid ));			
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
				$status =true;
			    $successMsg = "Company profile updated successfully.";
				if(isset($_FILES['file0']))
				{
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = end((explode(".", $file_name))); 
				$storage_name="companylogo.png";
					if (!file_exists("public/uploads/$orgid/"))
						{
						mkdir("public/uploads/$orgid/", 0777, true);
					    }
					if (file_exists("public/uploads/$orgid/$storage_name"))
					{ 
						unlink("public/uploads/$orgid/$storage_name"); 
					}
				$file_size =$_FILES['file0']['size'];
				$file_tmp =$_FILES['file0']['tmp_name'];
				$file_type=$_FILES['file0']['type'];   
				$location="public/uploads/$orgid/";
				// if($file_size > 2097152){
					// $errors[]='File size must be less than 2 MB';
				// }	
				
				if(empty($errors)==true)
				{
					move_uploaded_file($file_tmp, $location.$storage_name );
				}
				else
				{
					$status =false;
					$errorMsg="File size must be less than 2 MB";
					//print_r($errors);
				}
			}
			   
			} else {
			   $status =false;
			   $errorMsg="Problem while updating profile.";
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function UpdateLoginTime($request)
	{
		$result = array();
		$count=0;  $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['user_org_id'];
		$loginduration = $request[0];
		$durationtype = $request[1];
		$modifiedtime = $request[2];
		// $mdate = date("Y-m-d H:i:s");
			$sql = "UPDATE company_master SET  LoginDuration=?, DurationType=?,modified_date=? WHERE id=?";
		
			$query = $this->db->prepare($sql);
			
			try{
				
				$query->execute(array($request[0], $request[1],$request[2],$orgid ));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Login time is updated successfully";
			} else {
			   $status =false;
			   $errorMsg="Problem while updating login time";
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		// default return
		return $result;
	}
   
   	public function getlogintimedetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $sql = "SELECT * FROM company_master WHERE id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['loginduration'] =(int)$row->LoginDuration;
				$res['durationtype'] =$row->DurationType;
				$data[] = $res;
			}
        }
		if ($count == 1) {
           $status =true;
		   $successMsg = "Login time is updated successfully";
        } else {
           $status =false;
		   $errorMsg=  "Problem while updating login time";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
   
}
