<?php

/**
 * CourseModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class AssignmentModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }
	
	 public function getorgnization()
    {
		//$org_id=$_SESSION['user_org_id'];
		$sts1="";
	
        $sql = "SELECT * FROM Organization";
        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['Id'] = $row->Id;
			$res['PhoneNumber'] = $row->PhoneNumber;
			$res['Name'] = $row->Name;
			$res['Email'] = $row->Email;
			$res['City'] = $row->City;
			/*$test_id_array = $row->TestPaper;
			$test= explode(',', $test_id_array);			
			$tests="";	
			foreach($test as $value)
			{
				$test_name=$this->getName($value,'test_category_child','cat_name','cat_id');
				
				if($tests==""){
					$tests=$test_name;
				}else{
						$tests.=",".$test_name;
				}
			}		
			$res['Tests'] = $tests;*/
				
			$result[] =$res;
		}
      
        return $result;
    }
	
	///////////get test according to candidate designation////////
	 public function getAllTests($sts=0)
    {
		$result=array();
		$candidate_id=isset($_REQUEST['candidate_id'])?$_REQUEST['candidate_id']:"";
	
		$desig=$this->getName($candidate_id,'candidate_table','designation_id','candidate_id');
		if($candidate_id==""){
			
			$desig=isset($_REQUEST['designation_id'])?$_REQUEST['designation_id']:"";
		}
		
		$designame=$this->getName($desig,'designation_table','designation_name','designation_id');
		$sql="";
		if($sts==0){
        $sql = "SELECT * FROM set_test WHERE designation_id = :desig_id";
		}else{
		  $sql = "SELECT * FROM set_test WHERE designation_id = :desig_id and testlevel_id=1";	
		}
        $query = $this->db->prepare($sql);
        $query->execute(array(':desig_id' => $desig));
		$data=array();
		while($row=$query->fetch())
		{
			$test_id = $row->tests_id;
			$test= explode(',', $test_id);
			$res=array();
			$tests="";	
			foreach($test as $value)
			{
				if($tests=="")
					$tests=$this->getName($value,'test_category_child','cat_name','cat_id');
				else
					$tests.=", ".$this->getName($value,'test_category_child','cat_name','cat_id');
			}
			$res['id']=$test_id;
			$res['name']=$tests;
			$data[]=$res;
		}
		$result['data']=$data;
		$result['designame']=$designame;
        return $result;
    }
	
	/* public function getAllTestbyLevel($level,$desig)
    {
		$result=array();		
        $sql = "SELECT * FROM set_test WHERE designation_id = :desig_id and testlevel_id=:level";
        $query = $this->db->prepare($sql);
        $query->execute(array(':desig_id' => $desig,':level' => $level));
		$data=array();
		while($row=$query->fetch())
		{
			$test_id = $row->tests_id;
			$test= explode(',', $test_id);
			$res=array();
			$tests="";	
			foreach($test as $value)
			{
				if($tests=="")
					$tests=$this->getName($value,'test_category_child','cat_name','cat_id');
				else
					$tests.=", ".$this->getName($value,'test_category_child','cat_name','cat_id');
			}
			$res['id']=$test_id;
			$res['name']=$tests;
			$data[]=$res;
		}
		$result['data']=$data;
		
        return $result;
    } */
	
	public function getAllTestbyLevel($level,$desig)
    {
		$result=array();		
        $sql = "SELECT * FROM set_test WHERE designation_id = :desig_id and testlevel_id=:level";
        $query = $this->db->prepare($sql);
        $query->execute(array(':desig_id' => $desig,':level' => $level));
		$data=array();
		while($row=$query->fetch())
		{
			$test_id_array = $row->tests_id;
			$test= explode(',', $test_id_array);
			$res=array();
			$tests="";	
			foreach($test as $value)
			{
				$test_name=$this->getName($value,'test_category_child','cat_name','cat_id');
				$test_id=$value;
				$res['id']=$test_id;
				$res['name']=$test_name;
				$data[]=$res;
			}
		}
		$result['data']=$data;
		
        return $result;
    }
	
	public function fetchAllTestPaper()
	{
		$result=array();		
		$org_id=$_SESSION['user_org_id'];
		$sql = "SELECT * FROM test_category WHERE org_id=:org_id";
		$query = $this->db->prepare($sql);
		$query->execute(array(':org_id' => $org_id));
		$testarr=array();
		
		while($row=$query->fetch())
		{
			$data=array();
			$data['cat_id']=$cat_id=$row->test_id;
			$data['cat_name']=$row->test_name;
			$sql1 = "SELECT * FROM test_category_child WHERE org_id=:org_id and test_id=:cat_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':org_id' => $org_id,':cat_id'=> $cat_id));
			$testpaperarr=array();
			while($row1=$query1->fetch())
			{		$res=array();			
					$res['id']=$row1->cat_id;
					$res['name']=$row1->cat_name;
					$testpaperarr[]=$res;
			}
			$data['testpaper']=$testpaperarr;
			$testarr[]=$data;
		}
			$result['data']=$testarr;
		return $result;
	}
	
    public function getAllSetTest($sts)
    {
		$org_id=$_SESSION['user_org_id'];
		$sts1="";
		if($sts==0){
		$sts1="where sts=2";
		}elseif($sts==1){
		$sts1="where sts=1";
		}
        $sql = "SELECT settest_id, designation_id,category_id, tests_id, testlevel_id,create_date, modified_date FROM set_test where designation_id in(select designation_id from designation_table $sts1) and org_id=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['settest_id'] = $row->settest_id;
			$res['designation_id'] = $row->designation_id;
			$res['level'] = $this->getName($row->testlevel_id,'test_level','level','id');
			$res['category_id'] = $row->category_id;
			$res['tests_id'] = "";//$row->tests_id;
			$per=$row->tests_id;
			$res['create_date'] = $row->create_date;
			$res['modified_date'] = $row->modified_date;
			$res['designation_name']="";
			$res['category_name']="";
			$sql1="SELECT designation_name FROM designation_table WHERE designation_id=:designationid";
			$query1= $this->db->prepare($sql1);
			$query1->execute(array(':designationid'=>$row->designation_id));
			while($row1=$query1->fetch())
			{
				$res['designation_name'] = $row1->designation_name;
				
			}
			
			if($per != ""){
				$sql2="SELECT cat_name FROM test_category_child where cat_id in($per)";
				$query2= $this->db->prepare($sql2);
				$query2->execute();
				while($row2=$query2->fetch())
				{
					 $res['category_name'] .= $row2->cat_name.", ";
					
				}
				$res['category_name'] = ($res['category_name']!="")?substr($res['category_name'],0 ,-2):""; // To remove last comma with space (2 characters from last string)
			}	
			
				
			$result[] =$res;
		}
      
        return $result;
    }
	
	
	public function getAllTestPaper($val="")
    {
		
		$org_id=$_SESSION['user_org_id'];
		$positionSts = isset($_POST["positionSts"])?$_POST["positionSts"]:1;
		$position = isset($_POST["position"])?$_POST["position"]:0;
		$sort = isset($_POST["sort"])?$_POST["sort"]:2;
		
		$whr="";
			$whr1="";
			$whr2="";
			$whr3="";
			$ordrby="";
			if($sort!=0){
				if($sort==1){
					$ordrby=" order by created_date";
				}else{
					$ordrby=" order by cat_name";
				}
				
			}
			if($val!=""){
				
				$whr3=" and cat_name like '$val%'";
				
			}
		if($positionSts!=0){
			if($positionSts==1){
				
				if($position!=0){
					
					$whr=" and designation_id=$position";
					
				}
				
			}
			if($positionSts==2){
				
				if($position!=0){
					
					$whr1=" and test_id=$position";
					
				}
				
			}
			
			if($positionSts==3){
				
				if($position!=0){
					
					$whr2=" and testlevel_id=$position";
					
				}
				
			}
			
		}
		
       $sql = "SELECT settest_id, designation_id,category_id, tests_id, testlevel_id,create_date, modified_date FROM set_test where designation_id in(select designation_id from designation_table where sts=1 $whr $whr2) and org_id=$org_id";
        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
		$testpapers="";
        while($row = $query->fetch())
        {
			
			
		
		
			if($testpapers==""){
				$testpapers=$row->tests_id;
			}else{
				$testpapers=$testpapers.",".$row->tests_id;
			}
			
			
		}
			if($testpapers != ""){
				$sql2="SELECT * FROM test_category_child where cat_id in($testpapers) $whr1 $whr3 $ordrby";
				$query2= $this->db->prepare($sql2);
				$query2->execute();
				while($row2=$query2->fetch())
				{
					$res= array();
					 $res['testPaperName'] = $row2->cat_name;
					 $cat_id=$row2->cat_id;
					  $sql = "SELECT quiz_id, test_id,  cat_id,quiz_status, quiz_ques, total_ques, total_time, total_marks, passing_score, negative_marking, negative_markingscore, created_date, modified_date FROM quiz_table where org_id=? and cat_id=$cat_id";
        $query = $this->db->prepare($sql);
        $query->execute(array($org_id));

       
        if($row = $query->fetch())
        {
			
			$res['quiz_id'] = $row->quiz_id;
			$res['test_id'] = $row->test_id;
			$res['cat_id'] = $row->cat_id;
			$res['quiz_status'] = $row->quiz_status;
			$res['quiz_ques'] = $row->quiz_ques;
			$res['total_ques'] = $row->total_ques;
			$res['total_time'] = $row->total_time;
			$res['total_marks'] = $row->total_marks;
			$res['passing_score'] = $row->passing_score;
			$res['negative_marking'] = $row->negative_marking;
			$res['negative_markingscore'] = $row->negative_markingscore;
			$res['created_date'] = $row->created_date;
			$res['modified_date'] = $row->modified_date;
			
			$res['totalques'] =0;
			$sql1 = "SELECT count(ques_id) as totalques,sum(marks) as totalmarks FROM question_table where cat_id =$cat_id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array());
			while($row1 = $query1->fetch()){
				$res['totalques'] = $row1->totalques;
				$res['totalmarks'] = $row1->totalmarks;
			}

			
		}
					 
					 $result[] =$res;
				}
				
			}
		
        return $result;
    }
	
    /**
     * Getter for a single group
     * @param int $group_id id of the specific group
     * @return object a single object (the result)
     */
	 ////////// for edit date///////////
    public function getSetTest($settest_id)
    {
        $sql = "SELECT * FROM set_test WHERE settest_id = :settest_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':settest_id' => $settest_id));
		
        // fetch() is the PDO method that gets a single result
        return $query->fetch();
    }
	
	public function getTestPaperByFilter()
    {
       $positionSts = isset($_POST["positionSts"])?$_POST["positionSts"]:0;
	   
	   $org_id=$_SESSION['user_org_id'];
	   $sql="";
	   if($positionSts==1)
	   {
		   $sql="select * from designation_table where sts=1";
	   }elseif($positionSts==2){
		   
		    $sql="select * from test_category";
		   
	   }else{
		   $sql="select * from test_level";
	   }
	   
	   $result=array();
	   $data=array();
	   if($sql!=""){
			$query1 = $this->db->prepare($sql);
			$query1->execute(array());
			while($row1 = $query1->fetch()){
				$res=array();
				if($positionSts==1)
				{
				$res['id'] = $row1->designation_id;
				$res['name'] = $row1->designation_name;
				}
				if($positionSts==2)
				{
				$res['id'] = $row1->test_id;
				$res['name'] = $row1->test_name;
				}
				if($positionSts==3)
				{
				$res['id'] = $row1->id;
				$res['name'] = $row1->level;
				}
				
				$data[]=$res;
			}
	   }
	   $result['data']=$data;
	   return $result;
    }
	 ////////// for edit date///////////
	/*  public function getDesignationSetTest($designation_id)
    {
		$result =array();
		$sql = "SELECT * FROM set_test WHERE designation_id = :designation_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':designation_id' => $designation_id));
       
        return $query->fetchAll();
    } */
    /**
     * Setter for a group (create)
     * @param string $group_text group text that will be created
     * @return bool feedback (was the group created properly ?)
     */
    public function create()
    {
		$org_id=$_SESSION['user_org_id'];
        // clean the input to prevent for example javascript within the groups.
		$position = isset($_POST['position']) ? $_POST['position'] : "";
		$tests = isset($_POST['tests']) ? $_POST['tests'] : "";
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		$testid="";
			foreach($tests as $value){
				if($testid==""){
					$testid=$value;
				}else{
					$testid.=",".$value;					
				}
			}
			$data=array();
		$sql1 = "select * from DefaultPosition where OrganizationId = ? and PositionName = ?";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array($org_id,$position));
		if(($query1->rowCount())>=1)
		{
			$data["status"]=false;
			$data["errorMsg"] = "Position is already exist";
		}else{
			 $sql = "INSERT INTO DefaultPosition (PositionName,TestPaper, OrganizationId, CreatedById, CreatedDate) VALUES (:position,:test, :org_id,:cid,:cdate)";
			$query = $this->db->prepare($sql);
			$query->execute(array(':position' => $position,':test' => $testid, ':org_id' => $org_id,':cid' => $org_id,':cdate'=>$mdate));
			$count =  $query->rowCount();
			if ($count == 1) {
				$data["status"]=true;		
				$data["successMsg"]=$_SESSION["feedback_positive"][]="Default Position is created successfully.";
			} else {
				$data["status"]=false;			
				$data["errorMsg"]  = "Problem while creating Default Position.";
			}
		}
        // default return
        return $data;
    }

    /**
     * Setter for a group (update)
     * @param int $group_id id of the specific group
     * @param string $group_text new text of the specific group
     * @return bool feedback (was the update successful ?)
     */
    public function editSave($settest_id)
    {
        // clean the input to prevent for example javascript within the groups.
		$org_id=$_SESSION['user_org_id'];
		$designation_id = isset($_POST['designation']) ? $_POST['designation'] : "";
		$level = isset($_POST['level']) ? $_POST['level'] : "";
		$category_id = isset($_POST['category']) ?implode(',',$_POST['category']) : "";
		$test_id = isset($_POST['tests']) ?implode(',',$_POST['tests']) : "";

		$mdate = date("Y-m-d H:i:s");
		$count=0;
		
        $sql = "UPDATE set_test SET category_id = :category_id, tests_id = :test_id, modified_date=:mdate, org_id=$org_id WHERE settest_id = :settest_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':category_id' => $category_id, ':test_id' => $test_id, ':mdate'=>$mdate, ':settest_id' => $settest_id ));
        $count =  $query->rowCount();
	
        if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_SETTEST_EDITING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_SETTEST_EDITING_FAILED;
        }
        // default return
        return false;
    }
    
    public function getName($id,$table,$field,$where)
    {
		$name="";
        $sql = "select $field from $table where $where = ?";
        $query = $this->db->prepare($sql);
        $query->execute(array($id));
		while($row=$query->fetch())
		{
			$name=$row->$field;
		}

        return $name;
    }
	
    /**
     * Deletes a specific group
     * @param int $group_id id of the group
     * @return bool feedback (was the group deleted properly ?)
     */
    public function delete($defaultPositionId)
    {
		$sql= "select * from designation_table where DefaultPositionId=:defaultPositionId";
		$query = $this->db->prepare($sql);
        $query->execute(array(':defaultPositionId' => $defaultPositionId));
		$count1 =  $query->rowCount();
		if($count1 ==1)
		{
			$_SESSION["feedback_negative"][] = "This position is already used";
			return false;
		}
        $sql = "DELETE FROM DefaultPosition WHERE Id = :defaultPositionId";
        $query = $this->db->prepare($sql);
        $query->execute(array(':defaultPositionId' => $defaultPositionId));

        $count =  $query->rowCount();

        if ($count == 1) {
			$_SESSION["feedback_positive"][] = "Test for this position deleted successfully";
            return true;
        } else {
          $_SESSION["feedback_negative"][] = "FEEDBACK_SETTEST_DELETION_FAILED";
			return false;
        }
        // default return
        
    }
    public function getdefaultposition($positionid){
	
	     $sql = "SELECT * from DefaultPosition WHERE Id = :positionid ";
	     $query = $this->db->prepare($sql);
        $query->execute(array(':positionid' => $positionid));
		$res = array();
		if($row = $query->fetch())
		{
			$res['PositionName'] = $row->PositionName;
			$testpaper=$row->TestPaper;
			$test= explode(',', $testpaper);
			$testpaperarr=array();				
			foreach($test as $value)
			{						
					$testpaperarr[]=$value;
			}
			$res['TestId']=$testpaperarr;
		}
		
		return $res;
  }
  public function updateposition($positionid){
	 
	     // $org_id=$_SESSION['user_org_id'];
        // clean the input to prevent for example javascript within the groups.
		$position = isset($_POST['position']) ? $_POST['position'] : "";
		$tests = isset($_POST['tests']) ? $_POST['tests'] : "";
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		$testid="";
			foreach($tests as $value){
				if($testid==""){
					$testid=$value;
				}else{
					$testid.=",".$value;					
				}
			}
		$data=array();
		$sql1 = "select * from DefaultPosition where Id != ? and PositionName = ?";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array($positionid,$position));
		if(($query1->rowCount())>=1)
		{
			$data["status"]=false;
			$data["errorMsg"] = "Position is already exist";
		}else{
			 $sql = "UPDATE DefaultPosition SET PositionName=:position,TestPaper=:test, UpdatedDate=:updatedate WHERE Id=$positionid ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':position' => $position,':test' => $testid,':updatedate' => $mdate));
			$count =  $query->rowCount();
			if ($count == 1) {
				$sql2 = "UPDATE designation_table SET designation_name=:position WHERE DefaultPositionId=$positionid";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array(':position'=>$position));
				/*$count2 =  $query2->rowCount();
				if($count2 == 1)
				{
					$data["status"]=true;		
				    $data["successMsg"]=$_SESSION["feedback_positive"][]="Default Position is updated successfully.";
				}*/
				$data["status"]=true;		
				$data["successMsg"]=$_SESSION["feedback_positive"][]="Default Position is updated successfully.";
				
				
				
			} else {
				$data["status"]=false;			
				$data["errorMsg"]  = "Problem while updated Default Position.";
			}
		}
        // default return
        return $data;
	  
  }
    
   
}
