<?php

/**
 * Class Index
 * The index controller
 */
class Users extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();
	
        Auth::handleLogin();

    }

    function index($val="")
    {
		$viewper = $this->checkPermission(21, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->addper= $this->checkPermission(21, 4);
			$this->view->editper= $this->checkPermission(21, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(21, 3);
		
			$user_model = $this->loadModel('User');
			$this->view->users = $user_model->getAllUsers();        
            $this->view->render('users/index');
		}
    }
	
	 function getusers($val="")
    {
			$user_model = $this->loadModel('User');
			$Usergrouparray = $user_model->getusersonprofilebasis();   
			echo json_encode($Usergrouparray);				
    }
	
	 function costcenter($val="")
    {
		$viewper = $this->checkPermission(23, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->addper= $this->checkPermission(23, 4);
			$this->view->editper= $this->checkPermission(23, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(23, 3);
		if($val!=''){
		   Session::set('edit_label', true);
		
		   } 
		   
			$user_model = $this->loadModel('User');
			$this->view->users = $user_model->getAllUsers();        
            $this->view->render('costcenter/index');
		}
    }
	
	function addnew($val="")
    {
		$user_profile = $this->loadModel('User');
		$this->view->usersprofile = $user_profile->getAllUsersprofile();   
		$this->view->render('users/addnew');
    }
	
    public function create()
    {
        $user_model = $this->loadModel('User');
        $user_model->create();
        
         header('location: ' . URL . 'users');
    }

    public function edit($user_id)
    {
		$this->view->pageid=14;
        if (isset($user_id)) {
            // get the group that you want to edit (to show the current content)
            $group_model = $this->loadModel('Group');
			$this->view->groups = $group_model->getAllGroups();		
            $user_model = $this->loadModel('User');
            $this->view->user = $user_model->getUser($user_id);
				
		$this->view->usersprofile = $user_model->getAllUsersprofile();   
            $this->view->render('users/edit');
        } else {
            header('location: ' . URL . 'users');
        }
    }

   
    public function editSave($user_id)
    {
        if (isset($user_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $user_model = $this->loadModel('User');
            $user_model->editSave($user_id);
        }
        header('location: ' . URL . 'users');
    }

   
    public function delete($user_id)
    {
        if (isset($user_id))
			{
            $user_model = $this->loadModel('User');
            $user_model->delete($user_id);
           }
        header('location: ' . URL . 'users');
    }
	
	public function deleteprofile($user_id)
    {
        if (isset($user_id)) 
		{
            $user_model = $this->loadModel('User');
            $user_model->deleteprofile($user_id);
        }
        header('location: ' . URL . 'users/userprofile');
    }
    
    public function statuschange($user_id, $status)
    {
        if (isset($user_id)) {
            $user_model = $this->loadModel('User');
            $user_model->changestatus($user_id, $status);
        }
        header('location: ' . URL . 'users');
    }
	
	function userprofile()
    {
		$viewper = $this->checkPermission(20, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->addper= $this->checkPermission(20, 4);
			$this->view->editper= $this->checkPermission(20, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(20, 3);
		
		  
		//$group_model = $this->loadModel('Group');
		//$this->view->groups = $group_model->getAllGroups();
		$user_model = $this->loadModel('User');
		$this->view->users  = $user_model->getUserprofiledata();
		$this->view->render('users/userprofile');
		}
    }
	
	function setpermissions($val)
    {
		    //echo $val;
		   // $this->view->pageid=14;
		//$group_model = $this->loadModel('Group');
		//$this->view->groups = $group_model->getAllGroups();
		$user_model = $this->loadModel('User');
		$this->view->users  = $user_model->getUserprofiledata();
		$this->view->profileid=$val;
		$this->view->render('users/setpermission');
    }
	function gettab()
	{	
		$pid = $_POST['permissionid'];
		$Usergroup = $this->loadModel('User');
		$Usergrouparray = $Usergroup->gettabs($pid);
		echo json_encode($Usergrouparray);
	}
	
	function getmodulepermission()
	{
		$Usergroup = $this->loadModel('User');
		$Usergrouparray = $Usergroup->getModules();
		echo json_encode($Usergrouparray);	
		
	}
	
	function getapermission()
	{		
		$pid = $_POST['permissionid'];
		$orgid = $_SESSION['user_org_id'];
		$Usergroup = $this->loadModel('User');
		$Usergrouparray = $Usergroup->getpermissionDetail($pid,$orgid);
		echo json_encode($Usergrouparray);	
		
	}
	
	 function updatedepermission()
	{
		//$editper = $this->CheckPermission(3, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
    
			$arr = array();
			$arr[0] = $_SESSION['user_id'];
			$arr[1] = $_SESSION['user_org_id'];;
			$arr[2] = $_POST['jsonarr'];
			$arr[3] = $_POST['permissionid'];
			$Usergroup = $this->loadModel('User');
			$Usergrouparray = $Usergroup->Updatepermission($arr);
			echo json_encode($Usergrouparray);	
			
	}
	
	function createuserprofile()
	{
		
		$arr = array();
		$arr[1] = $_POST['usergroupname'];
		$arr[2] = $_POST['description'];
		$Usergroup = $this->loadModel('User');
		$Usergrouparr = $Usergroup->Createprofile($arr);
		echo json_encode($Usergrouparr);
	 
   /*  else
    {
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have add permission";
			echo json_encode($result);	
	} */
	}
	
	function updateuserprofile()
	{
		
			$arr = array();
			$arr[1] = $_POST['usergroupname'];
			$arr[2] = $_POST['description'];
			$arr[3] = $_POST['profile_id'];
			$Usergroup = $this->loadModel('User');
			$Usergrouparr = $Usergroup->Updateprofile($arr);
			echo json_encode($Usergrouparr);	
		 
	}
	
	 public function getprofiledata($id)
    {
        
            $user_model = $this->loadModel('User');
            $userprofile = $user_model->getUserprofile($id);
			
		
			echo json_encode($userprofile);	
          
      
    }
	
	function activitylogs()
    {	
		$startdate = isset($_POST['startdate'])?$_POST['startdate']:'' ;
		$enddate = isset($_POST['enddate'])?$_POST['enddate']:'' ;
		$userid = isset($_POST['username'])?$_POST['username']:'' ;
		$user_model = $this->loadModel('User');
		$this->view->activity  = $user_model->getActivityLog();
		$this->view->users  = $user_model->getAllUsers();
		$this->view->startdate = $startdate;
		$this->view->enddate = $enddate;
		$this->view->userid = $userid ;
		$this->view->render('users/activitylogs');
		
    }
}
